/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.spark.DaemonException;
import org.pentaho.adaptive.daemon.spark.SparkPropertyBlacklistEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SparkConfigGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SparkConfigGenerator.class);
    private static final MessageLoader MESSAGE_LOADER = new MessageLoader(SparkConfigGenerator.class);
    public static final String DEBUG_TEMPLATE = " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=%s,address=%s";
    private static final String SPARK_DEFAULT_FILE = "spark-defaults.conf";
    private static final String SPARK_CONFIGURATION = "Spark Configuration";
    private static final String WINDOWS_PATH_SEP = "\\";
    private static final String UNIX_PATH_SEP = "/";
    private static final String SPARK_PROP_PREFIX = "spark.";
    private static final String WHITE_SPACE = " ";
    private static final String COMMA = ",";
    private static final String Y_LWR = "y";
    private static final String N_LWR = "n";
    private static final String WIN64 = "/libswt/win64";
    private static final String SPARK_PRPTY_JARS = "spark.jars";
    private static final String SPARK_PRPTY_EXEC_EXTRA_JOPTS = "spark.executor.extraJavaOptions";
    private static final String SPARK_PRPTY_YARN_DIST_ARCH = "spark.yarn.dist.archives";
    private static final String SPARK_PRPTY_EXEC_MEMORY = "spark.executor.memory";
    private static final String SPARK_PRPTY_DRV_EXTRA_JOPTS = "spark.driver.extraJavaOptions";
    private static final String SPARK_PRPTY_DRV_MEMORY = "spark.driver.memory";
    private static final String UNABLE_CREATE_KETTLE_CONF = "SparkConfigGenerator.UnableToCreateKettleConfError";
    private static final String PRPTY_BLACK_LISTED = "SparkConfigGenerator.WarnBlackListedProperty";
    private static final String ARG_USER_DIR = "-Duser.dir=";
    private static final String ARG_JAVA_LIB = "-Djava.library.path=";
    private static final String ARG_IS_EXECUTOR = "-DisExecutor=";
    @Autowired
    private ApplicationProperties config;

    public void createSparkDefaults(File confDir, List<String> jars, Map<String, Object> pdiParametersProperties, Map<String, Object> pdiEnvironmentProperties) {
        try {
            boolean overwriteConfig = this.config.isOverwriteConfig();
            if (confDir.exists()) {
                if (overwriteConfig) {
                    FileUtils.deleteDirectory((File)confDir);
                } else {
                    return;
                }
            }
            confDir.mkdirs();
            File conf = new File(confDir, SPARK_DEFAULT_FILE);
            conf.createNewFile();
            Properties properties = new Properties();
            File launcher = new File(this.config.getSparkApp());
            String dataIntegration = launcher.getAbsolutePath().replace(WINDOWS_PATH_SEP, UNIX_PATH_SEP);
            Map<String, String> allSparkProperties = this.getAllSparkProperties(dataIntegration, jars, pdiParametersProperties, pdiEnvironmentProperties);
            for (Map.Entry<String, String> propEntry : allSparkProperties.entrySet()) {
                properties.put(propEntry.getKey(), propEntry.getValue());
            }
            FileOutputStream outputStream = new FileOutputStream(conf);
            properties.store(outputStream, SPARK_CONFIGURATION);
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            throw new DaemonException(MESSAGE_LOADER.get(UNABLE_CREATE_KETTLE_CONF), e);
        }
    }

    private String executorExtraJavaOptions(String dataIntegrationPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(ARG_IS_EXECUTOR).append(Boolean.toString(true)).append(WHITE_SPACE).append(ARG_JAVA_LIB).append(dataIntegrationPath).append(WIN64).append(WHITE_SPACE).append(this.config.getSparkExecutorExtraJavaOptions());
        if (this.config.getExecutorDebugPort() > -1) {
            sb.append(String.format(DEBUG_TEMPLATE, this.config.getSuspendDebug() ? Y_LWR : N_LWR, this.config.getExecutorDebugPort()));
        }
        return sb.toString();
    }

    private String driverExtraJavaOptions(String dataIntegration) {
        StringBuilder sb = new StringBuilder();
        sb.append(ARG_USER_DIR).append(dataIntegration).append(WHITE_SPACE).append(ARG_JAVA_LIB).append(dataIntegration).append(WIN64).append(WHITE_SPACE).append(this.config.getSparkDriverExtraJavaOptions());
        if (this.config.getDriverDebugPort() > -1) {
            sb.append(String.format(DEBUG_TEMPLATE, this.config.getSuspendDebug() ? Y_LWR : N_LWR, this.config.getDriverDebugPort()));
        }
        return sb.toString();
    }

    private Map<String, String> getAllSparkProperties(String dataIntegrationPath, List<String> jars, Map<String, Object> pdiParametersProperties, Map<String, Object> pdiEnvironmentProperties) {
        ConcurrentHashMap<String, String> allSparkProperties = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> blackListedSparkProperties = new ConcurrentHashMap<String, String>();
        Map<String, String> sparkPropertiesFromPdiEnvironment = null;
        Map<String, String> sparkPropertiesFromPdiParameters = null;
        Map<String, String> sparkPropertiesFromAppPropertiesAel = null;
        Map<String, String> sparkPropertiesFromAppPropertiesUserDefined = null;
        sparkPropertiesFromAppPropertiesAel = this.getSparkPropertiesFromAppPropertiesAel(dataIntegrationPath, jars);
        sparkPropertiesFromAppPropertiesUserDefined = this.config.userDefinedSparkProperties();
        sparkPropertiesFromPdiEnvironment = this.getSparkPropertiesFromMap(pdiEnvironmentProperties);
        sparkPropertiesFromPdiParameters = this.getSparkPropertiesFromMap(pdiParametersProperties);
        this.addAllSparkProperties(sparkPropertiesFromAppPropertiesUserDefined, allSparkProperties, blackListedSparkProperties, true);
        this.addAllSparkProperties(sparkPropertiesFromAppPropertiesAel, allSparkProperties, blackListedSparkProperties, false);
        this.addAllSparkProperties(sparkPropertiesFromPdiEnvironment, allSparkProperties, blackListedSparkProperties, true);
        this.addAllSparkProperties(sparkPropertiesFromPdiParameters, allSparkProperties, blackListedSparkProperties, true);
        if (blackListedSparkProperties != null && !blackListedSparkProperties.isEmpty()) {
            LOG.warn(MESSAGE_LOADER.get(PRPTY_BLACK_LISTED, blackListedSparkProperties));
        }
        return allSparkProperties;
    }

    private void addAllSparkProperties(Map<String, String> sparkPropertiesToAdd, Map<String, String> allSparkProperties, Map<String, String> allBlacklistedSparkProperties, boolean removeBlacklistedProperties) {
        Map<String, String> blackListedSparkProperties = null;
        if (removeBlacklistedProperties) {
            blackListedSparkProperties = this.removeBlacklistedSparkProperties(sparkPropertiesToAdd);
        }
        allSparkProperties.putAll(sparkPropertiesToAdd);
        if (removeBlacklistedProperties && allBlacklistedSparkProperties != null && blackListedSparkProperties != null && !blackListedSparkProperties.isEmpty()) {
            allBlacklistedSparkProperties.putAll(blackListedSparkProperties);
        }
    }

    private Map<String, String> getSparkPropertiesFromAppPropertiesAel(String dataIntegrationPath, List<String> jars) {
        ConcurrentHashMap<String, String> sparkPropertiesFromAppPropertiesAel = new ConcurrentHashMap<String, String>();
        sparkPropertiesFromAppPropertiesAel.put(SPARK_PRPTY_DRV_MEMORY, this.config.getSparkDriverMemory());
        sparkPropertiesFromAppPropertiesAel.put(SPARK_PRPTY_DRV_EXTRA_JOPTS, this.driverExtraJavaOptions(dataIntegrationPath));
        sparkPropertiesFromAppPropertiesAel.put(SPARK_PRPTY_EXEC_MEMORY, this.config.getSparkExecutorMemory());
        sparkPropertiesFromAppPropertiesAel.put(SPARK_PRPTY_YARN_DIST_ARCH, this.config.getAssemblyZip());
        sparkPropertiesFromAppPropertiesAel.put(SPARK_PRPTY_EXEC_EXTRA_JOPTS, this.executorExtraJavaOptions(dataIntegrationPath));
        sparkPropertiesFromAppPropertiesAel.put(SPARK_PRPTY_JARS, jars.stream().collect(Collectors.joining(COMMA)));
        return sparkPropertiesFromAppPropertiesAel;
    }

    private Map<String, String> getSparkPropertiesFromMap(Map<String, Object> propMap) {
        ConcurrentHashMap<String, String> sparkPropertiesMap = new ConcurrentHashMap<String, String>();
        if (propMap == null || propMap.isEmpty()) {
            return sparkPropertiesMap;
        }
        for (Map.Entry<String, Object> propEntry : propMap.entrySet()) {
            if (!propEntry.getKey().startsWith(SPARK_PROP_PREFIX)) continue;
            sparkPropertiesMap.put(propEntry.getKey(), propEntry.getValue().toString());
        }
        return sparkPropertiesMap;
    }

    private Map<String, String> removeBlacklistedSparkProperties(Map<String, String> sparkProperties) {
        ConcurrentHashMap<String, String> blacklistedSparkProps = new ConcurrentHashMap<String, String>();
        if (sparkProperties == null || sparkProperties.isEmpty()) {
            return blacklistedSparkProps;
        }
        for (Map.Entry<String, String> propEntry : sparkProperties.entrySet()) {
            if (!SparkPropertyBlacklistEnum.isSparkPropertyBlacklisted(propEntry.getKey())) continue;
            sparkProperties.remove(propEntry.getKey());
            blacklistedSparkProps.put(propEntry.getKey(), propEntry.getValue());
        }
        return blacklistedSparkProps;
    }
}

