/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.session;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.websocket.Session;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.session.DriverSession;
import org.pentaho.adaptive.daemon.session.RequestData;
import org.pentaho.adaptive.daemon.session.SessionHelper;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.springframework.stereotype.Component;

@Component
public class SessionTracker {
    private Map<String, ArrayList<DriverSession>> driverSessionCache;
    private Map<String, RequestData> requestDataCache = new HashMap<String, RequestData>();

    SessionTracker() {
        this.driverSessionCache = new HashMap<String, ArrayList<DriverSession>>();
    }

    public Session fetchClientSessionByRequestId(String requestId) {
        RequestData requestData = this.requestDataCache.get(requestId);
        return requestData == null ? null : requestData.getClientSession();
    }

    public boolean executeWithSparkContextReuse(String requestId) {
        RequestData requestData = this.requestDataCache.get(requestId);
        return requestData == null ? false : requestData.isReuseSparkContext();
    }

    public ExecutionRequest fetchRequestMessageByRequestId(String requestId) {
        RequestData requestData = this.requestDataCache.get(requestId);
        return requestData == null ? null : requestData.getExecutionRequest();
    }

    public void addRequest(ApplicationProperties config, Session clientWebsocketSession, ExecutionRequest requestMessage) {
        String requestId = requestMessage.getRequestId();
        RequestData requestData = new RequestData(config, requestId, clientWebsocketSession, requestMessage);
        this.requestDataCache.put(requestId, requestData);
    }

    public void removeRequest(String requestId) {
        if (requestId != null) {
            this.requestDataCache.remove(requestId);
        }
    }

    public Session getDriverSession(ApplicationProperties config, Principal principal) {
        DriverSession driverSession = null;
        String user = SessionHelper.getUserId(config, principal);
        ArrayList<DriverSession> driverSessions = this.driverSessionCache.get(user);
        if (driverSessions != null && driverSessions.size() > 0) {
            driverSession = driverSessions.stream().filter(dSession -> dSession.canReuseThisSession() && ValidatorHelper.getMemAsBytes(dSession.getDriverMemory()) >= ValidatorHelper.getMemAsBytes(config.getSparkDriverMemory()) && ValidatorHelper.getMemAsBytes(dSession.getExecutorMemory()) >= ValidatorHelper.getMemAsBytes(config.getSparkExecutorMemory())).findFirst().orElse(null);
        }
        return driverSession == null ? null : driverSession.getWebsocketDriverSession();
    }

    public Session getDriverSession(Session clientWebsocketSession) {
        RequestData clientSession = this.requestDataCache.values().stream().filter(requestData -> requestData.getClientSession().getId().equals(clientWebsocketSession.getId())).findFirst().orElse(null);
        return clientSession != null ? clientSession.getDriverSession() : null;
    }

    public List<RequestData> getRequestsData(Session driverWebsocketSession) {
        return this.requestDataCache.values().stream().filter(requestData -> requestData.getDriverSession() != null && requestData.getDriverSession().getId().equals(driverWebsocketSession.getId())).collect(Collectors.toList());
    }

    public String getRequestId(Session clientWebsocketSession) {
        RequestData requestDatafound = this.requestDataCache.values().stream().filter(requestData -> requestData.getClientSession() != null && requestData.getClientSession().getId().equals(clientWebsocketSession.getId())).findFirst().orElse(null);
        return requestDatafound == null ? null : requestDatafound.getRequestID();
    }

    public void addDriverSession(String requestId, Session driverWebsocketSession) {
        RequestData requestData = this.requestDataCache.get(requestId);
        if (requestData != null) {
            requestData.setDriverSession(driverWebsocketSession);
            ArrayList<DriverSession> driverSessions = this.driverSessionCache.get(requestData.getUserID());
            if (driverSessions == null) {
                driverSessions = new ArrayList();
            }
            driverSessions.add(new DriverSession(driverWebsocketSession, requestData));
            this.driverSessionCache.put(requestData.getUserID(), driverSessions);
        }
    }

    public void setDriverSession(String requestId, Session driverWebsocketSession) {
        RequestData requestData = this.requestDataCache.get(requestId);
        if (requestData != null) {
            requestData.setDriverSession(driverWebsocketSession);
        }
    }

    public void removeDriverSession(String userID, String driverSessionID) {
        ArrayList<DriverSession> driverSessions = this.driverSessionCache.get(userID);
        if (driverSessions != null) {
            driverSessions.stream().filter(driverSession -> driverSession.getSessionID().equals(driverSessionID)).findFirst().ifPresent(driverSessions::remove);
            if (driverSessions.size() == 0) {
                this.driverSessionCache.remove(userID);
            }
        }
    }

    public int totalDriverSessions() {
        return this.driverSessionCache.values().stream().mapToInt(ArrayList::size).sum();
    }

    public int totalDriverSessions(String user) {
        ArrayList<DriverSession> userDriverSession = this.driverSessionCache.get(user);
        return userDriverSession == null ? 0 : userDriverSession.size();
    }

    public boolean userInDriverCache(String user) {
        return this.driverSessionCache.containsKey(user);
    }

    public int totalRequestsData() {
        return this.requestDataCache.size();
    }

    public RequestData getRequestData(String requestId) {
        return this.requestDataCache.get(requestId);
    }
}

