/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.config.container;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.catalina.connector.Connector;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.config.container.ConnectorConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContainerConfig
implements EmbeddedServletContainerCustomizer {
    private static final MessageLoader MESSAGE_LOADER = new MessageLoader(ContainerConfig.class);
    private final List<ConnectorConfigService> connectorConfigService;
    private static final String EXPECTED_TOMCAT_EMBEDDED_SRVLET_CONTAINER = "ContainerConfig.ExpectedTomcatEmbeddedServletContainer";
    private static final String NO_SRV_DAEMON_DEFINED = "ContainerConfig.NoDaemonServicesDefined";

    @Autowired
    public ContainerConfig(List<ConnectorConfigService> connectorConfigService) {
        this.connectorConfigService = connectorConfigService;
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        Preconditions.checkArgument((boolean)(container instanceof TomcatEmbeddedServletContainerFactory), (Object)MESSAGE_LOADER.get(EXPECTED_TOMCAT_EMBEDDED_SRVLET_CONTAINER));
        Preconditions.checkNotNull(this.connectorConfigService);
        List applicableConnectorConfigServices = this.connectorConfigService.stream().filter(ConnectorConfigService::shouldApply).collect(Collectors.toList());
        Preconditions.checkArgument((applicableConnectorConfigServices.size() > 0 ? 1 : 0) != 0, (Object)MESSAGE_LOADER.get(NO_SRV_DAEMON_DEFINED));
        TomcatEmbeddedServletContainerFactory tomcatContainer = (TomcatEmbeddedServletContainerFactory)container;
        tomcatContainer.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> ((ConnectorConfigService)applicableConnectorConfigServices.get(0)).apply(container, connector)});
        int numberPortsRequired = (int)applicableConnectorConfigServices.stream().map(ConnectorConfigService::port).distinct().count();
        IntStream.range(1, numberPortsRequired).forEach(i -> {
            Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            tomcatContainer.addAdditionalTomcatConnectors(new Connector[]{connector});
            this.connectorConfigService.get(i).apply(container, connector);
        });
    }
}

