/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Shorts;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.crypto.CipherOption;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolStats;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.InotifyProtos;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockIdCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.CheckpointCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.hdfs.util.ExactSizeInputStream;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.DataChecksum;

public class PBHelper {
    private static final DatanodeProtocolProtos.RegisterCommandProto REG_CMD_PROTO = DatanodeProtocolProtos.RegisterCommandProto.newBuilder().build();
    private static final RegisterCommand REG_CMD = new RegisterCommand();
    private static final AclEntryScope[] ACL_ENTRY_SCOPE_VALUES = AclEntryScope.values();
    private static final AclEntryType[] ACL_ENTRY_TYPE_VALUES = AclEntryType.values();
    private static final FsAction[] FSACTION_VALUES = FsAction.values();
    private static final XAttr.NameSpace[] XATTR_NAMESPACE_VALUES = XAttr.NameSpace.values();

    private PBHelper() {
    }

    public static ByteString getByteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    private static <T extends Enum<T>, U extends Enum<U>> U castEnum(T from, U[] to) {
        return to[from.ordinal()];
    }

    public static HdfsServerConstants.NamenodeRole convert(HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto role) {
        switch (role) {
            case NAMENODE: {
                return HdfsServerConstants.NamenodeRole.NAMENODE;
            }
            case BACKUP: {
                return HdfsServerConstants.NamenodeRole.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsServerConstants.NamenodeRole.CHECKPOINT;
            }
        }
        return null;
    }

    public static HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto convert(HdfsServerConstants.NamenodeRole role) {
        switch (role) {
            case NAMENODE: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE;
            }
            case BACKUP: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP;
            }
            case CHECKPOINT: {
                return HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT;
            }
        }
        return null;
    }

    public static BlockStoragePolicy[] convertStoragePolicies(List<HdfsProtos.BlockStoragePolicyProto> policyProtos) {
        if (policyProtos == null || policyProtos.size() == 0) {
            return new BlockStoragePolicy[0];
        }
        BlockStoragePolicy[] policies = new BlockStoragePolicy[policyProtos.size()];
        int i = 0;
        for (HdfsProtos.BlockStoragePolicyProto proto : policyProtos) {
            policies[i++] = PBHelper.convert(proto);
        }
        return policies;
    }

    public static BlockStoragePolicy convert(HdfsProtos.BlockStoragePolicyProto proto) {
        List<HdfsProtos.StorageTypeProto> cList = proto.getCreationPolicy().getStorageTypesList();
        StorageType[] creationTypes = PBHelper.convertStorageTypes(cList, cList.size());
        List<HdfsProtos.StorageTypeProto> cfList = proto.hasCreationFallbackPolicy() ? proto.getCreationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] creationFallbackTypes = cfList == null ? StorageType.EMPTY_ARRAY : PBHelper.convertStorageTypes(cfList, cfList.size());
        List<HdfsProtos.StorageTypeProto> rfList = proto.hasReplicationFallbackPolicy() ? proto.getReplicationFallbackPolicy().getStorageTypesList() : null;
        StorageType[] replicationFallbackTypes = rfList == null ? StorageType.EMPTY_ARRAY : PBHelper.convertStorageTypes(rfList, rfList.size());
        return new BlockStoragePolicy((byte)proto.getPolicyId(), proto.getName(), creationTypes, creationFallbackTypes, replicationFallbackTypes);
    }

    public static HdfsProtos.BlockStoragePolicyProto convert(BlockStoragePolicy policy) {
        HdfsProtos.StorageTypesProto replicationFallbackProto;
        HdfsProtos.BlockStoragePolicyProto.Builder builder = HdfsProtos.BlockStoragePolicyProto.newBuilder().setPolicyId(policy.getId()).setName(policy.getName());
        HdfsProtos.StorageTypesProto creationProto = PBHelper.convert(policy.getStorageTypes());
        Preconditions.checkArgument((creationProto != null ? 1 : 0) != 0);
        builder.setCreationPolicy(creationProto);
        HdfsProtos.StorageTypesProto creationFallbackProto = PBHelper.convert(policy.getCreationFallbacks());
        if (creationFallbackProto != null) {
            builder.setCreationFallbackPolicy(creationFallbackProto);
        }
        if ((replicationFallbackProto = PBHelper.convert(policy.getReplicationFallbacks())) != null) {
            builder.setReplicationFallbackPolicy(replicationFallbackProto);
        }
        return builder.build();
    }

    public static HdfsProtos.StorageTypesProto convert(StorageType[] types) {
        if (types == null || types.length == 0) {
            return null;
        }
        List<HdfsProtos.StorageTypeProto> list = PBHelper.convertStorageTypes(types);
        return HdfsProtos.StorageTypesProto.newBuilder().addAllStorageTypes(list).build();
    }

    public static HdfsProtos.StorageInfoProto convert(StorageInfo info) {
        return HdfsProtos.StorageInfoProto.newBuilder().setClusterID(info.getClusterID()).setCTime(info.getCTime()).setLayoutVersion(info.getLayoutVersion()).setNamespceID(info.getNamespaceID()).build();
    }

    public static StorageInfo convert(HdfsProtos.StorageInfoProto info, HdfsServerConstants.NodeType type) {
        return new StorageInfo(info.getLayoutVersion(), info.getNamespceID(), info.getClusterID(), info.getCTime(), type);
    }

    public static HdfsProtos.NamenodeRegistrationProto convert(NamenodeRegistration reg) {
        return HdfsProtos.NamenodeRegistrationProto.newBuilder().setHttpAddress(reg.getHttpAddress()).setRole(PBHelper.convert(reg.getRole())).setRpcAddress(reg.getAddress()).setStorageInfo(PBHelper.convert((StorageInfo)reg)).build();
    }

    public static NamenodeRegistration convert(HdfsProtos.NamenodeRegistrationProto reg) {
        StorageInfo si = PBHelper.convert(reg.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new NamenodeRegistration(reg.getRpcAddress(), reg.getHttpAddress(), si, PBHelper.convert(reg.getRole()));
    }

    public static DatanodeID convert(HdfsProtos.DatanodeIDProto dn) {
        return new DatanodeID(dn.getIpAddr(), dn.getHostName(), dn.getDatanodeUuid(), dn.getXferPort(), dn.getInfoPort(), dn.hasInfoSecurePort() ? dn.getInfoSecurePort() : 0, dn.getIpcPort());
    }

    public static HdfsProtos.DatanodeIDProto convert(DatanodeID dn) {
        return HdfsProtos.DatanodeIDProto.newBuilder().setIpAddr(dn.getIpAddr()).setHostName(dn.getHostName()).setXferPort(dn.getXferPort()).setDatanodeUuid(dn.getDatanodeUuid() != null ? dn.getDatanodeUuid() : "").setInfoPort(dn.getInfoPort()).setInfoSecurePort(dn.getInfoSecurePort()).setIpcPort(dn.getIpcPort()).build();
    }

    public static HdfsProtos.DatanodeIDProto[] convert(DatanodeID[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        HdfsProtos.DatanodeIDProto[] result = new HdfsProtos.DatanodeIDProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static DatanodeID[] convert(HdfsProtos.DatanodeIDProto[] did) {
        if (did == null) {
            return null;
        }
        int len = did.length;
        DatanodeID[] result = new DatanodeID[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(did[i]);
        }
        return result;
    }

    public static HdfsProtos.BlockProto convert(Block b) {
        return HdfsProtos.BlockProto.newBuilder().setBlockId(b.getBlockId()).setGenStamp(b.getGenerationStamp()).setNumBytes(b.getNumBytes()).build();
    }

    public static Block convert(HdfsProtos.BlockProto b) {
        return new Block(b.getBlockId(), b.getNumBytes(), b.getGenStamp());
    }

    public static HdfsProtos.BlockWithLocationsProto convert(BlocksWithLocations.BlockWithLocations blk) {
        return HdfsProtos.BlockWithLocationsProto.newBuilder().setBlock(PBHelper.convert(blk.getBlock())).addAllDatanodeUuids(Arrays.asList(blk.getDatanodeUuids())).addAllStorageUuids(Arrays.asList(blk.getStorageIDs())).addAllStorageTypes(PBHelper.convertStorageTypes(blk.getStorageTypes())).build();
    }

    public static BlocksWithLocations.BlockWithLocations convert(HdfsProtos.BlockWithLocationsProto b) {
        List<String> datanodeUuids = b.getDatanodeUuidsList();
        List<String> storageUuids = b.getStorageUuidsList();
        List<HdfsProtos.StorageTypeProto> storageTypes = b.getStorageTypesList();
        return new BlocksWithLocations.BlockWithLocations(PBHelper.convert(b.getBlock()), datanodeUuids.toArray(new String[datanodeUuids.size()]), storageUuids.toArray(new String[storageUuids.size()]), PBHelper.convertStorageTypes(storageTypes, storageUuids.size()));
    }

    public static HdfsProtos.BlocksWithLocationsProto convert(BlocksWithLocations blks) {
        HdfsProtos.BlocksWithLocationsProto.Builder builder = HdfsProtos.BlocksWithLocationsProto.newBuilder();
        for (BlocksWithLocations.BlockWithLocations b : blks.getBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static BlocksWithLocations convert(HdfsProtos.BlocksWithLocationsProto blocks) {
        List<HdfsProtos.BlockWithLocationsProto> b = blocks.getBlocksList();
        BlocksWithLocations.BlockWithLocations[] ret = new BlocksWithLocations.BlockWithLocations[b.size()];
        int i = 0;
        for (HdfsProtos.BlockWithLocationsProto entry : b) {
            ret[i++] = PBHelper.convert(entry);
        }
        return new BlocksWithLocations(ret);
    }

    public static HdfsProtos.BlockKeyProto convert(BlockKey key) {
        byte[] encodedKey = key.getEncodedKey();
        ByteString keyBytes = ByteString.copyFrom((byte[])(encodedKey == null ? DFSUtil.EMPTY_BYTES : encodedKey));
        return HdfsProtos.BlockKeyProto.newBuilder().setKeyId(key.getKeyId()).setKeyBytes(keyBytes).setExpiryDate(key.getExpiryDate()).build();
    }

    public static BlockKey convert(HdfsProtos.BlockKeyProto k) {
        return new BlockKey(k.getKeyId(), k.getExpiryDate(), k.getKeyBytes().toByteArray());
    }

    public static HdfsProtos.ExportedBlockKeysProto convert(ExportedBlockKeys keys) {
        HdfsProtos.ExportedBlockKeysProto.Builder builder = HdfsProtos.ExportedBlockKeysProto.newBuilder();
        builder.setIsBlockTokenEnabled(keys.isBlockTokenEnabled()).setKeyUpdateInterval(keys.getKeyUpdateInterval()).setTokenLifeTime(keys.getTokenLifetime()).setCurrentKey(PBHelper.convert(keys.getCurrentKey()));
        for (BlockKey k : keys.getAllKeys()) {
            builder.addAllKeys(PBHelper.convert(k));
        }
        return builder.build();
    }

    public static ExportedBlockKeys convert(HdfsProtos.ExportedBlockKeysProto keys) {
        return new ExportedBlockKeys(keys.getIsBlockTokenEnabled(), keys.getKeyUpdateInterval(), keys.getTokenLifeTime(), PBHelper.convert(keys.getCurrentKey()), PBHelper.convertBlockKeys(keys.getAllKeysList()));
    }

    public static HdfsProtos.CheckpointSignatureProto convert(CheckpointSignature s) {
        return HdfsProtos.CheckpointSignatureProto.newBuilder().setBlockPoolId(s.getBlockpoolID()).setCurSegmentTxId(s.getCurSegmentTxId()).setMostRecentCheckpointTxId(s.getMostRecentCheckpointTxId()).setStorageInfo(PBHelper.convert((StorageInfo)s)).build();
    }

    public static CheckpointSignature convert(HdfsProtos.CheckpointSignatureProto s) {
        StorageInfo si = PBHelper.convert(s.getStorageInfo(), HdfsServerConstants.NodeType.NAME_NODE);
        return new CheckpointSignature(si, s.getBlockPoolId(), s.getMostRecentCheckpointTxId(), s.getCurSegmentTxId());
    }

    public static HdfsProtos.RemoteEditLogProto convert(RemoteEditLog log) {
        return HdfsProtos.RemoteEditLogProto.newBuilder().setStartTxId(log.getStartTxId()).setEndTxId(log.getEndTxId()).setIsInProgress(log.isInProgress()).build();
    }

    public static RemoteEditLog convert(HdfsProtos.RemoteEditLogProto l) {
        return new RemoteEditLog(l.getStartTxId(), l.getEndTxId(), l.getIsInProgress());
    }

    public static HdfsProtos.RemoteEditLogManifestProto convert(RemoteEditLogManifest manifest) {
        HdfsProtos.RemoteEditLogManifestProto.Builder builder = HdfsProtos.RemoteEditLogManifestProto.newBuilder();
        for (RemoteEditLog log : manifest.getLogs()) {
            builder.addLogs(PBHelper.convert(log));
        }
        return builder.build();
    }

    public static RemoteEditLogManifest convert(HdfsProtos.RemoteEditLogManifestProto manifest) {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>(manifest.getLogsList().size());
        for (HdfsProtos.RemoteEditLogProto l : manifest.getLogsList()) {
            logs.add(PBHelper.convert(l));
        }
        return new RemoteEditLogManifest(logs);
    }

    public static HdfsProtos.CheckpointCommandProto convert(CheckpointCommand cmd) {
        return HdfsProtos.CheckpointCommandProto.newBuilder().setSignature(PBHelper.convert(cmd.getSignature())).setNeedToReturnImage(cmd.needToReturnImage()).build();
    }

    public static HdfsProtos.NamenodeCommandProto convert(NamenodeCommand cmd) {
        if (cmd instanceof CheckpointCommand) {
            return HdfsProtos.NamenodeCommandProto.newBuilder().setAction(cmd.getAction()).setType(HdfsProtos.NamenodeCommandProto.Type.CheckPointCommand).setCheckpointCmd(PBHelper.convert((CheckpointCommand)cmd)).build();
        }
        return HdfsProtos.NamenodeCommandProto.newBuilder().setType(HdfsProtos.NamenodeCommandProto.Type.NamenodeCommand).setAction(cmd.getAction()).build();
    }

    public static BlockKey[] convertBlockKeys(List<HdfsProtos.BlockKeyProto> list) {
        BlockKey[] ret = new BlockKey[list.size()];
        int i = 0;
        for (HdfsProtos.BlockKeyProto k : list) {
            ret[i++] = PBHelper.convert(k);
        }
        return ret;
    }

    public static NamespaceInfo convert(HdfsProtos.NamespaceInfoProto info) {
        HdfsProtos.StorageInfoProto storage = info.getStorageInfo();
        return new NamespaceInfo(storage.getNamespceID(), storage.getClusterID(), info.getBlockPoolID(), storage.getCTime(), info.getBuildVersion(), info.getSoftwareVersion(), info.getCapabilities());
    }

    public static NamenodeCommand convert(HdfsProtos.NamenodeCommandProto cmd) {
        if (cmd == null) {
            return null;
        }
        switch (cmd.getType()) {
            case CheckPointCommand: {
                HdfsProtos.CheckpointCommandProto chkPt = cmd.getCheckpointCmd();
                return new CheckpointCommand(PBHelper.convert(chkPt.getSignature()), chkPt.getNeedToReturnImage());
            }
        }
        return new NamenodeCommand(cmd.getAction());
    }

    public static ExtendedBlock convert(HdfsProtos.ExtendedBlockProto eb) {
        if (eb == null) {
            return null;
        }
        return new ExtendedBlock(eb.getPoolId(), eb.getBlockId(), eb.getNumBytes(), eb.getGenerationStamp());
    }

    public static HdfsProtos.ExtendedBlockProto convert(ExtendedBlock b) {
        if (b == null) {
            return null;
        }
        return HdfsProtos.ExtendedBlockProto.newBuilder().setPoolId(b.getBlockPoolId()).setBlockId(b.getBlockId()).setNumBytes(b.getNumBytes()).setGenerationStamp(b.getGenerationStamp()).build();
    }

    public static HdfsProtos.RecoveringBlockProto convert(BlockRecoveryCommand.RecoveringBlock b) {
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto lb = PBHelper.convert((LocatedBlock)b);
        return HdfsProtos.RecoveringBlockProto.newBuilder().setBlock(lb).setNewGenStamp(b.getNewGenerationStamp()).build();
    }

    public static BlockRecoveryCommand.RecoveringBlock convert(HdfsProtos.RecoveringBlockProto b) {
        ExtendedBlock block = PBHelper.convert(b.getBlock().getB());
        DatanodeInfo[] locs = PBHelper.convert(b.getBlock().getLocsList());
        return new BlockRecoveryCommand.RecoveringBlock(block, locs, b.getNewGenStamp());
    }

    public static HdfsProtos.DatanodeInfoProto.AdminState convert(DatanodeInfo.AdminStates inAs) {
        switch (inAs) {
            case NORMAL: {
                return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
            }
            case DECOMMISSION_INPROGRESS: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return HdfsProtos.DatanodeInfoProto.AdminState.DECOMMISSIONED;
            }
            case ENTERING_MAINTENANCE: {
                return HdfsProtos.DatanodeInfoProto.AdminState.ENTERING_MAINTENANCE;
            }
            case IN_MAINTENANCE: {
                return HdfsProtos.DatanodeInfoProto.AdminState.IN_MAINTENANCE;
            }
        }
        return HdfsProtos.DatanodeInfoProto.AdminState.NORMAL;
    }

    public static DatanodeInfo convert(HdfsProtos.DatanodeInfoProto di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo dinfo = new DatanodeInfo(PBHelper.convert(di.getId()), di.hasLocation() ? di.getLocation() : null, di.getCapacity(), di.getDfsUsed(), di.getRemaining(), di.getBlockPoolUsed(), di.getCacheCapacity(), di.getCacheUsed(), di.getLastUpdate(), di.getXceiverCount(), PBHelper.convert(di.getAdminState()), di.hasUpgradeDomain() ? di.getUpgradeDomain() : null);
        if (di.hasNonDfsUsed()) {
            dinfo.setNonDfsUsed(di.getNonDfsUsed());
        } else {
            long nonDFSUsed = di.getCapacity() - di.getDfsUsed() - di.getRemaining();
            dinfo.setNonDfsUsed(nonDFSUsed < 0L ? 0L : nonDFSUsed);
        }
        return dinfo;
    }

    public static HdfsProtos.DatanodeInfoProto convertDatanodeInfo(DatanodeInfo di) {
        if (di == null) {
            return null;
        }
        return PBHelper.convert(di);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfoProto[] di) {
        if (di == null) {
            return null;
        }
        DatanodeInfo[] result = new DatanodeInfo[di.length];
        for (int i = 0; i < di.length; ++i) {
            result[i] = PBHelper.convert(di[i]);
        }
        return result;
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos) {
        return PBHelper.convert(dnInfos, 0);
    }

    public static List<? extends HdfsProtos.DatanodeInfoProto> convert(DatanodeInfo[] dnInfos, int startIdx) {
        if (dnInfos == null) {
            return null;
        }
        ArrayList protos = Lists.newArrayListWithCapacity((int)dnInfos.length);
        for (int i = startIdx; i < dnInfos.length; ++i) {
            protos.add(PBHelper.convert(dnInfos[i]));
        }
        return protos;
    }

    public static DatanodeInfo[] convert(List<HdfsProtos.DatanodeInfoProto> list) {
        DatanodeInfo[] info = new DatanodeInfo[list.size()];
        for (int i = 0; i < info.length; ++i) {
            info[i] = PBHelper.convert(list.get(i));
        }
        return info;
    }

    public static HdfsProtos.DatanodeInfoProto convert(DatanodeInfo info) {
        HdfsProtos.DatanodeInfoProto.Builder builder = HdfsProtos.DatanodeInfoProto.newBuilder();
        if (info.getNetworkLocation() != null) {
            builder.setLocation(info.getNetworkLocation());
        }
        if (info.getUpgradeDomain() != null) {
            builder.setUpgradeDomain(info.getUpgradeDomain());
        }
        builder.setId(PBHelper.convert((DatanodeID)info)).setCapacity(info.getCapacity()).setDfsUsed(info.getDfsUsed()).setNonDfsUsed(info.getNonDfsUsed()).setRemaining(info.getRemaining()).setBlockPoolUsed(info.getBlockPoolUsed()).setCacheCapacity(info.getCacheCapacity()).setCacheUsed(info.getCacheUsed()).setLastUpdate(info.getLastUpdate()).setXceiverCount(info.getXceiverCount()).setAdminState(PBHelper.convert(info.getAdminState())).build();
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeStorageReportProto convertDatanodeStorageReport(DatanodeStorageReport report) {
        return ClientNamenodeProtocolProtos.DatanodeStorageReportProto.newBuilder().setDatanodeInfo(PBHelper.convert(report.getDatanodeInfo())).addAllStorageReports(PBHelper.convertStorageReports(report.getStorageReports())).build();
    }

    public static List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> convertDatanodeStorageReports(DatanodeStorageReport[] reports) {
        ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos = new ArrayList<ClientNamenodeProtocolProtos.DatanodeStorageReportProto>(reports.length);
        for (int i = 0; i < reports.length; ++i) {
            protos.add(PBHelper.convertDatanodeStorageReport(reports[i]));
        }
        return protos;
    }

    public static DatanodeStorageReport convertDatanodeStorageReport(ClientNamenodeProtocolProtos.DatanodeStorageReportProto proto) {
        return new DatanodeStorageReport(PBHelper.convert(proto.getDatanodeInfo()), PBHelper.convertStorageReports(proto.getStorageReportsList()));
    }

    public static DatanodeStorageReport[] convertDatanodeStorageReports(List<ClientNamenodeProtocolProtos.DatanodeStorageReportProto> protos) {
        DatanodeStorageReport[] reports = new DatanodeStorageReport[protos.size()];
        for (int i = 0; i < reports.length; ++i) {
            reports[i] = PBHelper.convertDatanodeStorageReport(protos.get(i));
        }
        return reports;
    }

    public static DatanodeInfo.AdminStates convert(HdfsProtos.DatanodeInfoProto.AdminState adminState) {
        switch (adminState) {
            case DECOMMISSION_INPROGRESS: {
                return DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS;
            }
            case DECOMMISSIONED: {
                return DatanodeInfo.AdminStates.DECOMMISSIONED;
            }
            case ENTERING_MAINTENANCE: {
                return DatanodeInfo.AdminStates.ENTERING_MAINTENANCE;
            }
            case IN_MAINTENANCE: {
                return DatanodeInfo.AdminStates.IN_MAINTENANCE;
            }
        }
        return DatanodeInfo.AdminStates.NORMAL;
    }

    public static HdfsProtos.LocatedBlockProto convert(LocatedBlock b) {
        String[] storageIDs;
        if (b == null) {
            return null;
        }
        HdfsProtos.LocatedBlockProto.Builder builder = HdfsProtos.LocatedBlockProto.newBuilder();
        DatanodeInfo[] locs = b.getLocations();
        LinkedList cachedLocs = Lists.newLinkedList(Arrays.asList(b.getCachedLocations()));
        for (int i = 0; i < locs.length; ++i) {
            DatanodeInfo loc = locs[i];
            builder.addLocs(i, PBHelper.convert(loc));
            boolean locIsCached = cachedLocs.contains(loc);
            builder.addIsCached(locIsCached);
            if (!locIsCached) continue;
            cachedLocs.remove(loc);
        }
        Preconditions.checkArgument((cachedLocs.size() == 0 ? 1 : 0) != 0, (Object)"Found additional cached replica locations that are not in the set of storage-backed locations!");
        StorageType[] storageTypes = b.getStorageTypes();
        if (storageTypes != null) {
            for (int i = 0; i < storageTypes.length; ++i) {
                builder.addStorageTypes(PBHelper.convertStorageType(storageTypes[i]));
            }
        }
        if ((storageIDs = b.getStorageIDs()) != null) {
            builder.addAllStorageIDs(Arrays.asList(storageIDs));
        }
        return builder.setB(PBHelper.convert(b.getBlock())).setBlockToken(PBHelper.convert(b.getBlockToken())).setCorrupt(b.isCorrupt()).setOffset(b.getStartOffset()).build();
    }

    public static LocatedBlock convert(HdfsProtos.LocatedBlockProto proto) {
        String[] storageIDs;
        if (proto == null) {
            return null;
        }
        List<HdfsProtos.DatanodeInfoProto> locs = proto.getLocsList();
        DatanodeInfo[] targets = new DatanodeInfo[locs.size()];
        for (int i = 0; i < locs.size(); ++i) {
            targets[i] = PBHelper.convert(locs.get(i));
        }
        StorageType[] storageTypes = PBHelper.convertStorageTypes(proto.getStorageTypesList(), locs.size());
        int storageIDsCount = proto.getStorageIDsCount();
        if (storageIDsCount == 0) {
            storageIDs = null;
        } else {
            Preconditions.checkState((storageIDsCount == locs.size() ? 1 : 0) != 0);
            storageIDs = proto.getStorageIDsList().toArray(new String[storageIDsCount]);
        }
        ArrayList<DatanodeInfo> cachedLocs = new ArrayList<DatanodeInfo>(locs.size());
        List<Boolean> isCachedList = proto.getIsCachedList();
        for (int i = 0; i < isCachedList.size(); ++i) {
            if (!isCachedList.get(i).booleanValue()) continue;
            cachedLocs.add(targets[i]);
        }
        LocatedBlock lb = new LocatedBlock(PBHelper.convert(proto.getB()), targets, storageIDs, storageTypes, proto.getOffset(), proto.getCorrupt(), cachedLocs.toArray(new DatanodeInfo[0]));
        lb.setBlockToken(PBHelper.convert(proto.getBlockToken()));
        return lb;
    }

    public static SecurityProtos.TokenProto convert(Token<?> tok) {
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])tok.getIdentifier())).setPassword(ByteString.copyFrom((byte[])tok.getPassword())).setKind(tok.getKind().toString()).setService(tok.getService().toString()).build();
    }

    public static Token<BlockTokenIdentifier> convert(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static Token<DelegationTokenIdentifier> convertDelegationToken(SecurityProtos.TokenProto blockToken) {
        return new Token(blockToken.getIdentifier().toByteArray(), blockToken.getPassword().toByteArray(), new Text(blockToken.getKind()), new Text(blockToken.getService()));
    }

    public static HdfsServerConstants.ReplicaState convert(HdfsProtos.ReplicaStateProto state) {
        switch (state) {
            case RBW: {
                return HdfsServerConstants.ReplicaState.RBW;
            }
            case RUR: {
                return HdfsServerConstants.ReplicaState.RUR;
            }
            case RWR: {
                return HdfsServerConstants.ReplicaState.RWR;
            }
            case TEMPORARY: {
                return HdfsServerConstants.ReplicaState.TEMPORARY;
            }
        }
        return HdfsServerConstants.ReplicaState.FINALIZED;
    }

    public static HdfsProtos.ReplicaStateProto convert(HdfsServerConstants.ReplicaState state) {
        switch (state) {
            case RBW: {
                return HdfsProtos.ReplicaStateProto.RBW;
            }
            case RUR: {
                return HdfsProtos.ReplicaStateProto.RUR;
            }
            case RWR: {
                return HdfsProtos.ReplicaStateProto.RWR;
            }
            case TEMPORARY: {
                return HdfsProtos.ReplicaStateProto.TEMPORARY;
            }
        }
        return HdfsProtos.ReplicaStateProto.FINALIZED;
    }

    public static DatanodeProtocolProtos.DatanodeRegistrationProto convert(DatanodeRegistration registration) {
        DatanodeProtocolProtos.DatanodeRegistrationProto.Builder builder = DatanodeProtocolProtos.DatanodeRegistrationProto.newBuilder();
        return builder.setDatanodeID(PBHelper.convert((DatanodeID)registration)).setStorageInfo(PBHelper.convert(registration.getStorageInfo())).setKeys(PBHelper.convert(registration.getExportedKeys())).setSoftwareVersion(registration.getSoftwareVersion()).build();
    }

    public static DatanodeRegistration convert(DatanodeProtocolProtos.DatanodeRegistrationProto proto) {
        StorageInfo si = PBHelper.convert(proto.getStorageInfo(), HdfsServerConstants.NodeType.DATA_NODE);
        return new DatanodeRegistration(PBHelper.convert(proto.getDatanodeID()), si, PBHelper.convert(proto.getKeys()), proto.getSoftwareVersion());
    }

    public static DatanodeCommand convert(DatanodeProtocolProtos.DatanodeCommandProto proto) {
        switch (proto.getCmdType()) {
            case BalancerBandwidthCommand: {
                return PBHelper.convert(proto.getBalancerCmd());
            }
            case BlockCommand: {
                return PBHelper.convert(proto.getBlkCmd());
            }
            case BlockRecoveryCommand: {
                return PBHelper.convert(proto.getRecoveryCmd());
            }
            case FinalizeCommand: {
                return PBHelper.convert(proto.getFinalizeCmd());
            }
            case KeyUpdateCommand: {
                return PBHelper.convert(proto.getKeyUpdateCmd());
            }
            case RegisterCommand: {
                return REG_CMD;
            }
            case BlockIdCommand: {
                return PBHelper.convert(proto.getBlkIdCmd());
            }
        }
        return null;
    }

    public static DatanodeProtocolProtos.BalancerBandwidthCommandProto convert(BalancerBandwidthCommand bbCmd) {
        return DatanodeProtocolProtos.BalancerBandwidthCommandProto.newBuilder().setBandwidth(bbCmd.getBalancerBandwidthValue()).build();
    }

    public static DatanodeProtocolProtos.KeyUpdateCommandProto convert(KeyUpdateCommand cmd) {
        return DatanodeProtocolProtos.KeyUpdateCommandProto.newBuilder().setKeys(PBHelper.convert(cmd.getExportedKeys())).build();
    }

    public static DatanodeProtocolProtos.BlockRecoveryCommandProto convert(BlockRecoveryCommand cmd) {
        DatanodeProtocolProtos.BlockRecoveryCommandProto.Builder builder = DatanodeProtocolProtos.BlockRecoveryCommandProto.newBuilder();
        for (BlockRecoveryCommand.RecoveringBlock b : cmd.getRecoveringBlocks()) {
            builder.addBlocks(PBHelper.convert(b));
        }
        return builder.build();
    }

    public static DatanodeProtocolProtos.FinalizeCommandProto convert(FinalizeCommand cmd) {
        return DatanodeProtocolProtos.FinalizeCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId()).build();
    }

    public static DatanodeProtocolProtos.BlockCommandProto convert(BlockCommand cmd) {
        DatanodeProtocolProtos.BlockCommandProto.Builder builder = DatanodeProtocolProtos.BlockCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 1: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.TRANSFER);
                break;
            }
            case 2: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.INVALIDATE);
                break;
            }
            case 3: {
                builder.setAction(DatanodeProtocolProtos.BlockCommandProto.Action.SHUTDOWN);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        Block[] blocks = cmd.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            builder.addBlocks(PBHelper.convert(blocks[i]));
        }
        builder.addAllTargets(PBHelper.convert(cmd.getTargets())).addAllTargetStorageUuids(PBHelper.convert(cmd.getTargetStorageIDs()));
        StorageType[][] types = cmd.getTargetStorageTypes();
        if (types != null) {
            builder.addAllTargetStorageTypes(PBHelper.convert(types));
        }
        return builder.build();
    }

    private static List<HdfsProtos.StorageTypesProto> convert(StorageType[][] types) {
        ArrayList list = Lists.newArrayList();
        if (types != null) {
            for (StorageType[] ts : types) {
                HdfsProtos.StorageTypesProto.Builder builder = HdfsProtos.StorageTypesProto.newBuilder();
                builder.addAllStorageTypes(PBHelper.convertStorageTypes(ts));
                list.add(builder.build());
            }
        }
        return list;
    }

    public static DatanodeProtocolProtos.BlockIdCommandProto convert(BlockIdCommand cmd) {
        DatanodeProtocolProtos.BlockIdCommandProto.Builder builder = DatanodeProtocolProtos.BlockIdCommandProto.newBuilder().setBlockPoolId(cmd.getBlockPoolId());
        switch (cmd.getAction()) {
            case 9: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.CACHE);
                break;
            }
            case 10: {
                builder.setAction(DatanodeProtocolProtos.BlockIdCommandProto.Action.UNCACHE);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid action");
            }
        }
        long[] blockIds = cmd.getBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            builder.addBlockIds(blockIds[i]);
        }
        return builder.build();
    }

    private static List<HdfsProtos.DatanodeInfosProto> convert(DatanodeInfo[][] targets) {
        HdfsProtos.DatanodeInfosProto[] ret = new HdfsProtos.DatanodeInfosProto[targets.length];
        for (int i = 0; i < targets.length; ++i) {
            ret[i] = HdfsProtos.DatanodeInfosProto.newBuilder().addAllDatanodes(PBHelper.convert(targets[i])).build();
        }
        return Arrays.asList(ret);
    }

    private static List<HdfsProtos.StorageUuidsProto> convert(String[][] targetStorageUuids) {
        HdfsProtos.StorageUuidsProto[] ret = new HdfsProtos.StorageUuidsProto[targetStorageUuids.length];
        for (int i = 0; i < targetStorageUuids.length; ++i) {
            ret[i] = HdfsProtos.StorageUuidsProto.newBuilder().addAllStorageUuids(Arrays.asList(targetStorageUuids[i])).build();
        }
        return Arrays.asList(ret);
    }

    public static DatanodeProtocolProtos.DatanodeCommandProto convert(DatanodeCommand datanodeCommand) {
        DatanodeProtocolProtos.DatanodeCommandProto.Builder builder = DatanodeProtocolProtos.DatanodeCommandProto.newBuilder();
        if (datanodeCommand == null) {
            return builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand).build();
        }
        switch (datanodeCommand.getAction()) {
            case 8: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BalancerBandwidthCommand).setBalancerCmd(PBHelper.convert((BalancerBandwidthCommand)datanodeCommand));
                break;
            }
            case 7: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.KeyUpdateCommand).setKeyUpdateCmd(PBHelper.convert((KeyUpdateCommand)datanodeCommand));
                break;
            }
            case 6: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockRecoveryCommand).setRecoveryCmd(PBHelper.convert((BlockRecoveryCommand)datanodeCommand));
                break;
            }
            case 5: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.FinalizeCommand).setFinalizeCmd(PBHelper.convert((FinalizeCommand)datanodeCommand));
                break;
            }
            case 4: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.RegisterCommand).setRegisterCmd(REG_CMD_PROTO);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockCommand).setBlkCmd(PBHelper.convert((BlockCommand)datanodeCommand));
                break;
            }
            case 9: 
            case 10: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.BlockIdCommand).setBlkIdCmd(PBHelper.convert((BlockIdCommand)datanodeCommand));
                break;
            }
            default: {
                builder.setCmdType(DatanodeProtocolProtos.DatanodeCommandProto.Type.NullDatanodeCommand);
            }
        }
        return builder.build();
    }

    public static KeyUpdateCommand convert(DatanodeProtocolProtos.KeyUpdateCommandProto keyUpdateCmd) {
        return new KeyUpdateCommand(PBHelper.convert(keyUpdateCmd.getKeys()));
    }

    public static FinalizeCommand convert(DatanodeProtocolProtos.FinalizeCommandProto finalizeCmd) {
        return new FinalizeCommand(finalizeCmd.getBlockPoolId());
    }

    public static BlockRecoveryCommand convert(DatanodeProtocolProtos.BlockRecoveryCommandProto recoveryCmd) {
        List<HdfsProtos.RecoveringBlockProto> list = recoveryCmd.getBlocksList();
        ArrayList<BlockRecoveryCommand.RecoveringBlock> recoveringBlocks = new ArrayList<BlockRecoveryCommand.RecoveringBlock>(list.size());
        for (HdfsProtos.RecoveringBlockProto rbp : list) {
            recoveringBlocks.add(PBHelper.convert(rbp));
        }
        return new BlockRecoveryCommand(recoveringBlocks);
    }

    public static BlockCommand convert(DatanodeProtocolProtos.BlockCommandProto blkCmd) {
        int i;
        List<HdfsProtos.BlockProto> blockProtoList = blkCmd.getBlocksList();
        Block[] blocks = new Block[blockProtoList.size()];
        for (int i2 = 0; i2 < blockProtoList.size(); ++i2) {
            blocks[i2] = PBHelper.convert(blockProtoList.get(i2));
        }
        List<HdfsProtos.DatanodeInfosProto> targetList = blkCmd.getTargetsList();
        DatanodeInfo[][] targets = new DatanodeInfo[targetList.size()][];
        for (int i3 = 0; i3 < targetList.size(); ++i3) {
            targets[i3] = PBHelper.convert(targetList.get(i3));
        }
        StorageType[][] targetStorageTypes = new StorageType[targetList.size()][];
        List<HdfsProtos.StorageTypesProto> targetStorageTypesList = blkCmd.getTargetStorageTypesList();
        if (targetStorageTypesList.isEmpty()) {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                targetStorageTypes[i] = new StorageType[targets[i].length];
                Arrays.fill((Object[])targetStorageTypes[i], (Object)StorageType.DEFAULT);
            }
        } else {
            for (i = 0; i < targetStorageTypes.length; ++i) {
                List<HdfsProtos.StorageTypeProto> p = targetStorageTypesList.get(i).getStorageTypesList();
                targetStorageTypes[i] = PBHelper.convertStorageTypes(p, targets[i].length);
            }
        }
        List<HdfsProtos.StorageUuidsProto> targetStorageUuidsList = blkCmd.getTargetStorageUuidsList();
        String[][] targetStorageIDs = new String[targetStorageUuidsList.size()][];
        for (int i4 = 0; i4 < targetStorageIDs.length; ++i4) {
            List<String> storageIDs = targetStorageUuidsList.get(i4).getStorageUuidsList();
            targetStorageIDs[i4] = storageIDs.toArray(new String[storageIDs.size()]);
        }
        int action = 0;
        switch (blkCmd.getAction()) {
            case TRANSFER: {
                action = 1;
                break;
            }
            case INVALIDATE: {
                action = 2;
                break;
            }
            case SHUTDOWN: {
                action = 3;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkCmd.getAction())));
            }
        }
        return new BlockCommand(action, blkCmd.getBlockPoolId(), blocks, targets, targetStorageTypes, targetStorageIDs);
    }

    public static BlockIdCommand convert(DatanodeProtocolProtos.BlockIdCommandProto blkIdCmd) {
        int numBlockIds = blkIdCmd.getBlockIdsCount();
        long[] blockIds = new long[numBlockIds];
        for (int i = 0; i < numBlockIds; ++i) {
            blockIds[i] = blkIdCmd.getBlockIds(i);
        }
        int action = 0;
        switch (blkIdCmd.getAction()) {
            case CACHE: {
                action = 9;
                break;
            }
            case UNCACHE: {
                action = 10;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown action type: " + (Object)((Object)blkIdCmd.getAction())));
            }
        }
        return new BlockIdCommand(action, blkIdCmd.getBlockPoolId(), blockIds);
    }

    public static DatanodeInfo[] convert(HdfsProtos.DatanodeInfosProto datanodeInfosProto) {
        List<HdfsProtos.DatanodeInfoProto> proto = datanodeInfosProto.getDatanodesList();
        DatanodeInfo[] infos = new DatanodeInfo[proto.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = PBHelper.convert(proto.get(i));
        }
        return infos;
    }

    public static BalancerBandwidthCommand convert(DatanodeProtocolProtos.BalancerBandwidthCommandProto balancerCmd) {
        return new BalancerBandwidthCommand(balancerCmd.getBandwidth());
    }

    public static DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto convert(ReceivedDeletedBlockInfo receivedDeletedBlockInfo) {
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus status;
        DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.Builder builder = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.newBuilder();
        switch (receivedDeletedBlockInfo.getStatus()) {
            case RECEIVING_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVING;
                break;
            }
            case RECEIVED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.RECEIVED;
                break;
            }
            case DELETED_BLOCK: {
                status = DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto.BlockStatus.DELETED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status: " + (Object)((Object)receivedDeletedBlockInfo.getStatus()));
            }
        }
        builder.setStatus(status);
        if (receivedDeletedBlockInfo.getDelHints() != null) {
            builder.setDeleteHint(receivedDeletedBlockInfo.getDelHints());
        }
        return builder.setBlock(PBHelper.convert(receivedDeletedBlockInfo.getBlock())).build();
    }

    public static ReceivedDeletedBlockInfo convert(DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto proto) {
        ReceivedDeletedBlockInfo.BlockStatus status = null;
        switch (proto.getStatus()) {
            case RECEIVING: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVING_BLOCK;
                break;
            }
            case RECEIVED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK;
                break;
            }
            case DELETED: {
                status = ReceivedDeletedBlockInfo.BlockStatus.DELETED_BLOCK;
            }
        }
        return new ReceivedDeletedBlockInfo(PBHelper.convert(proto.getBlock()), status, proto.hasDeleteHint() ? proto.getDeleteHint() : null);
    }

    public static HdfsProtos.NamespaceInfoProto convert(NamespaceInfo info) {
        return HdfsProtos.NamespaceInfoProto.newBuilder().setBlockPoolID(info.getBlockPoolID()).setBuildVersion(info.getBuildVersion()).setUnused(0).setStorageInfo(PBHelper.convert((StorageInfo)info)).setSoftwareVersion(info.getSoftwareVersion()).setCapabilities(info.getCapabilities()).build();
    }

    public static HdfsProtos.LocatedBlockProto[] convertLocatedBlock(LocatedBlock[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelper.convertLocatedBlock2(Arrays.asList(lb)).toArray(new HdfsProtos.LocatedBlockProto[lb.length]);
    }

    public static LocatedBlock[] convertLocatedBlock(HdfsProtos.LocatedBlockProto[] lb) {
        if (lb == null) {
            return null;
        }
        return PBHelper.convertLocatedBlock(Arrays.asList(lb)).toArray(new LocatedBlock[lb.length]);
    }

    public static List<LocatedBlock> convertLocatedBlock(List<HdfsProtos.LocatedBlockProto> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<LocatedBlock> result = new ArrayList<LocatedBlock>(len);
        for (int i = 0; i < len; ++i) {
            result.add(PBHelper.convert(lb.get(i)));
        }
        return result;
    }

    public static List<HdfsProtos.LocatedBlockProto> convertLocatedBlock2(List<LocatedBlock> lb) {
        if (lb == null) {
            return null;
        }
        int len = lb.size();
        ArrayList<HdfsProtos.LocatedBlockProto> result = new ArrayList<HdfsProtos.LocatedBlockProto>(len);
        for (int i = 0; i < len; ++i) {
            result.add(PBHelper.convert(lb.get(i)));
        }
        return result;
    }

    public static LocatedBlocks convert(HdfsProtos.LocatedBlocksProto lb) {
        return new LocatedBlocks(lb.getFileLength(), lb.getUnderConstruction(), PBHelper.convertLocatedBlock(lb.getBlocksList()), lb.hasLastBlock() ? PBHelper.convert(lb.getLastBlock()) : null, lb.getIsLastBlockComplete(), lb.hasFileEncryptionInfo() ? PBHelper.convert(lb.getFileEncryptionInfo()) : null);
    }

    public static HdfsProtos.LocatedBlocksProto convert(LocatedBlocks lb) {
        if (lb == null) {
            return null;
        }
        HdfsProtos.LocatedBlocksProto.Builder builder = HdfsProtos.LocatedBlocksProto.newBuilder();
        if (lb.getLastLocatedBlock() != null) {
            builder.setLastBlock(PBHelper.convert(lb.getLastLocatedBlock()));
        }
        if (lb.getFileEncryptionInfo() != null) {
            builder.setFileEncryptionInfo(PBHelper.convert(lb.getFileEncryptionInfo()));
        }
        return builder.setFileLength(lb.getFileLength()).setUnderConstruction(lb.isUnderConstruction()).addAllBlocks(PBHelper.convertLocatedBlock2(lb.getLocatedBlocks())).setIsLastBlockComplete(lb.isLastBlockComplete()).build();
    }

    public static DataEncryptionKey convert(HdfsProtos.DataEncryptionKeyProto bet) {
        String encryptionAlgorithm = bet.getEncryptionAlgorithm();
        return new DataEncryptionKey(bet.getKeyId(), bet.getBlockPoolId(), bet.getNonce().toByteArray(), bet.getEncryptionKey().toByteArray(), bet.getExpiryDate(), encryptionAlgorithm.isEmpty() ? null : encryptionAlgorithm);
    }

    public static HdfsProtos.DataEncryptionKeyProto convert(DataEncryptionKey bet) {
        HdfsProtos.DataEncryptionKeyProto.Builder b = HdfsProtos.DataEncryptionKeyProto.newBuilder().setKeyId(bet.keyId).setBlockPoolId(bet.blockPoolId).setNonce(ByteString.copyFrom((byte[])bet.nonce)).setEncryptionKey(ByteString.copyFrom((byte[])bet.encryptionKey)).setExpiryDate(bet.expiryDate);
        if (bet.encryptionAlgorithm != null) {
            b.setEncryptionAlgorithm(bet.encryptionAlgorithm);
        }
        return b.build();
    }

    public static FsServerDefaults convert(HdfsProtos.FsServerDefaultsProto fs) {
        if (fs == null) {
            return null;
        }
        return new FsServerDefaults(fs.getBlockSize(), fs.getBytesPerChecksum(), fs.getWritePacketSize(), (short)fs.getReplication(), fs.getFileBufferSize(), fs.getEncryptDataTransfer(), fs.getTrashInterval(), PBHelper.convert(fs.getChecksumType()), fs.hasKeyProviderUri() ? fs.getKeyProviderUri() : null);
    }

    public static HdfsProtos.FsServerDefaultsProto convert(FsServerDefaults fs) {
        if (fs == null) {
            return null;
        }
        return HdfsProtos.FsServerDefaultsProto.newBuilder().setBlockSize(fs.getBlockSize()).setBytesPerChecksum(fs.getBytesPerChecksum()).setWritePacketSize(fs.getWritePacketSize()).setReplication(fs.getReplication()).setFileBufferSize(fs.getFileBufferSize()).setEncryptDataTransfer(fs.getEncryptDataTransfer()).setTrashInterval(fs.getTrashInterval()).setChecksumType(PBHelper.convert(fs.getChecksumType())).setKeyProviderUri(fs.getKeyProviderUri()).build();
    }

    public static HdfsProtos.FsPermissionProto convert(FsPermission p) {
        return HdfsProtos.FsPermissionProto.newBuilder().setPerm(p.toExtendedShort()).build();
    }

    public static FsPermission convert(HdfsProtos.FsPermissionProto p) {
        return new FsPermissionExtension((short)p.getPerm());
    }

    public static int convertCreateFlag(EnumSetWritable<CreateFlag> flag) {
        int value = 0;
        if (flag.contains((Object)CreateFlag.APPEND)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.APPEND.getNumber();
        }
        if (flag.contains((Object)CreateFlag.CREATE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.CREATE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.OVERWRITE)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.OVERWRITE.getNumber();
        }
        if (flag.contains((Object)CreateFlag.LAZY_PERSIST)) {
            value |= ClientNamenodeProtocolProtos.CreateFlagProto.LAZY_PERSIST.getNumber();
        }
        return value;
    }

    public static EnumSetWritable<CreateFlag> convertCreateFlag(int flag) {
        EnumSet<CreateFlag> result = EnumSet.noneOf(CreateFlag.class);
        if ((flag & 4) == 4) {
            result.add(CreateFlag.APPEND);
        }
        if ((flag & 1) == 1) {
            result.add(CreateFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(CreateFlag.OVERWRITE);
        }
        if ((flag & 0x10) == 16) {
            result.add(CreateFlag.LAZY_PERSIST);
        }
        return new EnumSetWritable(result);
    }

    public static int convertCacheFlags(EnumSet<CacheFlag> flags) {
        int value = 0;
        if (flags.contains((Object)CacheFlag.FORCE)) {
            value |= ClientNamenodeProtocolProtos.CacheFlagProto.FORCE.getNumber();
        }
        return value;
    }

    public static EnumSet<CacheFlag> convertCacheFlags(int flags) {
        EnumSet<CacheFlag> result = EnumSet.noneOf(CacheFlag.class);
        if ((flags & 1) == 1) {
            result.add(CacheFlag.FORCE);
        }
        return result;
    }

    public static HdfsFileStatus convert(HdfsProtos.HdfsFileStatusProto fs) {
        if (fs == null) {
            return null;
        }
        return new HdfsLocatedFileStatus(fs.getLength(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR), fs.getBlockReplication(), fs.getBlocksize(), fs.getModificationTime(), fs.getAccessTime(), PBHelper.convert(fs.getPermission()), fs.getOwner(), fs.getGroup(), fs.getFileType().equals((Object)HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK) ? fs.getSymlink().toByteArray() : null, fs.getPath().toByteArray(), fs.hasFileId() ? fs.getFileId() : 0L, fs.hasLocations() ? PBHelper.convert(fs.getLocations()) : null, fs.hasChildrenNum() ? fs.getChildrenNum() : -1, fs.hasFileEncryptionInfo() ? PBHelper.convert(fs.getFileEncryptionInfo()) : null, fs.hasStoragePolicy() ? (byte)fs.getStoragePolicy() : (byte)0);
    }

    public static SnapshottableDirectoryStatus convert(HdfsProtos.SnapshottableDirectoryStatusProto sdirStatusProto) {
        if (sdirStatusProto == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto status = sdirStatusProto.getDirStatus();
        return new SnapshottableDirectoryStatus(status.getModificationTime(), status.getAccessTime(), PBHelper.convert(status.getPermission()), status.getOwner(), status.getGroup(), status.getPath().toByteArray(), status.getFileId(), status.getChildrenNum(), sdirStatusProto.getSnapshotNumber(), sdirStatusProto.getSnapshotQuota(), sdirStatusProto.getParentFullpath().toByteArray());
    }

    public static HdfsProtos.HdfsFileStatusProto convert(HdfsFileStatus fs) {
        HdfsLocatedFileStatus lfs;
        LocatedBlocks locations;
        if (fs == null) {
            return null;
        }
        HdfsProtos.HdfsFileStatusProto.FileType fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE;
        if (fs.isDir()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_DIR;
        } else if (fs.isSymlink()) {
            fType = HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK;
        }
        HdfsProtos.HdfsFileStatusProto.Builder builder = HdfsProtos.HdfsFileStatusProto.newBuilder().setLength(fs.getLen()).setFileType(fType).setBlockReplication(fs.getReplication()).setBlocksize(fs.getBlockSize()).setModificationTime(fs.getModificationTime()).setAccessTime(fs.getAccessTime()).setPermission(PBHelper.convert(fs.getPermission())).setOwner(fs.getOwner()).setGroup(fs.getGroup()).setFileId(fs.getFileId()).setChildrenNum(fs.getChildrenNum()).setPath(ByteString.copyFrom((byte[])fs.getLocalNameInBytes())).setStoragePolicy(fs.getStoragePolicy());
        if (fs.isSymlink()) {
            builder.setSymlink(ByteString.copyFrom((byte[])fs.getSymlinkInBytes()));
        }
        if (fs.getFileEncryptionInfo() != null) {
            builder.setFileEncryptionInfo(PBHelper.convert(fs.getFileEncryptionInfo()));
        }
        if (fs instanceof HdfsLocatedFileStatus && (locations = (lfs = (HdfsLocatedFileStatus)fs).getBlockLocations()) != null) {
            builder.setLocations(PBHelper.convert(locations));
        }
        return builder.build();
    }

    public static HdfsProtos.SnapshottableDirectoryStatusProto convert(SnapshottableDirectoryStatus status) {
        if (status == null) {
            return null;
        }
        int snapshotNumber = status.getSnapshotNumber();
        int snapshotQuota = status.getSnapshotQuota();
        byte[] parentFullPath = status.getParentFullPath();
        ByteString parentFullPathBytes = ByteString.copyFrom((byte[])(parentFullPath == null ? DFSUtil.EMPTY_BYTES : parentFullPath));
        HdfsProtos.HdfsFileStatusProto fs = PBHelper.convert(status.getDirStatus());
        HdfsProtos.SnapshottableDirectoryStatusProto.Builder builder = HdfsProtos.SnapshottableDirectoryStatusProto.newBuilder().setSnapshotNumber(snapshotNumber).setSnapshotQuota(snapshotQuota).setParentFullpath(parentFullPathBytes).setDirStatus(fs);
        return builder.build();
    }

    public static HdfsProtos.HdfsFileStatusProto[] convert(HdfsFileStatus[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsProtos.HdfsFileStatusProto[] result = new HdfsProtos.HdfsFileStatusProto[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static HdfsFileStatus[] convert(HdfsProtos.HdfsFileStatusProto[] fs) {
        if (fs == null) {
            return null;
        }
        int len = fs.length;
        HdfsFileStatus[] result = new HdfsFileStatus[len];
        for (int i = 0; i < len; ++i) {
            result[i] = PBHelper.convert(fs[i]);
        }
        return result;
    }

    public static DirectoryListing convert(HdfsProtos.DirectoryListingProto dl) {
        if (dl == null) {
            return null;
        }
        List<HdfsProtos.HdfsFileStatusProto> partList = dl.getPartialListingList();
        return new DirectoryListing(partList.isEmpty() ? new HdfsLocatedFileStatus[]{} : PBHelper.convert(partList.toArray(new HdfsProtos.HdfsFileStatusProto[partList.size()])), dl.getRemainingEntries());
    }

    public static HdfsProtos.DirectoryListingProto convert(DirectoryListing d) {
        if (d == null) {
            return null;
        }
        return HdfsProtos.DirectoryListingProto.newBuilder().addAllPartialListing(Arrays.asList(PBHelper.convert(d.getPartialListing()))).setRemainingEntries(d.getRemainingEntries()).build();
    }

    public static long[] convert(ClientNamenodeProtocolProtos.GetFsStatsResponseProto res) {
        long[] result = new long[]{res.getCapacity(), res.getUsed(), res.getRemaining(), res.getUnderReplicated(), res.getCorruptBlocks(), res.getMissingBlocks(), res.getMissingReplOneBlocks()};
        return result;
    }

    public static ClientNamenodeProtocolProtos.GetFsStatsResponseProto convert(long[] fsStats) {
        ClientNamenodeProtocolProtos.GetFsStatsResponseProto.Builder result = ClientNamenodeProtocolProtos.GetFsStatsResponseProto.newBuilder();
        if (fsStats.length >= 1) {
            result.setCapacity(fsStats[0]);
        }
        if (fsStats.length >= 2) {
            result.setUsed(fsStats[1]);
        }
        if (fsStats.length >= 3) {
            result.setRemaining(fsStats[2]);
        }
        if (fsStats.length >= 4) {
            result.setUnderReplicated(fsStats[3]);
        }
        if (fsStats.length >= 5) {
            result.setCorruptBlocks(fsStats[4]);
        }
        if (fsStats.length >= 6) {
            result.setMissingBlocks(fsStats[5]);
        }
        if (fsStats.length >= 7) {
            result.setMissingReplOneBlocks(fsStats[6]);
        }
        return result.build();
    }

    public static ClientNamenodeProtocolProtos.DatanodeReportTypeProto convert(HdfsConstants.DatanodeReportType t) {
        switch (t) {
            case ALL: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.ALL;
            }
            case LIVE: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.LIVE;
            }
            case DEAD: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DEAD;
            }
            case DECOMMISSIONING: {
                return ClientNamenodeProtocolProtos.DatanodeReportTypeProto.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static HdfsConstants.DatanodeReportType convert(ClientNamenodeProtocolProtos.DatanodeReportTypeProto t) {
        switch (t) {
            case ALL: {
                return HdfsConstants.DatanodeReportType.ALL;
            }
            case LIVE: {
                return HdfsConstants.DatanodeReportType.LIVE;
            }
            case DEAD: {
                return HdfsConstants.DatanodeReportType.DEAD;
            }
            case DECOMMISSIONING: {
                return HdfsConstants.DatanodeReportType.DECOMMISSIONING;
            }
        }
        throw new IllegalArgumentException("Unexpected data type report:" + (Object)((Object)t));
    }

    public static ClientNamenodeProtocolProtos.SafeModeActionProto convert(HdfsConstants.SafeModeAction a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return ClientNamenodeProtocolProtos.SafeModeActionProto.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static HdfsConstants.SafeModeAction convert(ClientNamenodeProtocolProtos.SafeModeActionProto a) {
        switch (a) {
            case SAFEMODE_LEAVE: {
                return HdfsConstants.SafeModeAction.SAFEMODE_LEAVE;
            }
            case SAFEMODE_ENTER: {
                return HdfsConstants.SafeModeAction.SAFEMODE_ENTER;
            }
            case SAFEMODE_GET: {
                return HdfsConstants.SafeModeAction.SAFEMODE_GET;
            }
        }
        throw new IllegalArgumentException("Unexpected SafeModeAction :" + (Object)((Object)a));
    }

    public static EncryptionZonesProtos.ReencryptActionProto convert(HdfsConstants.ReencryptAction a) {
        switch (a) {
            case CANCEL: {
                return EncryptionZonesProtos.ReencryptActionProto.CANCEL_REENCRYPT;
            }
            case START: {
                return EncryptionZonesProtos.ReencryptActionProto.START_REENCRYPT;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsConstants.ReencryptAction convert(EncryptionZonesProtos.ReencryptActionProto a) {
        switch (a) {
            case CANCEL_REENCRYPT: {
                return HdfsConstants.ReencryptAction.CANCEL;
            }
            case START_REENCRYPT: {
                return HdfsConstants.ReencryptAction.START;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeActionProto convert(HdfsConstants.RollingUpgradeAction a) {
        switch (a) {
            case QUERY: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.QUERY;
            }
            case PREPARE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.START;
            }
            case FINALIZE: {
                return ClientNamenodeProtocolProtos.RollingUpgradeActionProto.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsConstants.RollingUpgradeAction convert(ClientNamenodeProtocolProtos.RollingUpgradeActionProto a) {
        switch (a) {
            case QUERY: {
                return HdfsConstants.RollingUpgradeAction.QUERY;
            }
            case START: {
                return HdfsConstants.RollingUpgradeAction.PREPARE;
            }
            case FINALIZE: {
                return HdfsConstants.RollingUpgradeAction.FINALIZE;
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)a));
    }

    public static HdfsProtos.RollingUpgradeStatusProto convertRollingUpgradeStatus(RollingUpgradeStatus status) {
        return HdfsProtos.RollingUpgradeStatusProto.newBuilder().setBlockPoolId(status.getBlockPoolId()).setFinalized(status.isFinalized()).build();
    }

    public static RollingUpgradeStatus convert(HdfsProtos.RollingUpgradeStatusProto proto) {
        return new RollingUpgradeStatus(proto.getBlockPoolId(), proto.getFinalized());
    }

    public static ClientNamenodeProtocolProtos.RollingUpgradeInfoProto convert(RollingUpgradeInfo info) {
        return ClientNamenodeProtocolProtos.RollingUpgradeInfoProto.newBuilder().setStatus(PBHelper.convertRollingUpgradeStatus(info)).setCreatedRollbackImages(info.createdRollbackImages()).setStartTime(info.getStartTime()).setFinalizeTime(info.getFinalizeTime()).build();
    }

    public static RollingUpgradeInfo convert(ClientNamenodeProtocolProtos.RollingUpgradeInfoProto proto) {
        HdfsProtos.RollingUpgradeStatusProto status = proto.getStatus();
        return new RollingUpgradeInfo(status.getBlockPoolId(), proto.getCreatedRollbackImages(), proto.getStartTime(), proto.getFinalizeTime());
    }

    public static CorruptFileBlocks convert(HdfsProtos.CorruptFileBlocksProto c) {
        if (c == null) {
            return null;
        }
        List<String> fileList = c.getFilesList();
        return new CorruptFileBlocks(fileList.toArray(new String[fileList.size()]), c.getCookie());
    }

    public static HdfsProtos.CorruptFileBlocksProto convert(CorruptFileBlocks c) {
        if (c == null) {
            return null;
        }
        return HdfsProtos.CorruptFileBlocksProto.newBuilder().addAllFiles(Arrays.asList(c.getFiles())).setCookie(c.getCookie()).build();
    }

    public static ContentSummary convert(HdfsProtos.ContentSummaryProto cs) {
        if (cs == null) {
            return null;
        }
        return new ContentSummary(cs.getLength(), cs.getFileCount(), cs.getDirectoryCount(), cs.getQuota(), cs.getSpaceConsumed(), cs.getSpaceQuota(), cs.getSnapshotLength(), cs.getSnapshotFileCount(), cs.getSnapshotDirectoryCount(), cs.getSnapshotSpaceConsumed());
    }

    public static HdfsProtos.ContentSummaryProto convert(ContentSummary cs) {
        if (cs == null) {
            return null;
        }
        return HdfsProtos.ContentSummaryProto.newBuilder().setLength(cs.getLength()).setFileCount(cs.getFileCount()).setDirectoryCount(cs.getDirectoryCount()).setSnapshotLength(cs.getSnapshotLength()).setSnapshotFileCount(cs.getSnapshotFileCount()).setSnapshotDirectoryCount(cs.getSnapshotDirectoryCount()).setSnapshotSpaceConsumed(cs.getSnapshotSpaceConsumed()).setQuota(cs.getQuota()).setSpaceConsumed(cs.getSpaceConsumed()).setSpaceQuota(cs.getSpaceQuota()).build();
    }

    public static NNHAStatusHeartbeat convert(DatanodeProtocolProtos.NNHAStatusHeartbeatProto s) {
        if (s == null) {
            return null;
        }
        switch (s.getState()) {
            case ACTIVE: {
                return new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, s.getTxid());
            }
            case STANDBY: {
                return new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.STANDBY, s.getTxid());
            }
        }
        throw new IllegalArgumentException("Unexpected NNHAStatusHeartbeat.State:" + (Object)((Object)s.getState()));
    }

    public static DatanodeProtocolProtos.NNHAStatusHeartbeatProto convert(NNHAStatusHeartbeat hb) {
        if (hb == null) {
            return null;
        }
        DatanodeProtocolProtos.NNHAStatusHeartbeatProto.Builder builder = DatanodeProtocolProtos.NNHAStatusHeartbeatProto.newBuilder();
        switch (hb.getState()) {
            case ACTIVE: {
                builder.setState(DatanodeProtocolProtos.NNHAStatusHeartbeatProto.State.ACTIVE);
                break;
            }
            case STANDBY: {
                builder.setState(DatanodeProtocolProtos.NNHAStatusHeartbeatProto.State.STANDBY);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected NNHAStatusHeartbeat.State:" + hb.getState());
            }
        }
        builder.setTxid(hb.getTxId());
        return builder.build();
    }

    public static HdfsProtos.DatanodeStorageProto convert(DatanodeStorage s) {
        return HdfsProtos.DatanodeStorageProto.newBuilder().setState(PBHelper.convertState(s.getState())).setStorageType(PBHelper.convertStorageType(s.getStorageType())).setStorageUuid(s.getStorageID()).build();
    }

    private static HdfsProtos.DatanodeStorageProto.StorageState convertState(DatanodeStorage.State state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return HdfsProtos.DatanodeStorageProto.StorageState.READ_ONLY_SHARED;
            }
        }
        return HdfsProtos.DatanodeStorageProto.StorageState.NORMAL;
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types) {
        return PBHelper.convertStorageTypes(types, 0);
    }

    public static List<HdfsProtos.StorageTypeProto> convertStorageTypes(StorageType[] types, int startIdx) {
        if (types == null) {
            return null;
        }
        ArrayList<HdfsProtos.StorageTypeProto> protos = new ArrayList<HdfsProtos.StorageTypeProto>(types.length);
        for (int i = startIdx; i < types.length; ++i) {
            protos.add(PBHelper.convertStorageType(types[i]));
        }
        return protos;
    }

    public static HdfsProtos.StorageTypeProto convertStorageType(StorageType type) {
        switch (type) {
            case DISK: {
                return HdfsProtos.StorageTypeProto.DISK;
            }
            case SSD: {
                return HdfsProtos.StorageTypeProto.SSD;
            }
            case ARCHIVE: {
                return HdfsProtos.StorageTypeProto.ARCHIVE;
            }
            case RAM_DISK: {
                return HdfsProtos.StorageTypeProto.RAM_DISK;
            }
        }
        throw new IllegalStateException("BUG: StorageType not found, type=" + (Object)((Object)type));
    }

    public static DatanodeStorage convert(HdfsProtos.DatanodeStorageProto s) {
        return new DatanodeStorage(s.getStorageUuid(), PBHelper.convertState(s.getState()), PBHelper.convertStorageType(s.getStorageType()));
    }

    private static DatanodeStorage.State convertState(HdfsProtos.DatanodeStorageProto.StorageState state) {
        switch (state) {
            case READ_ONLY_SHARED: {
                return DatanodeStorage.State.READ_ONLY_SHARED;
            }
        }
        return DatanodeStorage.State.NORMAL;
    }

    public static StorageType convertStorageType(HdfsProtos.StorageTypeProto type) {
        switch (type) {
            case DISK: {
                return StorageType.DISK;
            }
            case SSD: {
                return StorageType.SSD;
            }
            case ARCHIVE: {
                return StorageType.ARCHIVE;
            }
            case RAM_DISK: {
                return StorageType.RAM_DISK;
            }
        }
        throw new IllegalStateException("BUG: StorageTypeProto not found, type=" + (Object)((Object)type));
    }

    public static StorageType[] convertStorageTypes(List<HdfsProtos.StorageTypeProto> storageTypesList, int expectedSize) {
        StorageType[] storageTypes = new StorageType[expectedSize];
        if (storageTypesList.size() != expectedSize) {
            Preconditions.checkState((boolean)storageTypesList.isEmpty());
            Arrays.fill((Object[])storageTypes, (Object)StorageType.DEFAULT);
        } else {
            for (int i = 0; i < storageTypes.length; ++i) {
                storageTypes[i] = PBHelper.convertStorageType(storageTypesList.get(i));
            }
        }
        return storageTypes;
    }

    public static HdfsProtos.StorageReportProto convert(StorageReport r) {
        HdfsProtos.StorageReportProto.Builder builder = HdfsProtos.StorageReportProto.newBuilder().setBlockPoolUsed(r.getBlockPoolUsed()).setCapacity(r.getCapacity()).setDfsUsed(r.getDfsUsed()).setRemaining(r.getRemaining()).setStorageUuid(r.getStorage().getStorageID()).setStorage(PBHelper.convert(r.getStorage())).setNonDfsUsed(r.getNonDfsUsed());
        return builder.build();
    }

    public static StorageReport convert(HdfsProtos.StorageReportProto p) {
        long nonDfsUsed = p.hasNonDfsUsed() ? p.getNonDfsUsed() : p.getCapacity() - p.getDfsUsed() - p.getRemaining();
        return new StorageReport(p.hasStorage() ? PBHelper.convert(p.getStorage()) : new DatanodeStorage(p.getStorageUuid()), p.getFailed(), p.getCapacity(), p.getDfsUsed(), p.getRemaining(), p.getBlockPoolUsed(), nonDfsUsed);
    }

    public static StorageReport[] convertStorageReports(List<HdfsProtos.StorageReportProto> list) {
        StorageReport[] report = new StorageReport[list.size()];
        for (int i = 0; i < report.length; ++i) {
            report[i] = PBHelper.convert(list.get(i));
        }
        return report;
    }

    public static List<HdfsProtos.StorageReportProto> convertStorageReports(StorageReport[] storages) {
        ArrayList<HdfsProtos.StorageReportProto> protos = new ArrayList<HdfsProtos.StorageReportProto>(storages.length);
        for (int i = 0; i < storages.length; ++i) {
            protos.add(PBHelper.convert(storages[i]));
        }
        return protos;
    }

    public static VolumeFailureSummary convertVolumeFailureSummary(DatanodeProtocolProtos.VolumeFailureSummaryProto proto) {
        List<String> failedStorageLocations = proto.getFailedStorageLocationsList();
        return new VolumeFailureSummary(failedStorageLocations.toArray(new String[failedStorageLocations.size()]), proto.getLastVolumeFailureDate(), proto.getEstimatedCapacityLostTotal());
    }

    public static DatanodeProtocolProtos.VolumeFailureSummaryProto convertVolumeFailureSummary(VolumeFailureSummary volumeFailureSummary) {
        DatanodeProtocolProtos.VolumeFailureSummaryProto.Builder builder = DatanodeProtocolProtos.VolumeFailureSummaryProto.newBuilder();
        for (String failedStorageLocation : volumeFailureSummary.getFailedStorageLocations()) {
            builder.addFailedStorageLocations(failedStorageLocation);
        }
        builder.setLastVolumeFailureDate(volumeFailureSummary.getLastVolumeFailureDate());
        builder.setEstimatedCapacityLostTotal(volumeFailureSummary.getEstimatedCapacityLostTotal());
        return builder.build();
    }

    public static JournalInfo convert(JournalProtocolProtos.JournalInfoProto info) {
        int lv = info.hasLayoutVersion() ? info.getLayoutVersion() : 0;
        int nsID = info.hasNamespaceID() ? info.getNamespaceID() : 0;
        return new JournalInfo(lv, info.getClusterID(), nsID);
    }

    public static JournalProtocolProtos.JournalInfoProto convert(JournalInfo j) {
        return JournalProtocolProtos.JournalInfoProto.newBuilder().setClusterID(j.getClusterId()).setLayoutVersion(j.getLayoutVersion()).setNamespaceID(j.getNamespaceId()).build();
    }

    public static SnapshottableDirectoryStatus[] convert(HdfsProtos.SnapshottableDirectoryListingProto sdlp) {
        if (sdlp == null) {
            return null;
        }
        List<HdfsProtos.SnapshottableDirectoryStatusProto> list = sdlp.getSnapshottableDirListingList();
        if (list.isEmpty()) {
            return new SnapshottableDirectoryStatus[0];
        }
        SnapshottableDirectoryStatus[] result = new SnapshottableDirectoryStatus[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = PBHelper.convert(list.get(i));
        }
        return result;
    }

    public static HdfsProtos.SnapshottableDirectoryListingProto convert(SnapshottableDirectoryStatus[] status) {
        if (status == null) {
            return null;
        }
        HdfsProtos.SnapshottableDirectoryStatusProto[] protos = new HdfsProtos.SnapshottableDirectoryStatusProto[status.length];
        for (int i = 0; i < status.length; ++i) {
            protos[i] = PBHelper.convert(status[i]);
        }
        List<HdfsProtos.SnapshottableDirectoryStatusProto> protoList = Arrays.asList(protos);
        return HdfsProtos.SnapshottableDirectoryListingProto.newBuilder().addAllSnapshottableDirListing(protoList).build();
    }

    public static SnapshotDiffReport.DiffReportEntry convert(HdfsProtos.SnapshotDiffReportEntryProto entry) {
        if (entry == null) {
            return null;
        }
        SnapshotDiffReport.DiffType type = SnapshotDiffReport.DiffType.getTypeFromLabel(entry.getModificationLabel());
        return type == null ? null : new SnapshotDiffReport.DiffReportEntry(type, entry.getFullpath().toByteArray(), entry.hasTargetPath() ? entry.getTargetPath().toByteArray() : null);
    }

    public static HdfsProtos.SnapshotDiffReportEntryProto convert(SnapshotDiffReport.DiffReportEntry entry) {
        if (entry == null) {
            return null;
        }
        ByteString sourcePath = ByteString.copyFrom((byte[])(entry.getSourcePath() == null ? DFSUtil.EMPTY_BYTES : entry.getSourcePath()));
        String modification = entry.getType().getLabel();
        HdfsProtos.SnapshotDiffReportEntryProto.Builder builder = HdfsProtos.SnapshotDiffReportEntryProto.newBuilder().setFullpath(sourcePath).setModificationLabel(modification);
        if (entry.getType() == SnapshotDiffReport.DiffType.RENAME) {
            ByteString targetPath = ByteString.copyFrom((byte[])(entry.getTargetPath() == null ? DFSUtil.EMPTY_BYTES : entry.getTargetPath()));
            builder.setTargetPath(targetPath);
        }
        return builder.build();
    }

    public static SnapshotDiffReport convert(HdfsProtos.SnapshotDiffReportProto reportProto) {
        if (reportProto == null) {
            return null;
        }
        String snapshotDir = reportProto.getSnapshotRoot();
        String fromSnapshot = reportProto.getFromSnapshot();
        String toSnapshot = reportProto.getToSnapshot();
        List<HdfsProtos.SnapshotDiffReportEntryProto> list = reportProto.getDiffReportEntriesList();
        ChunkedArrayList entries = new ChunkedArrayList();
        for (HdfsProtos.SnapshotDiffReportEntryProto entryProto : list) {
            SnapshotDiffReport.DiffReportEntry entry = PBHelper.convert(entryProto);
            if (entry == null) continue;
            entries.add(entry);
        }
        return new SnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot, (List<SnapshotDiffReport.DiffReportEntry>)entries);
    }

    public static HdfsProtos.SnapshotDiffReportProto convert(SnapshotDiffReport report) {
        if (report == null) {
            return null;
        }
        List<SnapshotDiffReport.DiffReportEntry> entries = report.getDiffList();
        ChunkedArrayList entryProtos = new ChunkedArrayList();
        for (SnapshotDiffReport.DiffReportEntry entry : entries) {
            HdfsProtos.SnapshotDiffReportEntryProto entryProto = PBHelper.convert(entry);
            if (entryProto == null) continue;
            entryProtos.add(entryProto);
        }
        HdfsProtos.SnapshotDiffReportProto reportProto = HdfsProtos.SnapshotDiffReportProto.newBuilder().setSnapshotRoot(report.getSnapshotRoot()).setFromSnapshot(report.getFromSnapshot()).setToSnapshot(report.getLaterSnapshotName()).addAllDiffReportEntries((Iterable<? extends HdfsProtos.SnapshotDiffReportEntryProto>)entryProtos).build();
        return reportProto;
    }

    public static DataChecksum.Type convert(HdfsProtos.ChecksumTypeProto type) {
        return DataChecksum.Type.valueOf((int)type.getNumber());
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoProto convert(CacheDirectiveInfo info) {
        ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveInfoProto.newBuilder();
        if (info.getId() != null) {
            builder.setId(info.getId());
        }
        if (info.getPath() != null) {
            builder.setPath(info.getPath().toUri().getPath());
        }
        if (info.getReplication() != null) {
            builder.setReplication(info.getReplication().shortValue());
        }
        if (info.getPool() != null) {
            builder.setPool(info.getPool());
        }
        if (info.getExpiration() != null) {
            builder.setExpiration(PBHelper.convert(info.getExpiration()));
        }
        return builder.build();
    }

    public static CacheDirectiveInfo convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoProto proto) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        if (proto.hasId()) {
            builder.setId(proto.getId());
        }
        if (proto.hasPath()) {
            builder.setPath(new Path(proto.getPath()));
        }
        if (proto.hasReplication()) {
            builder.setReplication(Shorts.checkedCast((long)proto.getReplication()));
        }
        if (proto.hasPool()) {
            builder.setPool(proto.getPool());
        }
        if (proto.hasExpiration()) {
            builder.setExpiration(PBHelper.convert(proto.getExpiration()));
        }
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto convert(CacheDirectiveInfo.Expiration expiration) {
        return ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto.newBuilder().setIsRelative(expiration.isRelative()).setMillis(expiration.getMillis()).build();
    }

    public static CacheDirectiveInfo.Expiration convert(ClientNamenodeProtocolProtos.CacheDirectiveInfoExpirationProto proto) {
        if (proto.getIsRelative()) {
            return CacheDirectiveInfo.Expiration.newRelative(proto.getMillis());
        }
        return CacheDirectiveInfo.Expiration.newAbsolute(proto.getMillis());
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveStatsProto convert(CacheDirectiveStats stats) {
        ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        builder.setHasExpired(stats.hasExpired());
        return builder.build();
    }

    public static CacheDirectiveStats convert(ClientNamenodeProtocolProtos.CacheDirectiveStatsProto proto) {
        CacheDirectiveStats.Builder builder = new CacheDirectiveStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        builder.setHasExpired(proto.getHasExpired());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CacheDirectiveEntryProto convert(CacheDirectiveEntry entry) {
        ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.Builder builder = ClientNamenodeProtocolProtos.CacheDirectiveEntryProto.newBuilder();
        builder.setInfo(PBHelper.convert(entry.getInfo()));
        builder.setStats(PBHelper.convert(entry.getStats()));
        return builder.build();
    }

    public static CacheDirectiveEntry convert(ClientNamenodeProtocolProtos.CacheDirectiveEntryProto proto) {
        CacheDirectiveInfo info = PBHelper.convert(proto.getInfo());
        CacheDirectiveStats stats = PBHelper.convert(proto.getStats());
        return new CacheDirectiveEntry(info, stats);
    }

    public static ClientNamenodeProtocolProtos.CachePoolInfoProto convert(CachePoolInfo info) {
        ClientNamenodeProtocolProtos.CachePoolInfoProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolInfoProto.newBuilder();
        builder.setPoolName(info.getPoolName());
        if (info.getOwnerName() != null) {
            builder.setOwnerName(info.getOwnerName());
        }
        if (info.getGroupName() != null) {
            builder.setGroupName(info.getGroupName());
        }
        if (info.getMode() != null) {
            builder.setMode(info.getMode().toShort());
        }
        if (info.getLimit() != null) {
            builder.setLimit(info.getLimit());
        }
        if (info.getMaxRelativeExpiryMs() != null) {
            builder.setMaxRelativeExpiry(info.getMaxRelativeExpiryMs());
        }
        return builder.build();
    }

    public static CachePoolInfo convert(ClientNamenodeProtocolProtos.CachePoolInfoProto proto) {
        String poolName = (String)Preconditions.checkNotNull((Object)proto.getPoolName());
        CachePoolInfo info = new CachePoolInfo(poolName);
        if (proto.hasOwnerName()) {
            info.setOwnerName(proto.getOwnerName());
        }
        if (proto.hasGroupName()) {
            info.setGroupName(proto.getGroupName());
        }
        if (proto.hasMode()) {
            info.setMode(new FsPermission((short)proto.getMode()));
        }
        if (proto.hasLimit()) {
            info.setLimit(proto.getLimit());
        }
        if (proto.hasMaxRelativeExpiry()) {
            info.setMaxRelativeExpiryMs(proto.getMaxRelativeExpiry());
        }
        return info;
    }

    public static ClientNamenodeProtocolProtos.CachePoolStatsProto convert(CachePoolStats stats) {
        ClientNamenodeProtocolProtos.CachePoolStatsProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolStatsProto.newBuilder();
        builder.setBytesNeeded(stats.getBytesNeeded());
        builder.setBytesCached(stats.getBytesCached());
        builder.setBytesOverlimit(stats.getBytesOverlimit());
        builder.setFilesNeeded(stats.getFilesNeeded());
        builder.setFilesCached(stats.getFilesCached());
        return builder.build();
    }

    public static CachePoolStats convert(ClientNamenodeProtocolProtos.CachePoolStatsProto proto) {
        CachePoolStats.Builder builder = new CachePoolStats.Builder();
        builder.setBytesNeeded(proto.getBytesNeeded());
        builder.setBytesCached(proto.getBytesCached());
        builder.setBytesOverlimit(proto.getBytesOverlimit());
        builder.setFilesNeeded(proto.getFilesNeeded());
        builder.setFilesCached(proto.getFilesCached());
        return builder.build();
    }

    public static ClientNamenodeProtocolProtos.CachePoolEntryProto convert(CachePoolEntry entry) {
        ClientNamenodeProtocolProtos.CachePoolEntryProto.Builder builder = ClientNamenodeProtocolProtos.CachePoolEntryProto.newBuilder();
        builder.setInfo(PBHelper.convert(entry.getInfo()));
        builder.setStats(PBHelper.convert(entry.getStats()));
        return builder.build();
    }

    public static CachePoolEntry convert(ClientNamenodeProtocolProtos.CachePoolEntryProto proto) {
        CachePoolInfo info = PBHelper.convert(proto.getInfo());
        CachePoolStats stats = PBHelper.convert(proto.getStats());
        return new CachePoolEntry(info, stats);
    }

    public static HdfsProtos.ChecksumTypeProto convert(DataChecksum.Type type) {
        return HdfsProtos.ChecksumTypeProto.valueOf(type.id);
    }

    public static HdfsProtos.DatanodeLocalInfoProto convert(DatanodeLocalInfo info) {
        HdfsProtos.DatanodeLocalInfoProto.Builder builder = HdfsProtos.DatanodeLocalInfoProto.newBuilder();
        builder.setSoftwareVersion(info.getSoftwareVersion());
        builder.setConfigVersion(info.getConfigVersion());
        builder.setUptime(info.getUptime());
        return builder.build();
    }

    public static DatanodeLocalInfo convert(HdfsProtos.DatanodeLocalInfoProto proto) {
        return new DatanodeLocalInfo(proto.getSoftwareVersion(), proto.getConfigVersion(), proto.getUptime());
    }

    public static InputStream vintPrefixed(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw new EOFException("Premature EOF: no length prefix available");
        }
        int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)input);
        assert (size >= 0);
        return new ExactSizeInputStream(input, size);
    }

    private static AclProtos.AclEntryProto.AclEntryScopeProto convert(AclEntryScope v) {
        return AclProtos.AclEntryProto.AclEntryScopeProto.valueOf(v.ordinal());
    }

    private static AclEntryScope convert(AclProtos.AclEntryProto.AclEntryScopeProto v) {
        return (AclEntryScope)PBHelper.castEnum((Enum)v, (Enum[])ACL_ENTRY_SCOPE_VALUES);
    }

    private static AclProtos.AclEntryProto.AclEntryTypeProto convert(AclEntryType e) {
        return AclProtos.AclEntryProto.AclEntryTypeProto.valueOf(e.ordinal());
    }

    private static AclEntryType convert(AclProtos.AclEntryProto.AclEntryTypeProto v) {
        return (AclEntryType)PBHelper.castEnum((Enum)v, (Enum[])ACL_ENTRY_TYPE_VALUES);
    }

    private static XAttrProtos.XAttrProto.XAttrNamespaceProto convert(XAttr.NameSpace v) {
        return XAttrProtos.XAttrProto.XAttrNamespaceProto.valueOf(v.ordinal());
    }

    private static XAttr.NameSpace convert(XAttrProtos.XAttrProto.XAttrNamespaceProto v) {
        return (XAttr.NameSpace)PBHelper.castEnum((Enum)v, (Enum[])XATTR_NAMESPACE_VALUES);
    }

    public static AclProtos.AclEntryProto.FsActionProto convert(FsAction v) {
        return AclProtos.AclEntryProto.FsActionProto.valueOf(v != null ? v.ordinal() : 0);
    }

    public static FsAction convert(AclProtos.AclEntryProto.FsActionProto v) {
        return (FsAction)PBHelper.castEnum((Enum)v, (Enum[])FSACTION_VALUES);
    }

    public static List<AclProtos.AclEntryProto> convertAclEntryProto(List<AclEntry> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclEntry e : aclSpec) {
            AclProtos.AclEntryProto.Builder builder = AclProtos.AclEntryProto.newBuilder();
            builder.setType(PBHelper.convert(e.getType()));
            builder.setScope(PBHelper.convert(e.getScope()));
            builder.setPermissions(PBHelper.convert(e.getPermission()));
            if (e.getName() != null) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static List<AclEntry> convertAclEntry(List<AclProtos.AclEntryProto> aclSpec) {
        ArrayList r = Lists.newArrayListWithCapacity((int)aclSpec.size());
        for (AclProtos.AclEntryProto e : aclSpec) {
            AclEntry.Builder builder = new AclEntry.Builder();
            builder.setType(PBHelper.convert(e.getType()));
            builder.setScope(PBHelper.convert(e.getScope()));
            builder.setPermission(PBHelper.convert(e.getPermissions()));
            if (e.hasName()) {
                builder.setName(e.getName());
            }
            r.add(builder.build());
        }
        return r;
    }

    public static AclStatus convert(AclProtos.GetAclStatusResponseProto e) {
        AclProtos.AclStatusProto r = e.getResult();
        AclStatus.Builder builder = new AclStatus.Builder();
        builder.owner(r.getOwner()).group(r.getGroup()).stickyBit(r.getSticky()).addEntries(PBHelper.convertAclEntry(r.getEntriesList()));
        if (r.hasPermission()) {
            builder.setPermission(PBHelper.convert(r.getPermission()));
        }
        return builder.build();
    }

    public static AclProtos.GetAclStatusResponseProto convert(AclStatus e) {
        AclProtos.AclStatusProto.Builder builder = AclProtos.AclStatusProto.newBuilder();
        builder.setOwner(e.getOwner()).setGroup(e.getGroup()).setSticky(e.isStickyBit()).addAllEntries(PBHelper.convertAclEntryProto(e.getEntries()));
        if (e.getPermission() != null) {
            builder.setPermission(PBHelper.convert(e.getPermission()));
        }
        AclProtos.AclStatusProto r = builder.build();
        return AclProtos.GetAclStatusResponseProto.newBuilder().setResult(r).build();
    }

    public static XAttrProtos.XAttrProto convertXAttrProto(XAttr a) {
        XAttrProtos.XAttrProto.Builder builder = XAttrProtos.XAttrProto.newBuilder();
        builder.setNamespace(PBHelper.convert(a.getNameSpace()));
        if (a.getName() != null) {
            builder.setName(a.getName());
        }
        if (a.getValue() != null) {
            builder.setValue(PBHelper.getByteString(a.getValue()));
        }
        return builder.build();
    }

    public static List<XAttrProtos.XAttrProto> convertXAttrProto(List<XAttr> xAttrSpec) {
        if (xAttrSpec == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)xAttrSpec.size());
        for (XAttr a : xAttrSpec) {
            XAttrProtos.XAttrProto.Builder builder = XAttrProtos.XAttrProto.newBuilder();
            builder.setNamespace(PBHelper.convert(a.getNameSpace()));
            if (a.getName() != null) {
                builder.setName(a.getName());
            }
            if (a.getValue() != null) {
                builder.setValue(PBHelper.getByteString(a.getValue()));
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    public static int convert(EnumSet<XAttrSetFlag> flag) {
        int value = 0;
        if (flag.contains(XAttrSetFlag.CREATE)) {
            value |= XAttrProtos.XAttrSetFlagProto.XATTR_CREATE.getNumber();
        }
        if (flag.contains(XAttrSetFlag.REPLACE)) {
            value |= XAttrProtos.XAttrSetFlagProto.XATTR_REPLACE.getNumber();
        }
        return value;
    }

    public static EnumSet<XAttrSetFlag> convert(int flag) {
        EnumSet<XAttrSetFlag> result = EnumSet.noneOf(XAttrSetFlag.class);
        if ((flag & 1) == 1) {
            result.add(XAttrSetFlag.CREATE);
        }
        if ((flag & 2) == 2) {
            result.add(XAttrSetFlag.REPLACE);
        }
        return result;
    }

    public static XAttr convertXAttr(XAttrProtos.XAttrProto a) {
        XAttr.Builder builder = new XAttr.Builder();
        builder.setNameSpace(PBHelper.convert(a.getNamespace()));
        if (a.hasName()) {
            builder.setName(a.getName());
        }
        if (a.hasValue()) {
            builder.setValue(a.getValue().toByteArray());
        }
        return builder.build();
    }

    public static List<XAttr> convertXAttrs(List<XAttrProtos.XAttrProto> xAttrSpec) {
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)xAttrSpec.size());
        for (XAttrProtos.XAttrProto a : xAttrSpec) {
            XAttr.Builder builder = new XAttr.Builder();
            builder.setNameSpace(PBHelper.convert(a.getNamespace()));
            if (a.hasName()) {
                builder.setName(a.getName());
            }
            if (a.hasValue()) {
                builder.setValue(a.getValue().toByteArray());
            }
            xAttrs.add(builder.build());
        }
        return xAttrs;
    }

    public static List<XAttr> convert(XAttrProtos.GetXAttrsResponseProto a) {
        List<XAttrProtos.XAttrProto> xAttrs = a.getXAttrsList();
        return PBHelper.convertXAttrs(xAttrs);
    }

    public static XAttrProtos.GetXAttrsResponseProto convertXAttrsResponse(List<XAttr> xAttrs) {
        XAttrProtos.GetXAttrsResponseProto.Builder builder = XAttrProtos.GetXAttrsResponseProto.newBuilder();
        if (xAttrs != null) {
            builder.addAllXAttrs(PBHelper.convertXAttrProto(xAttrs));
        }
        return builder.build();
    }

    public static List<XAttr> convert(XAttrProtos.ListXAttrsResponseProto a) {
        List<XAttrProtos.XAttrProto> xAttrs = a.getXAttrsList();
        return PBHelper.convertXAttrs(xAttrs);
    }

    public static XAttrProtos.ListXAttrsResponseProto convertListXAttrsResponse(List<XAttr> names) {
        XAttrProtos.ListXAttrsResponseProto.Builder builder = XAttrProtos.ListXAttrsResponseProto.newBuilder();
        if (names != null) {
            builder.addAllXAttrs(PBHelper.convertXAttrProto(names));
        }
        return builder.build();
    }

    public static EncryptionZonesProtos.EncryptionZoneProto convert(EncryptionZone zone) {
        return EncryptionZonesProtos.EncryptionZoneProto.newBuilder().setId(zone.getId()).setPath(zone.getPath()).setSuite(PBHelper.convert(zone.getSuite())).setCryptoProtocolVersion(PBHelper.convert(zone.getVersion())).setKeyName(zone.getKeyName()).build();
    }

    public static EncryptionZone convert(EncryptionZonesProtos.EncryptionZoneProto proto) {
        return new EncryptionZone(proto.getId(), proto.getPath(), PBHelper.convert(proto.getSuite()), PBHelper.convert(proto.getCryptoProtocolVersion()), proto.getKeyName());
    }

    public static ClientNamenodeProtocolProtos.OpenFilesBatchResponseProto convert(OpenFileEntry openFileEntry) {
        return ClientNamenodeProtocolProtos.OpenFilesBatchResponseProto.newBuilder().setId(openFileEntry.getId()).setPath(openFileEntry.getFilePath()).setClientName(openFileEntry.getClientName()).setClientMachine(openFileEntry.getClientMachine()).build();
    }

    public static OpenFileEntry convert(ClientNamenodeProtocolProtos.OpenFilesBatchResponseProto proto) {
        return new OpenFileEntry(proto.getId(), proto.getPath(), proto.getClientName(), proto.getClientMachine());
    }

    public static DataTransferProtos.ShortCircuitShmSlotProto convert(ShortCircuitShm.SlotId slotId) {
        return DataTransferProtos.ShortCircuitShmSlotProto.newBuilder().setShmId(PBHelper.convert(slotId.getShmId())).setSlotIdx(slotId.getSlotIdx()).build();
    }

    public static DataTransferProtos.ShortCircuitShmIdProto convert(ShortCircuitShm.ShmId shmId) {
        return DataTransferProtos.ShortCircuitShmIdProto.newBuilder().setHi(shmId.getHi()).setLo(shmId.getLo()).build();
    }

    public static ShortCircuitShm.SlotId convert(DataTransferProtos.ShortCircuitShmSlotProto slotId) {
        return new ShortCircuitShm.SlotId(PBHelper.convert(slotId.getShmId()), slotId.getSlotIdx());
    }

    public static ShortCircuitShm.ShmId convert(DataTransferProtos.ShortCircuitShmIdProto shmId) {
        return new ShortCircuitShm.ShmId(shmId.getHi(), shmId.getLo());
    }

    private static Event.CreateEvent.INodeType createTypeConvert(InotifyProtos.INodeType type) {
        switch (type) {
            case I_TYPE_DIRECTORY: {
                return Event.CreateEvent.INodeType.DIRECTORY;
            }
            case I_TYPE_FILE: {
                return Event.CreateEvent.INodeType.FILE;
            }
            case I_TYPE_SYMLINK: {
                return Event.CreateEvent.INodeType.SYMLINK;
            }
        }
        return null;
    }

    private static InotifyProtos.MetadataUpdateType metadataUpdateTypeConvert(Event.MetadataUpdateEvent.MetadataType type) {
        switch (type) {
            case TIMES: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_TIMES;
            }
            case REPLICATION: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_REPLICATION;
            }
            case OWNER: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_OWNER;
            }
            case PERMS: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_PERMS;
            }
            case ACLS: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_ACLS;
            }
            case XATTRS: {
                return InotifyProtos.MetadataUpdateType.META_TYPE_XATTRS;
            }
        }
        return null;
    }

    private static Event.MetadataUpdateEvent.MetadataType metadataUpdateTypeConvert(InotifyProtos.MetadataUpdateType type) {
        switch (type) {
            case META_TYPE_TIMES: {
                return Event.MetadataUpdateEvent.MetadataType.TIMES;
            }
            case META_TYPE_REPLICATION: {
                return Event.MetadataUpdateEvent.MetadataType.REPLICATION;
            }
            case META_TYPE_OWNER: {
                return Event.MetadataUpdateEvent.MetadataType.OWNER;
            }
            case META_TYPE_PERMS: {
                return Event.MetadataUpdateEvent.MetadataType.PERMS;
            }
            case META_TYPE_ACLS: {
                return Event.MetadataUpdateEvent.MetadataType.ACLS;
            }
            case META_TYPE_XATTRS: {
                return Event.MetadataUpdateEvent.MetadataType.XATTRS;
            }
        }
        return null;
    }

    private static InotifyProtos.INodeType createTypeConvert(Event.CreateEvent.INodeType type) {
        switch (type) {
            case DIRECTORY: {
                return InotifyProtos.INodeType.I_TYPE_DIRECTORY;
            }
            case FILE: {
                return InotifyProtos.INodeType.I_TYPE_FILE;
            }
            case SYMLINK: {
                return InotifyProtos.INodeType.I_TYPE_SYMLINK;
            }
        }
        return null;
    }

    public static EventBatchList convert(ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto resp) throws IOException {
        InotifyProtos.EventsListProto list = resp.getEventsList();
        long firstTxid = list.getFirstTxid();
        long lastTxid = list.getLastTxid();
        ArrayList batches = Lists.newArrayList();
        if (list.getEventsList().size() > 0) {
            throw new IOException("Can't handle old inotify server response.");
        }
        for (InotifyProtos.EventBatchProto bp : list.getBatchList()) {
            long txid = bp.getTxid();
            if (txid != -1L && (txid < firstTxid || txid > lastTxid)) {
                throw new IOException("Error converting TxidResponseProto: got a transaction id " + txid + " that was outside the range of [" + firstTxid + ", " + lastTxid + "].");
            }
            ArrayList events = Lists.newArrayList();
            block9: for (InotifyProtos.EventProto p : bp.getEventsList()) {
                switch (p.getType()) {
                    case EVENT_CLOSE: {
                        InotifyProtos.CloseEventProto close = InotifyProtos.CloseEventProto.parseFrom(p.getContents());
                        events.add(new Event.CloseEvent(close.getPath(), close.getFileSize(), close.getTimestamp()));
                        continue block9;
                    }
                    case EVENT_CREATE: {
                        InotifyProtos.CreateEventProto create = InotifyProtos.CreateEventProto.parseFrom(p.getContents());
                        events.add(new Event.CreateEvent.Builder().iNodeType(PBHelper.createTypeConvert(create.getType())).path(create.getPath()).ctime(create.getCtime()).ownerName(create.getOwnerName()).groupName(create.getGroupName()).perms(PBHelper.convert(create.getPerms())).replication(create.getReplication()).symlinkTarget(create.getSymlinkTarget().isEmpty() ? null : create.getSymlinkTarget()).defaultBlockSize(create.getDefaultBlockSize()).overwrite(create.getOverwrite()).build());
                        continue block9;
                    }
                    case EVENT_METADATA: {
                        InotifyProtos.MetadataUpdateEventProto meta = InotifyProtos.MetadataUpdateEventProto.parseFrom(p.getContents());
                        events.add(new Event.MetadataUpdateEvent.Builder().path(meta.getPath()).metadataType(PBHelper.metadataUpdateTypeConvert(meta.getType())).mtime(meta.getMtime()).atime(meta.getAtime()).replication(meta.getReplication()).ownerName(meta.getOwnerName().isEmpty() ? null : meta.getOwnerName()).groupName(meta.getGroupName().isEmpty() ? null : meta.getGroupName()).perms(meta.hasPerms() ? PBHelper.convert(meta.getPerms()) : null).acls(meta.getAclsList().isEmpty() ? null : PBHelper.convertAclEntry(meta.getAclsList())).xAttrs(meta.getXAttrsList().isEmpty() ? null : PBHelper.convertXAttrs(meta.getXAttrsList())).xAttrsRemoved(meta.getXAttrsRemoved()).build());
                        continue block9;
                    }
                    case EVENT_RENAME: {
                        InotifyProtos.RenameEventProto rename = InotifyProtos.RenameEventProto.parseFrom(p.getContents());
                        events.add(new Event.RenameEvent.Builder().srcPath(rename.getSrcPath()).dstPath(rename.getDestPath()).timestamp(rename.getTimestamp()).build());
                        continue block9;
                    }
                    case EVENT_APPEND: {
                        InotifyProtos.AppendEventProto reopen = InotifyProtos.AppendEventProto.parseFrom(p.getContents());
                        events.add(new Event.AppendEvent.Builder().path(reopen.getPath()).build());
                        continue block9;
                    }
                    case EVENT_UNLINK: {
                        InotifyProtos.UnlinkEventProto unlink = InotifyProtos.UnlinkEventProto.parseFrom(p.getContents());
                        events.add(new Event.UnlinkEvent.Builder().path(unlink.getPath()).timestamp(unlink.getTimestamp()).build());
                        continue block9;
                    }
                }
                throw new RuntimeException("Unexpected inotify event type: " + (Object)((Object)p.getType()));
            }
            batches.add(new EventBatch(txid, events.toArray(new Event[0])));
        }
        return new EventBatchList(batches, resp.getEventsList().getFirstTxid(), resp.getEventsList().getLastTxid(), resp.getEventsList().getSyncTxid());
    }

    public static ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto convertEditsResponse(EventBatchList el) {
        InotifyProtos.EventsListProto.Builder builder = InotifyProtos.EventsListProto.newBuilder();
        for (EventBatch b : el.getBatches()) {
            ArrayList events = Lists.newArrayList();
            block9: for (Event e : b.getEvents()) {
                switch (e.getEventType()) {
                    case CLOSE: {
                        Event.CloseEvent ce = (Event.CloseEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_CLOSE).setContents(InotifyProtos.CloseEventProto.newBuilder().setPath(ce.getPath()).setFileSize(ce.getFileSize()).setTimestamp(ce.getTimestamp()).build().toByteString()).build());
                        continue block9;
                    }
                    case CREATE: {
                        Event.CreateEvent ce2 = (Event.CreateEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_CREATE).setContents(InotifyProtos.CreateEventProto.newBuilder().setType(PBHelper.createTypeConvert(ce2.getiNodeType())).setPath(ce2.getPath()).setCtime(ce2.getCtime()).setOwnerName(ce2.getOwnerName()).setGroupName(ce2.getGroupName()).setPerms(PBHelper.convert(ce2.getPerms())).setReplication(ce2.getReplication()).setSymlinkTarget(ce2.getSymlinkTarget() == null ? "" : ce2.getSymlinkTarget()).setDefaultBlockSize(ce2.getDefaultBlockSize()).setOverwrite(ce2.getOverwrite()).build().toByteString()).build());
                        continue block9;
                    }
                    case METADATA: {
                        Event.MetadataUpdateEvent me = (Event.MetadataUpdateEvent)e;
                        InotifyProtos.MetadataUpdateEventProto.Builder metaB = InotifyProtos.MetadataUpdateEventProto.newBuilder().setPath(me.getPath()).setType(PBHelper.metadataUpdateTypeConvert(me.getMetadataType())).setMtime(me.getMtime()).setAtime(me.getAtime()).setReplication(me.getReplication()).setOwnerName(me.getOwnerName() == null ? "" : me.getOwnerName()).setGroupName(me.getGroupName() == null ? "" : me.getGroupName()).addAllAcls((Iterable<? extends AclProtos.AclEntryProto>)(me.getAcls() == null ? Lists.newArrayList() : PBHelper.convertAclEntryProto(me.getAcls()))).addAllXAttrs((Iterable<? extends XAttrProtos.XAttrProto>)(me.getxAttrs() == null ? Lists.newArrayList() : PBHelper.convertXAttrProto(me.getxAttrs()))).setXAttrsRemoved(me.isxAttrsRemoved());
                        if (me.getPerms() != null) {
                            metaB.setPerms(PBHelper.convert(me.getPerms()));
                        }
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_METADATA).setContents(metaB.build().toByteString()).build());
                        continue block9;
                    }
                    case RENAME: {
                        Event.RenameEvent re = (Event.RenameEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_RENAME).setContents(InotifyProtos.RenameEventProto.newBuilder().setSrcPath(re.getSrcPath()).setDestPath(re.getDstPath()).setTimestamp(re.getTimestamp()).build().toByteString()).build());
                        continue block9;
                    }
                    case APPEND: {
                        Event.AppendEvent re2 = (Event.AppendEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_APPEND).setContents(InotifyProtos.AppendEventProto.newBuilder().setPath(re2.getPath()).build().toByteString()).build());
                        continue block9;
                    }
                    case UNLINK: {
                        Event.UnlinkEvent ue = (Event.UnlinkEvent)e;
                        events.add(InotifyProtos.EventProto.newBuilder().setType(InotifyProtos.EventType.EVENT_UNLINK).setContents(InotifyProtos.UnlinkEventProto.newBuilder().setPath(ue.getPath()).setTimestamp(ue.getTimestamp()).build().toByteString()).build());
                        continue block9;
                    }
                    default: {
                        throw new RuntimeException("Unexpected inotify event: " + e);
                    }
                }
            }
            builder.addBatch(InotifyProtos.EventBatchProto.newBuilder().setTxid(b.getTxid()).addAllEvents(events));
        }
        builder.setFirstTxid(el.getFirstTxid());
        builder.setLastTxid(el.getLastTxid());
        builder.setSyncTxid(el.getSyncTxid());
        return ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto.newBuilder().setEventsList(builder.build()).build();
    }

    public static HdfsProtos.CipherOptionProto convert(CipherOption option) {
        if (option != null) {
            HdfsProtos.CipherOptionProto.Builder builder = HdfsProtos.CipherOptionProto.newBuilder();
            if (option.getCipherSuite() != null) {
                builder.setSuite(PBHelper.convert(option.getCipherSuite()));
            }
            if (option.getInKey() != null) {
                builder.setInKey(ByteString.copyFrom((byte[])option.getInKey()));
            }
            if (option.getInIv() != null) {
                builder.setInIv(ByteString.copyFrom((byte[])option.getInIv()));
            }
            if (option.getOutKey() != null) {
                builder.setOutKey(ByteString.copyFrom((byte[])option.getOutKey()));
            }
            if (option.getOutIv() != null) {
                builder.setOutIv(ByteString.copyFrom((byte[])option.getOutIv()));
            }
            return builder.build();
        }
        return null;
    }

    public static CipherOption convert(HdfsProtos.CipherOptionProto proto) {
        if (proto != null) {
            CipherSuite suite = null;
            if (proto.getSuite() != null) {
                suite = PBHelper.convert(proto.getSuite());
            }
            byte[] inKey = null;
            if (proto.getInKey() != null) {
                inKey = proto.getInKey().toByteArray();
            }
            byte[] inIv = null;
            if (proto.getInIv() != null) {
                inIv = proto.getInIv().toByteArray();
            }
            byte[] outKey = null;
            if (proto.getOutKey() != null) {
                outKey = proto.getOutKey().toByteArray();
            }
            byte[] outIv = null;
            if (proto.getOutIv() != null) {
                outIv = proto.getOutIv().toByteArray();
            }
            return new CipherOption(suite, inKey, inIv, outKey, outIv);
        }
        return null;
    }

    public static List<HdfsProtos.CipherOptionProto> convertCipherOptions(List<CipherOption> options) {
        if (options != null) {
            ArrayList protos = Lists.newArrayListWithCapacity((int)options.size());
            for (CipherOption option : options) {
                protos.add(PBHelper.convert(option));
            }
            return protos;
        }
        return null;
    }

    public static List<CipherOption> convertCipherOptionProtos(List<HdfsProtos.CipherOptionProto> protos) {
        if (protos != null) {
            ArrayList options = Lists.newArrayListWithCapacity((int)protos.size());
            for (HdfsProtos.CipherOptionProto proto : protos) {
                options.add(PBHelper.convert(proto));
            }
            return options;
        }
        return null;
    }

    public static HdfsProtos.CipherSuiteProto convert(CipherSuite suite) {
        switch (suite) {
            case UNKNOWN: {
                return HdfsProtos.CipherSuiteProto.UNKNOWN;
            }
            case AES_CTR_NOPADDING: {
                return HdfsProtos.CipherSuiteProto.AES_CTR_NOPADDING;
            }
        }
        return null;
    }

    public static CipherSuite convert(HdfsProtos.CipherSuiteProto proto) {
        switch (proto) {
            case AES_CTR_NOPADDING: {
                return CipherSuite.AES_CTR_NOPADDING;
            }
        }
        CipherSuite suite = CipherSuite.UNKNOWN;
        suite.setUnknownValue(proto.getNumber());
        return suite;
    }

    public static List<HdfsProtos.CryptoProtocolVersionProto> convert(CryptoProtocolVersion[] versions) {
        ArrayList protos = Lists.newArrayListWithCapacity((int)versions.length);
        for (CryptoProtocolVersion v : versions) {
            protos.add(PBHelper.convert(v));
        }
        return protos;
    }

    public static CryptoProtocolVersion[] convertCryptoProtocolVersions(List<HdfsProtos.CryptoProtocolVersionProto> protos) {
        ArrayList versions = Lists.newArrayListWithCapacity((int)protos.size());
        for (HdfsProtos.CryptoProtocolVersionProto p : protos) {
            versions.add(PBHelper.convert(p));
        }
        return versions.toArray(new CryptoProtocolVersion[0]);
    }

    public static CryptoProtocolVersion convert(HdfsProtos.CryptoProtocolVersionProto proto) {
        switch (proto) {
            case ENCRYPTION_ZONES: {
                return CryptoProtocolVersion.ENCRYPTION_ZONES;
            }
        }
        CryptoProtocolVersion version = CryptoProtocolVersion.UNKNOWN;
        version.setUnknownValue(proto.getNumber());
        return version;
    }

    public static HdfsProtos.CryptoProtocolVersionProto convert(CryptoProtocolVersion version) {
        switch (version) {
            case UNKNOWN: {
                return HdfsProtos.CryptoProtocolVersionProto.UNKNOWN_PROTOCOL_VERSION;
            }
            case ENCRYPTION_ZONES: {
                return HdfsProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES;
            }
        }
        return null;
    }

    public static HdfsProtos.FileEncryptionInfoProto convert(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return HdfsProtos.FileEncryptionInfoProto.newBuilder().setSuite(PBHelper.convert(info.getCipherSuite())).setCryptoProtocolVersion(PBHelper.convert(info.getCryptoProtocolVersion())).setKey(PBHelper.getByteString(info.getEncryptedDataEncryptionKey())).setIv(PBHelper.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).setKeyName(info.getKeyName()).build();
    }

    public static HdfsProtos.PerFileEncryptionInfoProto convertPerFileEncInfo(FileEncryptionInfo info) {
        if (info == null) {
            return null;
        }
        return HdfsProtos.PerFileEncryptionInfoProto.newBuilder().setKey(PBHelper.getByteString(info.getEncryptedDataEncryptionKey())).setIv(PBHelper.getByteString(info.getIV())).setEzKeyVersionName(info.getEzKeyVersionName()).build();
    }

    public static HdfsProtos.ZoneEncryptionInfoProto convert(CipherSuite suite, CryptoProtocolVersion version, String keyName) {
        return PBHelper.convert(suite, version, keyName, null);
    }

    public static HdfsProtos.ZoneEncryptionInfoProto convert(CipherSuite suite, CryptoProtocolVersion version, String keyName, HdfsProtos.ReencryptionInfoProto proto) {
        if (suite == null || version == null || keyName == null) {
            return null;
        }
        HdfsProtos.ZoneEncryptionInfoProto.Builder builder = HdfsProtos.ZoneEncryptionInfoProto.newBuilder().setSuite(PBHelper.convert(suite)).setCryptoProtocolVersion(PBHelper.convert(version)).setKeyName(keyName);
        if (proto != null) {
            builder.setReencryptionProto(proto);
        }
        return builder.build();
    }

    public static FileEncryptionInfo convert(HdfsProtos.FileEncryptionInfoProto proto) {
        if (proto == null) {
            return null;
        }
        CipherSuite suite = PBHelper.convert(proto.getSuite());
        CryptoProtocolVersion version = PBHelper.convert(proto.getCryptoProtocolVersion());
        byte[] key = proto.getKey().toByteArray();
        byte[] iv = proto.getIv().toByteArray();
        String ezKeyVersionName = proto.getEzKeyVersionName();
        String keyName = proto.getKeyName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static FileEncryptionInfo convert(HdfsProtos.PerFileEncryptionInfoProto fileProto, CipherSuite suite, CryptoProtocolVersion version, String keyName) {
        if (fileProto == null || suite == null || version == null || keyName == null) {
            return null;
        }
        byte[] key = fileProto.getKey().toByteArray();
        byte[] iv = fileProto.getIv().toByteArray();
        String ezKeyVersionName = fileProto.getEzKeyVersionName();
        return new FileEncryptionInfo(suite, version, key, iv, keyName, ezKeyVersionName);
    }

    public static HdfsProtos.ReencryptionInfoProto convert(String ezkvn, Long submissionTime, boolean isCanceled, long numReencrypted, long numFailures, Long completionTime, String lastFile) {
        if (ezkvn == null || submissionTime == null) {
            return null;
        }
        HdfsProtos.ReencryptionInfoProto.Builder builder = HdfsProtos.ReencryptionInfoProto.newBuilder().setEzKeyVersionName(ezkvn).setSubmissionTime(submissionTime).setCanceled(isCanceled).setNumReencrypted(numReencrypted).setNumFailures(numFailures);
        if (completionTime != null) {
            builder.setCompletionTime(completionTime);
        }
        if (lastFile != null) {
            builder.setLastFile(lastFile);
        }
        return builder.build();
    }

    public static EncryptionZonesProtos.ZoneReencryptionStatusProto convert(ZoneReencryptionStatus zs) {
        String file;
        EncryptionZonesProtos.ZoneReencryptionStatusProto.Builder builder = EncryptionZonesProtos.ZoneReencryptionStatusProto.newBuilder().setId(zs.getId()).setPath(zs.getZoneName()).setEzKeyVersionName(zs.getEzKeyVersionName()).setSubmissionTime(zs.getSubmissionTime()).setCanceled(zs.isCanceled()).setNumReencrypted(zs.getFilesReencrypted()).setNumFailures(zs.getNumReencryptionFailures());
        switch (zs.getState()) {
            case Submitted: {
                builder.setState(EncryptionZonesProtos.ReencryptionStateProto.SUBMITTED);
                break;
            }
            case Processing: {
                builder.setState(EncryptionZonesProtos.ReencryptionStateProto.PROCESSING);
                break;
            }
            case Completed: {
                builder.setState(EncryptionZonesProtos.ReencryptionStateProto.COMPLETED);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state " + (Object)((Object)zs.getState()));
            }
        }
        long completion = zs.getCompletionTime();
        if (completion != 0L) {
            builder.setCompletionTime(completion);
        }
        if ((file = zs.getLastCheckpointFile()) != null) {
            builder.setLastFile(file);
        }
        return builder.build();
    }

    public static ZoneReencryptionStatus convert(EncryptionZonesProtos.ZoneReencryptionStatusProto proto) {
        ZoneReencryptionStatus.State state;
        switch (proto.getState()) {
            case SUBMITTED: {
                state = ZoneReencryptionStatus.State.Submitted;
                break;
            }
            case PROCESSING: {
                state = ZoneReencryptionStatus.State.Processing;
                break;
            }
            case COMPLETED: {
                state = ZoneReencryptionStatus.State.Completed;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state " + (Object)((Object)proto.getState()));
            }
        }
        ZoneReencryptionStatus.Builder builder = new ZoneReencryptionStatus.Builder().id(proto.getId()).zoneName(proto.getPath()).state(state).ezKeyVersionName(proto.getEzKeyVersionName()).submissionTime(proto.getSubmissionTime()).canceled(proto.getCanceled()).filesReencrypted(proto.getNumReencrypted()).fileReencryptionFailures(proto.getNumFailures());
        if (proto.hasCompletionTime()) {
            builder.completionTime(proto.getCompletionTime());
        }
        if (proto.hasLastFile()) {
            builder.lastCheckpointFile(proto.getLastFile());
        }
        return builder.build();
    }

    public static BlockReportContext convert(DatanodeProtocolProtos.BlockReportContextProto proto) {
        return new BlockReportContext(proto.getTotalRpcs(), proto.getCurRpc(), proto.getId(), proto.getLeaseId(), proto.getSorted());
    }

    public static DatanodeProtocolProtos.BlockReportContextProto convert(BlockReportContext context) {
        return DatanodeProtocolProtos.BlockReportContextProto.newBuilder().setTotalRpcs(context.getTotalRpcs()).setCurRpc(context.getCurRpc()).setId(context.getReportId()).setLeaseId(context.getLeaseId()).setSorted(context.isSorted()).build();
    }

    public static List<Boolean> convert(boolean[] targetPinnings, int idx) {
        ArrayList<Boolean> pinnings = new ArrayList<Boolean>();
        if (targetPinnings == null) {
            pinnings.add(Boolean.FALSE);
        } else {
            while (idx < targetPinnings.length) {
                pinnings.add(targetPinnings[idx]);
                ++idx;
            }
        }
        return pinnings;
    }

    public static boolean[] convertBooleanList(List<Boolean> targetPinningsList) {
        boolean[] targetPinnings = new boolean[targetPinningsList.size()];
        for (int i = 0; i < targetPinningsList.size(); ++i) {
            targetPinnings[i] = targetPinningsList.get(i);
        }
        return targetPinnings;
    }

    public static EnumSet<AddBlockFlag> convertAddBlockFlags(List<ClientNamenodeProtocolProtos.AddBlockFlagProto> addBlockFlags) {
        EnumSet<AddBlockFlag> flags = EnumSet.noneOf(AddBlockFlag.class);
        for (ClientNamenodeProtocolProtos.AddBlockFlagProto af : addBlockFlags) {
            AddBlockFlag flag = AddBlockFlag.valueOf((short)af.getNumber());
            if (flag == null) continue;
            flags.add(flag);
        }
        return flags;
    }

    public static List<ClientNamenodeProtocolProtos.AddBlockFlagProto> convertAddBlockFlags(EnumSet<AddBlockFlag> flags) {
        ArrayList<ClientNamenodeProtocolProtos.AddBlockFlagProto> ret = new ArrayList<ClientNamenodeProtocolProtos.AddBlockFlagProto>();
        for (AddBlockFlag flag : flags) {
            ClientNamenodeProtocolProtos.AddBlockFlagProto abfp = ClientNamenodeProtocolProtos.AddBlockFlagProto.valueOf(flag.getMode());
            if (abfp == null) continue;
            ret.add(abfp);
        }
        return ret;
    }
}

