/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderUtil;
import org.apache.hadoop.hdfs.ReplicaAccessor;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;

@InterfaceAudience.Private
public final class ExternalBlockReader
implements BlockReader {
    private final ReplicaAccessor accessor;
    private final long visibleLength;
    private long pos;

    ExternalBlockReader(ReplicaAccessor accessor, long visibleLength, long startOffset) {
        this.accessor = accessor;
        this.visibleLength = visibleLength;
        this.pos = startOffset;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int nread = this.accessor.read(this.pos, buf, off, len);
        if (nread < 0) {
            return nread;
        }
        this.pos += (long)nread;
        return nread;
    }

    public int read(ByteBuffer buf) throws IOException {
        int nread = this.accessor.read(this.pos, buf);
        if (nread < 0) {
            return nread;
        }
        this.pos += (long)nread;
        return nread;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long oldPos = this.pos;
        this.pos += n;
        if (this.pos > this.visibleLength) {
            this.pos = this.visibleLength;
        }
        return this.pos - oldPos;
    }

    @Override
    public int available() throws IOException {
        long diff = this.visibleLength - this.pos;
        if (diff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }

    @Override
    public void close() throws IOException {
        this.accessor.close();
    }

    @Override
    public void readFully(byte[] buf, int offset, int len) throws IOException {
        BlockReaderUtil.readFully(this, buf, offset, len);
    }

    @Override
    public int readAll(byte[] buf, int offset, int len) throws IOException {
        return BlockReaderUtil.readAll(this, buf, offset, len);
    }

    @Override
    public boolean isLocal() {
        return this.accessor.isLocal();
    }

    @Override
    public boolean isShortCircuit() {
        return this.accessor.isShortCircuit();
    }

    @Override
    public ClientMmap getClientMmap(EnumSet<ReadOption> opts) {
        return null;
    }
}

