/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mysql;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.UpdateOutputFormat;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.UpdateOutputFormat;

public class MySQLUpsertOutputFormat<K extends SqoopRecord, V>
extends UpdateOutputFormat<K, V> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new MySQLUpsertRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class MySQLUpsertRecordWriter
    extends UpdateOutputFormat.UpdateRecordWriter {
        public MySQLUpsertRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PreparedStatement getPreparedStatement(List<SqoopRecord> userRecords) throws SQLException {
            Connection conn;
            PreparedStatement stmt = null;
            Connection connection = conn = this.getConnection();
            synchronized (connection) {
                stmt = conn.prepareStatement(this.getUpdateStatement(userRecords.size()));
            }
            int i = 0;
            for (SqoopRecord record : userRecords) {
                record.write(stmt, i);
                i += this.columnNames.length;
            }
            stmt.addBatch();
            return stmt;
        }

        protected String getUpdateStatement(int numRows) {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(this.tableName);
            sb.append("(");
            boolean first = true;
            for (String column : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(column);
            }
            sb.append(") VALUES(");
            for (int i = 0; i < numRows; ++i) {
                if (i > 0) {
                    sb.append("),(");
                }
                for (int j = 0; j < this.columnNames.length; ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append("?");
                }
            }
            sb.append(") ON DUPLICATE KEY UPDATE ");
            first = true;
            for (String column : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(column).append("=VALUES(").append(column).append(")");
            }
            String query = sb.toString();
            MySQLUpsertOutputFormat.this.log.debug((Object)("Using upsert query: " + query));
            return query;
        }
    }
}

