/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="describecluster", description="Print the name, snitch, partitioner and schema version of a cluster")
public class DescribeCluster
extends NodeTool.NodeToolCmd {
    @Override
    public void execute(NodeProbe probe) {
        System.out.println("Cluster Information:");
        System.out.println("\tName: " + probe.getClusterName());
        System.out.println("\tSnitch: " + probe.getEndpointSnitchInfoProxy().getSnitchName());
        System.out.println("\tPartitioner: " + probe.getPartitioner());
        System.out.println("\tSchema versions:");
        Map<String, List<String>> schemaVersions = probe.getSpProxy().getSchemaVersions();
        for (String version : schemaVersions.keySet()) {
            System.out.println(String.format("\t\t%s: %s%n", version, schemaVersions.get(version)));
        }
    }
}

