/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class BarcodeTypePropertyEditor
implements PropertyEditor {
    private String value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void setValue(Object value) {
        String oldValue = this.value;
        this.value = this.isValidBarcode(value) ? (String)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    private boolean isValidBarcode(Object barodeType) {
        if ("2of5".equals(barodeType)) {
            return true;
        }
        if ("2of5int".equals(barodeType)) {
            return true;
        }
        if ("codabar".equals(barodeType)) {
            return true;
        }
        if ("code128".equals(barodeType)) {
            return true;
        }
        if ("code128a".equals(barodeType)) {
            return true;
        }
        if ("code128b".equals(barodeType)) {
            return true;
        }
        if ("code128c".equals(barodeType)) {
            return true;
        }
        if ("code39".equals(barodeType)) {
            return true;
        }
        if ("code39ext".equals(barodeType)) {
            return true;
        }
        if ("ean13".equals(barodeType)) {
            return true;
        }
        if ("isbn".equals(barodeType)) {
            return true;
        }
        if ("pdf417".equals(barodeType)) {
            return true;
        }
        if ("postnet".equals(barodeType)) {
            return true;
        }
        if ("uccean128".equals(barodeType)) {
            return true;
        }
        if ("upca".equals(barodeType)) {
            return true;
        }
        if ("ean8".equals(barodeType)) {
            return true;
        }
        if ("upce".equals(barodeType)) {
            return true;
        }
        if ("ean128".equals(barodeType)) {
            return true;
        }
        if ("datamatrix".equals(barodeType)) {
            return true;
        }
        if ("royalmail".equals(barodeType)) {
            return true;
        }
        return "uspsintelligentmail".equals(barodeType);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    @Override
    public String[] getTags() {
        return new String[]{"2of5", "2of5int", "codabar", "code128", "code128a", "code128b", "code128c", "code39", "code39ext", "ean13", "isbn", "pdf417", "postnet", "uccean128", "upca", "ean8", "upce", "ean128", "datamatrix", "royalmail", "uspsintelligentmail"};
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

