/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.TableSample;

public class QBParseInfo {
    private final boolean isSubQ;
    private final String alias;
    private ASTNode joinExpr;
    private ASTNode hints;
    private final HashMap<String, ASTNode> aliasToSrc = new HashMap();
    private final HashMap<String, ASTNode> nameToDest = new HashMap();
    private final Map<String, List<String>> nameToDestSchema = new HashMap<String, List<String>>();
    private final HashMap<String, TableSample> nameToSample = new HashMap();
    private final Map<ASTNode, String> exprToColumnAlias = new HashMap<ASTNode, String>();
    private final Map<String, ASTNode> destToSelExpr;
    private final HashMap<String, ASTNode> destToWhereExpr;
    private final HashMap<String, ASTNode> destToGroupby;
    private final Set<String> destRollups;
    private final Set<String> destCubes;
    private final Set<String> destGroupingSets;
    private final Map<String, ASTNode> destToHaving;
    private final HashSet<String> insertIntoTables;
    private boolean isAnalyzeCommand;
    private boolean isInsertToTable;
    private boolean isNoScanAnalyzeCommand;
    private boolean isPartialScanAnalyzeCommand;
    private final HashMap<String, BaseSemanticAnalyzer.tableSpec> tableSpecs;
    private String tableName;
    private List<String> colName;
    private List<String> colType;
    private boolean isTblLvl;
    private final HashMap<String, ASTNode> destToClusterby;
    private final HashMap<String, ASTNode> destToDistributeby;
    private final HashMap<String, ASTNode> destToSortby;
    private final HashMap<String, ArrayList<ASTNode>> aliasToLateralViews;
    private final HashMap<String, ASTNode> destToLateralView = new HashMap();
    private final HashMap<String, ASTNode> destToOrderby;
    private final HashMap<String, Integer> destToLimit;
    private int outerQueryLimit;
    private final LinkedHashMap<String, LinkedHashMap<String, ASTNode>> destToAggregationExprs;
    private final HashMap<String, List<ASTNode>> destToDistinctFuncExprs;
    private final LinkedHashMap<String, LinkedHashMap<String, ASTNode>> destToWindowingExprs;
    private static final Log LOG = LogFactory.getLog((String)QBParseInfo.class.getName());

    public QBParseInfo(String alias, boolean isSubQ) {
        this.destToSelExpr = new LinkedHashMap<String, ASTNode>();
        this.destToWhereExpr = new HashMap();
        this.destToGroupby = new HashMap();
        this.destToHaving = new HashMap<String, ASTNode>();
        this.destToClusterby = new HashMap();
        this.destToDistributeby = new HashMap();
        this.destToSortby = new HashMap();
        this.destToOrderby = new HashMap();
        this.destToLimit = new HashMap();
        this.insertIntoTables = new HashSet();
        this.destRollups = new HashSet<String>();
        this.destCubes = new HashSet<String>();
        this.destGroupingSets = new HashSet<String>();
        this.destToAggregationExprs = new LinkedHashMap();
        this.destToWindowingExprs = new LinkedHashMap();
        this.destToDistinctFuncExprs = new HashMap();
        this.alias = alias;
        this.isSubQ = isSubQ;
        this.outerQueryLimit = -1;
        this.aliasToLateralViews = new HashMap();
        this.tableSpecs = new HashMap();
    }

    public void clearAggregationExprsForClause(String clause) {
        this.destToAggregationExprs.get(clause).clear();
    }

    public void setAggregationExprsForClause(String clause, LinkedHashMap<String, ASTNode> aggregationTrees) {
        this.destToAggregationExprs.put(clause, aggregationTrees);
    }

    public void addAggregationExprsForClause(String clause, LinkedHashMap<String, ASTNode> aggregationTrees) {
        if (this.destToAggregationExprs.containsKey(clause)) {
            this.destToAggregationExprs.get(clause).putAll(aggregationTrees);
        } else {
            this.destToAggregationExprs.put(clause, aggregationTrees);
        }
    }

    public void addInsertIntoTable(String fullName) {
        this.insertIntoTables.add(fullName.toLowerCase());
    }

    public boolean isInsertIntoTable(String dbName, String table) {
        String fullName = dbName + "." + table;
        return this.insertIntoTables.contains(fullName.toLowerCase());
    }

    public boolean isInsertIntoTable(String fullTableName) {
        return this.insertIntoTables.contains(fullTableName.toLowerCase());
    }

    public HashMap<String, ASTNode> getAggregationExprsForClause(String clause) {
        return this.destToAggregationExprs.get(clause);
    }

    public void addWindowingExprToClause(String clause, ASTNode windowingExprNode) {
        LinkedHashMap<String, ASTNode> windowingExprs = this.destToWindowingExprs.get(clause);
        if (windowingExprs == null) {
            windowingExprs = new LinkedHashMap();
            this.destToWindowingExprs.put(clause, windowingExprs);
        }
        windowingExprs.put(windowingExprNode.toStringTree(), windowingExprNode);
    }

    public HashMap<String, ASTNode> getWindowingExprsForClause(String clause) {
        return this.destToWindowingExprs.get(clause);
    }

    public void clearDistinctFuncExprsForClause(String clause) {
        List<ASTNode> l = this.destToDistinctFuncExprs.get(clause);
        if (l != null) {
            l.clear();
        }
    }

    public void setDistinctFuncExprsForClause(String clause, List<ASTNode> ast) {
        this.destToDistinctFuncExprs.put(clause, ast);
    }

    public List<ASTNode> getDistinctFuncExprsForClause(String clause) {
        return this.destToDistinctFuncExprs.get(clause);
    }

    public void setSelExprForClause(String clause, ASTNode ast) {
        this.destToSelExpr.put(clause, ast);
    }

    public void setWhrExprForClause(String clause, ASTNode ast) {
        this.destToWhereExpr.put(clause, ast);
    }

    public void setHavingExprForClause(String clause, ASTNode ast) {
        this.destToHaving.put(clause, ast);
    }

    public void setGroupByExprForClause(String clause, ASTNode ast) {
        this.destToGroupby.put(clause, ast);
    }

    public void setDestForClause(String clause, ASTNode ast) {
        this.nameToDest.put(clause, ast);
    }

    List<String> setDestSchemaForClause(String clause, List<String> columnList) {
        return this.nameToDestSchema.put(clause, columnList);
    }

    List<String> getDestSchemaForClause(String clause) {
        return this.nameToDestSchema.get(clause);
    }

    public void setClusterByExprForClause(String clause, ASTNode ast) {
        this.destToClusterby.put(clause, ast);
    }

    public void setDistributeByExprForClause(String clause, ASTNode ast) {
        this.destToDistributeby.put(clause, ast);
    }

    public void setSortByExprForClause(String clause, ASTNode ast) {
        this.destToSortby.put(clause, ast);
    }

    public void setOrderByExprForClause(String clause, ASTNode ast) {
        this.destToOrderby.put(clause, ast);
    }

    public void setSrcForAlias(String alias, ASTNode ast) {
        this.aliasToSrc.put(alias.toLowerCase(), ast);
    }

    public Set<String> getClauseNames() {
        return this.destToSelExpr.keySet();
    }

    public Set<String> getClauseNamesForDest() {
        return this.nameToDest.keySet();
    }

    public ASTNode getDestForClause(String clause) {
        return this.nameToDest.get(clause);
    }

    public ASTNode getWhrForClause(String clause) {
        return this.destToWhereExpr.get(clause);
    }

    public HashMap<String, ASTNode> getDestToWhereExpr() {
        return this.destToWhereExpr;
    }

    public ASTNode getGroupByForClause(String clause) {
        return this.destToGroupby.get(clause);
    }

    public Set<String> getDestRollups() {
        return this.destRollups;
    }

    public Set<String> getDestCubes() {
        return this.destCubes;
    }

    public Set<String> getDestGroupingSets() {
        return this.destGroupingSets;
    }

    public HashMap<String, ASTNode> getDestToGroupBy() {
        return this.destToGroupby;
    }

    public ASTNode getHavingForClause(String clause) {
        return this.destToHaving.get(clause);
    }

    public Map<String, ASTNode> getDestToHaving() {
        return this.destToHaving;
    }

    public ASTNode getSelForClause(String clause) {
        return this.destToSelExpr.get(clause);
    }

    public ASTNode getClusterByForClause(String clause) {
        return this.destToClusterby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToClusterBy() {
        return this.destToClusterby;
    }

    public ASTNode getDistributeByForClause(String clause) {
        return this.destToDistributeby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToDistributeBy() {
        return this.destToDistributeby;
    }

    public ASTNode getSortByForClause(String clause) {
        return this.destToSortby.get(clause);
    }

    public ASTNode getOrderByForClause(String clause) {
        return this.destToOrderby.get(clause);
    }

    public HashMap<String, ASTNode> getDestToSortBy() {
        return this.destToSortby;
    }

    public HashMap<String, ASTNode> getDestToOrderBy() {
        return this.destToOrderby;
    }

    public ASTNode getSrcForAlias(String alias) {
        return this.aliasToSrc.get(alias.toLowerCase());
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean getIsSubQ() {
        return this.isSubQ;
    }

    public ASTNode getJoinExpr() {
        return this.joinExpr;
    }

    public void setJoinExpr(ASTNode joinExpr) {
        this.joinExpr = joinExpr;
    }

    public TableSample getTabSample(String alias) {
        return this.nameToSample.get(alias.toLowerCase());
    }

    public void setTabSample(String alias, TableSample tableSample) {
        this.nameToSample.put(alias.toLowerCase(), tableSample);
    }

    public String getExprToColumnAlias(ASTNode expr) {
        return this.exprToColumnAlias.get(expr);
    }

    public Map<ASTNode, String> getAllExprToColumnAlias() {
        return this.exprToColumnAlias;
    }

    public boolean hasExprToColumnAlias(ASTNode expr) {
        return this.exprToColumnAlias.containsKey(expr);
    }

    public void setExprToColumnAlias(ASTNode expr, String alias) {
        this.exprToColumnAlias.put(expr, alias);
    }

    public void setDestLimit(String dest, Integer limit) {
        this.destToLimit.put(dest, limit);
    }

    public Integer getDestLimit(String dest) {
        return this.destToLimit.get(dest);
    }

    public int getOuterQueryLimit() {
        return this.outerQueryLimit;
    }

    public void setOuterQueryLimit(int outerQueryLimit) {
        this.outerQueryLimit = outerQueryLimit;
    }

    public boolean isTopLevelSimpleSelectStarQuery() {
        if (this.alias != null || this.destToSelExpr.size() != 1 || !this.isSimpleSelectQuery()) {
            return false;
        }
        for (ASTNode selExprs : this.destToSelExpr.values()) {
            if (selExprs.getChildCount() != 1) {
                return false;
            }
            Tree sel = selExprs.getChild(0).getChild(0);
            if (sel != null && sel.getType() == 594) continue;
            return false;
        }
        return true;
    }

    public boolean isSimpleSelectQuery() {
        if (!(this.joinExpr == null && this.destToOrderby.isEmpty() && this.destToSortby.isEmpty() && this.destToGroupby.isEmpty() && this.destToClusterby.isEmpty() && this.destToDistributeby.isEmpty() && this.destRollups.isEmpty() && this.destCubes.isEmpty() && this.destGroupingSets.isEmpty() && this.destToHaving.isEmpty())) {
            return false;
        }
        for (Map map : this.destToAggregationExprs.values()) {
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        for (Map map : this.destToWindowingExprs.values()) {
            if (map == null || map.isEmpty()) continue;
            return false;
        }
        for (List list : this.destToDistinctFuncExprs.values()) {
            if (list.isEmpty()) continue;
            return false;
        }
        for (ASTNode aSTNode : this.nameToDest.values()) {
            if (aSTNode.getChild(0).getType() == 885) continue;
            return false;
        }
        return true;
    }

    public void setHints(ASTNode hint) {
        this.hints = hint;
    }

    public ASTNode getHints() {
        return this.hints;
    }

    public Map<String, ArrayList<ASTNode>> getAliasToLateralViews() {
        return this.aliasToLateralViews;
    }

    public List<ASTNode> getLateralViewsForAlias(String alias) {
        return this.aliasToLateralViews.get(alias.toLowerCase());
    }

    public void addLateralViewForAlias(String alias, ASTNode lateralView) {
        ArrayList<ASTNode> lateralViews = this.aliasToLateralViews.get(alias);
        if (lateralViews == null) {
            lateralViews = new ArrayList();
            this.aliasToLateralViews.put(alias, lateralViews);
        }
        lateralViews.add(lateralView);
    }

    public void setIsAnalyzeCommand(boolean isAnalyzeCommand) {
        this.isAnalyzeCommand = isAnalyzeCommand;
    }

    public boolean isAnalyzeCommand() {
        return this.isAnalyzeCommand;
    }

    public void setIsInsertToTable(boolean isInsertToTable) {
        this.isInsertToTable = isInsertToTable;
    }

    public boolean isInsertToTable() {
        return this.isInsertToTable;
    }

    public void addTableSpec(String tName, BaseSemanticAnalyzer.tableSpec tSpec) {
        this.tableSpecs.put(tName, tSpec);
    }

    public BaseSemanticAnalyzer.tableSpec getTableSpec(String tName) {
        return this.tableSpecs.get(tName);
    }

    public BaseSemanticAnalyzer.tableSpec getTableSpec() {
        Iterator<String> tName = this.tableSpecs.keySet().iterator();
        return this.tableSpecs.get(tName.next());
    }

    public HashMap<String, Integer> getDestToLimit() {
        return this.destToLimit;
    }

    public LinkedHashMap<String, LinkedHashMap<String, ASTNode>> getDestToAggregationExprs() {
        return this.destToAggregationExprs;
    }

    public HashMap<String, List<ASTNode>> getDestToDistinctFuncExprs() {
        return this.destToDistinctFuncExprs;
    }

    public HashMap<String, TableSample> getNameToSample() {
        return this.nameToSample;
    }

    public HashMap<String, ASTNode> getDestToLateralView() {
        return this.destToLateralView;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getColName() {
        return this.colName;
    }

    public void setColName(List<String> colName) {
        this.colName = colName;
    }

    public boolean isTblLvl() {
        return this.isTblLvl;
    }

    public void setTblLvl(boolean isTblLvl) {
        this.isTblLvl = isTblLvl;
    }

    public List<String> getColType() {
        return this.colType;
    }

    public void setColType(List<String> colType) {
        this.colType = colType;
    }

    public boolean isNoScanAnalyzeCommand() {
        return this.isNoScanAnalyzeCommand;
    }

    public void setNoScanAnalyzeCommand(boolean isNoScanAnalyzeCommand) {
        this.isNoScanAnalyzeCommand = isNoScanAnalyzeCommand;
    }

    public boolean isPartialScanAnalyzeCommand() {
        return this.isPartialScanAnalyzeCommand;
    }

    public void setPartialScanAnalyzeCommand(boolean isPartialScanAnalyzeCommand) {
        this.isPartialScanAnalyzeCommand = isPartialScanAnalyzeCommand;
    }

    protected static enum ClauseType {
        CLUSTER_BY_CLAUSE,
        DISTRIBUTE_BY_CLAUSE,
        ORDER_BY_CLAUSE,
        SORT_BY_CLAUSE;

    }
}

