/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinPersistableTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.SparkBucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class SparkHashTableSinkOperator
extends TerminalOperator<SparkHashTableSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String CLASS_NAME = this.getClass().getName();
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    protected static final Log LOG = LogFactory.getLog((String)SparkHashTableSinkOperator.class.getName());
    public static final String DFS_REPLICATION_MAX = "dfs.replication.max";
    private int minReplication = 10;
    private HashTableSinkOperator htsOperator = new HashTableSinkOperator();
    private byte tag;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[((SparkHashTableSinkDesc)this.conf).getTagLength()];
        inputOIs[this.tag] = this.inputObjInspectors[0];
        ((SparkHashTableSinkDesc)this.conf).setTagOrder(new Byte[]{this.tag});
        int dfsMaxReplication = hconf.getInt(DFS_REPLICATION_MAX, this.minReplication);
        this.minReplication = Math.min(this.minReplication, dfsMaxReplication);
        this.htsOperator.setConf(this.conf);
        this.htsOperator.initialize(hconf, inputOIs);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        this.htsOperator.processOp(row, this.tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            MapJoinPersistableTableContainer[] mapJoinTables = this.htsOperator.mapJoinTables;
            if (mapJoinTables == null || mapJoinTables.length < this.tag || mapJoinTables[this.tag] == null) {
                LOG.debug((Object)"mapJoinTable is null");
            } else if (abort) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Aborting, skip dumping side-table for tag: " + this.tag));
                }
            } else {
                String method = "SparkFlushHashTable." + this.getName();
                this.perfLogger.PerfLogBegin(this.CLASS_NAME, method);
                try {
                    this.flushToFile(mapJoinTables[this.tag], this.tag);
                }
                finally {
                    this.perfLogger.PerfLogEnd(this.CLASS_NAME, method);
                }
            }
            super.closeOp(abort);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushToFile(MapJoinPersistableTableContainer tableContainer, byte tag) throws Exception {
        MapredLocalWork localWork = this.getExecContext().getLocalWork();
        BucketMapJoinContext mapJoinCtx = localWork.getBucketMapjoinContext();
        Path inputPath = this.getExecContext().getCurrentInputPath();
        String bigInputPath = null;
        if (inputPath != null && mapJoinCtx != null) {
            Set<String> aliases = ((SparkBucketMapJoinContext)mapJoinCtx).getPosToAliasMap().get(tag);
            bigInputPath = mapJoinCtx.getMappingBigFile(aliases.iterator().next(), inputPath.toString());
        }
        Path tmpURI = localWork.getTmpHDFSPath();
        LOG.info((Object)("Temp URI for side table: " + tmpURI));
        String fileName = localWork.getBucketFileName(bigInputPath);
        String dumpFilePrefix = ((SparkHashTableSinkDesc)this.conf).getDumpFilePrefix();
        Path path = Utilities.generatePath(tmpURI, dumpFilePrefix, tag, fileName);
        FileSystem fs = path.getFileSystem(this.htsOperator.getConfiguration());
        short replication = fs.getDefaultReplication(path);
        fs.mkdirs(path);
        while (true) {
            path = new Path(path, this.getOperatorId() + "-" + Math.abs(Utilities.randGen.nextInt()));
            try {
                if (!fs.createNewFile(path)) continue;
            }
            catch (FileExistsException e) {
                continue;
            }
            break;
        }
        short numOfPartitions = replication;
        replication = (short)Math.max(this.minReplication, numOfPartitions);
        this.htsOperator.console.printInfo(Utilities.now() + "\tDump the side-table for tag: " + tag + " with group count: " + tableContainer.size() + " into file: " + path);
        try {
            FSDataOutputStream os = null;
            ObjectOutputStream out = null;
            MapJoinTableContainerSerDe mapJoinTableSerde = this.htsOperator.mapJoinTableSerdes[tag];
            try {
                os = fs.create(path, replication);
                out = new ObjectOutputStream(new BufferedOutputStream((OutputStream)os, 4096));
                mapJoinTableSerde.persist(out, tableContainer);
            }
            finally {
                if (out != null) {
                    out.close();
                } else if (os != null) {
                    os.close();
                }
            }
            FileStatus status = fs.getFileStatus(path);
            this.htsOperator.console.printInfo(Utilities.now() + "\tUploaded 1 File to: " + path + " (" + status.getLen() + " bytes)");
        }
        catch (Exception e) {
            try {
                fs.delete(path, false);
            }
            catch (Exception ex) {
                LOG.warn((Object)("Got exception in deleting partial side-table dump for tag: " + tag + ", file " + path), (Throwable)ex);
            }
            throw e;
        }
        tableContainer.clear();
    }

    public void setTag(byte tag) {
        this.tag = tag;
    }

    @Override
    public String getName() {
        return HashTableSinkOperator.getOperatorName();
    }

    @Override
    public OperatorType getType() {
        return OperatorType.HASHTABLESINK;
    }
}

