/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.HiveDriverRunHook;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryLifeTimeHookRunner;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.HooksLoader;
import org.apache.hadoop.hive.ql.hooks.QueryLifeTimeHook;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.YarnFairScheduling;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class Driver
implements CommandProcessor {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private final QueryInfo queryInfo;
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private HiveConf conf;
    private DataInput resStream;
    private Context ctx;
    private DriverContext driverCxt;
    private QueryPlan plan;
    private Schema schema;
    private String errorMessage;
    private String SQLState;
    private Throwable downstreamError;
    private FetchTask fetchTask;
    List<HiveLock> hiveLocks = new ArrayList<HiveLock>();
    private Set<FileSinkDesc> acidSinks;
    private int maxthreads;
    private int tryCount = Integer.MAX_VALUE;
    private String userName;
    private final QueryDisplay queryDisplay = new QueryDisplay();
    private LockedDriverState lDrvState = new LockedDriverState();
    private QueryLifeTimeHookRunner queryLifeTimeHookRunner;
    private final HooksLoader hooksLoader;
    List<QueryLifeTimeHook> queryHooks;
    private static final ReentrantLock globalCompileLock = new ReentrantLock();

    private boolean checkConcurrency() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (!supportConcurrency) {
            LOG.info((Object)"Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        return true;
    }

    @Override
    public void init() {
        Operator.resetId();
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning cluster status: " + cs.toString()));
        return cs;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info((Object)"No returning schema.");
                } else {
                    String tableName = "result";
                    List lst = null;
                    try {
                        lst = MetaStoreUtils.getFieldsFromDeserializer((String)tableName, (Deserializer)td.getDeserializer(conf));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error getting schema: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info((Object)("Returning Hive schema: " + schema));
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(MetaStoreUtils.typeToThriftType((String)f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info((Object)("Returning Thrift schema: " + schema));
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public Driver(HiveConf conf) {
        this(conf, new HooksLoader(conf));
    }

    public Driver(HiveConf conf, String userName) {
        this(conf, userName, new HooksLoader(conf), null);
    }

    public Driver() {
        this(SessionState.get() != null ? SessionState.get().getConf() : null);
    }

    public Driver(HiveConf conf, HooksLoader hooksLoader) {
        this(conf, null, hooksLoader, null);
    }

    public Driver(HiveConf conf, String userName, QueryInfo queryInfo) {
        this(conf, userName, new HooksLoader(conf), queryInfo);
    }

    public Driver(HiveConf conf, String userName, HooksLoader hooksLoader, QueryInfo queryInfo) {
        this.conf = conf;
        this.userName = userName;
        this.hooksLoader = hooksLoader;
        this.queryLifeTimeHookRunner = new QueryLifeTimeHookRunner(conf, hooksLoader, console);
        this.queryInfo = queryInfo;
    }

    public int compile(String command) {
        return this.compile(command, true);
    }

    public void saveSession(QueryState qs) {
        SessionState oldss = SessionState.get();
        if (oldss != null && oldss.getHiveOperation() != null) {
            qs.init(oldss.getHiveOperation(), oldss.getCmd());
        }
    }

    public void restoreSession(QueryState qs) {
        SessionState ss = SessionState.get();
        if (ss != null && qs != null && qs.isInitialized()) {
            ss.setCmd(qs.getCmd());
            ss.setCommandType(qs.getOp());
        }
    }

    public int compile(String command, boolean resetTaskIds) {
        return this.compile(command, resetTaskIds, false);
    }

    /*
     * Exception decompiling
     */
    public int compile(String command, boolean resetTaskIds, boolean deferClose) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [34[CATCHBLOCK], 10[TRYBLOCK], 37[CATCHBLOCK]], but top level block is 15[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int handleInterruption(String msg) {
        this.SQLState = "HY008";
        this.errorMessage = "FAILED: command has been interrupted: " + msg;
        console.printError(this.errorMessage);
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInterrupted() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private HiveConf configureScheduling(HiveConf configuration, String forUser) throws IOException, HiveException {
        if (configuration == null || StringUtils.isEmpty(forUser)) {
            return configuration;
        }
        if (YarnFairScheduling.usingNonImpersonationModeWithFairScheduling(configuration)) {
            YarnFairScheduling.validateYarnQueue(configuration, forUser);
        }
        return configuration;
    }

    private ImmutableMap<String, Long> dumpMetaCallTimingWithoutEx(String phase) {
        try {
            return Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn((Object)("Caught exception attempting to write metadata call information " + he), (Throwable)he);
            return null;
        }
    }

    private String getExplainOutput(BaseSemanticAnalyzer sem, QueryPlan plan, String astStringTree) throws IOException {
        String ret = null;
        ExplainTask task = new ExplainTask();
        task.initialize(this.conf, plan, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            List<Task<?>> rootTasks = sem.getRootTasks();
            task.getJSONPlan(ps, astStringTree, rootTasks, sem.getFetchTask(), false, true, true);
            ret = baos.toString();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception generating explain output: " + e), (Throwable)e);
        }
        return ret;
    }

    public static void doAuthorization(BaseSemanticAnalyzer sem, String command) throws HiveException, AuthorizationException {
        ImportSemanticAnalyzer isa;
        HashSet<ReadEntity> inputs = sem.getInputs();
        HashSet<WriteEntity> outputs = sem.getOutputs();
        SessionState ss = SessionState.get();
        HiveOperation op = ss.getHiveOperation();
        Hive db = sem.getDb();
        if (ss.isAuthorizationModeV2()) {
            ColumnAccessInfo colAccessInfo = sem.getColumnAccessInfo();
            Map<String, List<String>> selectTab2Cols = colAccessInfo != null ? colAccessInfo.getTableToColumnAccessMap() : null;
            Map<String, List<String>> updateTab2Cols = sem.getUpdateColumnAccessInfo() != null ? sem.getUpdateColumnAccessInfo().getTableToColumnAccessMap() : null;
            Driver.doAuthorizationV2(ss, op, inputs, outputs, command, selectTab2Cols, updateTab2Cols);
            return;
        }
        if (op == null) {
            throw new HiveException("Operation should not be null");
        }
        HiveAuthorizationProvider authorizer = ss.getAuthorizer();
        if (op.equals((Object)HiveOperation.CREATEDATABASE)) {
            authorizer.authorize(op.getInputRequiredPrivileges(), op.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.CREATETABLE)) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        } else if (op.equals((Object)HiveOperation.IMPORT) && !(isa = (ImportSemanticAnalyzer)sem).existsTable()) {
            authorizer.authorize(db.getDatabase(SessionState.get().getCurrentDatabase()), null, HiveOperation.CREATETABLE_AS_SELECT.getOutputRequiredPrivileges());
        }
        if (outputs != null && outputs.size() > 0) {
            for (WriteEntity write : outputs) {
                Partition part;
                if (write.isDummy() || write.isPathType()) continue;
                if (write.getType() == Entity.Type.DATABASE) {
                    authorizer.authorize(write.getDatabase(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getType() == Entity.Type.PARTITION && (part = db.getPartition(write.getTable(), write.getPartition().getSpec(), false)) != null) {
                    authorizer.authorize(write.getPartition(), null, op.getOutputRequiredPrivileges());
                    continue;
                }
                if (write.getTable() == null) continue;
                authorizer.authorize(write.getTable(), null, op.getOutputRequiredPrivileges());
            }
        }
        if (inputs != null && inputs.size() > 0) {
            HashMap<Table, List<String>> tab2Cols = new HashMap<Table, List<String>>();
            HashMap<Partition, List<String>> part2Cols = new HashMap<Partition, List<String>>();
            HashMap<String, Boolean> tableUsePartLevelAuth = new HashMap<String, Boolean>();
            for (ReadEntity read : inputs) {
                boolean usePartLevelPriv;
                String tblName;
                if (read.isDummy() || read.isPathType() || read.getType() == Entity.Type.DATABASE) continue;
                Table tbl = read.getTable();
                if (read.getPartition() == null && (tbl == null || !tbl.isPartitioned()) || tableUsePartLevelAuth.get(tblName = tbl.getTableName()) != null) continue;
                boolean bl = usePartLevelPriv = tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(tbl.getParameters().get("PARTITION_LEVEL_PRIVILEGE"));
                if (usePartLevelPriv) {
                    tableUsePartLevelAuth.put(tblName, Boolean.TRUE);
                    continue;
                }
                tableUsePartLevelAuth.put(tblName, Boolean.FALSE);
            }
            Driver.getTablePartitionUsedColumns(op, sem, tab2Cols, part2Cols, tableUsePartLevelAuth);
            HashSet<String> tableAuthChecked = new HashSet<String>();
            for (ReadEntity read : inputs) {
                Partition partition;
                if (read.isDummy() || read.isPathType() || !read.isDirect()) continue;
                if (read.getType() == Entity.Type.DATABASE) {
                    authorizer.authorize(read.getDatabase(), op.getInputRequiredPrivileges(), null);
                    continue;
                }
                Table tbl = read.getTable();
                if (read.getPartition() != null && Boolean.TRUE.equals(tableUsePartLevelAuth.get((tbl = (partition = read.getPartition()).getTable()).getTableName()))) {
                    List cols = (List)part2Cols.get(partition);
                    if (cols != null && cols.size() > 0) {
                        authorizer.authorize(partition.getTable(), partition, cols, op.getInputRequiredPrivileges(), null);
                        continue;
                    }
                    authorizer.authorize(partition, op.getInputRequiredPrivileges(), null);
                    continue;
                }
                if (tbl == null || tableAuthChecked.contains(tbl.getTableName()) || Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) continue;
                List cols = (List)tab2Cols.get(tbl);
                if (cols != null && cols.size() > 0) {
                    authorizer.authorize(tbl, null, cols, op.getInputRequiredPrivileges(), null);
                } else {
                    authorizer.authorize(tbl, op.getInputRequiredPrivileges(), null);
                }
                tableAuthChecked.add(tbl.getTableName());
            }
        }
    }

    private static void getTablePartitionUsedColumns(HiveOperation op, BaseSemanticAnalyzer sem, Map<Table, List<String>> tab2Cols, Map<Partition, List<String>> part2Cols, Map<String, Boolean> tableUsePartLevelAuth) throws HiveException {
        if (op.equals((Object)HiveOperation.CREATETABLE_AS_SELECT) || op.equals((Object)HiveOperation.QUERY)) {
            SemanticAnalyzer querySem = (SemanticAnalyzer)sem;
            ParseContext parseCtx = querySem.getParseContext();
            for (Map.Entry<String, Operator<? extends OperatorDesc>> topOpMap : querySem.getParseContext().getTopOps().entrySet()) {
                TableScanOperator tableScanOp;
                Operator<? extends OperatorDesc> topOp = topOpMap.getValue();
                if (!(topOp instanceof TableScanOperator) || (tableScanOp = (TableScanOperator)topOp).isInsideView()) continue;
                Table tbl = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
                List<Integer> neededColumnIds = tableScanOp.getNeededColumnIDs();
                List<FieldSchema> columns = tbl.getCols();
                ArrayList<String> cols = new ArrayList<String>();
                for (int i = 0; i < neededColumnIds.size(); ++i) {
                    cols.add(columns.get(neededColumnIds.get(i)).getName());
                }
                if (tbl.isPartitioned() && Boolean.TRUE.equals(tableUsePartLevelAuth.get(tbl.getTableName()))) {
                    String alias_id = topOpMap.getKey();
                    PrunedPartitionList partsList = PartitionPruner.prune(tableScanOp, parseCtx, alias_id);
                    Set<Partition> parts = partsList.getPartitions();
                    for (Partition part : parts) {
                        List<String> existingCols = part2Cols.get(part);
                        if (existingCols == null) {
                            existingCols = new ArrayList<String>();
                        }
                        existingCols.addAll(cols);
                        part2Cols.put(part, existingCols);
                    }
                    continue;
                }
                List<String> existingCols = tab2Cols.get(tbl);
                if (existingCols == null) {
                    existingCols = new ArrayList<String>();
                }
                existingCols.addAll(cols);
                tab2Cols.put(tbl, existingCols);
            }
        }
    }

    private static void doAuthorizationV2(SessionState ss, HiveOperation op, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs, String command, Map<String, List<String>> tab2cols, Map<String, List<String>> updateTab2Cols) throws HiveException {
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setCommandString(command);
        HiveOperationType hiveOpType = Driver.getHiveOperationType(op);
        List<HivePrivilegeObject> inputsHObjs = Driver.getHivePrivObjects(inputs, tab2cols);
        List<HivePrivilegeObject> outputHObjs = Driver.getHivePrivObjects(outputs, updateTab2Cols);
        ss.getAuthorizerV2().checkPrivileges(hiveOpType, inputsHObjs, outputHObjs, authzContextBuilder.build());
    }

    private static List<HivePrivilegeObject> getHivePrivObjects(HashSet<? extends Entity> privObjects, Map<String, List<String>> tableName2Cols) {
        ArrayList<HivePrivilegeObject> hivePrivobjs = new ArrayList<HivePrivilegeObject>();
        if (privObjects == null) {
            return hivePrivobjs;
        }
        block7: for (Entity entity : privObjects) {
            HivePrivilegeObject.HivePrivilegeObjectType privObjType = AuthorizationUtils.getHivePrivilegeObjectType(entity.getType());
            if (entity instanceof ReadEntity && !((ReadEntity)entity).isDirect() || entity instanceof WriteEntity && ((WriteEntity)entity).isTempURI()) continue;
            String dbname = null;
            String objName = null;
            List<String> partKeys = null;
            List<String> columns = null;
            switch (entity.getType()) {
                case DATABASE: {
                    dbname = entity.getDatabase().getName();
                    break;
                }
                case TABLE: {
                    dbname = entity.getTable().getDbName();
                    objName = entity.getTable().getTableName();
                    columns = tableName2Cols == null ? null : tableName2Cols.get(Table.getCompleteName(dbname, objName));
                    break;
                }
                case DFS_DIR: 
                case LOCAL_DIR: {
                    objName = entity.getD().toString();
                    break;
                }
                case FUNCTION: {
                    if (entity.getDatabase() != null) {
                        dbname = entity.getDatabase().getName();
                    }
                    objName = entity.getFunctionName();
                    break;
                }
                case DUMMYPARTITION: 
                case PARTITION: {
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected object type");
                }
            }
            HivePrivilegeObject.HivePrivObjectActionType actionType = AuthorizationUtils.getActionType(entity);
            HivePrivilegeObject hPrivObject = new HivePrivilegeObject(privObjType, dbname, objName, partKeys, columns, actionType, null);
            hivePrivobjs.add(hPrivObject);
        }
        return hivePrivobjs;
    }

    private static HiveOperationType getHiveOperationType(HiveOperation op) {
        return HiveOperationType.valueOf(op.name());
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    private List<HiveLockObj> getLockObjects(Database d, Table t, Partition p, HiveLockMode mode) throws SemanticException {
        LinkedList<HiveLockObj> locks = new LinkedList<HiveLockObj>();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(this.plan.getQueryId(), String.valueOf(System.currentTimeMillis()), "IMPLICIT", this.plan.getQueryStr(), this.conf);
        if (d != null) {
            locks.add(new HiveLockObj(new HiveLockObject(d.getName(), lockData), mode));
            return locks;
        }
        if (t != null) {
            locks.add(new HiveLockObj(new HiveLockObject(t.getDbName(), lockData), mode));
            locks.add(new HiveLockObj(new HiveLockObject(t, lockData), mode));
            mode = HiveLockMode.SHARED;
            locks.add(new HiveLockObj(new HiveLockObject(t.getDbName(), lockData), mode));
            return locks;
        }
        if (p != null) {
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable().getDbName(), lockData), mode));
            if (!(p instanceof DummyPartition)) {
                locks.add(new HiveLockObj(new HiveLockObject(p, lockData), mode));
            }
            mode = HiveLockMode.SHARED;
            String name = p.getName();
            if (p instanceof DummyPartition) {
                name = p.getName().split("@")[2];
            }
            String partialName = "";
            String[] partns = name.split("/");
            int len = p instanceof DummyPartition ? partns.length : partns.length - 1;
            LinkedHashMap<String, String> partialSpec = new LinkedHashMap<String, String>();
            for (int idx = 0; idx < len; ++idx) {
                String partn = partns[idx];
                partialName = partialName + partn;
                String[] nameValue = partn.split("=");
                assert (nameValue.length == 2);
                partialSpec.put(nameValue[0], nameValue[1]);
                try {
                    locks.add(new HiveLockObj(new HiveLockObject(new DummyPartition(p.getTable(), p.getTable().getDbName() + "/" + p.getTable().getTableName() + "/" + partialName, partialSpec), lockData), mode));
                    partialName = partialName + "/";
                    continue;
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage());
                }
            }
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable(), lockData), mode));
            locks.add(new HiveLockObj(new HiveLockObject(p.getTable().getDbName(), lockData), mode));
        }
        return locks;
    }

    private void recordValidTxns() throws LockException {
        ValidTxnList txns = SessionState.get().getTxnMgr().getValidTxns();
        String txnStr = txns.toString();
        this.conf.set("hive.txn.valid.txns", txnStr);
        LOG.debug((Object)("Encoding valid txns info " + txnStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireLocksAndOpenTxn() {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        SessionState ss = SessionState.get();
        HiveTxnManager txnMgr = ss.getTxnMgr();
        try {
            String userFromUGI;
            try {
                userFromUGI = this.conf.getUser();
            }
            catch (IOException e) {
                this.errorMessage = "FAILED: Error in determining user while acquiring locks: " + e.getMessage();
                this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                this.downstreamError = e;
                console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                int n = 10;
                perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
                return n;
            }
            if (this.acidSinks != null && this.acidSinks.size() > 0) {
                long txnId = ss.getCurrentTxn();
                if (txnId == -1L) {
                    txnId = txnMgr.openTxn(userFromUGI);
                    ss.setCurrentTxn(txnId);
                }
                if (this.acidSinks != null) {
                    for (FileSinkDesc desc : this.acidSinks) {
                        desc.setTransactionId(txnId);
                    }
                }
            }
            txnMgr.acquireLocks(this.plan, this.ctx, userFromUGI, this.lDrvState);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            int n = 10;
            return n;
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocksAndCommitOrRollback(boolean commit) throws LockException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "releaseLocks");
        SessionState ss = SessionState.get();
        HiveTxnManager txnMgr = ss.getTxnMgr();
        if (ss.getCurrentTxn() != -1L && ss.isAutoCommit()) {
            try {
                if (commit) {
                    txnMgr.commitTxn();
                }
                txnMgr.rollbackTxn();
            }
            finally {
                ss.setCurrentTxn(-1L);
            }
        } else {
            if (this.ctx != null && this.ctx.getHiveLocks() != null) {
                this.hiveLocks.addAll(this.ctx.getHiveLocks());
            }
            if (!this.hiveLocks.isEmpty()) {
                txnMgr.getLockManager().releaseLocks(this.hiveLocks);
            }
        }
        this.hiveLocks.clear();
        if (this.ctx != null) {
            this.ctx.setHiveLocks(null);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "releaseLocks");
    }

    private void releaseResources() {
        this.releasePlan();
        this.releaseDriverContext();
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandNeedRetryException {
        return this.run(command, false);
    }

    public CommandProcessorResponse run() throws CommandNeedRetryException {
        return this.run(null, true);
    }

    public CommandProcessorResponse run(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        CommandProcessorResponse cpr = this.runInternal(command, alreadyCompiled);
        if (cpr.getResponseCode() == 0) {
            return cpr;
        }
        SessionState ss = SessionState.get();
        if (ss == null) {
            return cpr;
        }
        MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
        if (!(mdf instanceof JsonMetaDataFormatter)) {
            return cpr;
        }
        try {
            if (this.downstreamError == null) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState);
                return cpr;
            }
            ErrorMsg canonicalErr = ErrorMsg.getErrorMsg(cpr.getResponseCode());
            if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState, null);
                return cpr;
            }
            if (this.downstreamError instanceof HiveException) {
                HiveException rc = (HiveException)this.downstreamError;
                mdf.error(ss.out, this.errorMessage, rc.getCanonicalErrorMsg().getErrorCode(), this.SQLState, rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? org.apache.hadoop.util.StringUtils.stringifyException((Throwable)rc) : null);
            } else {
                ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg(this.downstreamError.getMessage());
                mdf.error(ss.out, this.errorMessage, canonicalMsg.getErrorCode(), this.SQLState, org.apache.hadoop.util.StringUtils.stringifyException((Throwable)this.downstreamError));
            }
        }
        catch (HiveException ex) {
            console.printError("Unable to JSON-encode the error", org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
        }
        return cpr;
    }

    public CommandProcessorResponse compileAndRespond(String command) {
        return this.createProcessorResponse(this.compileInternal(command, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compileInternal(String command, boolean deferClose) {
        int ret;
        LOG.debug((Object)"Acquire a monitor for compiling query");
        ReentrantLock compileLock = this.tryAcquireCompileLock(command);
        if (compileLock == null) {
            return ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode();
        }
        try {
            ret = this.compile(command, true, deferClose);
        }
        finally {
            compileLock.unlock();
        }
        if (ret != 0) {
            try {
                this.releaseLocksAndCommitOrRollback(false);
            }
            catch (LockException e) {
                LOG.warn((Object)("Exception in releasing locks. " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        PerfLogger perfLogger = SessionState.getPerfLogger();
        this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.COMPILATION, perfLogger.getStartTimes());
        this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.COMPILATION, perfLogger.getEndTimes());
        return ret;
    }

    private ReentrantLock tryAcquireCompileLock(String command) {
        block6: {
            long maxCompileLockWaitTime = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, TimeUnit.SECONDS);
            if (maxCompileLockWaitTime > 0L) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Waiting to acquire compile lock: " + command));
                    }
                    if (!globalCompileLock.tryLock(maxCompileLockWaitTime, TimeUnit.SECONDS)) {
                        this.errorMessage = ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg();
                        LOG.error((Object)(this.errorMessage + ": " + command));
                        return null;
                    }
                    break block6;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Interrupted Exception ignored", (Throwable)e);
                    }
                    return null;
                }
            }
            globalCompileLock.lock();
        }
        return globalCompileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandProcessorResponse runInternal(String command, boolean alreadyCompiled) throws CommandNeedRetryException {
        CommandProcessorResponse commandProcessorResponse;
        boolean isFinishedWithError;
        block79: {
            block75: {
                int ret;
                PerfLogger perfLogger;
                List driverRunHooks;
                HiveDriverRunHookContextImpl hookContext;
                block73: {
                    CommandProcessorResponse e4;
                    block78: {
                        block74: {
                            block71: {
                                CommandProcessorResponse e22;
                                block77: {
                                    block72: {
                                        int ret2;
                                        block69: {
                                            CommandProcessorResponse commandProcessorResponse2;
                                            block76: {
                                                block70: {
                                                    int ret3;
                                                    this.errorMessage = null;
                                                    this.SQLState = null;
                                                    this.downstreamError = null;
                                                    if (!this.validateConfVariables()) {
                                                        return this.createProcessorResponse(12);
                                                    }
                                                    LockedDriverState.setLockedDriverState(this.lDrvState);
                                                    this.lDrvState.stateLock.lock();
                                                    try {
                                                        if (alreadyCompiled) {
                                                            if (this.lDrvState.driverState != DriverState.COMPILED) {
                                                                this.errorMessage = "FAILED: Precompiled query has been cancelled or closed.";
                                                                console.printError(this.errorMessage);
                                                                CommandProcessorResponse commandProcessorResponse3 = this.createProcessorResponse(12);
                                                                return commandProcessorResponse3;
                                                            }
                                                            this.lDrvState.driverState = DriverState.EXECUTING;
                                                        } else {
                                                            this.lDrvState.driverState = DriverState.COMPILING;
                                                        }
                                                    }
                                                    finally {
                                                        this.lDrvState.stateLock.unlock();
                                                    }
                                                    isFinishedWithError = true;
                                                    hookContext = new HiveDriverRunHookContextImpl(this.conf, alreadyCompiled ? this.ctx.getCmd() : command);
                                                    try {
                                                        driverRunHooks = this.hooksLoader.getHooks(HiveConf.ConfVars.HIVE_DRIVER_RUN_HOOKS, console);
                                                        for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                                                            driverRunHook.preDriverRun(hookContext);
                                                        }
                                                    }
                                                    catch (Exception e3) {
                                                        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e3);
                                                        this.SQLState = ErrorMsg.findSQLState(e3.getMessage());
                                                        this.downstreamError = e3;
                                                        console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e3));
                                                        CommandProcessorResponse driverRunHook = this.createProcessorResponse(12);
                                                        if (this.isInterrupted()) {
                                                            this.closeInProcess(true);
                                                        } else {
                                                            this.releaseResources();
                                                        }
                                                        this.lDrvState.stateLock.lock();
                                                        try {
                                                            if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                                                                this.lDrvState.driverState = DriverState.ERROR;
                                                                return driverRunHook;
                                                            }
                                                            this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                                                            return driverRunHook;
                                                        }
                                                        finally {
                                                            this.lDrvState.stateLock.unlock();
                                                        }
                                                    }
                                                    perfLogger = SessionState.getPerfLogger(true);
                                                    perfLogger.PerfLogBegin(CLASS_NAME, "Driver.run");
                                                    perfLogger.PerfLogBegin(CLASS_NAME, "TimeToSubmit");
                                                    if (alreadyCompiled || (ret3 = this.compileInternal(command, true)) == 0) break block69;
                                                    commandProcessorResponse2 = this.createProcessorResponse(ret3);
                                                    if (!this.isInterrupted()) break block70;
                                                    this.closeInProcess(true);
                                                    break block76;
                                                }
                                                this.releaseResources();
                                            }
                                            this.lDrvState.stateLock.lock();
                                            try {
                                                if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                                                    this.lDrvState.driverState = DriverState.ERROR;
                                                    return commandProcessorResponse2;
                                                }
                                                this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                                                return commandProcessorResponse2;
                                            }
                                            finally {
                                                this.lDrvState.stateLock.unlock();
                                            }
                                        }
                                        this.ctx.setHiveTxnManager(SessionState.get().getTxnMgr());
                                        if (!this.requiresLock() || (ret2 = this.isInterrupted() ? this.handleInterruption("at acquiring the lock.") : this.acquireLocksAndOpenTxn()) == 0) break block71;
                                        try {
                                            this.releaseLocksAndCommitOrRollback(false);
                                        }
                                        catch (LockException e22) {
                                            // empty catch block
                                        }
                                        e22 = this.createProcessorResponse(ret2);
                                        if (!this.isInterrupted()) break block72;
                                        this.closeInProcess(true);
                                        break block77;
                                    }
                                    this.releaseResources();
                                }
                                this.lDrvState.stateLock.lock();
                                try {
                                    if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                                        this.lDrvState.driverState = DriverState.ERROR;
                                        return e22;
                                    }
                                    this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                                    return e22;
                                }
                                finally {
                                    this.lDrvState.stateLock.unlock();
                                }
                            }
                            ret = this.execute(true);
                            if (ret == 0) break block73;
                            try {
                                this.releaseLocksAndCommitOrRollback(false);
                            }
                            catch (LockException e4) {
                                // empty catch block
                            }
                            e4 = this.createProcessorResponse(ret);
                            if (!this.isInterrupted()) break block74;
                            this.closeInProcess(true);
                            break block78;
                        }
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                            this.lDrvState.driverState = DriverState.ERROR;
                            return e4;
                        }
                        this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                        return e4;
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                }
                try {
                    this.releaseLocksAndCommitOrRollback(true);
                }
                catch (LockException e) {
                    this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                    this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                    this.downstreamError = e;
                    console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    CommandProcessorResponse commandProcessorResponse4 = this.createProcessorResponse(12);
                    if (this.isInterrupted()) {
                        this.closeInProcess(true);
                    } else {
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                            this.lDrvState.driverState = DriverState.ERROR;
                            return commandProcessorResponse4;
                        }
                        this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                        return commandProcessorResponse4;
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                }
                try {
                    perfLogger.PerfLogEnd(CLASS_NAME, "Driver.run");
                    this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.EXECUTION, perfLogger.getStartTimes());
                    this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.EXECUTION, perfLogger.getEndTimes());
                    try {
                        for (HiveDriverRunHook driverRunHook : driverRunHooks) {
                            driverRunHook.postDriverRun(hookContext);
                        }
                    }
                    catch (Exception e) {
                        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                        this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                        this.downstreamError = e;
                        console.printError(this.errorMessage + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        CommandProcessorResponse commandProcessorResponse5 = this.createProcessorResponse(12);
                        if (this.isInterrupted()) {
                            this.closeInProcess(true);
                        } else {
                            this.releaseResources();
                        }
                        this.lDrvState.stateLock.lock();
                        try {
                            if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                                this.lDrvState.driverState = DriverState.ERROR;
                                return commandProcessorResponse5;
                            }
                            this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                            return commandProcessorResponse5;
                        }
                        finally {
                            this.lDrvState.stateLock.unlock();
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (this.isInterrupted()) {
                        this.closeInProcess(true);
                    } else {
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                            this.lDrvState.driverState = DriverState.ERROR;
                            throw throwable;
                        }
                        this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                        throw throwable;
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                }
                isFinishedWithError = false;
                commandProcessorResponse = this.createProcessorResponse(ret);
                if (!this.isInterrupted()) break block75;
                this.closeInProcess(true);
                break block79;
            }
            this.releaseResources();
        }
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState == DriverState.INTERRUPT) {
                this.lDrvState.driverState = DriverState.ERROR;
                return commandProcessorResponse;
            }
            this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
            return commandProcessorResponse;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private boolean requiresLock() {
        if (!this.checkConcurrency()) {
            return false;
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        LinkedList<Task<? extends Serializable>> taskQueue = new LinkedList<Task<? extends Serializable>>();
        taskQueue.addAll(this.plan.getRootTasks());
        while (taskQueue.peek() != null) {
            Task tsk = (Task)taskQueue.remove();
            if (tsk.requireLock()) {
                return true;
            }
            if (tsk instanceof ConditionalTask) {
                taskQueue.addAll(((ConditionalTask)tsk).getListTasks());
            }
            if (tsk.getChildTasks() == null) continue;
            taskQueue.addAll(tsk.getChildTasks());
        }
        return false;
    }

    private CommandProcessorResponse createProcessorResponse(int ret) {
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
        this.queryDisplay.setErrorMessage(this.errorMessage);
        return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState, this.downstreamError);
    }

    private boolean validateConfVariables() {
        boolean valid = true;
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES) && (this.conf.getBoolVar(HiveConf.ConfVars.HADOOPMAPREDINPUTDIRRECURSIVE) || this.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTLISTBUCKETING) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_UNION_REMOVE))) {
            this.errorMessage = "FAILED: Hive Internal Error: " + ErrorMsg.SUPPORT_DIR_MUST_TRUE_FOR_LIST_BUCKETING.getMsg();
            this.SQLState = ErrorMsg.SUPPORT_DIR_MUST_TRUE_FOR_LIST_BUCKETING.getSQLState();
            console.printError(this.errorMessage + "\n");
            valid = false;
        }
        return valid;
    }

    public int execute() throws CommandNeedRetryException {
        return this.execute(false);
    }

    /*
     * Exception decompiling
     */
    public int execute(boolean deferClose) throws CommandNeedRetryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 57[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releasePlan(QueryPlan plan) {
        this.lDrvState.stateLock.lock();
        try {
            if (plan != null) {
                plan.setDone();
                if (SessionState.get() != null) {
                    try {
                        SessionState.get().getHiveHistory().logPlanProgress(plan);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Could not log query plan progress", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private void setErrorMsgAndDetail(int exitVal, Throwable downstreamError, Task tsk) {
        this.downstreamError = downstreamError;
        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
        if (downstreamError != null) {
            this.errorMessage = this.errorMessage + ". " + downstreamError.getMessage();
        } else {
            ErrorMsg em = ErrorMsg.getErrorMsg(exitVal);
            if (em != null) {
                this.errorMessage = this.errorMessage + ". " + em.getMsg();
            }
        }
    }

    private TaskRunner launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, String jobname, int jobs, DriverContext cxt) throws HiveException {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.setVar(HiveConf.ConfVars.HADOOPJOBNAME, jobname + "(" + tsk.getId() + ")");
            }
            this.conf.set("mapreduce.workflow.node.name", tsk.getId());
            Utilities.setWorkflowAdjacencies(this.conf, this.plan);
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.conf, this.plan, cxt);
        TaskResult tskRes = new TaskResult();
        TaskRunner tskRun = new TaskRunner(tsk, tskRes);
        cxt.launching(tskRun);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.isMapRedTask()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Starting task [" + tsk + "] in parallel"));
            }
            tskRun.setOperationLog(OperationLog.getCurrentOperationLog());
            tskRun.start();
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Starting task [" + tsk + "] in serial mode"));
            }
            tskRun.runSequential();
        }
        return tskRun;
    }

    public boolean isFetchingTable() {
        return this.fetchTask != null;
    }

    public boolean getResults(List res) throws IOException, CommandNeedRetryException {
        if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.CLOSED) {
            throw new IOException("FAILED: query has been cancelled, closed, or destroyed.");
        }
        if (this.isFetchingTable()) {
            this.fetchTask.setMaxRows(this.maxRows);
            return this.fetchTask.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getLength() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getLength(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
                row = null;
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    public void resetFetch() throws IOException {
        if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.CLOSED) {
            throw new IOException("FAILED: driver has been cancelled, closed or destroyed.");
        }
        if (this.isFetchingTable()) {
            try {
                this.fetchTask.clearFetch();
            }
            catch (Exception e) {
                throw new IOException("Error closing the current fetch task", e);
            }
            this.fetchTask.initialize(this.conf, null, null);
        } else {
            this.ctx.resetStream();
            this.resStream = null;
        }
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDriverContext() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.driverCxt != null) {
                this.driverCxt.shutdown();
                this.driverCxt = null;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception while shutting down the task runner", (Throwable)e);
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private void releasePlan() {
        try {
            if (this.plan != null) {
                this.fetchTask = this.plan.getFetchTask();
                if (this.fetchTask != null) {
                    this.fetchTask.setDriverContext(null);
                    this.fetchTask.setQueryPlan(null);
                }
            }
            this.plan = null;
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception while clearing the Fetch task", (Throwable)e);
        }
    }

    private void releaseContext() {
        try {
            if (this.ctx != null) {
                this.ctx.clear();
                if (this.ctx.getHiveLocks() != null) {
                    this.hiveLocks.addAll(this.ctx.getHiveLocks());
                    this.ctx.setHiveLocks(null);
                }
                this.ctx = null;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception while clearing the context ", (Throwable)e);
        }
    }

    private void releaseResStream() {
        try {
            if (this.resStream != null) {
                ((FSDataInputStream)this.resStream).close();
                this.resStream = null;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)" Exception while closing the resStream ", (Throwable)e);
        }
    }

    private void releaseFetchTask() {
        try {
            if (this.fetchTask != null) {
                this.fetchTask.clearFetch();
                this.fetchTask = null;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)" Exception while clearing the FetchTask ", (Throwable)e);
        }
    }

    private int closeInProcess(boolean destroyed) {
        this.releaseDriverContext();
        this.releasePlan();
        this.releaseFetchTask();
        this.releaseResStream();
        this.releaseContext();
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
        if (destroyed && !this.hiveLocks.isEmpty()) {
            try {
                this.releaseLocksAndCommitOrRollback(false);
            }
            catch (LockException e) {
                LOG.warn((Object)("Exception when releasing locking in destroy: " + e.getMessage()));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        this.lDrvState.stateLock.lock();
        try {
            this.releaseDriverContext();
            if (this.lDrvState.driverState == DriverState.COMPILING || this.lDrvState.driverState == DriverState.EXECUTING || this.lDrvState.driverState == DriverState.INTERRUPT) {
                this.lDrvState.driverState = DriverState.INTERRUPT;
                int n = 0;
                return n;
            }
            this.releasePlan();
            this.releaseFetchTask();
            this.releaseResStream();
            this.releaseContext();
            this.lDrvState.driverState = DriverState.CLOSED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
            LockedDriverState.removeLockedDriverState();
        }
        if (SessionState.get() != null) {
            SessionState.get().getLineageState().clear();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.INTERRUPT) {
                return;
            }
            this.lDrvState.driverState = DriverState.DESTROYED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        if (!this.hiveLocks.isEmpty()) {
            try {
                this.releaseLocksAndCommitOrRollback(false);
            }
            catch (LockException e) {
                LOG.warn((Object)("Exception when releasing locking in destroy: " + e.getMessage()));
            }
        }
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    public QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    private static class QueryState {
        private HiveOperation op;
        private String cmd;
        private boolean init = false;

        private QueryState() {
        }

        public void init(HiveOperation op, String cmd) {
            this.op = op;
            this.cmd = cmd;
            this.init = true;
        }

        public boolean isInitialized() {
            return this.init;
        }

        public HiveOperation getOp() {
            return this.op;
        }

        public String getCmd() {
            return this.cmd;
        }
    }

    public static class LockedDriverState {
        public final ReentrantLock stateLock = new ReentrantLock();
        public DriverState driverState = DriverState.INITIALIZED;
        private static ThreadLocal<LockedDriverState> lds = new ThreadLocal<LockedDriverState>(){

            @Override
            protected LockedDriverState initialValue() {
                return new LockedDriverState();
            }
        };

        public static void setLockedDriverState(LockedDriverState lDrv) {
            lds.set(lDrv);
        }

        public static LockedDriverState getLockedDriverState() {
            return lds.get();
        }

        public static void removeLockedDriverState() {
            if (lds != null) {
                lds.remove();
            }
        }
    }

    public static enum DriverState {
        INITIALIZED,
        COMPILING,
        COMPILED,
        EXECUTING,
        EXECUTED,
        INTERRUPT,
        CLOSED,
        DESTROYED,
        ERROR;

    }
}

