/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class DataServiceTestModel
extends XulEventSourceAdapter {
    private String sql;
    protected static final LogLevel DEFAULT_LOGLEVEL = LogLevel.DETAILED;
    private LogLevel logLevel = DEFAULT_LOGLEVEL;
    private String alertMessage;
    private List<OptimizationImpactInfo> optimizationImpact = new ArrayList<OptimizationImpactInfo>();
    private List<Object[]> resultRows = new ArrayList<Object[]>();
    private RowMetaInterface resultRowMeta;
    private LogChannelInterface serviceTransLogChannel;
    private LogChannelInterface genTransLogChannel;
    private int maxRows = 0;
    public static final List<Integer> MAXROWS_CHOICES = Arrays.asList(100, 500, 1000);
    public static final List<Integer> MAXROWS_STREAMING_CHOICES = Arrays.asList(0);
    private IDataServiceClientService.StreamingMode windowMode = IDataServiceClientService.StreamingMode.TIME_BASED;
    private long windowSize = 0L;
    private long windowEvery = 0L;
    private long windowLimit = 0L;
    private boolean executing = false;

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public LogChannelInterface getServiceTransLogChannel() {
        return this.serviceTransLogChannel;
    }

    public void setServiceTransLogChannel(LogChannelInterface serviceTransLogChannel) {
        this.serviceTransLogChannel = serviceTransLogChannel;
    }

    public void setGenTransLogChannel(LogChannelInterface logChannel) {
        this.genTransLogChannel = logChannel;
    }

    public LogChannelInterface getGenTransLogChannel() {
        return this.genTransLogChannel;
    }

    public void addResultRow(Object[] row) {
        this.resultRows.add(row);
    }

    public List<Object[]> getResultRows() {
        return this.resultRows;
    }

    public void clearResultRows() {
        this.resultRows.clear();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public List<String> getAllLogLevels() {
        return Arrays.asList(LogLevel.logLevelDescriptions);
    }

    public int getMaxRows() {
        return MAXROWS_CHOICES.get(this.maxRows);
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public List<Integer> getAllMaxRows() {
        return MAXROWS_CHOICES;
    }

    public List<Integer> getAllStreamingMaxRows() {
        return MAXROWS_STREAMING_CHOICES;
    }

    public IDataServiceClientService.StreamingMode getWindowMode() {
        return this.windowMode;
    }

    public void setWindowMode(IDataServiceClientService.StreamingMode windowMode) {
        this.windowMode = windowMode;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    public long getWindowEvery() {
        return this.windowEvery;
    }

    public void setWindowEvery(long windowEvery) {
        this.windowEvery = windowEvery;
    }

    public long getWindowLimit() {
        return this.windowLimit;
    }

    public void setWindowLimit(long windowLimit) {
        this.windowLimit = windowLimit;
    }

    public boolean isTimeBased() {
        return IDataServiceClientService.StreamingMode.TIME_BASED.equals((Object)this.windowMode);
    }

    public void setTimeBased(boolean timeBased) {
        this.windowMode = timeBased ? IDataServiceClientService.StreamingMode.TIME_BASED : IDataServiceClientService.StreamingMode.ROW_BASED;
    }

    public boolean isRowBased() {
        return IDataServiceClientService.StreamingMode.ROW_BASED.equals((Object)this.windowMode);
    }

    public void setRowBased(boolean rowBased) {
        this.windowMode = rowBased ? IDataServiceClientService.StreamingMode.ROW_BASED : IDataServiceClientService.StreamingMode.TIME_BASED;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
        this.firePropertyChange("alertMessage", null, alertMessage);
    }

    public RowMetaInterface getResultRowMeta() {
        return this.resultRowMeta;
    }

    public void setResultRowMeta(RowMetaInterface resultRowMeta) {
        this.resultRowMeta = resultRowMeta;
    }

    public void clearOptimizationImpact() {
        this.optimizationImpact.clear();
        this.firePropertyChange("optimizationImpactDescription", null, this.getOptimizationImpactDescription());
    }

    public void addOptimizationImpact(OptimizationImpactInfo info) {
        this.optimizationImpact.add(info);
        this.firePropertyChange("optimizationImpactDescription", null, this.getOptimizationImpactDescription());
    }

    public String getOptimizationImpactDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        if (this.optimizationImpact.size() == 0) {
            builder.append("[No Push Down Optimizations Defined]\n");
        }
        for (OptimizationImpactInfo info : this.optimizationImpact) {
            builder.append(info.getDescription());
            builder.append("\n- - - - - - - - - - - - - - - - - - - - - -\n\n");
        }
        return builder.toString();
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setExecuting(boolean executing) {
        this.executing = executing;
        this.firePropertyChange("executing", null, executing);
    }
}

