/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.MetricsPainter;
import org.pentaho.di.core.metrics.MetricsDuration;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.ui.controller.DataServiceTestController;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.SWTGC;

public class DataServiceTestMetrics {
    private final Canvas canvas;
    private volatile Image image;
    private final ScrolledComposite metricsComposite;
    private List<MetricsDuration> durations = Collections.emptyList();
    public static final Comparator<MetricsDuration> METRICS_COMPARATOR = new Comparator<MetricsDuration>(){

        @Override
        public int compare(MetricsDuration o1, MetricsDuration o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    };

    public DataServiceTestMetrics(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.metricsComposite = new ScrolledComposite(composite, 768);
        this.metricsComposite.setExpandHorizontal(true);
        this.metricsComposite.setExpandVertical(true);
        this.canvas = new Canvas((Composite)this.metricsComposite, 0);
        this.metricsComposite.setContent((Control)this.canvas);
        this.metricsComposite.setMinSize(100, 100);
        this.metricsComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (DataServiceTestMetrics.this.image != null) {
                    DataServiceTestMetrics.this.image.dispose();
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.drawImage(DataServiceTestMetrics.this.refreshImage(), 0, 0);
            }
        });
    }

    public synchronized void display(List<MetricsDuration> durations) {
        if (Const.isEmpty(durations)) {
            durations = Collections.emptyList();
        } else {
            Collections.sort(durations, METRICS_COMPARATOR);
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.durations = durations;
        this.canvas.redraw();
    }

    private synchronized Image refreshImage() {
        Display device = this.metricsComposite.getDisplay();
        Rectangle bounds = this.metricsComposite.getBounds();
        if (this.image != null) {
            Rectangle imageBounds = this.image.getBounds();
            if (imageBounds.width == bounds.width && imageBounds.height >= bounds.height) {
                return this.image;
            }
            this.image.dispose();
            this.image = null;
        }
        String metricsMessage = BaseMessages.getString(DataServiceTestController.PKG, (String)"DataServiceTest.MetricsPlaceholder", (String[])new String[0]);
        org.eclipse.swt.graphics.Point textExtent = new GC((Drawable)this.canvas).textExtent(metricsMessage);
        if (this.durations.isEmpty()) {
            bounds.height = textExtent.y * 2;
            this.image = new Image((Device)device, bounds.width, bounds.height);
            GC gc = new GC((Drawable)this.image);
            gc.drawText(metricsMessage, (bounds.width - textExtent.x) / 2, textExtent.y / 2);
        } else {
            int barHeight = textExtent.y + 5;
            bounds.height = Math.max(20 + this.durations.size() * (barHeight + 5), bounds.height);
            SWTGC gc = new SWTGC((Device)device, new Point(bounds.width, bounds.height), PropsUI.getInstance().getIconSize());
            MetricsPainter painter = new MetricsPainter((GCInterface)gc, barHeight);
            painter.paint(this.durations);
            this.image = (Image)gc.getImage();
            gc.dispose();
        }
        this.metricsComposite.setMinHeight(bounds.height);
        this.metricsComposite.layout();
        return this.image;
    }

    public void dispose() {
        this.metricsComposite.dispose();
        if (this.canvas != null) {
            this.canvas.dispose();
        }
    }
}

