/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming.ui;

import java.lang.reflect.InvocationTargetException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.di.trans.dataservice.utils.KettleUtils;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulTab;
import org.pentaho.ui.xul.components.XulTextbox;

public class StreamingController
extends AbstractController {
    private static final String NAME = "streamingCtrl";
    KettleUtils kettleUtils = KettleUtils.getInstance();

    public StreamingController() {
        this.setName(NAME);
    }

    public void initBindings(DataServiceModel model) throws InvocationTargetException, XulException, KettleException {
        BindingFactory bindingFactory = this.getBindingFactory();
        XulRadio streamingRadioButton = (XulRadio)this.getElementById("streaming-type-radio");
        XulTab streamingTab = (XulTab)this.getElementById("streaming-tab");
        XulTextbox streamingMaxRows = (XulTextbox)this.getElementById("streaming-max-rows");
        XulTextbox streamingMaxTime = (XulTextbox)this.getElementById("streaming-max-time");
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        int modelStreamingMaxRows = model.getServiceMaxRows();
        streamingMaxRows.setValue(modelStreamingMaxRows > 0 ? Integer.toString(modelStreamingMaxRows) : this.kettleUtils.getKettleProperty("KETTLE_STREAMING_ROW_LIMIT", Integer.toString(5000)));
        long modelStreamingMaxTime = model.getServiceMaxTime();
        streamingMaxTime.setValue(modelStreamingMaxTime > 0L ? Long.toString(modelStreamingMaxTime) : this.kettleUtils.getKettleProperty("KETTLE_STREAMING_TIME_LIMIT", Integer.toString(10000)));
        streamingTab.setVisible(model.isStreaming());
        bindingFactory.createBinding((Object)model, "serviceMaxRows", (Object)streamingMaxRows, "value", new BindingConvertor[]{BindingConvertor.integer2String()});
        bindingFactory.createBinding((Object)model, "serviceMaxTime", (Object)streamingMaxTime, "value", new BindingConvertor[]{BindingConvertor.long2String()});
        bindingFactory.createBinding((Object)streamingRadioButton, "selected", (Object)streamingTab, "visible", new BindingConvertor[0]);
    }
}

