/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming.execution;

import com.google.common.annotations.VisibleForTesting;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;

public class StreamExecutionListener {
    private IDataServiceClientService.StreamingMode windowMode;
    private long windowSize;
    private long windowEvery;
    private int maxRows;
    private long maxTime;
    private Disposable starterSubject;
    private Disposable subject;
    private Disposable fallbackSubject;
    private Observable<List<RowMetaAndData>> buffer;
    private Observable<List<RowMetaAndData>> fallbackBuffer;
    private List<RowMetaAndData> cachedWindow = Collections.synchronizedList(new ArrayList());
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);
    private final AtomicBoolean hasWindow = new AtomicBoolean(false);

    public StreamExecutionListener(PublishSubject<RowMetaAndData> stream, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, int maxRows, long maxTime) {
        this.windowMode = windowMode;
        this.windowSize = windowSize;
        this.windowEvery = windowEvery;
        this.maxRows = maxRows;
        this.maxTime = maxTime;
        this.init(stream);
    }

    private void init(PublishSubject<RowMetaAndData> stream) {
        boolean rowBased = IDataServiceClientService.StreamingMode.ROW_BASED.equals((Object)this.windowMode);
        boolean timeBased = IDataServiceClientService.StreamingMode.TIME_BASED.equals((Object)this.windowMode);
        if (this.windowEvery > 0L) {
            if (timeBased) {
                this.buffer = stream.buffer(this.windowSize, this.windowEvery, TimeUnit.MILLISECONDS);
                this.fallbackBuffer = stream.buffer(this.maxRows);
            } else if (rowBased) {
                this.buffer = stream.buffer((int)this.windowSize, (int)this.windowEvery);
                this.fallbackBuffer = stream.buffer(this.maxTime, TimeUnit.MILLISECONDS);
            }
        } else if (timeBased) {
            this.buffer = stream.buffer(this.windowSize, TimeUnit.MILLISECONDS);
            this.fallbackBuffer = stream.buffer(this.maxRows);
        } else {
            this.buffer = stream.buffer((int)this.windowSize);
            this.fallbackBuffer = stream.buffer(this.maxTime, TimeUnit.MILLISECONDS);
        }
        this.subject = this.buffer.subscribe(window -> this.processBufferWindow((List<RowMetaAndData>)window));
        this.fallbackSubject = this.fallbackBuffer.subscribe(window -> this.processFallbackWindow((List<RowMetaAndData>)window));
        this.starterSubject = stream.subscribe(item -> {
            if (!this.hasWindow.get()) {
                this.cachedWindow.add((RowMetaAndData)item);
            }
        });
    }

    public List<RowMetaAndData> getCachedWindow() {
        return this.cachedWindow;
    }

    public void unSubscribe() {
        this.unSubscribeStarter();
        this.unSubscribeBuffer();
        this.unSubscribeFallbackBuffer();
    }

    @VisibleForTesting
    protected void unSubscribeStarter() {
        if (this.starterSubject != null) {
            this.starterSubject.dispose();
            this.starterSubject = null;
        }
    }

    @VisibleForTesting
    protected void unSubscribeBuffer() {
        if (this.subject != null) {
            this.subject.dispose();
            this.subject = null;
        }
    }

    @VisibleForTesting
    protected void unSubscribeFallbackBuffer() {
        if (this.fallbackSubject != null) {
            this.fallbackSubject.dispose();
            this.fallbackSubject = null;
        }
    }

    private void processBufferWindow(List<RowMetaAndData> list) {
        if (this.isProcessing.compareAndSet(false, true)) {
            if (this.fallbackSubject != null) {
                this.fallbackSubject.dispose();
                this.fallbackSubject = this.fallbackBuffer.subscribe(bufferList -> this.processFallbackWindow((List<RowMetaAndData>)bufferList));
            }
            this.unSubscribeStarter();
            this.hasWindow.set(true);
            this.setCacheWindow(list);
            this.isProcessing.set(false);
        }
    }

    private void processFallbackWindow(List<RowMetaAndData> list) {
        if (this.isProcessing.compareAndSet(false, true)) {
            if (this.subject != null) {
                this.subject.dispose();
                this.subject = this.buffer.subscribe(bufferList -> this.processBufferWindow((List<RowMetaAndData>)bufferList));
            }
            this.unSubscribeStarter();
            this.hasWindow.set(true);
            this.setCacheWindow(list);
            this.isProcessing.set(false);
        }
    }

    private void setCacheWindow(List<RowMetaAndData> list) {
        this.cachedWindow.clear();
        this.cachedWindow.addAll(list);
    }
}

