/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.streaming;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;

public class StreamServiceKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String dataServiceId;
    private final ImmutableMap<String, String> parameters;
    private final List<String> optimizations;

    private StreamServiceKey(String dataServiceId, ImmutableMap<String, String> parameters, List<String> optimizations) {
        this.dataServiceId = dataServiceId;
        this.parameters = parameters;
        this.optimizations = optimizations;
    }

    public static StreamServiceKey create(String dataServiceId, Map<String, String> parameters, List<OptimizationImpactInfo> optimizationList) {
        ImmutableMap params = ImmutableMap.copyOf(parameters);
        ArrayList<String> optimizations = new ArrayList<String>();
        if (optimizationList != null) {
            for (OptimizationImpactInfo optimizationImpact : optimizationList) {
                if (optimizationImpact.getQueryAfterOptimization() == null || optimizationImpact.getQueryAfterOptimization().isEmpty()) continue;
                optimizations.add(optimizationImpact.getQueryAfterOptimization());
            }
        }
        return new StreamServiceKey(dataServiceId, (ImmutableMap<String, String>)params, optimizations);
    }

    public String getDataServiceId() {
        return this.dataServiceId;
    }

    public ImmutableMap<String, String> getParameters() {
        return this.parameters;
    }

    public List<String> getOptimizations() {
        return this.optimizations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamServiceKey cacheKey = (StreamServiceKey)o;
        return Objects.equal((Object)this.dataServiceId, (Object)cacheKey.dataServiceId) && Objects.equal(this.parameters, cacheKey.parameters) && Objects.equal(this.optimizations, cacheKey.optimizations);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataServiceId, this.parameters, this.optimizations});
    }

    public String toString() {
        return Objects.toStringHelper(StreamServiceKey.class).add("dataServiceId", (Object)this.dataServiceId).add("parameters", this.parameters).add("optimizations", this.optimizations).toString();
    }
}

