/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.dataservice.Context;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.AutoOptimizationService;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.di.trans.dataservice.streaming.StreamServiceKey;
import org.pentaho.di.trans.dataservice.streaming.execution.StreamingServiceTransExecutor;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.UIFactory;

public class DataServiceContext
implements Context {
    private final DataServiceMetaStoreUtil metaStoreUtil;
    private final List<AutoOptimizationService> autoOptimizationServices;
    private final PentahoCacheManager cacheManager;
    private final List<PushDownFactory> pushDownFactories;
    private final LogChannelInterface logChannel;
    private final UIFactory uiFactory;
    private final ConcurrentMap<String, DataServiceExecutor> executors = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).softValues().build().asMap();
    private final ConcurrentMap<StreamServiceKey, StreamingServiceTransExecutor> serviceExecutors = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).removalListener((RemovalListener)new RemovalListener<StreamServiceKey, StreamingServiceTransExecutor>(){

        public void onRemoval(RemovalNotification<StreamServiceKey, StreamingServiceTransExecutor> removal) {
            StreamingServiceTransExecutor item = (StreamingServiceTransExecutor)removal.getValue();
            LogChannelInterface log = item.getServiceTrans().getLogChannel();
            item.stopAll();
            log.logDebug("Streaming service cache listener removed: " + removal.getKey());
        }
    }).softValues().build().asMap();

    public DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = DataServiceMetaStoreUtil.create(this);
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @VisibleForTesting
    protected DataServiceContext(List<PushDownFactory> pushDownFactories, List<AutoOptimizationService> autoOptimizationServices, PentahoCacheManager cacheManager, DataServiceMetaStoreUtil metaStoreUtil, UIFactory uiFactory, LogChannelInterface logChannel) {
        this.pushDownFactories = pushDownFactories;
        this.autoOptimizationServices = autoOptimizationServices;
        this.cacheManager = cacheManager;
        this.metaStoreUtil = metaStoreUtil;
        this.logChannel = logChannel;
        this.uiFactory = uiFactory;
    }

    @Override
    public PentahoCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public DataServiceMetaStoreUtil getMetaStoreUtil() {
        return this.metaStoreUtil;
    }

    @Override
    public List<AutoOptimizationService> getAutoOptimizationServices() {
        return this.autoOptimizationServices;
    }

    @Override
    public List<PushDownFactory> getPushDownFactories() {
        return this.pushDownFactories;
    }

    @Override
    public LogChannelInterface getLogChannel() {
        return this.logChannel;
    }

    @Override
    public UIFactory getUIFactory() {
        return this.uiFactory;
    }

    @Override
    public DataServiceDelegate getDataServiceDelegate() {
        return DataServiceDelegate.withDefaultSpoonInstance(this);
    }

    @Override
    public void addExecutor(DataServiceExecutor executor) {
        this.executors.putIfAbsent(executor.getId(), executor);
    }

    @Override
    public DataServiceExecutor getExecutor(String id) {
        return (DataServiceExecutor)this.executors.get(id);
    }

    @Override
    public void removeExecutor(String id) {
        this.executors.remove(id);
    }

    @Override
    public void addServiceTransExecutor(StreamingServiceTransExecutor serviceExecutor) {
        this.serviceExecutors.putIfAbsent(serviceExecutor.getKey(), serviceExecutor);
    }

    @Override
    public StreamingServiceTransExecutor getServiceTransExecutor(StreamServiceKey key) {
        return (StreamingServiceTransExecutor)this.serviceExecutors.get(key);
    }

    @Override
    public void removeServiceTransExecutor(StreamServiceKey key) {
        this.serviceExecutors.remove(key);
    }

    @Override
    public void removeServiceTransExecutor(String dataServiceName) {
        for (StreamServiceKey key : this.serviceExecutors.keySet()) {
            if (!key.getDataServiceId().equals(dataServiceName)) continue;
            this.serviceExecutors.remove(key);
        }
    }
}

