/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;
import org.pentaho.pdi.spark.driver.app.builder.ZipBuilder;

public class SparkDriverAssembly {
    private static final String PDI_SPARK_EXECUTOR_ZIP = "pdi-spark-executor.zip";
    private static final String SCRPT_DAEMON_SH = "adaptive-execution/daemon.sh";
    private static final String SCRPT_DAEMON_SH_PATH = "data-integration/adaptive-execution/%s";
    private AppBuilderContext context;
    String[] EXTRA_EXECUTOR_EXCLUSIONS = new String[]{"**/data-integration/libswt", "**/data-integration/lib", "**/data-integration/adaptive-execution"};
    ZipBuilder driverBuilder;
    ZipBuilder executorBuilder;

    public SparkDriverAssembly(AppBuilderContext context) {
        this.context = context;
    }

    public void build() throws IOException {
        File tempDir = Files.createTempDir();
        AppBuilderContext executorContext = this.context.copy(PDI_SPARK_EXECUTOR_ZIP);
        executorContext.exclude(this.EXTRA_EXECUTOR_EXCLUSIONS);
        executorContext.setOutputLocation(tempDir);
        this.executorBuilder = new ZipBuilder(executorContext);
        this.executorBuilder.compress();
        this.driverBuilder = new ZipBuilder(this.context);
        File exeZip = new File(executorContext.getOutputFilePath());
        this.driverBuilder.addExtraFile(exeZip, exeZip.getName());
        File daemonScript = new File(this.context.getPdiLocation(), SCRPT_DAEMON_SH);
        daemonScript.setExecutable(true, true);
        this.driverBuilder.addExtraFile(daemonScript, String.format(SCRPT_DAEMON_SH_PATH, daemonScript.getName()));
        this.driverBuilder.compress();
    }
}

