/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;
import org.pentaho.pdi.spark.driver.app.builder.CommandLineHandler;
import org.pentaho.pdi.spark.driver.app.builder.SparkDriverAssembly;

public class SparkDriverAppBuilder {
    private static final Class<?> PKG = SparkDriverAppBuilder.class;
    private static final String INFO_CREATING_ZIP = "INFO.CreatingZip";
    private static final String INFO_PLUGINS_EXCLUDED = "INFO.PluginsExcluded";
    private static final String INFO_PLUGINS_INCLUDED = "INFO.PluginsIncluded";
    private static final String INFO_DONE = "INFO.Done";
    private static final String ERROR_FAILED_BUILD_ZIP = "ERROR.FailedToBuildZip";
    private static final String PLUGINS = "plugins";
    private static final String PRT_SEP = "**************************";

    public static void main(String[] args) {
        CommandLineHandler commandLineHandler = new CommandLineHandler(args);
        AppBuilderContext context = commandLineHandler.parse();
        if (context == null || !context.isValid()) {
            return;
        }
        System.out.println(BaseMessages.getString(PKG, (String)INFO_CREATING_ZIP, (String[])new String[]{context.getOutputFilePath()}));
        SparkDriverAssembly driverAssembly = new SparkDriverAssembly(context);
        try {
            File pluginsfolder;
            driverAssembly.build();
            if (driverAssembly.driverBuilder.getExcludedPlugins().size() > 0) {
                System.out.println("");
                System.out.println(PRT_SEP);
                System.out.println(BaseMessages.getString(PKG, (String)INFO_PLUGINS_EXCLUDED, (String[])new String[0]));
                System.out.println(PRT_SEP);
                driverAssembly.driverBuilder.getExcludedPlugins().stream().forEach(path -> System.out.println(path.toFile().getName()));
            }
            if ((pluginsfolder = new File(context.getPdiLocation(), PLUGINS)) != null && pluginsfolder.listFiles() != null && pluginsfolder.listFiles().length > driverAssembly.driverBuilder.getExcludedPlugins().size()) {
                System.out.println("");
                System.out.println(PRT_SEP);
                System.out.println(BaseMessages.getString(PKG, (String)INFO_PLUGINS_INCLUDED, (String[])new String[0]));
                System.out.println(PRT_SEP);
                Arrays.stream(pluginsfolder.listFiles()).filter(File::isDirectory).filter(file -> {
                    Optional<String> first = driverAssembly.driverBuilder.getExcludedPlugins().stream().map(path -> path.toFile().getAbsolutePath()).filter(s -> s.equals(file.getAbsolutePath())).findFirst();
                    return !first.isPresent();
                }).forEach(file -> System.out.println(file.getName()));
            }
            System.out.println("");
            System.out.println(BaseMessages.getString(PKG, (String)INFO_DONE, (String[])new String[]{context.getOutputFilePath()}));
        }
        catch (IOException e) {
            System.err.println(BaseMessages.getString(PKG, (String)ERROR_FAILED_BUILD_ZIP, (String[])new String[]{context.getOutputFilePath()}));
            e.printStackTrace();
        }
    }
}

