/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import java.io.File;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;

public class CommandLineHandler {
    private static final Class<?> PKG = CommandLineHandler.class;
    private static final String HELP_DESC = "HELP.helpDesc";
    private static final String HELP_PDI_LOC_DESC = "HELP.pdiLocationDesc";
    private static final String HELP_OUTPUT_LOC_DESC = "HELP.outputLocationDesc";
    private static final String HELP_PLUGIN_EXCLUDE_DESC = "HELP.pluginExcludeDesc";
    private static final String HELP_EXCLUDE_DESC = "HELP.excludeDesc";
    private static final String ERROR_GENERIC = "ERROR.generic";
    private static final String CMD_LINE_SYNTAX = "SparkAppDriverBuilder [-h] [-p <path>] [-o <path>] [-e <plugin1> ... <pluginN>] [-x <pattern1> ... <patternN>]";
    private static final String NEWLINE = "\n";
    private static final String HELP = "help";
    private static final String PDI_LOCATION = "pdiLocation";
    private static final String OUTPUT_LOCATION = "outputLocation";
    private static final String EXCLUDE_PLUGINS = "exclude-plugins";
    private static final String EXCLUDE = "exclude";
    private static final String OPT_HELP = "h";
    private static final String OPT_PDI_LOCATION = "p";
    private static final String OPT_OUTPUT_LOCATION = "o";
    private static final String OPT_EXCLUDE_PLUGINS = "e";
    private static final String OPT_EXCLUDE = "x";
    private String[] args;
    private Options options = new Options();
    private CommandLineParser parser = new BasicParser();
    protected HelpFormatter formatter;

    public CommandLineHandler(String[] args) {
        this.args = args;
        this.options.addOption(OPT_HELP, HELP, false, BaseMessages.getString(PKG, (String)HELP_DESC, (String[])new String[0]));
        this.options.addOption(OPT_PDI_LOCATION, PDI_LOCATION, true, BaseMessages.getString(PKG, (String)HELP_PDI_LOC_DESC, (String[])new String[0]));
        this.options.addOption(OPT_OUTPUT_LOCATION, OUTPUT_LOCATION, true, BaseMessages.getString(PKG, (String)HELP_OUTPUT_LOC_DESC, (String[])new String[0]));
        Option pluginExcludes = new Option(OPT_EXCLUDE_PLUGINS, EXCLUDE_PLUGINS, true, BaseMessages.getString(PKG, (String)HELP_PLUGIN_EXCLUDE_DESC, (String[])new String[0]));
        pluginExcludes.setArgs(-2);
        this.options.addOption(pluginExcludes);
        Option excludes = new Option(OPT_EXCLUDE, EXCLUDE, true, BaseMessages.getString(PKG, (String)HELP_EXCLUDE_DESC, (String[])new String[0]));
        excludes.setArgs(-2);
        this.options.addOption(excludes);
    }

    public AppBuilderContext parse() {
        try {
            String[] excludedPlugins;
            String[] excludedValues;
            CommandLine cmd = this.parser.parse(this.options, this.args);
            AppBuilderContext context = new AppBuilderContext();
            if (cmd.hasOption(OPT_HELP)) {
                this.help();
                return null;
            }
            if (cmd.hasOption(OPT_PDI_LOCATION)) {
                context.setPdiLocation(new File(cmd.getOptionValue(OPT_PDI_LOCATION)));
            }
            if (cmd.hasOption(OPT_OUTPUT_LOCATION)) {
                context.setOutputLocation(new File(cmd.getOptionValue(OPT_OUTPUT_LOCATION)));
            }
            if (cmd.hasOption(OPT_EXCLUDE) && (excludedValues = cmd.getOptionValues(OPT_EXCLUDE)) != null) {
                context.exclude(excludedValues);
            }
            if (cmd.hasOption(OPT_EXCLUDE_PLUGINS) && (excludedPlugins = cmd.getOptionValues(OPT_EXCLUDE_PLUGINS)) != null) {
                context.excludePlugin(excludedPlugins);
            }
            context.validate();
            return context;
        }
        catch (Exception e) {
            System.err.println(BaseMessages.getString(PKG, (String)ERROR_GENERIC, (String[])new String[]{e.getMessage()}));
            this.help();
            return null;
        }
    }

    public void help() {
        if (this.formatter == null) {
            this.formatter = new HelpFormatter();
        }
        this.formatter.setWidth(120);
        this.formatter.setNewLine(NEWLINE);
        this.formatter.printHelp(CMD_LINE_SYNTAX, this.options);
    }
}

