/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.app.builder.CommandLineHandler;

public class AppBuilderContext {
    private static final Class<?> PKG = CommandLineHandler.class;
    static final String[] DEFAULT_GLOB_EXCLUSIONS = new String[]{"**/*.png", "**/*.svg", "**/*.ico", "**/*.html", "**/*.sh", "**/*.bat", "**/*.app", "**/spoon.command", "**/README", "**/README.txt", "**/data-integration/ui", "**/data-integration/docs", "**/data-integration/logs", "**/data-integration/samples", "**/data-integration/launcher", "**/data-integration/pwd", "**/data-integration/simple-jndi", "**/data-integration/Data Service JDBC Driver", "**/data-integration/system/karaf/caches", "**/data-integration/system/karaf/etc-carte", "**/data-integration/system/karaf/etc-pan", "**/data-integration/system/karaf/etc-kitchen", "**/data-integration/system/karaf/etc-spoon", "**/data-integration/*.zip"};
    static final String[] DEFAULT_PLUGIN_EXCLUSIONS = new String[]{"pdi-ee-plugin", "pdi-hana-plugin", "pentaho-big-data-plugin", "spoon"};
    public static final String ERROR_PDI_LOCATION_NULL = "ERROR.PDI_Location_must_not_be_null";
    public static final String ERROR_PDI_LOCATION_INVALID = "ERROR.PDI_Location_Invalid";
    public static final String ERROR_OUTPUT_LOCATION_NULL = "ERROR.Output_Location_must_not_be_null";
    public static final String ERROR_OUTPUT_LOCATION_INVALID = "ERROR.Output_Location_Invalid";
    public static final String ERROR_OUTPUT_LOCATION_NOT_SET = "ERROR.Output_Location_not_set";
    public static final String PLUGIN_GLOB_PATTERN = "**/data-integration/plugins/";
    public static final String DEFAULT_ASSEMBLY_NAME = "pdi-spark-driver.zip";
    public static final String DUMMY_TXT = "dummy.txt";
    public static final String DATA_INTEGRATION = "data-integration";
    private File pdiLocation;
    private Set<String> exclusions = Sets.newHashSet();
    private File outputLocation;
    private Set<String> pluginExclusions = Sets.newHashSet();
    private String assemblyName = "pdi-spark-driver.zip";

    public AppBuilderContext() {
        this.exclude(DEFAULT_GLOB_EXCLUSIONS);
        this.excludePlugin(DEFAULT_PLUGIN_EXCLUSIONS);
        File f = new File(DUMMY_TXT);
        this.setOutputLocation(f.getAbsoluteFile().getParentFile());
        this.setPdiLocation(f.getAbsoluteFile().getParentFile());
    }

    public String getAssemblyName() {
        return this.assemblyName;
    }

    public void setAssemblyName(String assemblyName) {
        this.assemblyName = assemblyName;
    }

    public File getPdiLocation() {
        return this.pdiLocation;
    }

    public void setPdiLocation(File pdiLocation) {
        this.pdiLocation = pdiLocation;
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void validate() throws IllegalStateException {
        if (this.pdiLocation == null) {
            throw new IllegalStateException(BaseMessages.getString(PKG, (String)ERROR_PDI_LOCATION_NULL, (String[])new String[0]));
        }
        if (!(this.pdiLocation.exists() && this.pdiLocation.isDirectory() && this.pdiLocation.getName().equals(DATA_INTEGRATION))) {
            throw new IllegalStateException(BaseMessages.getString(PKG, (String)ERROR_PDI_LOCATION_INVALID, (String[])new String[]{this.pdiLocation.getAbsolutePath()}));
        }
        if (this.outputLocation == null) {
            throw new IllegalStateException(BaseMessages.getString(PKG, (String)ERROR_OUTPUT_LOCATION_NULL, (String[])new String[0]));
        }
        if (!this.outputLocation.exists() || !this.outputLocation.isDirectory()) {
            throw new IllegalStateException(BaseMessages.getString(PKG, (String)ERROR_OUTPUT_LOCATION_INVALID, (String[])new String[]{this.outputLocation.getAbsolutePath()}));
        }
    }

    public Set<String> getExclusions() {
        return ImmutableSet.copyOf(this.exclusions);
    }

    public void exclude(String exclusionPattern) {
        this.exclusions.add(exclusionPattern);
    }

    public void exclude(String ... exclusionPattern) {
        this.exclusions.addAll(Sets.newHashSet((Object[])exclusionPattern));
    }

    public Set<String> getPluginExclusions() {
        return ImmutableSet.copyOf(this.pluginExclusions);
    }

    public void excludePlugin(String pluginFolderName) {
        this.pluginExclusions.add(pluginFolderName);
    }

    public void excludePlugin(String ... pluginFolderName) {
        this.pluginExclusions.addAll(Sets.newHashSet((Object[])pluginFolderName));
    }

    public File getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(File outputLocation) {
        this.outputLocation = outputLocation;
    }

    public String getOutputFilePath() {
        if (this.getOutputLocation() == null) {
            throw new IllegalStateException(BaseMessages.getString(PKG, (String)ERROR_OUTPUT_LOCATION_NOT_SET, (String[])new String[0]));
        }
        File f = new File(this.getOutputLocation(), this.getAssemblyName());
        return f.getAbsolutePath();
    }

    public AppBuilderContext copy(String newAssemblyName) {
        AppBuilderContext copy = new AppBuilderContext();
        copy.setPdiLocation(this.getPdiLocation());
        copy.setOutputLocation(this.getOutputLocation());
        copy.exclusions = Sets.newHashSet(this.exclusions);
        copy.pluginExclusions = Sets.newHashSet(this.pluginExclusions);
        copy.setAssemblyName(newAssemblyName);
        return copy;
    }
}

