/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.websocket.EncodeException;
import javax.websocket.Session;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.ExecutionRequestHandler;
import org.pentaho.pdi.spark.driver.RequestHandler;
import org.pentaho.pdi.spark.driver.SparkContextDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopMessageRequestHandler
implements RequestHandler {
    private static Class<?> PKG = StopMessageRequestHandler.class;
    private static final Logger LOG = LoggerFactory.getLogger(PKG);
    private static final String ERROR_MSG_RET = "StopMessageRequestHandler.ErrorSendingStopResultBack";
    private static final String CANCEL_ATTEMPT = "StopMessageRequestHandler.AttemptStopResult";
    private static final String SUCCESS = "StopMessageRequestHandler.Successfully";
    private static final String FAILED = "StopMessageRequestHandler.Unsuccessfully";
    private static final String CANCEL_INTERRUPTED = "StopMessageRequestHandler.InterruptedWhileCancelExecution";
    static final String TRANSF_NOT_FOUND = "StopMessageRequestHandler.TransformationNotFound";
    static final String STOP_WASN_T_SUCCESSFUL = "StopMessageRequestHandler.StopWasntSuccessful";
    private static final int SLEEP_TIME_MS = 2000;
    static final int CANCEL_MAX_ATTEMPS = 5;
    static final String SUFFIX = "_STOP";
    private String requestUUID;
    private SparkContextDriver sparkContextDriver;
    private Session session;
    private String reasonPhrase;
    private String executionrequestUUID;

    StopMessageRequestHandler(SparkContextDriver sparkContextDriver, Session session, StopMessage stopMessage) {
        this.requestUUID = stopMessage.getRequestUUID() + SUFFIX;
        this.sparkContextDriver = sparkContextDriver;
        this.session = session;
        this.reasonPhrase = stopMessage.getReasonPhrase();
        this.executionrequestUUID = stopMessage.getRequestUUID();
    }

    @Override
    public String getRequestId() {
        return this.requestUUID;
    }

    @Override
    public void execute() {
        try {
            boolean success = false;
            ExecutionRequestHandler requestHandler = (ExecutionRequestHandler)this.sparkContextDriver.getRequestHandler(this.executionrequestUUID);
            if (requestHandler != null) {
                success = this.stopExecution(requestHandler);
            }
            if (!success && this.session != null && this.session.isOpen()) {
                this.session.getBasicRemote().sendObject((Object)new StopMessage(this.executionrequestUUID, requestHandler != null ? BaseMessages.getString(PKG, (String)STOP_WASN_T_SUCCESSFUL, (String[])new String[0]) : BaseMessages.getString(PKG, (String)TRANSF_NOT_FOUND, (String[])new String[0]), StopMessage.Status.FAILED));
            }
        }
        catch (IOException | EncodeException e) {
            LOG.error(BaseMessages.getString(PKG, (String)ERROR_MSG_RET, (String[])new String[0]), e);
        }
        finally {
            this.sparkContextDriver.finishedExecutingRequest(this.requestUUID);
        }
    }

    private boolean stopExecution(ExecutionRequestHandler requestHandler) {
        requestHandler.setCancelReason(this.reasonPhrase);
        for (int attempts = 0; attempts < 5 && !requestHandler.isFinished(); ++attempts) {
            if (requestHandler.getExecutionContext() != null) {
                requestHandler.getExecutionContext().stopTransformation();
            }
            if (requestHandler.isFinished()) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.error(BaseMessages.getString(PKG, (String)CANCEL_INTERRUPTED, (String[])new String[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        LOG.info(BaseMessages.getString(PKG, (String)CANCEL_ATTEMPT, (String[])new String[]{requestHandler.isFinished() ? BaseMessages.getString(PKG, (String)SUCCESS, (String[])new String[0]) : BaseMessages.getString(PKG, (String)FAILED, (String[])new String[0])}));
        return requestHandler.isFinished();
    }
}

