/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import org.apache.spark.sql.SparkSession;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.engine.spark.SystemManager;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkMain {
    private static Class<?> PKG = SparkMain.class;
    private static final Logger LOG = LoggerFactory.getLogger(SparkMain.class);
    private static final String SPARK_SESSION_FAILURE = "SparkMain.SparkSessionFailure";
    private static final String EXECUTING_SERVICE_ID = "SparkMain.ExecutingServiceId";
    private static final String SERVICE_BARRIER_RELEASED = "SparkMain.ServiceBarrierReleased";
    private static final String SERVICE_BARRIER_FAILED = "SparkMain.ServiceBarrierFailed";
    private static final String SHUTTING_DOWN = "SparkMain.ShuttingDown";
    private static final String PDI_SPARK_EXECUTION_ID = "PDI_SPARK_EXECUTION_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SparkSession spark = null;
        int returnStatus = 1;
        try {
            spark = Util.getSparkSession();
        }
        catch (Exception e) {
            LOG.error(BaseMessages.getString(PKG, (String)SPARK_SESSION_FAILURE, (String[])new String[0]), (Throwable)e);
            System.exit(returnStatus);
        }
        String serviceId = args[0];
        LOG.info(BaseMessages.getString(PKG, (String)EXECUTING_SERVICE_ID, (String[])new String[]{serviceId}));
        System.setProperty(PDI_SPARK_EXECUTION_ID, serviceId);
        try {
            IServiceBarrier serviceBarrier = SystemManager.getInstance().getServiceBarrier();
            serviceBarrier.hold();
            serviceBarrier.awaitAvailability();
        }
        catch (InterruptedException ie) {
            LOG.debug(BaseMessages.getString(PKG, (String)SERVICE_BARRIER_RELEASED, (String[])new String[0]));
            returnStatus = 0;
        }
        catch (Exception e) {
            LOG.error(BaseMessages.getString(PKG, (String)SERVICE_BARRIER_FAILED, (String[])new String[0]), (Throwable)e);
        }
        finally {
            LOG.debug(BaseMessages.getString(PKG, (String)SHUTTING_DOWN, (String[])new String[0]));
            spark.stop();
            KettleEnvironment.shutdown();
            System.exit(returnStatus);
        }
    }
}

