/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.di.engine.api.remote.DriverSessionClosed;
import org.pentaho.di.engine.api.remote.ExecutionFetchRequest;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.MessageDecoder;
import org.pentaho.di.engine.api.remote.MessageEncoder;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.ael.websocket.SessionConfigurator;
import org.pentaho.pdi.spark.driver.ExecutionRequestHandler;
import org.pentaho.pdi.spark.driver.RequestHandler;
import org.pentaho.pdi.spark.driver.SparkContextDriver;
import org.pentaho.pdi.spark.driver.SparkWebSocketMain;
import org.pentaho.pdi.spark.driver.StopMessageRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkContextClientEndpoint
extends Endpoint {
    private static final Class<?> PKG = SparkContextClientEndpoint.class;
    private Logger LOG = LoggerFactory.getLogger(SparkContextClientEndpoint.class);
    private static final String MSG_IGN_UNEXP_TYPE = "SparkContextClientEndpoint.MessageIgnored";
    private static final String SESS_CLOSED = "SparkContextClientEndpoint.SessionClosed";
    private static final String SHT_DWN_REQ_EXEC = "SparkContextClientEndpoint.ShuttingDown";
    private static final String UNEXPECTED_ERROR = "SparkContextClientEndpoint.UnexpectedError";
    private Session daemonSrvSession = null;
    private final SparkContextDriver sparkContextDriver;
    private LinkedList<RequestHandler> requestQueue;
    private final Object lock;
    private final ExecutorService executor;
    private int driverWebsocketMaxMessageBufferSize;
    private boolean firsRequest = true;
    private UserGroupInformation ugi = null;

    SparkContextClientEndpoint(SparkWebSocketMain.ArgHandler args, SparkContextDriver sparkContextDriver) {
        try {
            this.sparkContextDriver = sparkContextDriver;
            this.requestQueue = new LinkedList();
            this.lock = new Object();
            this.executor = sparkContextDriver.getMaxRequestThread() <= 0 ? Executors.newCachedThreadPool() : (sparkContextDriver.getMaxRequestThread() == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(sparkContextDriver.getMaxRequestThread()));
            this.driverWebsocketMaxMessageBufferSize = args.driverWebsocketMaxMessageBufferSize;
            URI uri = new URI(sparkContextDriver.getDaemonURL());
            Supplier<WebSocketContainer> websocketSupplier = ContainerProvider::getWebSocketContainer;
            websocketSupplier.get().connectToServer((Endpoint)this, ClientEndpointConfig.Builder.create().encoders(Collections.singletonList(MessageEncoder.class)).decoders(Collections.singletonList(MessageDecoder.class)).configurator((ClientEndpointConfig.Configurator)new SessionConfigurator(uri, sparkContextDriver.getDriverSecurityKeyTab(), sparkContextDriver.getDriverSecurityPrincipal())).build(), uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.daemonSrvSession = session;
        this.daemonSrvSession.setMaxTextMessageBufferSize(this.driverWebsocketMaxMessageBufferSize);
        this.daemonSrvSession.setMaxBinaryMessageBufferSize(this.driverWebsocketMaxMessageBufferSize);
        this.daemonSrvSession.addMessageHandler((MessageHandler)new MessageHandler.Whole<Message>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(Message message) {
                try {
                    Object object = SparkContextClientEndpoint.this.lock;
                    synchronized (object) {
                        RequestHandler requestHandler;
                        if (message instanceof ExecutionRequest) {
                            requestHandler = new ExecutionRequestHandler(SparkContextClientEndpoint.this.sparkContextDriver, SparkContextClientEndpoint.this.daemonSrvSession, (ExecutionRequest)message);
                            if (SparkContextClientEndpoint.this.firsRequest) {
                                SparkContextClientEndpoint.this.sparkContextDriver.setDriverProperties(((ExecutionRequest)message).getActingPrincipal(), ((ExecutionRequest)message).isToReuseSparkContext());
                                SparkContextClientEndpoint.this.firsRequest = false;
                                SparkContextClientEndpoint.this.sparkContextDriver.firstRequestReceived();
                            }
                        } else if (message instanceof StopMessage) {
                            requestHandler = new StopMessageRequestHandler(SparkContextClientEndpoint.this.sparkContextDriver, SparkContextClientEndpoint.this.daemonSrvSession, (StopMessage)message);
                        } else {
                            SparkContextClientEndpoint.this.LOG.error(BaseMessages.getString((Class)PKG, (String)SparkContextClientEndpoint.MSG_IGN_UNEXP_TYPE, (String[])new String[0]));
                            return;
                        }
                        SparkContextClientEndpoint.this.sparkContextDriver.newExecuteRequest(requestHandler);
                        if (SparkContextClientEndpoint.this.sparkContextDriver.isContextReady()) {
                            SparkContextClientEndpoint.this.submitRequest(requestHandler);
                        } else {
                            SparkContextClientEndpoint.this.addToQueue(requestHandler);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void onClose(Session userSession, CloseReason reason) {
        this.shutdown();
        this.requestQueue.clear();
        this.requestQueue = null;
        this.daemonSrvSession = null;
    }

    public void onError(Session userSession, Throwable thr) {
        throw new RuntimeException(thr);
    }

    public void sendMessage(ExecutionFetchRequest request) throws RuntimeException {
        this.sessionValid();
        try {
            this.daemonSrvSession.getBasicRemote().sendObject((Object)request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendDriverSessionClosed(String userId, String closeReason) {
        this.sessionValid();
        try {
            this.daemonSrvSession.getBasicRemote().sendObject((Object)new DriverSessionClosed(userId, closeReason));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sessionValid() throws RuntimeException {
        if (this.daemonSrvSession == null || !this.daemonSrvSession.isOpen()) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)SESS_CLOSED, (String[])new String[0]));
        }
    }

    void close(String closeReason) {
        this.sessionValid();
        try {
            this.daemonSrvSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, closeReason));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addToQueue(RequestHandler requestHandler) {
        this.requestQueue.add(requestHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequestInQueue() {
        Object object = this.lock;
        synchronized (object) {
            for (RequestHandler requestHandler : this.requestQueue) {
                this.submitRequest(requestHandler);
            }
            this.requestQueue.clear();
        }
    }

    private void submitRequest(RequestHandler requestHandler) {
        if (requestHandler instanceof ExecutionRequestHandler) {
            this.submitRequest((ExecutionRequestHandler)requestHandler);
        } else {
            this.submitRequest((StopMessageRequestHandler)requestHandler);
        }
    }

    private void submitRequest(ExecutionRequestHandler executionRequestHandler) {
        this.executor.submit(() -> {
            try {
                this.ugi.doAs(() -> {
                    executionRequestHandler.execute();
                    return null;
                });
            }
            catch (IOException | InterruptedException e) {
                this.LOG.error(BaseMessages.getString(PKG, (String)UNEXPECTED_ERROR, (String[])new String[0]), (Throwable)e);
            }
        });
    }

    private void submitRequest(StopMessageRequestHandler stopMessageHandler) {
        this.executor.submit(stopMessageHandler::execute);
    }

    private void shutdown() {
        if (this.executor != null && !this.executor.isShutdown()) {
            try {
                this.LOG.debug(BaseMessages.getString(PKG, (String)SHT_DWN_REQ_EXEC, (String[])new String[0]));
                this.executor.shutdown();
            }
            finally {
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
    }

    public void setUserGroupInformation(UserGroupInformation ugi) {
        this.ugi = ugi;
    }
}

