/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.websocket.EncodeException;
import javax.websocket.Session;
import org.mortbay.log.Log;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.events.ErrorEvent;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.ModelType;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.api.reporting.SubTransCreation;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.pdi.spark.driver.RequestHandler;
import org.pentaho.pdi.spark.driver.SparkContextDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionRequestHandler
implements RequestHandler {
    private static Class<?> PKG = ExecutionRequestHandler.class;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionRequestHandler.class);
    private static final String FNL_EXEC_REQ = "ExecutionRequestHandler.FinalizingExecution";
    private static final String TRSF_EXEC_ERROR = "ExecutionRequestHandler.TransformationExecutionError";
    private static final String OPERATION_ERROR = "ExecutionRequestHandler.OperationError";
    private static final String LST_DAEMON_SRV_SESS_STP_MSG_LST = "ExecutionRequestHandler.DaemonServerSessionMessagesLost";
    private static final String FLD_CLS_SPARK = "ExecutionRequestHandler.ErrorFinalizingExecution";
    private static final String LST_DAEMON_SRV_SESS_EVENT_LST = "ExecutionRequestHandler.DaemonServerEventLost";
    private static final String CLOSING_DRIVER_SESSION = "ExecutionRequestHandler.ClosingDriver";
    static final String TRANSF_COMPLETE_SUC = "ExecutionRequestHandler.TransformationCompleteSuccessfully";
    static final String TRANSF_FAILED = "ExecutionRequestHandler.ErrorExecuting";
    static final String ANONYMOUS_USER = "ANONYMOUS_USER";
    private ExecutionRequest executionRequest;
    private SparkContextDriver sparkContextDriver;
    private Session session;
    private ExecutionContext execContext;
    private String cancelReason = null;
    private boolean finished = false;
    private boolean closeSessionAtEnd;

    ExecutionRequestHandler(SparkContextDriver sparkContextDriver, Session session, ExecutionRequest executionRequest) {
        this.sparkContextDriver = sparkContextDriver;
        this.session = session;
        this.executionRequest = executionRequest;
        this.closeSessionAtEnd = !executionRequest.isToReuseSparkContext();
        sparkContextDriver.setUserId(this.getUserId(executionRequest.getActingPrincipal()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Transformation transformation = this.executionRequest.getTransformation();
        Engine engine = this.sparkContextDriver.getEngine();
        this.execContext = engine.prepare(transformation);
        this.execContext.setLoggingLogLevel(this.executionRequest.getLoggingLogLevel());
        this.execContext.setActingPrincipal(this.executionRequest.getActingPrincipal());
        this.execContext.setParameters(this.executionRequest.getParameters());
        this.execContext.setEnvironment(this.executionRequest.getEnvironment());
        this.subscribeToEvents(this.execContext, transformation, this.session);
        try {
            ExecutionResult result = (ExecutionResult)this.execContext.execute().get();
            this.finalize(false);
            LOG.info(result.getDataEventReport().toString());
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            this.finalize(true);
        }
        finally {
            this.sparkContextDriver.finishedExecutingRequest(this.executionRequest.getRequestId());
            if (this.closeSessionAtEnd) {
                Log.info((String)BaseMessages.getString(PKG, (String)CLOSING_DRIVER_SESSION, (String[])new String[0]));
                this.sparkContextDriver.unlockShutDown();
            }
        }
    }

    @Override
    public String getRequestId() {
        return this.executionRequest.getRequestId();
    }

    public Principal getActingPrincipal() {
        return this.executionRequest.getActingPrincipal();
    }

    private void subscribeToEvents(ExecutionContext execContext, Transformation transformation, Session session) {
        List<Transformation> trans = Collections.singletonList(transformation);
        this.subscribe(execContext, session, Status.class, ModelType.TRANSFORMATION, trans, StatusEvent::new);
        this.subscribe(execContext, session, LogEntry.class, ModelType.TRANSFORMATION, trans, LogEvent::new);
        ArrayList<LogicalModelElement> ops = new ArrayList<LogicalModelElement>(transformation.getOperations());
        this.subscribe(execContext, session, Status.class, ModelType.OPERATION, ops, StatusEvent::new);
        this.subscribe(execContext, session, LogEntry.class, ModelType.OPERATION, ops, LogEvent::new);
        this.subscribe(execContext, session, Metrics.class, ModelType.OPERATION, ops, MetricsEvent::new);
        ops.forEach(element -> execContext.subscribe(element, SubTransCreation.class, s -> {
            ExecutionContext subTransContext = s.getContext();
            Transformation subTrans = s.getTransformation();
            subTransContext.setLoggingLogLevel(execContext.getLoggingLogLevel());
            ArrayList<LogicalModelElement> subTransOps = new ArrayList<LogicalModelElement>(subTrans.getOperations());
            this.subscribe(subTransContext, session, LogEntry.class, ModelType.TRANSFORMATION, Collections.singletonList(subTrans), LogEvent::new);
            this.subscribe(subTransContext, session, LogEntry.class, ModelType.TRANSFORMATION, subTransOps, LogEvent::new);
            this.subscribe(subTransContext, session, Metrics.class, ModelType.OPERATION, subTransOps, MetricsEvent::new);
        }));
    }

    private <T extends Serializable> void subscribe(ExecutionContext execContext, Session session, Class<T> eventType, ModelType modelType, List<LogicalModelElement> elements, EventFactory<T> eventFactory) {
        elements.forEach(element -> execContext.subscribe(element, eventType, s -> {
            try {
                if (session != null && session.isOpen()) {
                    session.getBasicRemote().sendObject((Object)eventFactory.apply(new RemoteSource(this.executionRequest.getRequestId(), modelType, element.getId()), eventType == LogEntry.class ? this.convertLogEntryToGenericException((LogEntry)s) : s));
                } else {
                    LOG.info(BaseMessages.getString(PKG, (String)LST_DAEMON_SRV_SESS_EVENT_LST, (String[])new String[]{eventType.getName()}));
                }
            }
            catch (IOException | EncodeException e) {
                throw new RuntimeException(e);
            }
        }, throwable -> this.handleError((Throwable)throwable, modelType)));
    }

    private <T extends Serializable> T convertLogEntryToGenericException(LogEntry logEntry) {
        if (logEntry != null && logEntry.getThrowable() != null) {
            return (T)LogEntry.LogEntryBuilder.aLogEntry().withMessage(logEntry.getMessage()).withLogLevel(logEntry.getLogLogLevel()).withTimestamp(logEntry.getTimestamp()).withExtras(logEntry.getExtras()).withThrowable((Throwable)this.genericException(logEntry.getThrowable())).build();
        }
        return (T)logEntry;
    }

    private void handleError(Throwable throwable, ModelType modelType) {
        if (this.cancelReason != null) {
            LOG.debug(BaseMessages.getString(PKG, (String)OPERATION_ERROR, (String[])new String[0]));
        } else if (modelType == ModelType.TRANSFORMATION) {
            this.fail(throwable);
        } else {
            LOG.error(BaseMessages.getString(PKG, (String)OPERATION_ERROR, (String[])new String[0]), throwable);
        }
    }

    private void fail(Throwable throwable) {
        try {
            LOG.error(BaseMessages.getString(PKG, (String)TRSF_EXEC_ERROR, (String[])new String[0]), throwable);
            if (this.session != null && this.session.isOpen()) {
                LogEntry logEntry = LogEntry.LogEntryBuilder.aLogEntry().withMessage(throwable.getMessage()).withLogLevel(LogLevel.ERROR).withTimestamp(new Date()).withThrowable((Throwable)this.genericException(throwable)).build();
                this.session.getBasicRemote().sendObject((Object)new ErrorEvent((LogicalModelElement)new RemoteSource(this.executionRequest.getRequestId(), ModelType.TRANSFORMATION, null), logEntry));
            } else {
                LOG.info(BaseMessages.getString(PKG, (String)LST_DAEMON_SRV_SESS_EVENT_LST, (String[])new String[]{ErrorEvent.class.getName()}));
            }
        }
        catch (IOException | EncodeException e) {
            throw new RuntimeException(e);
        }
    }

    private org.pentaho.di.engine.api.remote.ExecutionException genericException(Throwable throwable) {
        return throwable instanceof org.pentaho.di.engine.api.remote.ExecutionException ? (org.pentaho.di.engine.api.remote.ExecutionException)throwable : new org.pentaho.di.engine.api.remote.ExecutionException(throwable);
    }

    private void finalize(boolean error) {
        LOG.debug(BaseMessages.getString(PKG, (String)FNL_EXEC_REQ, (String[])new String[0]));
        this.finished = true;
        try {
            if (this.session != null && this.session.isOpen()) {
                String closeReason = error ? (this.cancelReason != null ? this.cancelReason : BaseMessages.getString(PKG, (String)TRANSF_FAILED, (String[])new String[0])) : BaseMessages.getString(PKG, (String)TRANSF_COMPLETE_SUC, (String[])new String[0]);
                this.session.getBasicRemote().sendObject((Object)new StopMessage(this.executionRequest.getRequestId(), closeReason));
            } else {
                LOG.error(BaseMessages.getString(PKG, (String)LST_DAEMON_SRV_SESS_STP_MSG_LST, (String[])new String[0]));
            }
        }
        catch (Exception e) {
            LOG.warn(BaseMessages.getString(PKG, (String)FLD_CLS_SPARK, (String[])new String[0]), (Throwable)e);
        }
    }

    private String getUserId(Principal actingPrincipal) {
        String userId = ANONYMOUS_USER;
        if (!(this.sparkContextDriver.isDisableProxyUser() || actingPrincipal == null || ActingPrincipal.ANONYMOUS.equals((Object)actingPrincipal) || Strings.isNullOrEmpty((String)actingPrincipal.getName()))) {
            userId = actingPrincipal.getName();
        }
        return userId;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public ExecutionContext getExecutionContext() {
        return this.execContext;
    }

    public boolean isFinished() {
        return this.finished;
    }

    @FunctionalInterface
    static interface EventFactory<T extends Serializable> {
        public PDIEvent apply(RemoteSource var1, T var2);
    }
}

