/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import com.amazonaws.auth.AWSCredentials;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.amazon.AmazonS3NFileSystemBootstrap;
import org.pentaho.amazon.AmazonSpoonPlugin;
import org.pentaho.amazon.s3.S3CredentialsProvider;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class S3NVfsFileChooserDialog
extends CustomVfsUiPanel {
    private static Class<?> PKG = AmazonSpoonPlugin.class;
    private LogChannel log = new LogChannel((Object)this);
    private FileObject rootFile;
    private FileObject initialFile;
    private VfsFileChooserDialog vfsFileChooserDialog;

    public S3NVfsFileChooserDialog(VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile) {
        super("s3n", AmazonS3NFileSystemBootstrap.getS3NFileSystemDisplayText(), vfsFileChooserDialog, 0);
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.setLayout((Layout)new GridLayout());
    }

    public void activate() {
        this.vfsFileChooserDialog.setRootFile(this.rootFile);
        this.vfsFileChooserDialog.setInitialFile(this.initialFile);
        this.vfsFileChooserDialog.openFileCombo.setText("s3n://s3n/");
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        super.activate();
        try {
            FileObject newRoot = this.resolveFile(this.vfsFileChooserDialog.openFileCombo.getText());
            this.vfsFileChooserDialog.vfsBrowser.resetVfsRoot(newRoot);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        AWSCredentials credentials = S3CredentialsProvider.getAWSCredentials();
        if (credentials != null) {
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, credentials.getAWSAccessKeyId(), credentials.getAWSSecretKey());
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)userAuthenticator);
        }
        return opts;
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }
}

