/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.extender.http.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.pentaho.webpackage.core.PentahoWebPackageBundle;
import org.pentaho.webpackage.core.PentahoWebPackageService;
import org.pentaho.webpackage.extender.http.impl.PentahoWebPackageBundleImpl;

public class PentahoWebPackageServiceImpl
implements PentahoWebPackageService,
BundleListener {
    private final Map<Long, PentahoWebPackageBundle> pentahoWebPackageBundles = new HashMap<Long, PentahoWebPackageBundle>();

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        int bundleEventType = bundleEvent.getType();
        if (bundleEventType == 2) {
            this.addBundle(bundle);
        } else if (bundleEventType == 16 || bundleEventType == 64 || bundleEventType == 4) {
            this.removeBundle(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundle(Bundle bundle) {
        PentahoWebPackageBundleImpl extendedBundle = this.extendBundle(bundle);
        if (extendedBundle != null) {
            Map<Long, PentahoWebPackageBundle> map = this.pentahoWebPackageBundles;
            synchronized (map) {
                if (this.pentahoWebPackageBundles.putIfAbsent(bundle.getBundleId(), extendedBundle) != null) {
                    return;
                }
            }
            extendedBundle.init();
        }
    }

    public void removeBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        PentahoWebPackageBundle pwpc = this.pentahoWebPackageBundles.remove(bundle.getBundleId());
        if (pwpc != null) {
            pwpc.destroy();
        }
    }

    private PentahoWebPackageBundleImpl extendBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        String provideCapabilityHeader = this.getHeader(bundle, "Provide-Capability");
        if (provideCapabilityHeader == null || !provideCapabilityHeader.contains("org.pentaho.webpackage")) {
            return null;
        }
        return new PentahoWebPackageBundleImpl(bundle);
    }

    private String getHeader(Bundle bundle, String ... keys) {
        Dictionary headers = bundle.getHeaders();
        if (headers != null) {
            for (String key : keys) {
                String value = (String)headers.get(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }
}

