/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;

public class StoreStatusFilter {
    public static final String coordSeletStr = "Select w.id, w.appName, w.statusStr, w.user, w.group, w.startTimestamp, w.endTimestamp, w.appPath, w.concurrency, w.frequency, w.lastActionTimestamp, w.nextMaterializedTimestamp, w.createdTimestamp, w.timeUnitStr, w.timeZone, w.timeOut from CoordinatorJobBean w";
    public static final String coordCountStr = "Select count(w) from CoordinatorJobBean w";
    public static final String wfSeletStr = "Select w.id, w.appName, w.statusStr, w.run, w.user, w.group, w.createdTimestamp, w.startTimestamp, w.lastModifiedTimestamp, w.endTimestamp from WorkflowJobBean w";
    public static final String wfCountStr = "Select count(w) from WorkflowJobBean w";
    public static final String bundleSeletStr = "Select w.id, w.appName, w.appPath, w.conf, w.statusStr, w.kickoffTimestamp, w.startTimestamp, w.endTimestamp, w.pauseTimestamp, w.createdTimestamp, w.user, w.group, w.timeUnitStr, w.timeOut from BundleJobBean w";
    public static final String bundleCountStr = "Select count(w) from BundleJobBean w";

    public static void filter(Map<String, List<String>> filter, List<String> orArray, List<String> colArray, List<Object> valArray, StringBuilder sb, String seletStr, String countStr) throws JPAExecutorException {
        boolean isStatus = false;
        boolean isAppName = false;
        boolean isUser = false;
        boolean isEnabled = false;
        boolean isFrequency = false;
        boolean isId = false;
        boolean isUnit = false;
        int index = 0;
        for (Map.Entry<String, List<String>> entry : filter.entrySet()) {
            Timestamp createdTimeStamp;
            List<String> values;
            String colName = null;
            String colVar = null;
            if (entry.getKey().equals("group")) {
                XLog.getLog(StoreStatusFilter.class).warn("Filter by 'group' is not supported anymore");
                continue;
            }
            if (entry.getKey().equals("status")) {
                values = filter.get("status");
                colName = "status";
                for (int i = 0; i < values.size(); ++i) {
                    colVar = "status";
                    colVar = colVar + index;
                    if (!isEnabled && !isStatus) {
                        sb.append(seletStr).append(" where w.statusStr IN (:status" + index);
                        isStatus = true;
                        isEnabled = true;
                    } else if (isEnabled && !isStatus) {
                        sb.append(" and w.statusStr IN (:status" + index);
                        isStatus = true;
                    } else if (isStatus) {
                        sb.append(", :status" + index);
                    }
                    if (i == values.size() - 1) {
                        sb.append(")");
                    }
                    ++index;
                    valArray.add(values.get(i));
                    orArray.add(colName);
                    colArray.add(colVar);
                }
                continue;
            }
            if (entry.getKey().equals("name")) {
                values = filter.get("name");
                colName = "appName";
                for (int i = 0; i < values.size(); ++i) {
                    colVar = "appName";
                    colVar = colVar + index;
                    if (!isEnabled && !isAppName) {
                        sb.append(seletStr).append(" where w.appName IN (:appName" + index);
                        isAppName = true;
                        isEnabled = true;
                    } else if (isEnabled && !isAppName) {
                        sb.append(" and w.appName IN (:appName" + index);
                        isAppName = true;
                    } else if (isAppName) {
                        sb.append(", :appName" + index);
                    }
                    if (i == values.size() - 1) {
                        sb.append(")");
                    }
                    ++index;
                    valArray.add(values.get(i));
                    orArray.add(colName);
                    colArray.add(colVar);
                }
                continue;
            }
            if (entry.getKey().equals("user")) {
                values = filter.get("user");
                colName = "user";
                for (int i = 0; i < values.size(); ++i) {
                    colVar = "user";
                    colVar = colVar + index;
                    if (!isEnabled && !isUser) {
                        sb.append(seletStr).append(" where w.user IN (:user" + index);
                        isUser = true;
                        isEnabled = true;
                    } else if (isEnabled && !isUser) {
                        sb.append(" and w.user IN (:user" + index);
                        isUser = true;
                    } else if (isUser) {
                        sb.append(", :user" + index);
                    }
                    if (i == values.size() - 1) {
                        sb.append(")");
                    }
                    ++index;
                    valArray.add(values.get(i));
                    orArray.add(colName);
                    colArray.add(colVar);
                }
                continue;
            }
            if (entry.getKey().equals("frequency")) {
                values = filter.get("frequency");
                colName = "frequency";
                for (int i = 0; i < values.size(); ++i) {
                    colVar = "frequency";
                    colVar = colVar + index;
                    if (!isEnabled && !isFrequency) {
                        sb.append(seletStr).append(" where w.frequency IN (:frequency" + index);
                        isFrequency = true;
                        isEnabled = true;
                    } else if (isEnabled && !isFrequency) {
                        sb.append(" and w.frequency IN (:frequency" + index);
                        isFrequency = true;
                    } else if (isFrequency) {
                        sb.append(", :frequency" + index);
                    }
                    if (i == values.size() - 1) {
                        sb.append(")");
                    }
                    ++index;
                    valArray.add(values.get(i));
                    orArray.add(colName);
                    colArray.add(colVar);
                }
                continue;
            }
            if (entry.getKey().equals("id")) {
                values = filter.get("id");
                colName = "id";
                for (int i = 0; i < values.size(); ++i) {
                    colVar = "id";
                    colVar = colVar + index;
                    if (!isEnabled && !isId) {
                        sb.append(seletStr).append(" where w.id IN (:id" + index);
                        isId = true;
                        isEnabled = true;
                    } else if (isEnabled && !isId) {
                        sb.append(" and w.id IN (:id" + index);
                        isId = true;
                    } else if (isId) {
                        sb.append(", :id" + index);
                    }
                    if (i == values.size() - 1) {
                        sb.append(")");
                    }
                    ++index;
                    valArray.add(values.get(i));
                    orArray.add(colName);
                    colArray.add(colVar);
                }
                continue;
            }
            if (entry.getKey().equals("unit")) {
                values = filter.get("unit");
                colName = "timeUnitStr";
                for (int i = 0; i < values.size(); ++i) {
                    colVar = colName + index;
                    if (!isEnabled && !isUnit) {
                        sb.append(seletStr).append(" where w.timeUnitStr IN (:timeUnitStr" + index);
                        isUnit = true;
                        isEnabled = true;
                    } else if (isEnabled && !isUnit) {
                        sb.append(" and w.timeUnitStr IN (:timeUnitStr" + index);
                        isUnit = true;
                    } else if (isUnit) {
                        sb.append(", :timeUnitStr" + index);
                    }
                    if (i == values.size() - 1) {
                        sb.append(")");
                    }
                    ++index;
                    valArray.add(values.get(i));
                    orArray.add(colName);
                    colArray.add(colVar);
                }
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("startcreatedtime")) {
                values = filter.get("startcreatedtime");
                colName = "createdTimestampStart";
                if (values.size() > 1) {
                    throw new JPAExecutorException(ErrorCode.E0302, "cannot specify multiple startcreatedtime");
                }
                colVar = colName;
                colVar = colVar + index;
                if (!isEnabled) {
                    sb.append(seletStr).append(" where w.createdTimestamp >= :" + colVar);
                    isEnabled = true;
                } else {
                    sb.append(" and w.createdTimestamp >= :" + colVar);
                }
                ++index;
                Date createdTime = null;
                try {
                    createdTime = StoreStatusFilter.parseCreatedTimeString(values.get(0));
                }
                catch (Exception e) {
                    throw new JPAExecutorException(ErrorCode.E0302, e.getMessage());
                }
                createdTimeStamp = new Timestamp(createdTime.getTime());
                valArray.add(createdTimeStamp);
                orArray.add(colName);
                colArray.add(colVar);
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("endcreatedtime")) continue;
            values = filter.get("endcreatedtime");
            colName = "createdTimestampEnd";
            if (values.size() > 1) {
                throw new JPAExecutorException(ErrorCode.E0302, "cannot specify multiple endcreatedtime");
            }
            colVar = colName;
            colVar = colVar + index;
            if (!isEnabled) {
                sb.append(seletStr).append(" where w.createdTimestamp <= :" + colVar);
                isEnabled = true;
            } else {
                sb.append(" and w.createdTimestamp <= :" + colVar);
            }
            ++index;
            Date createdTime = null;
            try {
                createdTime = StoreStatusFilter.parseCreatedTimeString(values.get(0));
            }
            catch (Exception e) {
                throw new JPAExecutorException(ErrorCode.E0302, e.getMessage());
            }
            createdTimeStamp = new Timestamp(createdTime.getTime());
            valArray.add(createdTimeStamp);
            orArray.add(colName);
            colArray.add(colVar);
        }
    }

    private static Date parseCreatedTimeString(String time) throws Exception {
        Date createdTime;
        block10: {
            block9: {
                createdTime = null;
                int offset = 0;
                if (!Character.isLetter(time.charAt(time.length() - 1))) break block9;
                switch (time.charAt(time.length() - 1)) {
                    case 'd': {
                        offset = Integer.parseInt(time.substring(0, time.length() - 1));
                        if (offset > 0) {
                            throw new IllegalArgumentException("offset must be minus from currentTime");
                        }
                        createdTime = org.apache.commons.lang.time.DateUtils.addDays((Date)new Date(), (int)offset);
                        break block10;
                    }
                    case 'h': {
                        offset = Integer.parseInt(time.substring(0, time.length() - 1));
                        if (offset > 0) {
                            throw new IllegalArgumentException("offset must be minus from currentTime");
                        }
                        createdTime = org.apache.commons.lang.time.DateUtils.addHours((Date)new Date(), (int)offset);
                        break block10;
                    }
                    case 'm': {
                        offset = Integer.parseInt(time.substring(0, time.length() - 1));
                        if (offset > 0) {
                            throw new IllegalArgumentException("offset must be minus from currentTime");
                        }
                        createdTime = org.apache.commons.lang.time.DateUtils.addMinutes((Date)new Date(), (int)offset);
                        break block10;
                    }
                    case 'Z': {
                        createdTime = DateUtils.parseDateUTC(time);
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported time format " + time);
                    }
                }
            }
            throw new IllegalArgumentException("the format of createdTime is wrong: " + time);
        }
        return createdTime;
    }
}

