/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.sla;

import java.util.Date;
import org.apache.oozie.XException;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLASummaryBean;

public abstract class SLAJobEventXCommand
extends XCommand<Void> {
    private long lockTimeOut = 0L;
    JPAService jpaService = Services.get().get(JPAService.class);
    SLACalcStatus slaCalc;
    static final String SLA_LOCK_PREFIX = "sla_";
    private boolean isEnded = false;
    private boolean isEndMiss = false;

    public SLAJobEventXCommand(SLACalcStatus slaCalc, long lockTimeOut) {
        super("SLA.job.event", "SLA.job.event", 1);
        this.slaCalc = slaCalc;
        this.lockTimeOut = lockTimeOut;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected boolean isReQueueRequired() {
        return false;
    }

    @Override
    public String getEntityKey() {
        return SLA_LOCK_PREFIX + this.slaCalc.getId();
    }

    @Override
    protected long getLockTimeOut() {
        return this.lockTimeOut;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected Void execute() throws CommandException {
        this.updateJobInfo();
        if (this.isEnded) {
            this.processForEnd();
        } else {
            this.processForRunning();
        }
        try {
            this.writeToDB();
        }
        catch (XException e) {
            throw new CommandException(e);
        }
        return null;
    }

    protected abstract void updateJobInfo();

    private boolean shouldAlert(SLACalcStatus slaObj) {
        return !slaObj.getSLAConfigMap().containsKey("oozie.sla.disable.alerts");
    }

    private void queueEvent(SLACalcStatus event) {
        Services.get().get(EventHandlerService.class).queueEvent((Event)event);
    }

    private void processDurationSLA(long expected, long actual, SLACalcStatus slaCalc) {
        if (expected != -1L) {
            if (actual > expected) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
            } else if (actual <= expected) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MET);
            }
            if (this.shouldAlert(slaCalc)) {
                this.queueEvent(new SLACalcStatus(slaCalc));
            }
        }
    }

    private void writeToDB() throws JPAExecutorException {
        byte eventProc = this.slaCalc.getEventProcessed();
        if (this.slaCalc.getEventProcessed() >= 8) {
            this.slaCalc.setEventProcessed(8);
        }
        SLASummaryBean slaSummaryBean = new SLASummaryBean();
        slaSummaryBean.setId(this.slaCalc.getId());
        slaSummaryBean.setEventProcessed(eventProc);
        slaSummaryBean.setSLAStatus(this.slaCalc.getSLAStatus());
        slaSummaryBean.setEventStatus(this.slaCalc.getEventStatus());
        slaSummaryBean.setActualEnd(this.slaCalc.getActualEnd());
        slaSummaryBean.setActualStart(this.slaCalc.getActualStart());
        slaSummaryBean.setActualDuration(this.slaCalc.getActualDuration());
        slaSummaryBean.setJobStatus(this.slaCalc.getJobStatus());
        slaSummaryBean.setLastModifiedTime(new Date());
        SLASummaryQueryExecutor.getInstance().executeUpdate(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, slaSummaryBean);
        this.LOG.debug(" Stored SLA SummaryBean Job [{0}] eventProc = [{1}], status = [{2}]", this.slaCalc.getId(), this.slaCalc.getEventProcessed(), this.slaCalc.getJobStatus());
    }

    private void processForEnd() {
        byte eventProc = this.slaCalc.getEventProcessed();
        this.LOG.debug("Job {0} has ended. endtime = [{1}]", this.slaCalc.getId(), this.slaCalc.getActualEnd());
        if (this.isEndMiss()) {
            this.slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
        } else {
            this.slaCalc.setSLAStatus(SLAEvent.SLAStatus.MET);
        }
        if (eventProc != 8 && this.slaCalc.getActualStart() != null) {
            if ((eventProc & 1) == 0 && this.slaCalc.getExpectedStart() != null) {
                if (this.slaCalc.getExpectedStart().getTime() < this.slaCalc.getActualStart().getTime()) {
                    this.slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                } else {
                    this.slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                }
                if (this.shouldAlert(this.slaCalc)) {
                    this.queueEvent(new SLACalcStatus(this.slaCalc));
                }
            }
            this.slaCalc.setActualDuration(this.slaCalc.getActualEnd().getTime() - this.slaCalc.getActualStart().getTime());
            if ((eventProc >> 1 & 1) == 0) {
                this.processDurationSLA(this.slaCalc.getExpectedDuration(), this.slaCalc.getActualDuration(), this.slaCalc);
            }
        }
        if (eventProc != 8 && eventProc < 4) {
            if (this.isEndMiss()) {
                this.slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
            } else {
                this.slaCalc.setEventStatus(SLAEvent.EventStatus.END_MET);
            }
            if (this.shouldAlert(this.slaCalc)) {
                this.queueEvent(new SLACalcStatus(this.slaCalc));
            }
        }
        this.slaCalc.setEventProcessed(8);
    }

    private void processForRunning() {
        byte eventProc = this.slaCalc.getEventProcessed();
        if (eventProc != 8 && this.slaCalc.getActualStart() != null) {
            this.slaCalc.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        }
        if (eventProc != 8 && (eventProc & 1) == 0) {
            if (this.slaCalc.getExpectedStart() == null) {
                eventProc = (byte)(eventProc + 1);
            } else if (this.slaCalc.getActualStart() != null) {
                if (this.slaCalc.getExpectedStart().getTime() < this.slaCalc.getActualStart().getTime()) {
                    this.slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                } else {
                    this.slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                }
                if (this.shouldAlert(this.slaCalc)) {
                    this.queueEvent(new SLACalcStatus(this.slaCalc));
                }
                eventProc = (byte)(eventProc + 1);
            } else if (this.slaCalc.getExpectedStart() != null && this.slaCalc.getExpectedStart().getTime() < System.currentTimeMillis()) {
                this.slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                if (this.shouldAlert(this.slaCalc)) {
                    this.queueEvent(new SLACalcStatus(this.slaCalc));
                }
                eventProc = (byte)(eventProc + 1);
            }
        }
        if (eventProc != 8 && (eventProc >> 1 & 1) == 0) {
            if (this.slaCalc.getExpectedDuration() == -1L) {
                eventProc = (byte)(eventProc + 2);
            } else if (this.slaCalc.getActualStart() != null && this.slaCalc.getExpectedDuration() != -1L && System.currentTimeMillis() - this.slaCalc.getActualStart().getTime() > this.slaCalc.getExpectedDuration()) {
                this.slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                if (this.shouldAlert(this.slaCalc)) {
                    this.queueEvent(new SLACalcStatus(this.slaCalc));
                }
                eventProc = (byte)(eventProc + 2);
            }
        }
        if (eventProc < 4) {
            if (this.slaCalc.getExpectedEnd() != null) {
                if (this.slaCalc.getExpectedEnd().getTime() < System.currentTimeMillis()) {
                    this.slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                    this.slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                    if (this.shouldAlert(this.slaCalc)) {
                        this.queueEvent(new SLACalcStatus(this.slaCalc));
                    }
                    eventProc = (byte)(eventProc + 4);
                }
            } else {
                eventProc = (byte)(eventProc + 4);
            }
        }
        this.slaCalc.setEventProcessed(eventProc);
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public void setEnded(boolean isEnded) {
        this.isEnded = isEnded;
    }

    public boolean isEndMiss() {
        return this.isEndMiss;
    }

    public void setEndMiss(boolean isEndMiss) {
        this.isEndMiss = isEndMiss;
    }
}

