/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOrcInputFormat;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.orc.OrcMetaDataReader;
import org.pentaho.hadoop.shim.common.format.orc.OrcSchemaConverter;
import org.pentaho.hadoop.shim.common.format.orc.PentahoOrcRecordReader;

public class PentahoOrcInputFormat
extends HadoopFormatBase
implements IPentahoOrcInputFormat {
    private String fileName;
    private List<? extends IOrcInputField> inputFields;
    private Configuration conf = this.inClassloader(() -> {
        ConfigurationProxy conf = new ConfigurationProxy();
        conf.addResource("hive-site.xml");
        return conf;
    });

    public List<IPentahoInputFormat.IPentahoInputSplit> getSplits() throws Exception {
        return null;
    }

    public IPentahoInputFormat.IPentahoRecordReader createRecordReader(IPentahoInputFormat.IPentahoInputSplit split) throws Exception {
        if (this.fileName == null || this.inputFields == null) {
            throw new IllegalStateException("fileName or inputFields must not be null");
        }
        this.conf = new Configuration();
        return this.inClassloader(() -> new PentahoOrcRecordReader(this.fileName, this.conf, this.inputFields));
    }

    public List<IOrcInputField> readSchema() throws Exception {
        this.checkNullFileName();
        Reader orcReader = this.getReader();
        return this.readSchema(orcReader);
    }

    protected List<IOrcInputField> readSchema(Reader orcReader) throws Exception {
        OrcSchemaConverter OrcSchemaConverter2 = new OrcSchemaConverter();
        List<IOrcInputField> inputFields = OrcSchemaConverter2.buildInputFields(this.readTypeDescription(orcReader));
        OrcMetaDataReader orcMetaDataReader = new OrcMetaDataReader(orcReader);
        orcMetaDataReader.read(inputFields);
        return inputFields;
    }

    public TypeDescription readTypeDescription() throws Exception {
        this.checkNullFileName();
        Reader orcReader = this.getReader();
        return this.readTypeDescription(orcReader);
    }

    public TypeDescription readTypeDescription(Reader orcReader) {
        return orcReader.getSchema();
    }

    private Reader getReader() throws Exception {
        return this.inClassloader(() -> {
            Reader orcReader;
            this.checkNullFileName();
            try {
                S3NCredentialUtils.applyS3CredentialsToHadoopConfigurationIfNecessary(this.fileName, this.conf);
                Path filePath = new Path(this.fileName);
                FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)this.conf);
                if (!fs.exists(filePath)) {
                    throw new NoSuchFileException(this.fileName);
                }
                if (fs.getFileStatus(filePath).isDirectory()) {
                    PathFilter pathFilter = new PathFilter(){

                        public boolean accept(Path file) {
                            return file.getName().endsWith(".orc");
                        }
                    };
                    FileStatus[] fileStatuses = fs.listStatus(filePath, pathFilter);
                    if (fileStatuses.length == 0) {
                        throw new NoSuchFileException(this.fileName);
                    }
                    filePath = fileStatuses[0].getPath();
                }
                orcReader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(fs));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read data from file " + this.fileName, e);
            }
            return orcReader;
        });
    }

    public void setSchema(List<? extends IOrcInputField> inputFields) throws Exception {
        this.inputFields = inputFields;
    }

    public void setInputFile(String fileName) throws Exception {
        this.fileName = S3NCredentialUtils.scrubFilePathIfNecessary(fileName);
    }

    public void setSplitSize(long blockSize) throws Exception {
    }

    public void checkNullFileName() {
        if (this.fileName == null) {
            throw new IllegalStateException("fileName must not be null");
        }
    }
}

