/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.openerp.core;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.FilterCollection;
import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.OpenERPCommand;
import com.debortoliwines.openerp.api.OpeneERPApiException;
import com.debortoliwines.openerp.api.Row;
import com.debortoliwines.openerp.api.RowCollection;
import com.debortoliwines.openerp.api.Session;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.xmlrpc.XmlRpcException;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.openerp.core.FieldMapping;

public class OpenERPHelper
implements DatabaseFactoryInterface {
    private Session openERPConnection;
    private OpenERPCommand commands;
    private boolean importReturnsIDS = false;

    public String getConnectionTestReport(DatabaseMeta databaseMeta) {
        try {
            OpenERPHelper helper = new OpenERPHelper(databaseMeta);
            helper.StartSession();
            return "Successfully connected to [" + databaseMeta.environmentSubstitute(databaseMeta.getName()) + "]";
        }
        catch (NumberFormatException e) {
            return "Invalid port number: " + e.getMessage();
        }
        catch (Exception e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public OpenERPHelper() {
    }

    public OpenERPHelper(DatabaseMeta databaseMeta) {
        this.openERPConnection = new Session(databaseMeta.environmentSubstitute(databaseMeta.getHostname()), Integer.parseInt(databaseMeta.environmentSubstitute(databaseMeta.getDatabasePortNumberString())), databaseMeta.environmentSubstitute(databaseMeta.getDatabaseName()), databaseMeta.environmentSubstitute(databaseMeta.getUsername()), databaseMeta.environmentSubstitute(databaseMeta.getPassword()));
    }

    public void StartSession() throws Exception {
        this.openERPConnection.startSession();
        this.commands = this.openERPConnection.getOpenERPCommand();
        this.openERPConnection.getContext().setActiveTest(false);
        try {
            this.importReturnsIDS = this.openERPConnection.getServerVersion().getMajor() >= 7;
        }
        catch (XmlRpcException e) {
            this.importReturnsIDS = false;
        }
    }

    public String[] getModelList() {
        String[] modelNames = new String[]{};
        try {
            ObjectAdapter modelAdapter = new ObjectAdapter(this.openERPConnection, "ir.model");
            RowCollection rows = modelAdapter.searchAndReadObject(null, new String[]{"model"});
            modelNames = new String[rows.size()];
            for (int i = 0; i < modelNames.length; ++i) {
                modelNames[i] = ((Row)rows.get(i)).get("model").toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelNames;
    }

    public int getModelDataCount(String model, FilterCollection filter) throws XmlRpcException, OpeneERPApiException {
        ObjectAdapter modelAdapter = new ObjectAdapter(this.openERPConnection, model);
        return modelAdapter.getObjectCount(filter);
    }

    public RowCollection getModelData(String model, FilterCollection filter, ArrayList<FieldMapping> mappings, int offset, int limit) throws XmlRpcException, OpeneERPApiException {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (FieldMapping map : mappings) {
            if (fieldList.contains(map.source_field)) continue;
            fieldList.add(map.source_field);
        }
        String[] fieldStringList = new String[fieldList.size()];
        fieldStringList = fieldList.toArray(fieldStringList);
        ObjectAdapter modelAdapter = new ObjectAdapter(this.openERPConnection, model);
        return modelAdapter.searchAndReadObject(filter, fieldStringList, offset, limit, null);
    }

    public RowCollection getModelData(String model, FilterCollection filter, String[] fieldStringList) throws XmlRpcException, OpeneERPApiException {
        ObjectAdapter modelAdapter = new ObjectAdapter(this.openERPConnection, model);
        return modelAdapter.searchAndReadObject(filter, fieldStringList);
    }

    public String[] getOutputFields(String model) throws MalformedURLException, XmlRpcException, OpeneERPApiException {
        ObjectAdapter modelAdapter = new ObjectAdapter(this.openERPConnection, model);
        FieldCollection fields = modelAdapter.getFields();
        ArrayList<String> fieldArray = new ArrayList<String>();
        for (Field field : fields) {
            boolean readonly = field.getReadonly();
            if (readonly) {
                for (Object[] stateProperty : field.getStateProperties("readonly")) {
                    boolean stateReadonly = (Boolean)(stateProperty[1] instanceof Integer ? Boolean.valueOf((Integer)stateProperty[1] == 1) : stateProperty[1]);
                    boolean bl = readonly = readonly && stateReadonly;
                    if (!readonly) break;
                }
            }
            if (field.getType() == Field.FieldType.ONE2MANY || readonly) continue;
            fieldArray.add(field.getName());
        }
        Collections.sort(fieldArray);
        return fieldArray.toArray(new String[fieldArray.size()]);
    }

    public ObjectAdapter getAdapter(String objectName) throws XmlRpcException, OpeneERPApiException {
        return this.openERPConnection.getObjectAdapter(objectName);
    }

    public void deleteObjects(String model, ArrayList<Object> ids) throws XmlRpcException {
        this.commands.unlinkObject(model, ids.toArray(new Object[ids.size()]));
    }

    public boolean getImportReturnIDS() {
        return this.importReturnsIDS;
    }

    public ArrayList<FieldMapping> getDefaultFieldMappings(String model) throws Exception {
        ArrayList<FieldMapping> mappings = new ArrayList<FieldMapping>();
        ObjectAdapter adapter = new ObjectAdapter(this.openERPConnection, model);
        FieldCollection fields = adapter.getFields();
        FieldMapping fieldMap = new FieldMapping();
        fieldMap.source_model = model;
        fieldMap.source_field = "id";
        fieldMap.source_index = -1;
        fieldMap.target_model = model;
        fieldMap.target_field = "id";
        fieldMap.target_field_label = "Database ID";
        fieldMap.target_field_type = 5;
        mappings.add(fieldMap);
        block7: for (Field field : fields) {
            fieldMap = new FieldMapping();
            String fieldName = field.getName();
            fieldMap.source_model = model;
            fieldMap.source_field = fieldName;
            fieldMap.source_index = -1;
            fieldMap.target_model = model;
            fieldMap.target_field = fieldName;
            fieldMap.target_field_label = field.getDescription();
            Field.FieldType fieldType = field.getType();
            switch (fieldType) {
                case CHAR: 
                case TEXT: 
                case BINARY: {
                    fieldMap.target_field_type = 2;
                    mappings.add(fieldMap);
                    continue block7;
                }
                case BOOLEAN: {
                    fieldMap.target_field_type = 4;
                    mappings.add(fieldMap);
                    continue block7;
                }
                case FLOAT: {
                    fieldMap.target_field_type = 1;
                    mappings.add(fieldMap);
                    continue block7;
                }
                case DATETIME: 
                case DATE: {
                    fieldMap.target_field_type = 3;
                    mappings.add(fieldMap);
                    continue block7;
                }
                case MANY2ONE: {
                    FieldMapping newFieldMap = fieldMap.Clone();
                    newFieldMap.source_index = 0;
                    newFieldMap.target_model = field.getRelation();
                    newFieldMap.target_field = fieldName + "_id";
                    newFieldMap.target_field_label = field.getDescription() + "/Id";
                    newFieldMap.target_field_type = 5;
                    mappings.add(newFieldMap);
                    newFieldMap = fieldMap.Clone();
                    newFieldMap.source_index = 1;
                    newFieldMap.target_model = field.getRelation();
                    newFieldMap.target_field = fieldName + "_name";
                    newFieldMap.target_field_label = field.getDescription() + "/Name";
                    newFieldMap.target_field_type = 2;
                    mappings.add(newFieldMap);
                    continue block7;
                }
            }
            fieldMap.target_field_type = 2;
            mappings.add(fieldMap);
        }
        return mappings;
    }
}

