/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.concatfields;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

@PluginDialog(id="ConcatFields", pluginType=PluginDialog.PluginType.STEP, image="ConcatFields.svg", documentationUrl="http://wiki.pentaho.com/display/EAI/Concat+Fields")
public class ConcatFieldsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ConcatFieldsDialog.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wAdvancedTab;
    private CTabItem wFieldsTab;
    private FormData fdAdvancedComp;
    private FormData fdFieldsComp;
    private Label wlTargetFieldName;
    private TextVar wTargetFieldName;
    private FormData fdlTargetFieldName;
    private FormData fdTargetFieldName;
    private Label wlTargetFieldLength;
    private Text wTargetFieldLength;
    private FormData fdlTargetFieldLength;
    private FormData fdTargetFieldLength;
    private Label wlRemoveSelectedFields;
    private Button wRemoveSelectedFields;
    private FormData fdlRemoveSelectedFields;
    private FormData fdRemoveSelectedFields;
    private Label wlSeparator;
    private Button wbSeparator;
    private TextVar wSeparator;
    private FormData fdlSeparator;
    private FormData fdbSeparator;
    private FormData fdSeparator;
    private Label wlEnclosure;
    private TextVar wEnclosure;
    private FormData fdlEnclosure;
    private FormData fdEnclosure;
    private Label wlEndedLine;
    private Text wEndedLine;
    private FormData fdlEndedLine;
    private FormData fdEndedLine;
    private Label wlEnclForced;
    private Button wEnclForced;
    private FormData fdlEnclForced;
    private FormData fdEnclForced;
    private Label wlDisableEnclosureFix;
    private Button wDisableEnclosureFix;
    private FormData fdlDisableEnclosureFix;
    private FormData fdDisableEnclosureFix;
    private Label wlHeader;
    private Button wHeader;
    private FormData fdlHeader;
    private FormData fdHeader;
    private Label wlFooter;
    private Button wFooter;
    private FormData fdlFooter;
    private FormData fdFooter;
    private Label wlEncoding;
    private CCombo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlPad;
    private Button wPad;
    private FormData fdlPad;
    private FormData fdPad;
    private Label wlFastDump;
    private Button wFastDump;
    private FormData fdlFastDump;
    private FormData fdFastDump;
    private Label wlSplitEvery;
    private Text wSplitEvery;
    private FormData fdlSplitEvery;
    private FormData fdSplitEvery;
    private TableView wFields;
    private FormData fdFields;
    private ConcatFieldsMeta input;
    private Button wMinWidth;
    private Listener lsMinWidth;
    private boolean gotEncodings = false;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;

    public ConcatFieldsDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ConcatFieldsMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlTargetFieldName = new Label((Composite)this.shell, 131072);
        this.wlTargetFieldName.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldName.Label", (String[])new String[0]));
        this.wlTargetFieldName.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetFieldName);
        this.fdlTargetFieldName = new FormData();
        this.fdlTargetFieldName.left = new FormAttachment(0, 0);
        this.fdlTargetFieldName.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlTargetFieldName.right = new FormAttachment(middle, -margin);
        this.wlTargetFieldName.setLayoutData((Object)this.fdlTargetFieldName);
        this.wTargetFieldName = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wTargetFieldName.setText("");
        this.props.setLook((Control)this.wTargetFieldName);
        this.wTargetFieldName.addModifyListener(lsMod);
        this.fdTargetFieldName = new FormData();
        this.fdTargetFieldName.left = new FormAttachment(middle, 0);
        this.fdTargetFieldName.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTargetFieldName.right = new FormAttachment(100, 0);
        this.wTargetFieldName.setLayoutData((Object)this.fdTargetFieldName);
        this.wlTargetFieldLength = new Label((Composite)this.shell, 131072);
        this.wlTargetFieldLength.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldLength.Label", (String[])new String[0]));
        this.wlTargetFieldLength.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldLength.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetFieldLength);
        this.fdlTargetFieldLength = new FormData();
        this.fdlTargetFieldLength.left = new FormAttachment(0, 0);
        this.fdlTargetFieldLength.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        this.fdlTargetFieldLength.right = new FormAttachment(middle, -margin);
        this.wlTargetFieldLength.setLayoutData((Object)this.fdlTargetFieldLength);
        this.wTargetFieldLength = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTargetFieldLength);
        this.wTargetFieldLength.addModifyListener(lsMod);
        this.fdTargetFieldLength = new FormData();
        this.fdTargetFieldLength.left = new FormAttachment(middle, 0);
        this.fdTargetFieldLength.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        this.fdTargetFieldLength.right = new FormAttachment(100, 0);
        this.wTargetFieldLength.setLayoutData((Object)this.fdTargetFieldLength);
        this.wlSeparator = new Label((Composite)this.shell, 131072);
        this.wlSeparator.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Separator.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSeparator);
        this.fdlSeparator = new FormData();
        this.fdlSeparator.left = new FormAttachment(0, 0);
        this.fdlSeparator.top = new FormAttachment((Control)this.wTargetFieldLength, margin);
        this.fdlSeparator.right = new FormAttachment(middle, -margin);
        this.wlSeparator.setLayoutData((Object)this.fdlSeparator);
        this.wbSeparator = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSeparator);
        this.wbSeparator.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Separator.Button", (String[])new String[0]));
        this.fdbSeparator = new FormData();
        this.fdbSeparator.right = new FormAttachment(100, 0);
        this.fdbSeparator.top = new FormAttachment((Control)this.wTargetFieldLength, margin);
        this.wbSeparator.setLayoutData((Object)this.fdbSeparator);
        this.wbSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ConcatFieldsDialog.this.wSeparator.getTextWidget().insert("\t");
            }
        });
        this.wSeparator = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSeparator);
        this.wSeparator.addModifyListener(lsMod);
        this.fdSeparator = new FormData();
        this.fdSeparator.left = new FormAttachment(middle, 0);
        this.fdSeparator.top = new FormAttachment((Control)this.wTargetFieldLength, margin);
        this.fdSeparator.right = new FormAttachment((Control)this.wbSeparator, -margin);
        this.wSeparator.setLayoutData((Object)this.fdSeparator);
        this.wlEnclosure = new Label((Composite)this.shell, 131072);
        this.wlEnclosure.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Enclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEnclosure);
        this.fdlEnclosure = new FormData();
        this.fdlEnclosure.left = new FormAttachment(0, 0);
        this.fdlEnclosure.top = new FormAttachment((Control)this.wSeparator, margin);
        this.fdlEnclosure.right = new FormAttachment(middle, -margin);
        this.wlEnclosure.setLayoutData((Object)this.fdlEnclosure);
        this.wEnclosure = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        this.fdEnclosure = new FormData();
        this.fdEnclosure.left = new FormAttachment(middle, 0);
        this.fdEnclosure.top = new FormAttachment((Control)this.wSeparator, margin);
        this.fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)this.fdEnclosure);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        this.wMinWidth = new Button(wFieldsComp, 8);
        this.wMinWidth.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.MinWidth.Button", (String[])new String[0]));
        this.wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.MinWidth.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet, this.wMinWidth}, margin, null);
        int FieldsCols = 10;
        int FieldsRows = this.input.getOutputFields().length;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        this.colinf = new ColumnInfo[10];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.NameColumn.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TypeColumn.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames());
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FormatColumn.Column", (String[])new String[0]), 2, formats);
        this.colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.LengthColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[5] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.CurrencyColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[6] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DecimalColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[7] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.GroupColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[8] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TrimTypeColumn.Column", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc, true);
        this.colinf[9] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.NullColumn.Column", (String[])new String[0]), 1, false);
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = ConcatFieldsDialog.this.transMeta.findStep(ConcatFieldsDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = ConcatFieldsDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            ConcatFieldsDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        ConcatFieldsDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        ConcatFieldsDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        this.wAdvancedTab = new CTabItem(this.wTabFolder, 0);
        this.wAdvancedTab.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.AdvancedTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        this.wlRemoveSelectedFields = new Label(wContentComp, 131072);
        this.wlRemoveSelectedFields.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.RemoveSelectedFields.Label", (String[])new String[0]));
        this.wlRemoveSelectedFields.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.RemoveSelectedFields.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlRemoveSelectedFields);
        this.fdlRemoveSelectedFields = new FormData();
        this.fdlRemoveSelectedFields.left = new FormAttachment(0, 0);
        this.fdlRemoveSelectedFields.top = new FormAttachment(0, 0);
        this.fdlRemoveSelectedFields.right = new FormAttachment(middle, -margin);
        this.wlRemoveSelectedFields.setLayoutData((Object)this.fdlRemoveSelectedFields);
        this.wRemoveSelectedFields = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wRemoveSelectedFields);
        this.fdRemoveSelectedFields = new FormData();
        this.fdRemoveSelectedFields.left = new FormAttachment(middle, 0);
        this.fdRemoveSelectedFields.top = new FormAttachment(0, 0);
        this.fdRemoveSelectedFields.right = new FormAttachment(100, 0);
        this.wRemoveSelectedFields.setLayoutData((Object)this.fdRemoveSelectedFields);
        this.wRemoveSelectedFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        });
        this.wlEnclForced = new Label(wContentComp, 131072);
        this.wlEnclForced.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.EnclForced.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEnclForced);
        this.fdlEnclForced = new FormData();
        this.fdlEnclForced.left = new FormAttachment(0, 0);
        this.fdlEnclForced.top = new FormAttachment((Control)this.wRemoveSelectedFields, margin);
        this.fdlEnclForced.right = new FormAttachment(middle, -margin);
        this.wlEnclForced.setLayoutData((Object)this.fdlEnclForced);
        this.wEnclForced = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wEnclForced);
        this.fdEnclForced = new FormData();
        this.fdEnclForced.left = new FormAttachment(middle, 0);
        this.fdEnclForced.top = new FormAttachment((Control)this.wRemoveSelectedFields, margin);
        this.fdEnclForced.right = new FormAttachment(100, 0);
        this.wEnclForced.setLayoutData((Object)this.fdEnclForced);
        this.wEnclForced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        });
        this.wlDisableEnclosureFix = new Label(wContentComp, 131072);
        this.wlDisableEnclosureFix.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DisableEnclosureFix.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDisableEnclosureFix);
        this.fdlDisableEnclosureFix = new FormData();
        this.fdlDisableEnclosureFix.left = new FormAttachment(0, 0);
        this.fdlDisableEnclosureFix.top = new FormAttachment((Control)this.wEnclForced, margin);
        this.fdlDisableEnclosureFix.right = new FormAttachment(middle, -margin);
        this.wlDisableEnclosureFix.setLayoutData((Object)this.fdlDisableEnclosureFix);
        this.wDisableEnclosureFix = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wDisableEnclosureFix);
        this.fdDisableEnclosureFix = new FormData();
        this.fdDisableEnclosureFix.left = new FormAttachment(middle, 0);
        this.fdDisableEnclosureFix.top = new FormAttachment((Control)this.wEnclForced, margin);
        this.fdDisableEnclosureFix.right = new FormAttachment(100, 0);
        this.wDisableEnclosureFix.setLayoutData((Object)this.fdDisableEnclosureFix);
        this.wDisableEnclosureFix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        });
        this.wlHeader = new Label(wContentComp, 131072);
        this.wlHeader.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Header.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHeader);
        this.fdlHeader = new FormData();
        this.fdlHeader.left = new FormAttachment(0, 0);
        this.fdlHeader.top = new FormAttachment((Control)this.wDisableEnclosureFix, margin);
        this.fdlHeader.right = new FormAttachment(middle, -margin);
        this.wlHeader.setLayoutData((Object)this.fdlHeader);
        this.wHeader = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wHeader);
        this.fdHeader = new FormData();
        this.fdHeader.left = new FormAttachment(middle, 0);
        this.fdHeader.top = new FormAttachment((Control)this.wDisableEnclosureFix, margin);
        this.fdHeader.right = new FormAttachment(100, 0);
        this.wHeader.setLayoutData((Object)this.fdHeader);
        this.wHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        });
        this.wlFooter = new Label(wContentComp, 131072);
        this.wlFooter.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Footer.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFooter);
        this.fdlFooter = new FormData();
        this.fdlFooter.left = new FormAttachment(0, 0);
        this.fdlFooter.top = new FormAttachment((Control)this.wHeader, margin);
        this.fdlFooter.right = new FormAttachment(middle, -margin);
        this.wlFooter.setLayoutData((Object)this.fdlFooter);
        this.wFooter = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wFooter);
        this.fdFooter = new FormData();
        this.fdFooter.left = new FormAttachment(middle, 0);
        this.fdFooter.top = new FormAttachment((Control)this.wHeader, margin);
        this.fdFooter.right = new FormAttachment(100, 0);
        this.wFooter.setLayoutData((Object)this.fdFooter);
        this.wFooter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        });
        this.wlEncoding = new Label(wContentComp, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment((Control)this.wFooter, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment((Control)this.wFooter, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ConcatFieldsDialog.this.shell.getDisplay(), 1);
                ConcatFieldsDialog.this.shell.setCursor(busy);
                ConcatFieldsDialog.this.setEncodings();
                ConcatFieldsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlPad = new Label(wContentComp, 131072);
        this.wlPad.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Pad.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPad);
        this.fdlPad = new FormData();
        this.fdlPad.left = new FormAttachment(0, 0);
        this.fdlPad.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdlPad.right = new FormAttachment(middle, -margin);
        this.wlPad.setLayoutData((Object)this.fdlPad);
        this.wPad = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wPad);
        this.fdPad = new FormData();
        this.fdPad.left = new FormAttachment(middle, 0);
        this.fdPad.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdPad.right = new FormAttachment(100, 0);
        this.wPad.setLayoutData((Object)this.fdPad);
        this.wPad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        });
        this.wlFastDump = new Label(wContentComp, 131072);
        this.wlFastDump.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FastDump.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFastDump);
        this.fdlFastDump = new FormData();
        this.fdlFastDump.left = new FormAttachment(0, 0);
        this.fdlFastDump.top = new FormAttachment((Control)this.wPad, margin);
        this.fdlFastDump.right = new FormAttachment(middle, -margin);
        this.wlFastDump.setLayoutData((Object)this.fdlFastDump);
        this.wFastDump = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wFastDump);
        this.fdFastDump = new FormData();
        this.fdFastDump.left = new FormAttachment(middle, 0);
        this.fdFastDump.top = new FormAttachment((Control)this.wPad, margin);
        this.fdFastDump.right = new FormAttachment(100, 0);
        this.wFastDump.setLayoutData((Object)this.fdFastDump);
        this.wFastDump.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
                ConcatFieldsDialog.this.setFlags();
            }
        });
        this.wlSplitEvery = new Label(wContentComp, 131072);
        this.wlSplitEvery.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.SplitEvery.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSplitEvery);
        this.fdlSplitEvery = new FormData();
        this.fdlSplitEvery.left = new FormAttachment(0, 0);
        this.fdlSplitEvery.top = new FormAttachment((Control)this.wFastDump, margin);
        this.fdlSplitEvery.right = new FormAttachment(middle, -margin);
        this.wlSplitEvery.setLayoutData((Object)this.fdlSplitEvery);
        this.wSplitEvery = new Text(wContentComp, 18436);
        this.props.setLook((Control)this.wSplitEvery);
        this.wSplitEvery.addModifyListener(lsMod);
        this.fdSplitEvery = new FormData();
        this.fdSplitEvery.left = new FormAttachment(middle, 0);
        this.fdSplitEvery.top = new FormAttachment((Control)this.wFastDump, margin);
        this.fdSplitEvery.right = new FormAttachment(100, 0);
        this.wSplitEvery.setLayoutData((Object)this.fdSplitEvery);
        this.wlEndedLine = new Label(wContentComp, 131072);
        this.wlEndedLine.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.EndedLine.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEndedLine);
        this.fdlEndedLine = new FormData();
        this.fdlEndedLine.left = new FormAttachment(0, 0);
        this.fdlEndedLine.top = new FormAttachment((Control)this.wSplitEvery, margin);
        this.fdlEndedLine.right = new FormAttachment(middle, -margin);
        this.wlEndedLine.setLayoutData((Object)this.fdlEndedLine);
        this.wEndedLine = new Text(wContentComp, 18436);
        this.props.setLook((Control)this.wEndedLine);
        this.wEndedLine.addModifyListener(lsMod);
        this.fdEndedLine = new FormData();
        this.fdEndedLine.left = new FormAttachment(middle, 0);
        this.fdEndedLine.top = new FormAttachment((Control)this.wSplitEvery, margin);
        this.fdEndedLine.right = new FormAttachment(100, 0);
        this.wEndedLine.setLayoutData((Object)this.fdEndedLine);
        this.fdAdvancedComp = new FormData();
        this.fdAdvancedComp.left = new FormAttachment(0, 0);
        this.fdAdvancedComp.top = new FormAttachment(0, 0);
        this.fdAdvancedComp.right = new FormAttachment(100, 0);
        this.fdAdvancedComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)this.fdAdvancedComp);
        wContentComp.layout();
        this.wAdvancedTab.setControl((Control)wContentComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wEnclosure, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ConcatFieldsDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                ConcatFieldsDialog.this.get();
            }
        };
        this.lsMinWidth = new Listener(){

            public void handleEvent(Event e) {
                ConcatFieldsDialog.this.setMinimalWidth();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ConcatFieldsDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wMinWidth.addListener(13, this.lsMinWidth);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ConcatFieldsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wTargetFieldName.addSelectionListener(this.lsDef);
        this.wTargetFieldLength.addSelectionListener((SelectionListener)this.lsDef);
        this.wSeparator.addSelectionListener(this.lsDef);
        this.wTargetFieldName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatFieldsDialog.this.wTargetFieldName.setToolTipText(ConcatFieldsDialog.this.transMeta.environmentSubstitute(ConcatFieldsDialog.this.wTargetFieldName.getText()));
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ConcatFieldsDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = ConcatFieldsDialog.this.shell.getSize();
                ConcatFieldsDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((ConcatFieldsDialog)ConcatFieldsDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                ConcatFieldsDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    protected void setFlags() {
        boolean isNotFastDataDump = !this.wFastDump.getSelection();
        this.wDisableEnclosureFix.setEnabled(isNotFastDataDump);
        this.wlDisableEnclosureFix.setEnabled(isNotFastDataDump);
        this.wEncoding.setEnabled(isNotFastDataDump);
        this.wlEncoding.setEnabled(isNotFastDataDump);
        this.wPad.setEnabled(isNotFastDataDump);
        this.wlPad.setEnabled(isNotFastDataDump);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void getData() {
        if (this.input.getTargetFieldName() != null) {
            this.wTargetFieldName.setText(this.input.getTargetFieldName());
        }
        this.wTargetFieldLength.setText("" + this.input.getTargetFieldLength());
        this.wRemoveSelectedFields.setSelection(this.input.isRemoveSelectedFields());
        this.wSeparator.setText(Const.NVL((String)this.input.getSeparator(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getEndedLine() != null) {
            this.wEndedLine.setText(this.input.getEndedLine());
        }
        this.wSplitEvery.setText("" + this.input.getSplitEvery());
        this.wEnclForced.setSelection(this.input.isEnclosureForced());
        this.wDisableEnclosureFix.setSelection(this.input.isEnclosureFixDisabled());
        this.wHeader.setSelection(this.input.isHeaderEnabled());
        this.wFooter.setSelection(this.input.isFooterEnabled());
        this.wPad.setSelection(this.input.isPadded());
        this.wFastDump.setSelection(this.input.isFastDump());
        this.logDebug("getting fields info...");
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            String trim;
            TextFileField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            if (field.getName() != null) {
                item.setText(1, field.getName());
            }
            item.setText(2, field.getTypeDesc());
            if (field.getFormat() != null) {
                item.setText(3, field.getFormat());
            }
            if (field.getLength() >= 0) {
                item.setText(4, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                item.setText(5, "" + field.getPrecision());
            }
            if (field.getCurrencySymbol() != null) {
                item.setText(6, field.getCurrencySymbol());
            }
            if (field.getDecimalSymbol() != null) {
                item.setText(7, field.getDecimalSymbol());
            }
            if (field.getGroupingSymbol() != null) {
                item.setText(8, field.getGroupingSymbol());
            }
            if ((trim = field.getTrimTypeDesc()) != null) {
                item.setText(9, trim);
            }
            if (field.getNullString() == null) continue;
            item.setText(10, field.getNullString());
        }
        this.wFields.optWidth(true);
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(ConcatFieldsMeta tfoi) {
        tfoi.setTargetFieldName(this.wTargetFieldName.getText());
        tfoi.setTargetFieldLength(Const.toInt((String)this.wTargetFieldLength.getText(), (int)0));
        tfoi.setRemoveSelectedFields(this.wRemoveSelectedFields.getSelection());
        tfoi.setEncoding(this.wEncoding.getText());
        tfoi.setSeparator(this.wSeparator.getText());
        tfoi.setEnclosure(this.wEnclosure.getText());
        tfoi.setSplitEvery(Const.toInt((String)this.wSplitEvery.getText(), (int)0));
        tfoi.setEndedLine(this.wEndedLine.getText());
        tfoi.setEnclosureForced(this.wEnclForced.getSelection());
        tfoi.setEnclosureFixDisabled(this.wDisableEnclosureFix.getSelection());
        tfoi.setHeaderEnabled(this.wHeader.getSelection());
        tfoi.setFooterEnabled(this.wFooter.getSelection());
        tfoi.setPadded(this.wPad.getSelection());
        tfoi.setFastDump(this.wFastDump.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        tfoi.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TextFileField field = new TextFileField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setType(item.getText(2));
            field.setFormat(item.getText(3));
            field.setLength(Const.toInt((String)item.getText(4), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(5), (int)-1));
            field.setCurrencySymbol(item.getText(6));
            field.setDecimalSymbol(item.getText(7));
            field.setGroupingSymbol(item.getText(8));
            field.setTrimType(ValueMetaString.getTrimTypeByDesc((String)item.getText(9)));
            field.setNullString(item.getText(10));
            tfoi.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.isNumber() && v.getLength() > 0) {
                            int m;
                            int le = v.getLength();
                            int pr = v.getPrecision();
                            if (v.getPrecision() <= 0) {
                                pr = 0;
                            }
                            String mask = "";
                            for (m = 0; m < le - pr; ++m) {
                                mask = mask + "0";
                            }
                            if (pr > 0) {
                                mask = mask + ".";
                            }
                            for (m = 0; m < pr; ++m) {
                                mask = mask + "0";
                            }
                            tableItem.setText(3, mask);
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{2}, (int)4, (int)5, (TableItemInsertListener)listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int i;
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(4, "");
            item.setText(5, "");
            item.setText(9, ValueMetaString.getTrimTypeDesc((int)3));
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(3, "");
                    continue block6;
                }
                case 5: {
                    item.setText(3, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(3, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        for (i = 0; i < this.input.getOutputFields().length; ++i) {
            this.input.getOutputFields()[i].setTrimType(3);
        }
        this.wFields.optWidth(true);
    }
}

