/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DataSourceService;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceServiceException;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;

public class JndiConnectionProvider
implements OlapConnectionProvider {
    private transient DataSourceService dataSourceService = (DataSourceService)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceService.class);
    private static final Log logger = LogFactory.getLog(JndiConnectionProvider.class);
    private String connectionPath;
    private String username;
    private String password;

    public String getConnectionPath() {
        return this.connectionPath;
    }

    public void setConnectionPath(String connectionPath) {
        this.connectionPath = connectionPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public OlapConnection createConnection(String user, String password) throws SQLException {
        try {
            DataSource ds = this.dataSourceService.getDataSource(this.connectionPath);
            String realUser = this.username != null ? this.username : user;
            String realPassword = this.password != null ? this.password : password;
            if (realUser == null) {
                Connection connection = ds.getConnection();
                if (connection == null) {
                    throw new SQLException("JNDI DataSource is invalid; it returned null without throwing a meaningful error.");
                }
                if (connection instanceof OlapConnection) {
                    return (OlapConnection)connection;
                }
                if (connection instanceof OlapWrapper) {
                    OlapWrapper wrapper = (OlapWrapper)connection;
                    return (OlapConnection)wrapper.unwrap(OlapConnection.class);
                }
                throw new SQLException("Unable to unwrap the connection: " + this.connectionPath);
            }
            Connection connection = ds.getConnection(realUser, realPassword);
            if (connection == null) {
                throw new SQLException("JNDI DataSource is invalid; it returned null without throwing a meaningful error.");
            }
            if (connection instanceof OlapConnection) {
                return (OlapConnection)connection;
            }
            if (connection instanceof OlapWrapper) {
                OlapWrapper wrapper = (OlapWrapper)connection;
                return (OlapConnection)wrapper.unwrap(OlapConnection.class);
            }
            return connection.unwrap(OlapConnection.class);
        }
        catch (DatasourceServiceException ne) {
            logger.warn((Object)"Failed to access the JDNI-System", (Throwable)ne);
            throw new SQLException("Failed to access the JNDI system");
        }
    }

    @Override
    public Object getConnectionHash() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getClass().getName());
        list.add(this.connectionPath);
        list.add(this.username);
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JndiConnectionProvider that = (JndiConnectionProvider)o;
        if (this.connectionPath != null ? !this.connectionPath.equals(that.connectionPath) : that.connectionPath != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.connectionPath != null ? this.connectionPath.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dataSourceService = (DataSourceService)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceService.class);
    }
}

