/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMCriticalThreadUncaughtExceptionHandler;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerRescheduledEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSOpDurations;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSPreemptionThread;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.InvalidQueueNameException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.MaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class FairScheduler
extends AbstractYarnScheduler<FSAppAttempt, FSSchedulerNode> {
    private FairSchedulerConfiguration conf;
    private FSContext context;
    private Resource incrAllocation;
    private QueueManager queueMgr;
    private volatile Clock clock;
    private boolean usePortForNodeName;
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private static final Log STATE_DUMP_LOG = LogFactory.getLog((String)(FairScheduler.class.getName() + ".statedump"));
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private static final ResourceCalculator DOMINANT_RESOURCE_CALCULATOR = new DominantResourceCalculator();
    public static final Resource CONTAINER_RESERVED = Resources.createResource((int)-1);
    protected long updateInterval;
    private final int UPDATE_DEBUG_FREQUENCY = 25;
    private int updatesToSkipForDebug = 25;
    @VisibleForTesting
    Thread updateThread;
    private final Object updateThreadMonitor = new Object();
    @VisibleForTesting
    Thread schedulingThread;
    Thread preemptionThread;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    FSQueueMetrics rootMetrics;
    FSOpDurations fsOpDurations;
    private float reservableNodesRatio;
    protected boolean sizeBasedWeight;
    protected boolean continuousSchedulingEnabled;
    protected int continuousSchedulingSleepMs;
    private Comparator<FSSchedulerNode> nodeAvailableResourceComparator = new NodeAvailableResourceComparator();
    protected double nodeLocalityThreshold;
    protected double rackLocalityThreshold;
    protected long nodeLocalityDelayMs;
    protected long rackLocalityDelayMs;
    private FairSchedulerEventLog eventLog;
    protected boolean assignMultiple;
    @VisibleForTesting
    boolean maxAssignDynamic;
    protected int maxAssign;
    @VisibleForTesting
    final MaxRunningAppsEnforcer maxRunningEnforcer;
    private AllocationFileLoaderService allocsLoader;
    @VisibleForTesting
    AllocationConfiguration allocConf;
    @VisibleForTesting
    Resource reservationThreshold;

    public FairScheduler() {
        super(FairScheduler.class.getName());
        this.clock = new SystemClock();
        this.context = new FSContext(this);
        this.allocsLoader = new AllocationFileLoaderService();
        this.queueMgr = new QueueManager(this);
        this.maxRunningEnforcer = new MaxRunningAppsEnforcer(this);
    }

    public FSContext getContext() {
        return this.context;
    }

    public boolean isAtLeastReservationThreshold(ResourceCalculator resourceCalculator, Resource resource) {
        return Resources.greaterThanOrEqual((ResourceCalculator)resourceCalculator, (Resource)this.getClusterResource(), (Resource)resource, (Resource)this.reservationThreshold);
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem < 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration: yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ".  Both values must be greater than or equal to 0" + "and the maximum allocation value must be greater than or equal to" + "the minimum allocation value.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores < 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration: yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ".  Both values must be greater than or equal to 0" + "and the maximum allocation value must be greater than or equal to" + "the minimum allocation value.");
        }
    }

    public FairSchedulerConfiguration getConf() {
        return this.conf;
    }

    public int getNumNodesInRack(String rackName) {
        return this.nodeTracker.nodeCount(rackName);
    }

    public QueueManager getQueueManager() {
        return this.queueMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerUpdate() {
        Object object = this.updateThreadMonitor;
        synchronized (object) {
            this.updateThreadMonitor.notify();
        }
    }

    private void dumpSchedulerState() {
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        Resource clusterResource = this.getClusterResource();
        LOG.debug((Object)("FairScheduler state: Cluster Capacity: " + clusterResource + "  Allocations: " + this.rootMetrics.getAllocatedResources() + "  Availability: " + Resource.newInstance((int)this.rootMetrics.getAvailableMB(), (int)this.rootMetrics.getAvailableVirtualCores()) + "  Demand: " + rootQueue.getDemand()));
        STATE_DUMP_LOG.debug((Object)rootQueue.dumpState());
    }

    @VisibleForTesting
    public synchronized void update() {
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        rootQueue.updateDemand();
        Resource clusterResource = this.getClusterResource();
        rootQueue.update(clusterResource, this.shouldAttemptPreemption());
        rootQueue.setFairShare(clusterResource);
        this.updateRootQueueMetrics();
        if (LOG.isDebugEnabled() && --this.updatesToSkipForDebug < 0) {
            this.updatesToSkipForDebug = 25;
            this.dumpSchedulerState();
        }
    }

    public synchronized RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public synchronized ResourceWeights getAppWeight(FSAppAttempt app) {
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            weight = Math.log1p(app.getDemand().getMemory()) / Math.log(2.0);
        }
        ResourceWeights resourceWeights = app.getResourceWeights();
        resourceWeights.setWeight((float)(weight *= (double)app.getPriority().getPriority()));
        return resourceWeights;
    }

    public Resource getIncrementResourceCapability() {
        return this.incrAllocation;
    }

    private FSSchedulerNode getFSSchedulerNode(NodeId nodeId) {
        return (FSSchedulerNode)this.nodeTracker.getNode(nodeId);
    }

    public double getNodeLocalityThreshold() {
        return this.nodeLocalityThreshold;
    }

    public double getRackLocalityThreshold() {
        return this.rackLocalityThreshold;
    }

    public long getNodeLocalityDelayMs() {
        return this.nodeLocalityDelayMs;
    }

    public long getRackLocalityDelayMs() {
        return this.rackLocalityDelayMs;
    }

    public boolean isContinuousSchedulingEnabled() {
        return this.continuousSchedulingEnabled;
    }

    public synchronized int getContinuousSchedulingSleepMs() {
        return this.continuousSchedulingSleepMs;
    }

    public Clock getClock() {
        return this.clock;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    protected synchronized void addApplication(ApplicationId applicationId, String queueName, String user, boolean isAppRecovering) {
        if (queueName == null || queueName.isEmpty()) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an empty queue name.";
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, message));
            return;
        }
        if (queueName.startsWith(".") || queueName.endsWith(".")) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an illegal queue name " + queueName + ". " + "The queue name cannot start/end with period.";
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, message));
            return;
        }
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
        FSLeafQueue queue = this.assignToQueue(rmApp, queueName, user);
        if (queue == null) {
            return;
        }
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !queue.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
            String msg = "User " + userUgi.getUserName() + " cannot submit applications to queue " + queue.getName();
            LOG.info((Object)msg);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, msg));
            return;
        }
        SchedulerApplication application = new SchedulerApplication(queue, user);
        this.applications.put(applicationId, application);
        queue.getMetrics().submitApp(user);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queue.getName() + ", currently num of applications: " + this.applications.size()));
        if (isAppRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationId + " is recovering. Skip notifying APP_ACCEPTED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
        }
    }

    protected synchronized void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        String user = application.getUser();
        FSLeafQueue queue = (FSLeafQueue)application.getQueue();
        FSAppAttempt attempt = new FSAppAttempt(this, applicationAttemptId, user, queue, new ActiveUsersManager(this.getRootQueueMetrics()), this.rmContext);
        if (transferStateFromPreviousAttempt) {
            attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt(attempt);
        boolean runnable = this.maxRunningEnforcer.canAppBeRunnable(queue, user);
        queue.addApp(attempt, runnable);
        if (runnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        } else {
            this.maxRunningEnforcer.trackNonRunnableApp(attempt);
        }
        queue.getMetrics().submitAppAttempt(user);
        LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user: " + user));
        if (isAttemptRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationAttemptId + " is recovering. Skipping notifying ATTEMPT_ADDED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
        }
    }

    @VisibleForTesting
    FSLeafQueue assignToQueue(RMApp rmApp, String queueName, String user) {
        FSQueue queue = null;
        String appRejectMsg = null;
        try {
            QueuePlacementPolicy placementPolicy = this.allocConf.getPlacementPolicy();
            queueName = placementPolicy.assignAppToQueue(queueName, user);
            if (queueName == null) {
                appRejectMsg = "Application rejected by queue placement policy";
            } else {
                queue = this.queueMgr.getLeafQueue(queueName, true);
                if (queue == null) {
                    appRejectMsg = queueName + " is not a leaf queue";
                }
            }
        }
        catch (IllegalStateException se) {
            appRejectMsg = "Unable to match app " + rmApp.getApplicationId() + " to a queue placement policy, and no valid terminal queue " + " placement rule is configured. Please contact an administrator " + " to confirm that the fair scheduler configuration contains a " + " valid terminal queue placement rule.";
        }
        catch (InvalidQueueNameException qne) {
            appRejectMsg = qne.getMessage();
        }
        catch (IOException ioe) {
            appRejectMsg = "Error assigning app to queue " + queueName;
        }
        if (appRejectMsg != null && rmApp != null) {
            LOG.error((Object)appRejectMsg);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(rmApp.getApplicationId(), appRejectMsg));
            return null;
        }
        if (rmApp != null) {
            rmApp.setQueue(queue.getName());
        } else {
            LOG.error((Object)"Couldn't find RM app to set queue name on");
        }
        return queue;
    }

    private synchronized void removeApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void removeApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done." + " finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        FSAppAttempt attempt = this.getSchedulerApp(applicationAttemptId);
        if (attempt == null || application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        if (attempt.isStopped()) {
            LOG.info((Object)("Application " + applicationAttemptId + " has already been " + "stopped!"));
            return;
        }
        for (RMContainer rmContainer : attempt.getLiveContainers()) {
            if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                continue;
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : attempt.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
        FSLeafQueue queue = this.queueMgr.getLeafQueue(attempt.getQueue().getQueueName(), false);
        boolean wasRunnable = queue.removeApp(attempt);
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, attempt.getQueue());
        } else {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
    }

    @Override
    protected synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)("Container " + containerStatus.getContainerId() + " completed with event " + (Object)((Object)event)));
            return;
        }
        Container container = rmContainer.getContainer();
        FSAppAttempt application = (FSAppAttempt)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " finished application " + appId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FSSchedulerNode node = this.getFSSchedulerNode(container.getNodeId());
        if (rmContainer.getState() == RMContainerState.RESERVED) {
            application.unreserve(rmContainer.getReservedPriority(), node);
        } else {
            application.containerCompleted(rmContainer, containerStatus, event);
            node.releaseContainer(container);
            this.updateRootQueueMetrics();
        }
        LOG.info((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void addNode(List<NMContainerStatus> containerReports, RMNode node) {
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, this.usePortForNodeName);
        this.nodeTracker.addNode(schedulerNode);
        this.triggerUpdate();
        Resource clusterResource = this.getClusterResource();
        this.queueMgr.getRootQueue().setSteadyFairShare(clusterResource);
        this.queueMgr.getRootQueue().recomputeSteadyShares();
        LOG.info((Object)("Added node " + node.getNodeAddress() + " cluster capacity: " + clusterResource));
        this.recoverContainersOnNode(containerReports, node);
        this.updateRootQueueMetrics();
    }

    private synchronized void removeNode(RMNode rmNode) {
        NodeId nodeId = rmNode.getNodeID();
        FSSchedulerNode node = (FSSchedulerNode)this.nodeTracker.getNode(nodeId);
        if (node == null) {
            LOG.error((Object)("Attempting to remove non-existent node " + nodeId));
            return;
        }
        List<RMContainer> runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodeTracker.removeNode(nodeId);
        Resource clusterResource = this.getClusterResource();
        this.queueMgr.getRootQueue().setSteadyFairShare(clusterResource);
        this.queueMgr.getRootQueue().recomputeSteadyShares();
        this.updateRootQueueMetrics();
        this.triggerUpdate();
        LOG.info((Object)("Removed node " + rmNode.getNodeAddress() + " cluster capacity: " + clusterResource));
    }

    @Override
    public void normalizeResource(ResourceRequest requestedResource) {
        SchedulerUtils.normalizeRequest(requestedResource, DOMINANT_RESOURCE_CALCULATOR, null, this.minimumAllocation, this.getMaximumResourceCapability(), this.incrAllocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId appAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FSAppAttempt application = this.getSchedulerApp(appAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + appAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, DOMINANT_RESOURCE_CALCULATOR, this.getClusterResource(), this.minimumAllocation, this.getMaximumResourceCapability(), this.incrAllocation);
        application.recordContainerRequestTime(this.getClock().getTime());
        this.releaseContainers(release, application);
        FSAppAttempt fSAppAttempt = application;
        synchronized (fSAppAttempt) {
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + appAttemptId + " application=" + application.getApplicationId()));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                application.showRequests();
            }
            Set<ContainerId> preemptionContainerIds = application.getPreemptionContainerIds();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: post-update applicationAttemptId=" + appAttemptId + " #ask=" + ask.size() + " reservation= " + application.getCurrentReservation()));
                LOG.debug((Object)("Preempting " + preemptionContainerIds.size() + " container(s)"));
            }
            if (application.isWaitingForAMContainer(application.getApplicationId())) {
                application.updateAMBlacklist(blacklistAdditions, blacklistRemovals);
            } else {
                application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            }
            SchedulerApplicationAttempt.ContainersAndNMTokensAllocation allocation = application.pullNewlyAllocatedContainersAndNMTokens();
            if (!allocation.getContainerList().isEmpty()) {
                application.recordContainerAllocationTime(this.getClock().getTime());
            }
            return new Allocation(allocation.getContainerList(), application.getHeadroom(), preemptionContainerIds, null, null, allocation.getNMTokenList());
        }
    }

    private synchronized void nodeUpdate(RMNode nm) {
        long start = this.getClock().getTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " cluster capacity: " + this.getClusterResource()));
        }
        this.eventLog.log("HEARTBEAT", nm.getHostName());
        FSSchedulerNode node = this.getFSSchedulerNode(nm.getNodeID());
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (nm.getState() == NodeState.DECOMMISSIONING) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeResourceUpdateEvent(nm.getNodeID(), ResourceOption.newInstance((Resource)this.getSchedulerNode(nm.getNodeID()).getUsedResource(), (int)0)));
        }
        if (this.continuousSchedulingEnabled) {
            if (!completedContainers.isEmpty()) {
                this.attemptScheduling(node);
            }
        } else {
            this.attemptScheduling(node);
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addNodeUpdateDuration(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continuousSchedulingAttempt() throws InterruptedException {
        List<FSSchedulerNode> nodeIdList;
        long start = this.getClock().getTime();
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            nodeIdList = this.nodeTracker.sortedNodeList(this.nodeAvailableResourceComparator);
        }
        for (FSSchedulerNode node : nodeIdList) {
            try {
                if (!Resources.fitsIn((Resource)this.minimumAllocation, (Resource)node.getAvailableResource())) continue;
                this.attemptScheduling(node);
            }
            catch (Throwable ex) {
                LOG.error((Object)("Error while attempting scheduling for node " + node + ": " + ex.toString()), ex);
                if (!(ex instanceof YarnRuntimeException) || !(ex.getCause() instanceof InterruptedException)) continue;
                throw (InterruptedException)ex.getCause();
            }
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addContinuousSchedulingRunDuration(duration);
    }

    private boolean shouldContinueAssigning(int containers, Resource maxResourcesToAssign, Resource assignedResource) {
        if (!this.assignMultiple) {
            return false;
        }
        if (this.maxAssignDynamic) {
            return Resources.fitsIn((Resource)assignedResource, (Resource)maxResourcesToAssign);
        }
        return this.maxAssign <= 0 || containers < this.maxAssign;
    }

    @VisibleForTesting
    synchronized void attemptScheduling(FSSchedulerNode node) {
        if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
            return;
        }
        NodeId nodeID = node.getNodeID();
        if (!this.nodeTracker.exists(nodeID)) {
            LOG.info((Object)("Skipping scheduling as the node " + nodeID + " has been removed"));
            return;
        }
        boolean validReservation = false;
        FSAppAttempt reservedAppSchedulable = node.getReservedAppSchedulable();
        if (reservedAppSchedulable != null) {
            validReservation = reservedAppSchedulable.assignReservedContainer(node);
        }
        if (!validReservation) {
            int assignedContainers = 0;
            Resource assignedResource = Resources.clone((Resource)Resources.none());
            Resource maxResourcesToAssign = Resources.multiply((Resource)node.getAvailableResource(), (double)0.5);
            while (node.getReservedContainer() == null) {
                boolean assignedContainer = false;
                Resource assignment = this.queueMgr.getRootQueue().assignContainer(node);
                if (!assignment.equals((Object)Resources.none())) {
                    ++assignedContainers;
                    assignedContainer = true;
                    Resources.addTo((Resource)assignedResource, (Resource)assignment);
                }
                if (assignedContainer && this.shouldContinueAssigning(assignedContainers, maxResourcesToAssign, assignedResource)) continue;
                break;
            }
        }
        this.updateRootQueueMetrics();
    }

    public FSAppAttempt getSchedulerApp(ApplicationAttemptId appAttemptId) {
        return (FSAppAttempt)super.getApplicationAttempt(appAttemptId);
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return RESOURCE_CALCULATOR;
    }

    private void updateRootQueueMetrics() {
        this.rootMetrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.getClusterResource(), (Resource)this.rootMetrics.getAllocatedResources()));
    }

    private boolean shouldAttemptPreemption() {
        if (this.context.isPreemptionEnabled()) {
            Resource clusterResource = this.getClusterResource();
            return this.context.getPreemptionUtilizationThreshold() < Math.max((float)this.rootMetrics.getAllocatedMB() / (float)clusterResource.getMemory(), (float)this.rootMetrics.getAllocatedVirtualCores() / (float)clusterResource.getVirtualCores());
        }
        return false;
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.rootMetrics;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                if (!(event instanceof AppAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationId(), appAddedEvent.getQueue(), appAddedEvent.getUser(), appAddedEvent.getIsAppRecovering());
                break;
            }
            case APP_REMOVED: {
                if (!(event instanceof AppRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.removeApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                if (!(event instanceof NodeResourceUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                if (!(event instanceof AppAttemptAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                if (!(event instanceof AppAttemptRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.removeApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case CONTAINER_EXPIRED: {
                if (!(event instanceof ContainerExpiredSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            case CONTAINER_RESCHEDULED: {
                if (!(event instanceof ContainerRescheduledEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerRescheduledEvent containerRescheduledEvent = (ContainerRescheduledEvent)event;
                RMContainer container = containerRescheduledEvent.getContainer();
                this.recoverResourceRequestForContainer(container);
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived at FairScheduler: " + event.toString()));
            }
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public synchronized void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScheduler(Configuration conf) throws IOException {
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            this.conf = new FairSchedulerConfiguration(conf);
            this.validateConf(this.conf);
            this.minimumAllocation = this.conf.getMinimumAllocation();
            this.initMaximumResourceCapability(this.conf.getMaximumAllocation());
            this.incrAllocation = this.conf.getIncrementAllocation();
            this.updateReservationThreshold();
            this.continuousSchedulingEnabled = this.conf.isContinuousSchedulingEnabled();
            this.continuousSchedulingSleepMs = this.conf.getContinuousSchedulingSleepMs();
            this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
            this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
            this.nodeLocalityDelayMs = this.conf.getLocalityDelayNodeMs();
            this.rackLocalityDelayMs = this.conf.getLocalityDelayRackMs();
            this.assignMultiple = this.conf.getAssignMultiple();
            this.maxAssignDynamic = this.conf.isMaxAssignDynamic();
            this.maxAssign = this.conf.getMaxAssign();
            this.sizeBasedWeight = this.conf.getSizeBasedWeight();
            this.usePortForNodeName = this.conf.getUsePortForNodeName();
            this.reservableNodesRatio = this.conf.getReservableNodes();
            this.updateInterval = this.conf.getUpdateInterval();
            if (this.updateInterval < 0L) {
                this.updateInterval = 500L;
                LOG.warn((Object)"yarn.scheduler.fair.update-interval-ms is invalid, so using default value 500 ms instead");
            }
            this.rootMetrics = FSQueueMetrics.forQueue("root", null, true, conf);
            this.fsOpDurations = FSOpDurations.getInstance(true);
            this.applications = new ConcurrentHashMap();
            this.eventLog = new FairSchedulerEventLog();
            this.eventLog.init(this.conf);
            this.allocConf = new AllocationConfiguration(conf);
            try {
                this.queueMgr.initialize(conf);
            }
            catch (Exception e) {
                throw new IOException("Failed to start FairScheduler", e);
            }
            this.updateThread = new UpdateThread();
            this.updateThread.setName("FairSchedulerUpdateThread");
            this.updateThread.setUncaughtExceptionHandler(new RMCriticalThreadUncaughtExceptionHandler(this.rmContext));
            this.updateThread.setDaemon(true);
            if (this.continuousSchedulingEnabled) {
                this.schedulingThread = new ContinuousSchedulingThread();
                this.schedulingThread.setName("FairSchedulerContinuousScheduling");
                this.schedulingThread.setUncaughtExceptionHandler(new RMCriticalThreadUncaughtExceptionHandler(this.rmContext));
                this.schedulingThread.setDaemon(true);
            }
            if (this.conf.getPreemptionEnabled()) {
                this.createPreemptionThread();
            }
        }
        this.allocsLoader.init(conf);
        this.allocsLoader.setReloadListener(new AllocationReloadListener());
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize FairScheduler", e);
        }
    }

    @VisibleForTesting
    protected void createPreemptionThread() {
        this.preemptionThread = new FSPreemptionThread(this);
        this.preemptionThread.setUncaughtExceptionHandler(new RMCriticalThreadUncaughtExceptionHandler(this.rmContext));
    }

    private void updateReservationThreshold() {
        Resource newThreshold;
        this.reservationThreshold = newThreshold = Resources.multiply((Resource)this.getIncrementResourceCapability(), (double)this.conf.getReservationThresholdIncrementMultiple());
    }

    private synchronized void startSchedulerThreads() {
        Preconditions.checkNotNull((Object)this.updateThread, (Object)"updateThread is null");
        Preconditions.checkNotNull((Object)((Object)this.allocsLoader), (Object)"allocsLoader is null");
        this.updateThread.start();
        if (this.continuousSchedulingEnabled) {
            Preconditions.checkNotNull((Object)this.schedulingThread, (Object)"schedulingThread is null");
            this.schedulingThread.start();
        }
        if (this.preemptionThread != null) {
            this.preemptionThread.start();
        }
        this.allocsLoader.start();
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        this.initScheduler(conf);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            if (this.updateThread != null) {
                this.updateThread.interrupt();
                this.updateThread.join(1000L);
            }
            if (this.continuousSchedulingEnabled && this.schedulingThread != null) {
                this.schedulingThread.interrupt();
                this.schedulingThread.join(1000L);
            }
            if (this.preemptionThread != null) {
                this.preemptionThread.interrupt();
                this.preemptionThread.join(1000L);
            }
            if (this.allocsLoader != null) {
                this.allocsLoader.stop();
            }
        }
        super.serviceStop();
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to reload allocations file", (Throwable)e);
        }
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        if (!this.queueMgr.exists(queueName)) {
            throw new IOException("queue " + queueName + " does not exist");
        }
        return this.queueMgr.getQueue(queueName).getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.queueMgr.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodeTracker.nodeCount();
    }

    @Override
    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        FSQueue queue = this.getQueueManager().getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    public AllocationConfiguration getAllocationConfiguration() {
        return this.allocConf;
    }

    private void applyChildDefaults() {
        Collection<FSQueue> queues = this.queueMgr.getQueues();
        Set<String> configuredLeafQueues = this.allocConf.getConfiguredQueues().get((Object)FSQueueType.LEAF);
        Set<String> configuredParentQueues = this.allocConf.getConfiguredQueues().get((Object)FSQueueType.PARENT);
        for (FSQueue queue : queues) {
            Resource max;
            if (queue.getParent() == null || configuredLeafQueues.contains(queue.getName()) || configuredParentQueues.contains(queue.getName()) || (max = this.allocConf.getMaxChildResources(queue.getParent().getName())) == null) continue;
            this.allocConf.setMaxResources(queue.getName(), max);
        }
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        FSQueue queue = this.queueMgr.getQueue(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String moveApplication(ApplicationId appId, String queueName) throws YarnException {
        FSAppAttempt attempt;
        SchedulerApplication app = (SchedulerApplication)this.applications.get(appId);
        if (app == null) {
            throw new YarnException("App to be moved " + appId + " not found.");
        }
        FSAppAttempt fSAppAttempt = attempt = (FSAppAttempt)app.getCurrentAppAttempt();
        synchronized (fSAppAttempt) {
            FSLeafQueue oldQueue = (FSLeafQueue)app.getQueue();
            if (attempt.isStopped()) {
                LOG.info((Object)("Application " + appId + " is stopped and can't be moved!"));
                throw new YarnException("Application " + appId + " is stopped and can't be moved!");
            }
            FSLeafQueue targetQueue = this.queueMgr.getLeafQueue(queueName, false);
            if (targetQueue == null) {
                throw new YarnException("Target queue " + queueName + " not found or is not a leaf queue.");
            }
            if (targetQueue == oldQueue) {
                return oldQueue.getQueueName();
            }
            if (oldQueue.isRunnableApp(attempt)) {
                this.verifyMoveDoesNotViolateConstraints(attempt, oldQueue, targetQueue);
            }
            this.executeMove(app, attempt, oldQueue, targetQueue);
            return targetQueue.getQueueName();
        }
    }

    private void verifyMoveDoesNotViolateConstraints(FSAppAttempt app, FSLeafQueue oldQueue, FSLeafQueue targetQueue) throws YarnException {
        String queueName = targetQueue.getQueueName();
        ApplicationAttemptId appAttId = app.getApplicationAttemptId();
        FSQueue lowestCommonAncestor = this.findLowestCommonAncestorQueue(oldQueue, targetQueue);
        Resource consumption = app.getCurrentConsumption();
        for (FSQueue cur = targetQueue; cur != lowestCommonAncestor; cur = cur.getParent()) {
            if (cur.getNumRunnableApps() == this.allocConf.getQueueMaxApps(cur.getQueueName())) {
                throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxRunningApps constraints on" + " queue " + cur.getQueueName());
            }
            if (Resources.fitsIn((Resource)Resources.add((Resource)cur.getResourceUsage(), (Resource)consumption), (Resource)cur.getMaxShare())) continue;
            throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxShare constraints on" + " queue " + cur.getQueueName());
        }
    }

    private void executeMove(SchedulerApplication<FSAppAttempt> app, FSAppAttempt attempt, FSLeafQueue oldQueue, FSLeafQueue newQueue) throws YarnException {
        boolean wasRunnable = oldQueue.isRunnableApp(attempt);
        boolean nowRunnable = this.maxRunningEnforcer.canAppBeRunnable(newQueue, attempt.getUser());
        if (wasRunnable && !nowRunnable) {
            throw new YarnException("Should have already verified that app " + attempt.getApplicationId() + " would be runnable in new queue");
        }
        oldQueue.removeApp(attempt);
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
        } else if (nowRunnable) {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
        attempt.move(newQueue);
        app.setQueue(newQueue);
        newQueue.addApp(attempt, nowRunnable);
        if (nowRunnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        }
        if (wasRunnable) {
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, oldQueue);
        }
    }

    @VisibleForTesting
    FSQueue findLowestCommonAncestorQueue(FSQueue queue1, FSQueue queue2) {
        String name1 = queue1.getName();
        String name2 = queue2.getName();
        int lastPeriodIndex = -1;
        for (int i = 0; i < Math.max(name1.length(), name2.length()); ++i) {
            if (name1.length() <= i || name2.length() <= i || name1.charAt(i) != name2.charAt(i)) {
                return this.queueMgr.getQueue(name1.substring(0, lastPeriodIndex));
            }
            if (name1.charAt(i) != '.') continue;
            lastPeriodIndex = i;
        }
        return queue1;
    }

    @Override
    public synchronized void updateNodeResource(RMNode nm, ResourceOption resourceOption) {
        super.updateNodeResource(nm, resourceOption);
        this.updateRootQueueMetrics();
        this.queueMgr.getRootQueue().setSteadyFairShare(this.getClusterResource());
        this.queueMgr.getRootQueue().recomputeSteadyShares();
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU);
    }

    public float getReservableNodesRatio() {
        return this.reservableNodesRatio;
    }

    long getNMHeartbeatInterval() {
        return this.nmHeartbeatInterval;
    }

    private class AllocationReloadListener
    implements AllocationFileLoaderService.Listener {
        private AllocationReloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReload(AllocationConfiguration queueInfo) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.allocConf = queueInfo;
                FairScheduler.this.allocConf.getDefaultSchedulingPolicy().initialize(FairScheduler.this.getContext());
                FairScheduler.this.queueMgr.updateAllocationConfiguration(FairScheduler.this.allocConf);
                FairScheduler.this.applyChildDefaults();
                FairScheduler.this.maxRunningEnforcer.updateRunnabilityOnReload();
            }
        }
    }

    private class NodeAvailableResourceComparator
    implements Comparator<FSSchedulerNode> {
        private NodeAvailableResourceComparator() {
        }

        @Override
        public int compare(FSSchedulerNode n1, FSSchedulerNode n2) {
            return RESOURCE_CALCULATOR.compare(FairScheduler.this.getClusterResource(), n2.getAvailableResource(), n1.getAvailableResource());
        }
    }

    private class ContinuousSchedulingThread
    extends Thread {
        private ContinuousSchedulingThread() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    FairScheduler.this.continuousSchedulingAttempt();
                    Thread.sleep(FairScheduler.this.getContinuousSchedulingSleepMs());
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Continuous scheduling thread interrupted. Exiting.", (Throwable)e);
                    return;
                }
            }
        }
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Object object = FairScheduler.this.updateThreadMonitor;
                    synchronized (object) {
                        FairScheduler.this.updateThreadMonitor.wait(FairScheduler.this.updateInterval);
                    }
                    long start = FairScheduler.this.getClock().getTime();
                    FairScheduler.this.update();
                    long duration = FairScheduler.this.getClock().getTime() - start;
                    FairScheduler.this.fsOpDurations.addUpdateCallDuration(duration);
                    FairScheduler.this.fsOpDurations.addUpdateThreadRunDuration(duration);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"Update thread interrupted. Exiting.");
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                }
            }
        }
    }
}

