/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.DialogButton;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.swt.custom.BasicDialog;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class SwtMessageBox
extends SwtElement
implements XulMessageBox {
    protected List<Button> buttonList = new ArrayList<Button>();
    private String message;
    private String title;
    private DialogButton[] defaultButtons = new DialogButton[]{DialogButton.ACCEPT};
    private Object[] buttons = this.defaultButtons;
    private Object icon = new Integer(2);
    private XulComponent parent;
    private Shell parentObject = null;
    private boolean scrollable = false;
    private String acceptLabel = "OK";
    private int buttonAlignment = 0x1000000;
    protected MessageBox dialog;
    protected Composite buttonArea;
    private int retVal = DialogButton.CANCEL.getId();

    public SwtMessageBox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("messagebox");
        this.parent = parent;
        this.parent.addChild((Element)this);
    }

    public SwtMessageBox(XulComponent parent, String message) {
        this(parent, message, null);
    }

    public SwtMessageBox(XulComponent parent, String message, String title) {
        this(parent, message, title, null);
    }

    public SwtMessageBox(XulComponent parent, String message, String title, Object[] buttons) {
        this(parent, message, title, buttons, new Integer(2));
    }

    public SwtMessageBox(XulComponent parent, String message, String title, Object[] buttons, Object icon) {
        super("messagebox");
        this.parent = parent;
        this.setMessage(message);
        this.setTitle(title);
        this.setIcon(icon);
        this.setButtons(buttons);
    }

    public Object[] getButtons() {
        return this.buttons;
    }

    private int getBitwiseStyle() {
        int style = 0;
        if (this.icon != null) {
            style |= ((Integer)this.icon).intValue();
        }
        int pos = 0;
        for (Object button : this.buttons) {
            style = button instanceof Integer ? (style |= ((Integer)button).intValue()) : (style |= pos);
            ++pos;
        }
        return style;
    }

    protected void createNewMessageBox() {
        Shell shell = this.getParentObject();
        this.dialog = new MessageBox(shell, this.getBitwiseStyle());
        this.dialog.setText(this.getTitle());
        this.dialog.setMessage(this.getMessage());
    }

    public void setDefaultButtons(BasicDialog d) {
    }

    protected String getButtonText(DialogButton button) {
        switch (button) {
            case ACCEPT: {
                return this.acceptLabel != null ? this.acceptLabel : button.getLabel();
            }
        }
        return button.getLabel();
    }

    public Object getIcon() {
        return this.icon;
    }

    public String getMessage() {
        if (this.message == null) {
            return "";
        }
        return this.message;
    }

    public String getTitle() {
        if (this.title == null) {
            return "Message:";
        }
        return this.title;
    }

    public void setButtons(Object[] buttons) {
        if (buttons == null) {
            return;
        }
        this.buttons = buttons;
    }

    public void setIcon(Object icon) {
        this.icon = icon;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int open() {
        this.createNewMessageBox();
        this.retVal = this.dialog.open();
        return this.retVal;
    }

    public void setScrollable(boolean scroll) {
        this.scrollable = scroll;
    }

    public void setModalParent(Object parent) {
        this.parentObject = (Shell)parent;
    }

    protected Shell getParentObject() {
        if (this.parentObject != null) {
            return this.parentObject;
        }
        if (this.getParent() instanceof SwtDialog) {
            return ((SwtDialog)this.getParent()).getShell();
        }
        return (Shell)this.getParent().getManagedObject();
    }

    public void setAcceptLabel(String label) {
        this.acceptLabel = label;
    }

    public void setButtonAlignment(int buttonAlignment) {
        this.buttonAlignment = buttonAlignment;
    }
}

