/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.pentaho.marketplace.util.web.HttpClientManager;
import org.pentaho.telemetry.TelemetryEvent;

public class TelemetryEventSender
implements Runnable {
    protected static final String FILE_EXT = ".tel";
    protected static final String LAST_SUBMISSION_DIR_NAME = "lastsubmission";
    private static final int DAYS_TO_KEEP_FILES = 5;
    private static final int BLOCK_SIZE = 50;
    private static final int HTTP_CALL_TIMEOUT = 30000;
    private static final HttpClientManager HTTP_CLIENT_MANAGER = HttpClientManager.getInstance();
    private static final Log logger = LogFactory.getLog(TelemetryEventSender.class);
    protected static HttpPost defaultHttpMethod;
    protected static HttpClient defaultHttpClient;
    private File telemetryDir;
    private File lastSubmissionDir;

    public Log getLogger() {
        return logger;
    }

    protected static HttpClient getHttpClient() {
        return defaultHttpClient != null ? defaultHttpClient : HTTP_CLIENT_MANAGER.createBuilder().setConnectionTimeout(30000).build();
    }

    protected static HttpPost getHttpMethod() {
        return defaultHttpMethod != null ? defaultHttpMethod : new HttpPost();
    }

    public File getTelemetryDir() {
        return this.telemetryDir;
    }

    public void setTelemetryDir(File telemetryDir) {
        this.telemetryDir = telemetryDir;
    }

    public File getLastSubmissionDir() {
        return this.lastSubmissionDir;
    }

    public void setLastSubmissionDir(File lastSubmissionDir) {
        if (!lastSubmissionDir.exists()) {
            lastSubmissionDir.mkdir();
        }
        this.lastSubmissionDir = lastSubmissionDir;
    }

    public TelemetryEventSender(File telemetryDir) {
        this.setTelemetryDir(telemetryDir);
        this.setLastSubmissionDir(new File(telemetryDir.getAbsolutePath() + "/" + LAST_SUBMISSION_DIR_NAME));
    }

    @Override
    public void run() {
        File[] submittedFiles;
        for (File f : submittedFiles = this.getLastSubmissionDir().listFiles()) {
            f.delete();
        }
        File[] unsubmittedRequests = this.getTelemetryDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(TelemetryEventSender.FILE_EXT);
            }
        });
        File[] block = new File[50];
        int blockIndex = 0;
        Calendar cld = Calendar.getInstance();
        cld.add(6, -5);
        for (File f : unsubmittedRequests) {
            if (f.lastModified() < cld.getTime().getTime()) {
                f.delete();
                continue;
            }
            if (blockIndex > 0 && blockIndex % 50 == 0) {
                this.sendRequest(block);
                block = new File[50];
                blockIndex = 0;
                continue;
            }
            block[blockIndex] = f;
            ++blockIndex;
        }
        if (blockIndex > 0) {
            this.sendRequest(block);
        }
    }

    protected void sendRequest(File[] blockToSend) {
        HashMap<String, StringBuffer> urlsAndPostData = new HashMap<String, StringBuffer>();
        HashMap<String, ArrayList<File>> urlsAndFiles = new HashMap<String, ArrayList<File>>();
        for (File f : blockToSend) {
            if (f == null) break;
            try {
                FileInputStream fin = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fin);
                TelemetryEvent event = (TelemetryEvent)ois.readObject();
                ois.close();
                StringBuffer postData = (StringBuffer)urlsAndPostData.get(event.getUrlToCall());
                if (postData == null) {
                    postData = new StringBuffer().append("[");
                } else {
                    postData.append(", ");
                }
                postData.append(event.encodeToJSON());
                urlsAndPostData.put(event.getUrlToCall(), postData);
                ArrayList<File> filesForThisUrl = (ArrayList<File>)urlsAndFiles.get(event.getUrlToCall());
                if (filesForThisUrl == null) {
                    filesForThisUrl = new ArrayList<File>();
                }
                filesForThisUrl.add(f);
                urlsAndFiles.put(event.getUrlToCall(), filesForThisUrl);
            }
            catch (EOFException eofe) {
                this.getLogger().warn((Object)"EOF caught while deserializing telemetry event. Probably a corrupt save. Deleting event.", (Throwable)eofe);
                f.delete();
            }
            catch (IOException ioe) {
                this.getLogger().error((Object)"Error caught while deserializing telemetry event.", (Throwable)ioe);
                f.delete();
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().error((Object)"Class not found while deserializing telemetry event.", (Throwable)cnfe);
            }
        }
        for (String url : urlsAndPostData.keySet()) {
            StringBuffer postData = (StringBuffer)urlsAndPostData.get(url);
            postData.append("]");
            postData.append(System.lineSeparator());
            boolean success = true;
            try {
                HttpClient httpClient = TelemetryEventSender.getHttpClient();
                HttpPost httpMethod = TelemetryEventSender.getHttpMethod();
                httpMethod.setURI(URI.create(url));
                httpMethod.setEntity((HttpEntity)new StringEntity(postData.toString(), ContentType.APPLICATION_JSON));
                this.getLogger().info((Object)("Calling " + url));
                this.getLogger().info((Object)("Data: " + postData.toString()));
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
                int resultCode = httpResponse.getStatusLine().getStatusCode();
                if (resultCode != 200) {
                    this.getLogger().error((Object)("Invalid Result Code Returned: " + resultCode));
                    success = false;
                } else {
                    HttpEntity entity = httpResponse.getEntity();
                    String resultXml = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    if (!resultXml.contains("<result>OK</result>")) {
                        this.getLogger().warn((Object)("Telemetry request had unexpected result: " + resultXml + "."));
                        success = false;
                    }
                }
                httpMethod.releaseConnection();
            }
            catch (Exception e) {
                this.getLogger().warn((Object)"Exception caught while making telemetry request.", (Throwable)e);
                success = false;
            }
            if (!success) continue;
            for (File f : blockToSend) {
                if (f == null) continue;
                File newFile = new File(this.getLastSubmissionDir(), f.getName());
                f.renameTo(newFile);
                f.delete();
            }
        }
    }
}

