/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.jsonoutput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputField;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class JsonOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = JsonOutputMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wGeneralTab;
    private CTabItem wFieldsTab;
    private FormData fdGeneralComp;
    private FormData fdFieldsComp;
    private Label wlEncoding;
    private ComboVar wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlOutputValue;
    private TextVar wOutputValue;
    private FormData fdlOutputValue;
    private FormData fdOutputValue;
    private Label wlCompatibilityMode;
    private Button wCompatibilityMode;
    private FormData fdlCompatibilityMode;
    private FormData fdCompatibilityMode;
    private Label wlBlocName;
    private TextVar wBlocName;
    private FormData fdlBlocName;
    private FormData fdBlocName;
    private Label wlNrRowsInBloc;
    private TextVar wNrRowsInBloc;
    private FormData fdlNrRowsInBloc;
    private FormData fdNrRowsInBloc;
    private TableView wFields;
    private FormData fdFields;
    private JsonOutputMeta input;
    private boolean gotEncodings = false;
    private boolean gotPreviousFields = false;
    private ColumnInfo[] colinf;
    private Label wlAddToResult;
    private Button wAddToResult;
    private FormData fdlAddToResult;
    private FormData fdAddToResult;
    private Group wFileName;
    private FormData fdFileName;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Label wlExtension;
    private TextVar wExtension;
    private FormData fdlExtension;
    private FormData fdExtension;
    private Label wlServletOutput;
    private Button wServletOutput;
    private FormData fdlServletOutput;
    private FormData fdServletOutput;
    private Label wlCreateParentFolder;
    private Button wCreateParentFolder;
    private FormData fdlCreateParentFolder;
    private FormData fdCreateParentFolder;
    private Label wlDoNotOpenNewFileInit;
    private Button wDoNotOpenNewFileInit;
    private FormData fdlDoNotOpenNewFileInit;
    private FormData fdDoNotOpenNewFileInit;
    private Label wlAddDate;
    private Button wAddDate;
    private FormData fdlAddDate;
    private FormData fdAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private FormData fdlAddTime;
    private FormData fdAddTime;
    private Button wbShowFiles;
    private FormData fdbShowFiles;
    private Label wlAppend;
    private Button wAppend;
    private FormData fdlAppend;
    private FormData fdAppend;
    private Label wlOperation;
    private CCombo wOperation;
    private FormData fdlOperation;
    private FormData fdOperation;
    private Group wSettings;
    private FormData fdSettings;
    private Map<String, Integer> inputFields;

    public JsonOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (JsonOutputMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.GeneralTab.TabTitle", (String[])new String[0]));
        FormLayout GeneralLayout = new FormLayout();
        GeneralLayout.marginWidth = 3;
        GeneralLayout.marginHeight = 3;
        Composite wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        wGeneralComp.setLayout((Layout)GeneralLayout);
        this.wlOperation = new Label(wGeneralComp, 131072);
        this.wlOperation.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOperation);
        this.fdlOperation = new FormData();
        this.fdlOperation.left = new FormAttachment(0, 0);
        this.fdlOperation.right = new FormAttachment(middle, -margin);
        this.fdlOperation.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        this.wlOperation.setLayoutData((Object)this.fdlOperation);
        this.wOperation = new CCombo(wGeneralComp, 2056);
        this.props.setLook((Control)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        this.fdOperation = new FormData();
        this.fdOperation.left = new FormAttachment(middle, 0);
        this.fdOperation.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        this.fdOperation.right = new FormAttachment(100, -margin);
        this.wOperation.setLayoutData((Object)this.fdOperation);
        this.wOperation.setItems(JsonOutputMeta.operationTypeDesc);
        this.wOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.updateOperation();
            }
        });
        this.wSettings = new Group(wGeneralComp, 32);
        this.props.setLook((Control)this.wSettings);
        this.wSettings.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Group.Settings.Label", (String[])new String[0]));
        FormLayout groupFileLayout = new FormLayout();
        groupFileLayout.marginWidth = 10;
        groupFileLayout.marginHeight = 10;
        this.wSettings.setLayout((Layout)groupFileLayout);
        this.wlBlocName = new Label((Composite)this.wSettings, 131072);
        this.wlBlocName.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.BlocName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBlocName);
        this.fdlBlocName = new FormData();
        this.fdlBlocName.left = new FormAttachment(0, 0);
        this.fdlBlocName.top = new FormAttachment((Control)this.wOperation, margin);
        this.fdlBlocName.right = new FormAttachment(middle, -margin);
        this.wlBlocName.setLayoutData((Object)this.fdlBlocName);
        this.wBlocName = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettings, 2056);
        this.wBlocName.setEditable(true);
        this.props.setLook((Control)this.wBlocName);
        this.wBlocName.addModifyListener(lsMod);
        this.fdBlocName = new FormData();
        this.fdBlocName.left = new FormAttachment(middle, 0);
        this.fdBlocName.top = new FormAttachment((Control)this.wOperation, margin);
        this.fdBlocName.right = new FormAttachment(100, 0);
        this.wBlocName.setLayoutData((Object)this.fdBlocName);
        this.wlNrRowsInBloc = new Label((Composite)this.wSettings, 131072);
        this.wlNrRowsInBloc.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.NrRowsInBloc.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNrRowsInBloc);
        this.fdlNrRowsInBloc = new FormData();
        this.fdlNrRowsInBloc.left = new FormAttachment(0, 0);
        this.fdlNrRowsInBloc.top = new FormAttachment((Control)this.wBlocName, margin);
        this.fdlNrRowsInBloc.right = new FormAttachment(middle, -margin);
        this.wlNrRowsInBloc.setLayoutData((Object)this.fdlNrRowsInBloc);
        this.wNrRowsInBloc = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettings, 2056);
        this.wNrRowsInBloc.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.NrRowsInBloc.ToolTip", (String[])new String[0]));
        this.wNrRowsInBloc.setEditable(true);
        this.props.setLook((Control)this.wNrRowsInBloc);
        this.wNrRowsInBloc.addModifyListener(lsMod);
        this.fdNrRowsInBloc = new FormData();
        this.fdNrRowsInBloc.left = new FormAttachment(middle, 0);
        this.fdNrRowsInBloc.top = new FormAttachment((Control)this.wBlocName, margin);
        this.fdNrRowsInBloc.right = new FormAttachment(100, 0);
        this.wNrRowsInBloc.setLayoutData((Object)this.fdNrRowsInBloc);
        this.wlOutputValue = new Label((Composite)this.wSettings, 131072);
        this.wlOutputValue.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.OutputValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutputValue);
        this.fdlOutputValue = new FormData();
        this.fdlOutputValue.left = new FormAttachment(0, 0);
        this.fdlOutputValue.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        this.fdlOutputValue.right = new FormAttachment(middle, -margin);
        this.wlOutputValue.setLayoutData((Object)this.fdlOutputValue);
        this.wOutputValue = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettings, 2056);
        this.wOutputValue.setEditable(true);
        this.props.setLook((Control)this.wOutputValue);
        this.wOutputValue.addModifyListener(lsMod);
        this.fdOutputValue = new FormData();
        this.fdOutputValue.left = new FormAttachment(middle, 0);
        this.fdOutputValue.top = new FormAttachment((Control)this.wNrRowsInBloc, margin);
        this.fdOutputValue.right = new FormAttachment(100, 0);
        this.wOutputValue.setLayoutData((Object)this.fdOutputValue);
        this.wlCompatibilityMode = new Label((Composite)this.wSettings, 131072);
        this.wlCompatibilityMode.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CompatibilityMode.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCompatibilityMode);
        this.fdlCompatibilityMode = new FormData();
        this.fdlCompatibilityMode.left = new FormAttachment(0, 0);
        this.fdlCompatibilityMode.top = new FormAttachment((Control)this.wOutputValue, margin);
        this.fdlCompatibilityMode.right = new FormAttachment(middle, -margin);
        this.wlCompatibilityMode.setLayoutData((Object)this.fdlCompatibilityMode);
        this.wCompatibilityMode = new Button((Composite)this.wSettings, 32);
        this.wCompatibilityMode.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CompatibilityMode.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompatibilityMode);
        this.fdCompatibilityMode = new FormData();
        this.fdCompatibilityMode.left = new FormAttachment(middle, 0);
        this.fdCompatibilityMode.top = new FormAttachment((Control)this.wOutputValue, margin);
        this.fdCompatibilityMode.right = new FormAttachment(100, 0);
        this.wCompatibilityMode.setLayoutData((Object)this.fdCompatibilityMode);
        this.wCompatibilityMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.fdSettings = new FormData();
        this.fdSettings.left = new FormAttachment(0, margin);
        this.fdSettings.top = new FormAttachment((Control)this.wOperation, 2 * margin);
        this.fdSettings.right = new FormAttachment(100, -margin);
        this.wSettings.setLayoutData((Object)this.fdSettings);
        this.wFileName = new Group(wGeneralComp, 32);
        this.props.setLook((Control)this.wFileName);
        this.wFileName.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Group.File.Label", (String[])new String[0]));
        FormLayout groupfilenameayout = new FormLayout();
        groupfilenameayout.marginWidth = 10;
        groupfilenameayout.marginHeight = 10;
        this.wFileName.setLayout((Layout)groupfilenameayout);
        this.wlFilename = new Label((Composite)this.wFileName, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wSettings, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button((Composite)this.wFileName, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wSettings, 0);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JsonOutputDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.js", "*.JS", "*"});
                if (JsonOutputDialog.this.wFilename.getText() != null) {
                    dialog.setFileName(JsonOutputDialog.this.transMeta.environmentSubstitute(JsonOutputDialog.this.wFilename.getText()));
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String extension = JsonOutputDialog.this.wExtension.getText();
                    if (extension != null && dialog.getFileName() != null && dialog.getFileName().endsWith("." + extension)) {
                        String fileName = dialog.getFileName();
                        JsonOutputDialog.this.wFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + fileName.substring(0, fileName.length() - (extension.length() + 1)));
                    } else {
                        JsonOutputDialog.this.wFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName());
                    }
                }
            }
        });
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.wFileName, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.top = new FormAttachment((Control)this.wOutputValue, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData((Object)this.fdFilename);
        this.wlAppend = new Label((Composite)this.wFileName, 131072);
        this.wlAppend.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Append.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAppend);
        this.fdlAppend = new FormData();
        this.fdlAppend.left = new FormAttachment(0, 0);
        this.fdlAppend.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdlAppend.right = new FormAttachment(middle, -margin);
        this.wlAppend.setLayoutData((Object)this.fdlAppend);
        this.wAppend = new Button((Composite)this.wFileName, 32);
        this.wAppend.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Append.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAppend);
        this.fdAppend = new FormData();
        this.fdAppend.left = new FormAttachment(middle, 0);
        this.fdAppend.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdAppend.right = new FormAttachment(100, 0);
        this.wAppend.setLayoutData((Object)this.fdAppend);
        this.wAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlCreateParentFolder = new Label((Composite)this.wFileName, 131072);
        this.wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateParentFolder);
        this.fdlCreateParentFolder = new FormData();
        this.fdlCreateParentFolder.left = new FormAttachment(0, 0);
        this.fdlCreateParentFolder.top = new FormAttachment((Control)this.wAppend, margin);
        this.fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateParentFolder.setLayoutData((Object)this.fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)this.wFileName, 32);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateParentFolder);
        this.fdCreateParentFolder = new FormData();
        this.fdCreateParentFolder.left = new FormAttachment(middle, 0);
        this.fdCreateParentFolder.top = new FormAttachment((Control)this.wAppend, margin);
        this.fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)this.fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlDoNotOpenNewFileInit = new Label((Composite)this.wFileName, 131072);
        this.wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDoNotOpenNewFileInit);
        this.fdlDoNotOpenNewFileInit = new FormData();
        this.fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        this.fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        this.fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        this.wlDoNotOpenNewFileInit.setLayoutData((Object)this.fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button((Composite)this.wFileName, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDoNotOpenNewFileInit);
        this.fdDoNotOpenNewFileInit = new FormData();
        this.fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        this.fdDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        this.fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)this.fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlExtension = new Label((Composite)this.wFileName, 131072);
        this.wlExtension.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        this.props.setLook((Control)this.wlExtension);
        this.fdlExtension = new FormData();
        this.fdlExtension.left = new FormAttachment(0, 0);
        this.fdlExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdlExtension.right = new FormAttachment(middle, -margin);
        this.wlExtension.setLayoutData((Object)this.fdlExtension);
        this.wExtension = new TextVar((VariableSpace)this.transMeta, (Composite)this.wFileName, 18436);
        this.props.setLook((Control)this.wExtension);
        this.wExtension.addModifyListener(lsMod);
        this.fdExtension = new FormData();
        this.fdExtension.left = new FormAttachment(middle, 0);
        this.fdExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdExtension.right = new FormAttachment(100, -margin);
        this.wExtension.setLayoutData((Object)this.fdExtension);
        this.wlEncoding = new Label((Composite)this.wFileName, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment((Control)this.wExtension, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new ComboVar((VariableSpace)this.transMeta, (Composite)this.wFileName, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment((Control)this.wExtension, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)JsonOutputDialog.this.shell.getDisplay(), 1);
                JsonOutputDialog.this.shell.setCursor(busy);
                JsonOutputDialog.this.setEncodings();
                JsonOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlServletOutput = new Label((Composite)this.wFileName, 131072);
        this.wlServletOutput.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.ServletOutput.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlServletOutput);
        this.fdlServletOutput = new FormData();
        this.fdlServletOutput.left = new FormAttachment(0, 0);
        this.fdlServletOutput.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdlServletOutput.right = new FormAttachment(middle, -margin);
        this.wlServletOutput.setLayoutData((Object)this.fdlServletOutput);
        this.wServletOutput = new Button((Composite)this.wFileName, 32);
        this.wServletOutput.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.ServletOutput.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServletOutput);
        this.fdServletOutput = new FormData();
        this.fdServletOutput.left = new FormAttachment(middle, 0);
        this.fdServletOutput.top = new FormAttachment((Control)this.wEncoding, margin);
        this.fdServletOutput.right = new FormAttachment(100, 0);
        this.wServletOutput.setLayoutData((Object)this.fdServletOutput);
        this.wServletOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
                JsonOutputDialog.this.setFlagsServletOption();
            }
        });
        this.wlAddDate = new Label((Composite)this.wFileName, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddDate);
        this.fdlAddDate = new FormData();
        this.fdlAddDate.left = new FormAttachment(0, 0);
        this.fdlAddDate.top = new FormAttachment((Control)this.wServletOutput, margin);
        this.fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)this.fdlAddDate);
        this.wAddDate = new Button((Composite)this.wFileName, 32);
        this.props.setLook((Control)this.wAddDate);
        this.fdAddDate = new FormData();
        this.fdAddDate.left = new FormAttachment(middle, 0);
        this.fdAddDate.top = new FormAttachment((Control)this.wServletOutput, margin);
        this.fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)this.fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddTime = new Label((Composite)this.wFileName, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTime);
        this.fdlAddTime = new FormData();
        this.fdlAddTime.left = new FormAttachment(0, 0);
        this.fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        this.fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)this.fdlAddTime);
        this.wAddTime = new Button((Composite)this.wFileName, 32);
        this.props.setLook((Control)this.wAddTime);
        this.fdAddTime = new FormData();
        this.fdAddTime.left = new FormAttachment(middle, 0);
        this.fdAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        this.fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)this.fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputDialog.this.input.setChanged();
            }
        });
        this.wbShowFiles = new Button((Composite)this.wFileName, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.ShowFiles.Button", (String[])new String[0]));
        this.fdbShowFiles = new FormData();
        this.fdbShowFiles.left = new FormAttachment(middle, 0);
        this.fdbShowFiles.top = new FormAttachment((Control)this.wAddTime, margin * 2);
        this.wbShowFiles.setLayoutData((Object)this.fdbShowFiles);
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsonOutputMeta tfoi = new JsonOutputMeta();
                JsonOutputDialog.this.getInfo(tfoi);
                String[] files = tfoi.getFiles((VariableSpace)JsonOutputDialog.this.transMeta);
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(JsonOutputDialog.this.shell, files, BaseMessages.getString((Class)PKG, (String)"JsonOutputDialog.SelectOutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"JsonOutputDialog.SelectOutputFiles.DialogMessage", (String[])new String[0]));
                    esd.setViewOnly();
                    esd.open();
                } else {
                    MessageBox mb = new MessageBox(JsonOutputDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString((Class)PKG, (String)"JsonOutputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString((Class)PKG, (String)"System.DialogTitle.Error", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        this.wlAddToResult = new Label((Composite)this.wFileName, 131072);
        this.wlAddToResult.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddToResult);
        this.fdlAddToResult = new FormData();
        this.fdlAddToResult.left = new FormAttachment(0, 0);
        this.fdlAddToResult.top = new FormAttachment((Control)this.wbShowFiles, margin);
        this.fdlAddToResult.right = new FormAttachment(middle, -margin);
        this.wlAddToResult.setLayoutData((Object)this.fdlAddToResult);
        this.wAddToResult = new Button((Composite)this.wFileName, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        this.fdAddToResult = new FormData();
        this.fdAddToResult.left = new FormAttachment(middle, 0);
        this.fdAddToResult.top = new FormAttachment((Control)this.wbShowFiles, margin);
        this.fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)this.fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                JsonOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        this.fdFileName = new FormData();
        this.fdFileName.left = new FormAttachment(0, margin);
        this.fdFileName.top = new FormAttachment((Control)this.wSettings, 2 * margin);
        this.fdFileName.right = new FormAttachment(100, -margin);
        this.wFileName.setLayoutData((Object)this.fdFileName);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)wGeneralComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Get.Button", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Get.Tooltip", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wGet}, margin, null);
        int FieldsRows = this.input.getOutputFields().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JsonOutputDialog.ElementName.Column", (String[])new String[0]), 1, false)};
        this.colinf[1].setUsingVariables(true);
        this.wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = JsonOutputDialog.this.transMeta.findStep(JsonOutputDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = JsonOutputDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            JsonOutputDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        JsonOutputDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        JsonOutputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JsonOutputDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                JsonOutputDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JsonOutputDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JsonOutputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JsonOutputDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = JsonOutputDialog.this.shell.getSize();
                JsonOutputDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((JsonOutputDialog)JsonOutputDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                JsonOutputDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.updateOperation();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setFlagsServletOption() {
        boolean enableFilename = !this.wServletOutput.getSelection();
        this.wlFilename.setEnabled(enableFilename);
        this.wFilename.setEnabled(enableFilename);
        this.wlDoNotOpenNewFileInit.setEnabled(enableFilename);
        this.wDoNotOpenNewFileInit.setEnabled(enableFilename);
        this.wlCreateParentFolder.setEnabled(enableFilename);
        this.wCreateParentFolder.setEnabled(enableFilename);
        this.wlExtension.setEnabled(enableFilename);
        this.wExtension.setEnabled(enableFilename);
        this.wlAddDate.setEnabled(enableFilename);
        this.wAddDate.setEnabled(enableFilename);
        this.wlAddTime.setEnabled(enableFilename);
        this.wAddTime.setEnabled(enableFilename);
        this.wlAppend.setEnabled(enableFilename);
        this.wAppend.setEnabled(enableFilename);
        this.wbShowFiles.setEnabled(enableFilename);
        this.wlAddToResult.setEnabled(enableFilename);
        this.wAddToResult.setEnabled(enableFilename);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            } else {
                this.wEncoding.select(Const.indexOfString((String)"UTF-8", (String[])this.wEncoding.getItems()));
            }
        }
    }

    public void getData() {
        this.wBlocName.setText(Const.NVL((String)this.input.getJsonBloc(), (String)""));
        this.wNrRowsInBloc.setText(Const.NVL((String)this.input.getNrRowsInBloc(), (String)""));
        this.wEncoding.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wOutputValue.setText(Const.NVL((String)this.input.getOutputValue(), (String)""));
        this.wCompatibilityMode.setSelection(this.input.isCompatibilityMode());
        this.wOperation.setText(JsonOutputMeta.getOperationTypeDesc(this.input.getOperationType()));
        this.wFilename.setText(Const.NVL((String)this.input.getFileName(), (String)""));
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wExtension.setText(Const.NVL((String)this.input.getExtension(), (String)"js"));
        this.wServletOutput.setSelection(this.input.isServletOutput());
        this.setFlagsServletOption();
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wAppend.setSelection(this.input.isFileAppended());
        this.wEncoding.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wAddToResult.setSelection(this.input.AddToResult());
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            JsonOutputField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getFieldName(), (String)""));
            item.setText(2, Const.NVL((String)field.getElementName(), (String)""));
        }
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(JsonOutputMeta jsometa) {
        jsometa.setJsonBloc(this.wBlocName.getText());
        jsometa.setNrRowsInBloc(this.wNrRowsInBloc.getText());
        jsometa.setEncoding(this.wEncoding.getText());
        jsometa.setOutputValue(this.wOutputValue.getText());
        jsometa.setCompatibilityMode(this.wCompatibilityMode.getSelection());
        jsometa.setOperationType(JsonOutputMeta.getOperationTypeByDesc(this.wOperation.getText()));
        jsometa.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        jsometa.setFileName(this.wFilename.getText());
        jsometa.setExtension(this.wExtension.getText());
        jsometa.setServletOutput(this.wServletOutput.getSelection());
        jsometa.setFileAppended(this.wAppend.getSelection());
        jsometa.setDateInFilename(this.wAddDate.getSelection());
        jsometa.setTimeInFilename(this.wAddTime.getSelection());
        jsometa.setEncoding(this.wEncoding.getText());
        jsometa.setAddToResult(this.wAddToResult.getSelection());
        jsometa.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        jsometa.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            JsonOutputField field = new JsonOutputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setFieldName(item.getText(1));
            field.setElementName(item.getText(2));
            jsometa.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        if (this.gotPreviousFields) {
            return;
        }
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)5, (int)6, (TableItemInsertListener)new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.isNumber() && v.getLength() > 0) {
                            int m;
                            int le = v.getLength();
                            int pr = v.getPrecision();
                            if (v.getPrecision() <= 0) {
                                pr = 0;
                            }
                            String mask = " ";
                            for (m = 0; m < le - pr; ++m) {
                                mask = mask + "0";
                            }
                            if (pr > 0) {
                                mask = mask + ".";
                            }
                            for (m = 0; m < pr; ++m) {
                                mask = mask + "0";
                            }
                            tableItem.setText(4, mask);
                        }
                        return true;
                    }
                });
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void updateOperation() {
        int opType = JsonOutputMeta.getOperationTypeByDesc(this.wOperation.getText());
        boolean activeFile = opType != 0;
        this.wlFilename.setEnabled(activeFile);
        this.wFilename.setEnabled(activeFile);
        this.wbFilename.setEnabled(activeFile);
        this.wlExtension.setEnabled(activeFile);
        this.wExtension.setEnabled(activeFile);
        this.wlEncoding.setEnabled(activeFile);
        this.wEncoding.setEnabled(activeFile);
        this.wlAppend.setEnabled(activeFile);
        this.wAppend.setEnabled(activeFile);
        this.wlCreateParentFolder.setEnabled(activeFile);
        this.wCreateParentFolder.setEnabled(activeFile);
        this.wlDoNotOpenNewFileInit.setEnabled(activeFile);
        this.wDoNotOpenNewFileInit.setEnabled(activeFile);
        this.wlAddDate.setEnabled(activeFile);
        this.wAddDate.setEnabled(activeFile);
        this.wlAddTime.setEnabled(activeFile);
        this.wAddTime.setEnabled(activeFile);
        this.wlAddToResult.setEnabled(activeFile);
        this.wAddToResult.setEnabled(activeFile);
        this.wbShowFiles.setEnabled(activeFile);
        this.wlServletOutput.setEnabled(opType == 1 || opType == 2);
        this.wServletOutput.setEnabled(opType == 1 || opType == 2);
        boolean activeOutputValue = JsonOutputMeta.getOperationTypeByDesc(this.wOperation.getText()) != 1;
        this.wlOutputValue.setEnabled(activeOutputValue);
        this.wOutputValue.setEnabled(activeOutputValue);
        this.setFlagsServletOption();
    }
}

