/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.analyzer;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class JsonInputAnalyzer
extends ExternalResourceStepAnalyzer<JsonInputMeta> {
    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(JsonInputMeta.class);
        return supportedSteps;
    }

    public String getResourceInputNodeType() {
        return "JSON Field";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected Set<StepField> getUsedFields(JsonInputMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (meta.isAcceptingFilenames() && StringUtils.isNotEmpty((String)meta.getAcceptingField())) {
            Set inpusStepNames = this.getInputStepNames((BaseStepMeta)meta, meta.getAcceptingField());
            for (String inpusStepName : inpusStepNames) {
                StepField stepField = new StepField(inpusStepName, meta.getAcceptingField());
                usedFields.add(stepField);
            }
        }
        return usedFields;
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor, "JSON File");
    }

    protected void customAnalyze(JsonInputMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        super.customAnalyze((BaseStepMeta)meta, rootNode);
        if (meta.isAcceptingFilenames()) {
            rootNode.setProperty("sourceField", (Object)meta.getAcceptingField());
            rootNode.setProperty("sourceFieldIsFile", (Object)meta.getIsAFile());
            rootNode.setProperty("sourceFieldIsUrl", (Object)meta.isReadUrl());
            rootNode.setProperty("removeSourceField", (Object)meta.isRemoveSourceField());
        } else {
            rootNode.setProperty("fileDirName", (Object)meta.getFilenameField());
        }
    }
}

