/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.jdbc.ClosedOrCancelledStatementException;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.jdbc.HiveQueryResultSet;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.logs.InPlaceUpdateStream;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCancelOperationReq;
import org.apache.hive.service.cli.thrift.TCancelOperationResp;
import org.apache.hive.service.cli.thrift.TCloseOperationReq;
import org.apache.hive.service.cli.thrift.TCloseOperationResp;
import org.apache.hive.service.cli.thrift.TExecuteStatementReq;
import org.apache.hive.service.cli.thrift.TExecuteStatementResp;
import org.apache.hive.service.cli.thrift.TFetchOrientation;
import org.apache.hive.service.cli.thrift.TFetchResultsReq;
import org.apache.hive.service.cli.thrift.TFetchResultsResp;
import org.apache.hive.service.cli.thrift.TGetOperationStatusReq;
import org.apache.hive.service.cli.thrift.TGetOperationStatusResp;
import org.apache.hive.service.cli.thrift.TOperationHandle;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.TRowSet;
import org.apache.hive.service.cli.thrift.TSessionHandle;

public class HiveStatement
implements Statement {
    public static final Log LOG = LogFactory.getLog((String)HiveStatement.class.getName());
    private final HiveConnection connection;
    private TCLIService.Iface client;
    private TOperationHandle stmtHandle = null;
    private final TSessionHandle sessHandle;
    Map<String, String> sessConf = new HashMap<String, String>();
    private int fetchSize = 1000;
    private boolean isScrollableResultset = false;
    private boolean isOperationComplete = false;
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private boolean isQueryClosed = false;
    private boolean isLogBeingGenerated = true;
    private boolean isExecuteStatementFailed = false;
    private int queryTimeout = 0;
    private InPlaceUpdateStream inPlaceUpdateStream = InPlaceUpdateStream.NO_OP;

    public HiveStatement(HiveConnection connection, TCLIService.Iface client, TSessionHandle sessHandle) {
        this(connection, client, sessHandle, false);
    }

    public HiveStatement(HiveConnection connection, TCLIService.Iface client, TSessionHandle sessHandle, boolean isScrollableResultset) {
        this.connection = connection;
        this.client = client;
        this.sessHandle = sessHandle;
        this.isScrollableResultset = isScrollableResultset;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.stmtHandle != null) {
                TCancelOperationReq cancelReq = new TCancelOperationReq(this.stmtHandle);
                TCancelOperationResp cancelResp = this.client.CancelOperation(cancelReq);
                Utils.verifySuccessWithInfo(cancelResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString(), "08S01", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    void closeClientOperation() throws SQLException {
        try {
            if (this.stmtHandle != null) {
                TCloseOperationReq closeReq = new TCloseOperationReq(this.stmtHandle);
                TCloseOperationResp closeResp = this.client.CloseOperation(closeReq);
                Utils.verifySuccessWithInfo(closeResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.toString(), "08S01", e);
        }
        this.isQueryClosed = true;
        this.isExecuteStatementFailed = false;
        this.stmtHandle = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.client = null;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.runAsyncOnServer(sql);
        this.waitForOperationToComplete();
        if (!this.stmtHandle.isHasResultSet()) {
            return false;
        }
        this.resultSet = new HiveQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).build();
        return true;
    }

    public boolean executeAsync(String sql) throws SQLException {
        this.runAsyncOnServer(sql);
        if (!this.stmtHandle.isHasResultSet()) {
            return false;
        }
        this.resultSet = new HiveQueryResultSet.Builder(this).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(this.stmtHandle).setMaxRows(this.maxRows).setFetchSize(this.fetchSize).setScrollable(this.isScrollableResultset).build();
        return true;
    }

    private void runAsyncOnServer(String sql) throws SQLException {
        this.checkConnection("execute");
        this.closeClientOperation();
        this.initFlags();
        TExecuteStatementReq execReq = new TExecuteStatementReq(this.sessHandle, sql);
        execReq.setRunAsync(true);
        execReq.setConfOverlay(this.sessConf);
        execReq.setQueryTimeout((long)this.queryTimeout);
        try {
            TExecuteStatementResp execResp = this.client.ExecuteStatement(execReq);
            Utils.verifySuccessWithInfo(execResp.getStatus());
            this.stmtHandle = execResp.getOperationHandle();
            this.isExecuteStatementFailed = false;
        }
        catch (SQLException eS) {
            this.isExecuteStatementFailed = true;
            throw eS;
        }
        catch (Exception ex) {
            this.isExecuteStatementFailed = true;
            throw new SQLException(ex.toString(), "08S01", ex);
        }
    }

    void waitForOperationToComplete() throws SQLException {
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(this.stmtHandle);
        boolean shouldGetProgressUpdate = this.inPlaceUpdateStream != InPlaceUpdateStream.NO_OP;
        LOG.debug((Object)("requesting progress response :" + shouldGetProgressUpdate));
        statusReq.setGetProgressUpdate(shouldGetProgressUpdate);
        if (!shouldGetProgressUpdate) {
            this.inPlaceUpdateStream.getEventNotifier().progressBarCompleted();
        }
        while (!this.isOperationComplete) {
            try {
                TGetOperationStatusResp statusResp = this.client.GetOperationStatus(statusReq);
                this.inPlaceUpdateStream.update(statusResp.getProgressUpdateResponse());
                LOG.debug((Object)("Progress Bar Response Received: " + statusResp.getProgressUpdateResponse()));
                Utils.verifySuccessWithInfo(statusResp.getStatus());
                if (!statusResp.isSetOperationState()) continue;
                switch (statusResp.getOperationState()) {
                    case CLOSED_STATE: 
                    case FINISHED_STATE: {
                        this.isOperationComplete = true;
                        this.isLogBeingGenerated = false;
                        break;
                    }
                    case CANCELED_STATE: {
                        throw new SQLException("Query was cancelled", "01000");
                    }
                    case TIMEDOUT_STATE: {
                        throw new SQLTimeoutException("Query timed out after " + this.queryTimeout + " seconds");
                    }
                    case ERROR_STATE: {
                        throw new SQLException(statusResp.getErrorMessage(), statusResp.getSqlState(), statusResp.getErrorCode());
                    }
                    case UKNOWN_STATE: {
                        throw new SQLException("Unknown query", "HY000");
                    }
                }
            }
            catch (SQLException e) {
                this.isLogBeingGenerated = false;
                throw e;
            }
            catch (Exception e) {
                this.isLogBeingGenerated = false;
                throw new SQLException(e.toString(), "08S01", e);
            }
        }
        this.inPlaceUpdateStream.getEventNotifier().progressBarCompleted();
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't " + action + " after statement has been closed");
        }
    }

    private void initFlags() {
        this.isCancelled = false;
        this.isQueryClosed = false;
        this.isLogBeingGenerated = true;
        this.isExecuteStatementFailed = false;
        this.isOperationComplete = false;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection("getConnection");
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkConnection("getQueryTimeout");
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkConnection("getUpdateCount");
        this.waitForOperationToComplete();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection("getWarnings");
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            throw new SQLException("Method not supported");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException("Not supported direction " + direction);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection("setFetchSize");
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkConnection("setMaxRows");
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    public boolean hasMoreLogs() {
        return this.isLogBeingGenerated;
    }

    public List<String> getQueryLog() throws SQLException, ClosedOrCancelledStatementException {
        return this.getQueryLog(true, this.fetchSize);
    }

    public List<String> getQueryLog(boolean incremental, int fetchSize) throws SQLException, ClosedOrCancelledStatementException {
        this.checkConnection("getQueryLog");
        if (this.isCancelled) {
            throw new ClosedOrCancelledStatementException("Method getQueryLog() failed. The statement has been closed or cancelled.");
        }
        ArrayList<String> logs = new ArrayList<String>();
        TFetchResultsResp tFetchResultsResp = null;
        try {
            if (this.stmtHandle == null) {
                if (this.isQueryClosed) {
                    throw new ClosedOrCancelledStatementException("Method getQueryLog() failed. The statement has been closed or cancelled.");
                }
                if (this.isExecuteStatementFailed) {
                    throw new SQLException("Method getQueryLog() failed. Because the stmtHandle in HiveStatement is null and the statement execution might fail.");
                }
                return logs;
            }
            TFetchResultsReq tFetchResultsReq = new TFetchResultsReq(this.stmtHandle, this.getFetchOrientation(incremental), (long)fetchSize);
            tFetchResultsReq.setFetchType((short)1);
            tFetchResultsResp = this.client.FetchResults(tFetchResultsReq);
            Utils.verifySuccessWithInfo(tFetchResultsResp.getStatus());
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Error when getting query log: " + e, e);
        }
        RowSet rowSet = RowSetFactory.create((TRowSet)tFetchResultsResp.getResults(), (TProtocolVersion)this.connection.getProtocol());
        for (Object[] row : rowSet) {
            logs.add(String.valueOf(row[0]));
        }
        return logs;
    }

    private TFetchOrientation getFetchOrientation(boolean incremental) {
        if (incremental) {
            return TFetchOrientation.FETCH_NEXT;
        }
        return TFetchOrientation.FETCH_FIRST;
    }

    public String getYarnATSGuid() {
        if (this.stmtHandle != null) {
            String guid64 = Base64.encodeBase64URLSafeString((byte[])this.stmtHandle.getOperationId().getGuid()).trim();
            return guid64;
        }
        return null;
    }

    public void setInPlaceUpdateStream(InPlaceUpdateStream stream) {
        this.inPlaceUpdateStream = stream;
    }
}

