/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.annotations.PluginDialog;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.mqtt.MQTTProducerMeta;
import org.pentaho.di.trans.step.mqtt.MqttDialogOptionsLayout;
import org.pentaho.di.trans.step.mqtt.MqttDialogSecurityLayout;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

@PluginDialog(id="MQTTProducer", image="MQTTProducer.svg", pluginType=PluginDialog.PluginType.STEP)
public class MQTTProducerDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final int SHELL_MIN_WIDTH = 527;
    private static final int SHELL_MIN_HEIGHT = 650;
    private static final int INPUT_WIDTH = 350;
    private static Class<?> PKG = MQTTProducerDialog.class;
    private MQTTProducerMeta meta;
    private ModifyListener lsMod;
    private TextVar wMqttServer;
    private TextVar wClientId;
    private TextVar wTopic;
    private ComboVar wQOS;
    private ComboVar wMessageField;
    private CTabFolder wTabFolder;
    private MqttDialogSecurityLayout securityLayout;
    private MqttDialogOptionsLayout optionsLayout;

    public MQTTProducerDialog(Shell parent, Object in, TransMeta transMeta, String stepname) {
        super(parent, (BaseStepMeta)in, transMeta, stepname);
        this.meta = (MQTTProducerMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.changed = this.meta.hasChanged();
        this.lsMod = e -> this.meta.setChanged();
        this.lsCancel = e -> this.cancel();
        this.lsOK = e -> this.ok();
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MQTTProducerDialog.this.ok();
            }
        };
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.shell.setMinimumSize(527, 650);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MQTTProducerDialog.this.cancel();
            }
        });
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        Label topSeparator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData((Object)fdSpacer);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        this.wOK.addListener(13, this.lsOK);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)bottomSeparator);
        FormData fdBottomSeparator = new FormData();
        fdBottomSeparator.height = 2;
        fdBottomSeparator.left = new FormAttachment(0, 0);
        fdBottomSeparator.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdBottomSeparator.right = new FormAttachment(100, 0);
        bottomSeparator.setLayoutData((Object)fdBottomSeparator);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)topSeparator, 15);
        fdTabFolder.bottom = new FormAttachment((Control)bottomSeparator, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.buildSetupTab();
        this.securityLayout = new MqttDialogSecurityLayout(this.props, this.wTabFolder, this.meta.getUsername(), this.meta.getPassword(), this.lsMod, this.transMeta, this.meta.getSslConfig(), this.meta.isUseSsl());
        this.securityLayout.buildSecurityTab();
        this.optionsLayout = new MqttDialogOptionsLayout(this.props, this.wTabFolder, this.lsMod, this.transMeta, this.meta.retrieveOptions());
        this.optionsLayout.buildTab();
        this.getData();
        this.setSize();
        this.meta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void buildSetupTab() {
        CTabItem wSetupTab = new CTabItem(this.wTabFolder, 0);
        wSetupTab.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.SetupTab", (String[])new String[0]));
        Composite wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        Label wlMqttServer = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlMqttServer);
        wlMqttServer.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.Connection", (String[])new String[0]));
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment(0, 0);
        fdlBootstrapServers.top = new FormAttachment(0, 0);
        fdlBootstrapServers.right = new FormAttachment(0, 350);
        wlMqttServer.setLayoutData((Object)fdlBootstrapServers);
        this.wMqttServer = new TextVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wMqttServer);
        this.wMqttServer.addModifyListener(this.lsMod);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment(0, 0);
        fdBootstrapServers.top = new FormAttachment((Control)wlMqttServer, 5);
        fdBootstrapServers.right = new FormAttachment(0, 350);
        this.wMqttServer.setLayoutData((Object)fdBootstrapServers);
        Label wlClientId = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlClientId);
        wlClientId.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.ClientId", (String[])new String[0]));
        FormData fdlClientId = new FormData();
        fdlClientId.left = new FormAttachment(0, 0);
        fdlClientId.top = new FormAttachment((Control)this.wMqttServer, 10);
        fdlClientId.right = new FormAttachment(50, 0);
        wlClientId.setLayoutData((Object)fdlClientId);
        this.wClientId = new TextVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wClientId);
        this.wClientId.addModifyListener(this.lsMod);
        FormData fdClientId = new FormData();
        fdClientId.left = new FormAttachment(0, 0);
        fdClientId.top = new FormAttachment((Control)wlClientId, 5);
        fdClientId.right = new FormAttachment(0, 350);
        this.wClientId.setLayoutData((Object)fdClientId);
        Label wlTopic = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlTopic);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.Topic", (String[])new String[0]));
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)this.wClientId, 10);
        fdlTopic.width = 200;
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wTopic = new TextVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wTopic);
        this.wTopic.addModifyListener(this.lsMod);
        FormData fdTopic = new FormData();
        fdTopic.left = new FormAttachment(0, 0);
        fdTopic.top = new FormAttachment((Control)wlTopic, 5);
        fdTopic.width = 200;
        this.wTopic.setLayoutData((Object)fdTopic);
        Label wlQOS = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlQOS);
        wlQOS.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.QOS", (String[])new String[0]));
        FormData fdlQOS = new FormData();
        fdlQOS.left = new FormAttachment((Control)wlTopic, 15);
        fdlQOS.top = new FormAttachment((Control)this.wClientId, 10);
        fdlQOS.width = 120;
        wlQOS.setLayoutData((Object)fdlQOS);
        this.wQOS = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wQOS);
        this.wQOS.addModifyListener(this.lsMod);
        FormData fdQOS = new FormData();
        fdQOS.left = new FormAttachment((Control)this.wTopic, 15);
        fdQOS.top = new FormAttachment((Control)wlQOS, 5);
        fdQOS.width = 135;
        this.wQOS.setLayoutData((Object)fdQOS);
        this.wQOS.add("0");
        this.wQOS.add("1");
        this.wQOS.add("2");
        Label wlMessageField = new Label(wSetupComp, 16384);
        this.props.setLook((Control)wlMessageField);
        wlMessageField.setText(BaseMessages.getString(PKG, (String)"MQTTProducerDialog.MessageField", (String[])new String[0]));
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.top = new FormAttachment((Control)this.wTopic, 10);
        fdlMessageField.right = new FormAttachment(50, 0);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new ComboVar((VariableSpace)this.transMeta, wSetupComp, 18436);
        this.props.setLook((Control)this.wMessageField);
        this.wMessageField.addModifyListener(this.lsMod);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(0, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, 5);
        fdMessageField.right = new FormAttachment(0, 350);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        Listener lsMessageFocus = e -> {
            String current = this.wMessageField.getText();
            this.wMessageField.getCComboWidget().removeAll();
            this.wMessageField.setText(current);
            try {
                RowMetaInterface rmi = this.transMeta.getPrevStepFields(this.meta.getParentStepMeta().getName());
                List ls = rmi.getValueMetaList();
                for (Object l : ls) {
                    ValueMetaBase vmb = (ValueMetaBase)l;
                    this.wMessageField.add(vmb.getName());
                }
            }
            catch (KettleStepException kettleStepException) {
                // empty catch block
            }
        };
        this.wMessageField.getCComboWidget().addListener(15, lsMessageFocus);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        wSetupComp.setLayoutData((Object)fdSetupComp);
        wSetupComp.layout();
        wSetupTab.setControl((Control)wSetupComp);
    }

    public void setSize() {
        MQTTProducerDialog.setSize((Shell)this.shell);
        this.shell.setMinimumSize(527, 650);
        this.shell.setSize(527, 650);
    }

    private void getData() {
        this.wMqttServer.setText(Strings.nullToEmpty((String)this.meta.getMqttServer()));
        this.wClientId.setText(Strings.nullToEmpty((String)this.meta.getClientId()));
        this.wTopic.setText(Strings.nullToEmpty((String)this.meta.getTopic()));
        this.wQOS.setText(Strings.nullToEmpty((String)this.meta.getQOS()));
        this.wMessageField.setText(Strings.nullToEmpty((String)this.meta.getMessageField()));
        this.securityLayout.setUIText();
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.meta.setMqttServer(this.wMqttServer.getText());
        this.meta.setClientId(this.wClientId.getText());
        this.meta.setTopic(this.wTopic.getText());
        this.meta.setQOS(this.wQOS.getText());
        this.meta.setMessageField(this.wMessageField.getText());
        this.meta.setUsername(this.securityLayout.username());
        this.meta.setPassword(this.securityLayout.password());
        this.meta.setUseSsl(this.securityLayout.useSsl());
        this.meta.setSslConfig(this.securityLayout.sslConfig());
        this.optionsLayout.retrieveOptions().stream().forEach(option -> {
            switch (option.getKey()) {
                case "KEEP_ALIVE_INTERVAL": {
                    this.meta.setKeepAliveInterval(option.getValue());
                    break;
                }
                case "MAX_INFLIGHT": {
                    this.meta.setMaxInflight(option.getValue());
                    break;
                }
                case "CONNECTION_TIMEOUT": {
                    this.meta.setConnectionTimeout(option.getValue());
                    break;
                }
                case "CLEAN_SESSION": {
                    this.meta.setCleanSession(option.getValue());
                    break;
                }
                case "STORAGE_LEVEL": {
                    this.meta.setStorageLevel(option.getValue());
                    break;
                }
                case "SERVER_URIS": {
                    this.meta.setServerUris(option.getValue());
                    break;
                }
                case "MQTT_VERSION": {
                    this.meta.setMqttVersion(option.getValue());
                    break;
                }
                case "AUTOMATIC_RECONNECT": {
                    this.meta.setAutomaticReconnect(option.getValue());
                }
            }
        });
        this.dispose();
    }

    private Image getImage() {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
        String id = plugin.getIds()[0];
        if (id != null) {
            return ((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(id)).getAsBitmapForSize((Device)this.shell.getDisplay(), 32, 32);
        }
        return null;
    }
}

