/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.spi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowHandler;
import org.pentaho.di.trans.step.StepMeta;

public class KettleStepFunction
extends ConfigurableFunction<Iterator<Row>, Iterator<Row>>
implements FlatMapFunction<Iterator<Row>, Row> {
    private static final long serialVersionUID = 7177117844030482527L;
    protected transient StepMeta stepMeta;
    private final AtomicBoolean disposed = new AtomicBoolean();
    protected transient MetricsAccumulator metricsAccumulator = null;
    protected transient FunctionLogger transLogger = FunctionLogger.empty();
    protected transient FunctionLogger operationLogger = FunctionLogger.empty();

    public KettleStepFunction() {
    }

    public KettleStepFunction(StepMeta stepMeta) {
        this();
        this.stepMeta = stepMeta;
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void setStepMeta(StepMeta stepMeta) {
        this.stepMeta = stepMeta;
    }

    protected String getInputRowMetaFromStep() {
        return null;
    }

    public Iterator<Row> call(Iterator<Row> input) {
        Objects.requireNonNull(this.stepMeta, "Missing stepMeta");
        final LoggingToAccumAdapter logAdapter = Util.setLogAccumulators(this.stepMeta.getName(), this.transLogger, this.operationLogger);
        final BaseStep step = this.createStep();
        PeekingIterator lookAheadInput = Iterators.peekingIterator(input);
        if (lookAheadInput.hasNext()) {
            step.setInputRowMeta(this.getInputRowMetaFromStep() == null ? MetaHelper.getPrevStepFields(this.stepMeta.getParentTransMeta(), this.stepMeta.getName()) : MetaHelper.getRowMeta(this.stepMeta.getParentTransMeta(), this.getInputRowMetaFromStep()));
        }
        final LinkedList<KettleRow> outputQueue = new LinkedList<KettleRow>();
        step.setRowHandler((RowHandler)new RowIterator((Iterator<? extends Row>)lookAheadInput, outputQueue));
        this.operationLogger.basic("KettleStepFunction has initialized for processing");
        return new Iterator<Row>(){
            private boolean continueProcessing = true;

            @Override
            public boolean hasNext() {
                while (outputQueue.isEmpty() && this.continueProcessing) {
                    this.continueProcessing = KettleStepFunction.this.processRow(step);
                }
                if (outputQueue.isEmpty() && KettleStepFunction.this.disposed.compareAndSet(false, true)) {
                    KettleStepFunction.this.dispose(step);
                    KettleStepFunction.this.operationLogger.basic("KettleStepFunction has completed");
                    Util.removeLogAccumulatores(logAdapter);
                }
                return !outputQueue.isEmpty();
            }

            @Override
            public KettleRow next() {
                return (KettleRow)outputQueue.remove();
            }
        };
    }

    protected BaseStep createStep() {
        BaseStep step = Util.getTypedStep(this.stepMeta, BaseStep.class);
        step.init(step.getStepMetaInterface(), step.getStepDataInterface());
        return step;
    }

    protected boolean processRow(BaseStep step) {
        try {
            boolean toRet = step.processRow(step.getStepMetaInterface(), step.getStepDataInterface());
            IntStream.range(0, (int)step.getErrors()).forEach(i -> this.metricsAccumulator.addRowError());
            return toRet && !step.isStopped();
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    protected void dispose(BaseStep step) {
        step.dispose(step.getStepMetaInterface(), step.getStepDataInterface());
    }

    public List<Row> runOnDriver() {
        return ImmutableList.copyOf(this.call(Collections.emptyIterator()));
    }

    public void setOperationLogger(FunctionLogger logger) {
        this.operationLogger = logger;
    }

    public void setTransLogger(FunctionLogger logger) {
        this.transLogger = logger;
    }

    public void setMetricsAccumulator(MetricsAccumulator metricsAccumulator) {
        this.metricsAccumulator = metricsAccumulator;
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)"KettleStepFunction-stepMeta", (Object)new SerializableStepMeta(this.stepMeta), (Object)"KettleStepFunction-metricsAccumulator", (Object)this.metricsAccumulator, (Object)"KettleStepFunction-transLogger", (Object)this.transLogger, (Object)"KettleStepFunction-operationLogger", (Object)this.operationLogger);
    }

    public void setConfig(String key, Serializable value) {
        switch (key) {
            case "KettleStepFunction-stepMeta": {
                this.stepMeta = ((SerializableStepMeta)value).getStepMeta();
                break;
            }
            case "KettleStepFunction-metricsAccumulator": {
                this.metricsAccumulator = (MetricsAccumulator)value;
                break;
            }
            case "KettleStepFunction-transLogger": {
                this.transLogger = (FunctionLogger)value;
                break;
            }
            case "KettleStepFunction-operationLogger": {
                this.operationLogger = (FunctionLogger)value;
            }
        }
    }

    private class RowIterator
    implements RowHandler {
        private final Iterator<? extends Row> input;
        private final Queue<KettleRow> outputQueue;

        public RowIterator(Iterator<? extends Row> input, Queue<KettleRow> outputQueue) {
            this.input = input;
            this.outputQueue = outputQueue;
        }

        public Object[] getRow() {
            if (KettleStepFunction.this.metricsAccumulator != null && this.input.hasNext()) {
                KettleStepFunction.this.metricsAccumulator.addRowIn();
            }
            return this.input.hasNext() ? this.input.next().getObjects() : null;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) {
            if (KettleStepFunction.this.metricsAccumulator != null) {
                KettleStepFunction.this.metricsAccumulator.addRowOut();
            }
            this.outputQueue.add(new KettleRow(rowMeta, row));
        }

        public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
            throw new KettleStepException("Error handling is not supported from Spark: " + errorDescriptions);
        }
    }
}

