/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.spi;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.api.java.function.Function;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.engine.api.HasConfig;
import org.pentaho.di.engine.spark.spi.RegisteredFunction;

public abstract class ConfigurableFunction<T, R>
implements Function<T, R>,
HasConfig {
    private static final long serialVersionUID = 2377705268993509667L;
    static LogChannelInterfaceFactory logChannelFactory = KettleLogStore.getLogChannelInterfaceFactory();
    private transient AtomicReference<LogChannelInterface> logChannelRef = new AtomicReference();

    protected LogChannelInterface getLogChannel() {
        return this.logChannelRef.updateAndGet(logChannel -> Optional.ofNullable(logChannel).orElseGet(() -> logChannelFactory.create(this.getClass())));
    }

    public final RegisteredFunction<T, R> asRegisteredFunction(String pluginId) {
        return new RegisteredFunction(pluginId, this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(ImmutableMap.copyOf((Map)this.getConfig()));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.setConfig((Map)((ImmutableMap)ois.readObject()));
    }
}

