/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.logger;

import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.spark.impl.logger.AbstractLogger;

public class FunctionLogger
extends AbstractLogger {
    public static final FunctionLogger EMPTY = new FunctionLogger(null);
    @Nullable
    private final CollectionAccumulator<LogEntry> accumulator;

    public FunctionLogger(CollectionAccumulator<LogEntry> accumulator) {
        this.accumulator = accumulator;
    }

    public static FunctionLogger empty() {
        return EMPTY;
    }

    @Override
    void create(LogLevel level, String message, Optional<Throwable> throwableOptional) {
        if (this.accumulator == null) {
            return;
        }
        LogEntry.LogEntryBuilder logEntryBuilder = new LogEntry.LogEntryBuilder().withMessage(message).withLogLevel(level).withTimestamp(new Date());
        if (throwableOptional.isPresent()) {
            logEntryBuilder = logEntryBuilder.withThrowable(throwableOptional.get());
        }
        this.accumulator.add((Object)logEntryBuilder.build());
    }

    public CollectionAccumulator<LogEntry> getAccumulator() {
        return this.accumulator;
    }
}

