/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.listeners;

import com.google.common.annotations.VisibleForTesting;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.StageInfo;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.LogEntryAccumulator;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationEndedEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.logger.OperationLogger;
import org.pentaho.di.i18n.BaseMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class OperationEventListener
extends SparkListener {
    private static final Class<?> PKG = OperationEventListener.class;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String STAGE_SKIPPED = "OperationEventListener.StageSkipped";
    private static final String START_EXECUTION_STAGE_ATTEMPTS_TASKS = "OperationEventListener.StartExecutionOnStageAttempsTotalTasks";
    private static final String OPERATION_STAGE_COMPLETED = "OperationEventListener.OperationStageCompleted";
    private static final String FINISHED_PROCESSING = "OperationEventListener.FinishedProcessing";
    private static final String OPERATION_ALL_STAGES_COMPLETED = "OperationEventListener.OperationAllStagesCompleted";
    private static final String OPERATION_ERROR = "OperationEventListener.OperationError";
    private static final String OPERATION_CANCELLED = "OperationEventListener.OperationCancelled";
    private static final String SPARK_CANCELLED_MSG_PART = "cancelled part of cancelled job group";
    private static final String SUCCEEDED_STATUS = "succeeded";
    private final JavaSparkContext javaSparkContext;
    private final SparkOperation.Subscriber subscriber;
    private final String operationName;
    private final String operationUUID;
    private List<String> outputOps = new ArrayList<String>();
    private final boolean endOperation;
    private final boolean onlyOneOperation;
    private String msgError = null;
    private Status stageStatus = Status.FINISHED;
    private Throwable throwable = null;
    private AtomicInteger nextStepsEnded = new AtomicInteger(0);
    private AtomicBoolean readyToFinalize = new AtomicBoolean(false);
    private AtomicBoolean finalized = new AtomicBoolean(false);
    private AtomicBoolean cancelledByUser = new AtomicBoolean(false);
    private AtomicBoolean operationErrorPrinted = new AtomicBoolean(false);
    private AtomicBoolean listenerClosed = new AtomicBoolean(false);
    private ConcurrentHashMap<Integer, Boolean> operationStageStatus = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ArrayList<Integer>> jobStageRelation = new ConcurrentHashMap();
    private MetricsAccumulator metricsAccumulator;
    private LoggingToAccumAdapter loggingToAccumAdapter;
    private ReplaySubject<LogEntry> loggingSubject;

    public OperationEventListener(JavaSparkContext javaSparkContext, SparkOperation.Subscriber subscriber, SparkOperation operation, MetricsAccumulator metricsAccumulator, LoggingToAccumAdapter loggingToAccumAdapter) {
        this.javaSparkContext = javaSparkContext;
        this.subscriber = subscriber;
        this.operationName = operation.getId();
        this.operationUUID = operation.getUUID();
        this.metricsAccumulator = metricsAccumulator;
        this.loggingToAccumAdapter = loggingToAccumAdapter;
        subscriber.getExpectedOutputs().stream().forEach(op -> this.outputOps.add(op.getUUID()));
        this.endOperation = this.outputOps == null || this.outputOps.isEmpty();
        this.onlyOneOperation = (subscriber.getInputs() == null || subscriber.getInputs().isEmpty()) && this.endOperation;
        this.loggingSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        if (this.listenerClosed.get()) {
            return;
        }
        if (jobStart != null && jobStart.stageInfos() != null) {
            JavaConversions.seqAsJavaList((Seq)jobStart.stageInfos()).stream().forEach(stageInfo -> {
                ArrayList<Integer> stages;
                boolean hasRDDwithOperationUUID;
                boolean bl = hasRDDwithOperationUUID = JavaConversions.seqAsJavaList((Seq)stageInfo.rddInfos()).stream().filter(rddinfo -> this.onlyOneOperation || this.operationUUID.equals(rddinfo.name()) || this.outputOps.contains(rddinfo.name())).count() > 0L;
                if (hasRDDwithOperationUUID) {
                    this.operationStageStatus.put(stageInfo.stageId(), Boolean.FALSE);
                }
                if ((stages = this.jobStageRelation.get(jobStart.jobId())) == null) {
                    stages = new ArrayList();
                }
                if (!stages.contains(stageInfo.stageId())) {
                    this.jobStageRelation.put(jobStart.jobId(), stages);
                    stages.add(stageInfo.stageId());
                }
            });
        }
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        if (this.listenerClosed.get()) {
            return;
        }
        if (jobEnd != null && this.jobStageRelation.get(jobEnd.jobId()) != null) {
            this.jobStageRelation.get(jobEnd.jobId()).forEach(stageId -> {
                if (this.operationStageStatus.get(stageId) != null && !this.operationStageStatus.get(stageId).booleanValue()) {
                    this.operationStageStatus.put((Integer)stageId, Boolean.TRUE);
                    this.subscriber.getLogger().debug(BaseMessages.getString(PKG, (String)STAGE_SKIPPED, (Object[])new Object[]{stageId}));
                }
            });
            this.ifReadyFinalize();
        }
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        boolean isThisOperationStage;
        if (this.listenerClosed.get()) {
            return;
        }
        if (stageSubmitted != null && stageSubmitted.stageInfo() != null && stageSubmitted.stageInfo().rddInfos() != null && (isThisOperationStage = this.operationStageStatus.containsKey(stageSubmitted.stageInfo().stageId())) && this.stageStatus != Status.RUNNING && this.stageStatus != Status.FAILED) {
            StageInfo stageInfo = stageSubmitted.stageInfo();
            this.stageStatus = Status.RUNNING;
            this.updateStatus();
            this.subscriber.getLogger().debug(BaseMessages.getString(PKG, (String)START_EXECUTION_STAGE_ATTEMPTS_TASKS, (Object[])new Object[]{stageInfo.stageId(), stageInfo.attemptId(), stageInfo.numTasks()}));
            this.logger.debug(BaseMessages.getString(PKG, (String)START_EXECUTION_STAGE_ATTEMPTS_TASKS, (Object[])new Object[]{stageInfo.stageId(), stageInfo.attemptId(), stageInfo.numTasks()}));
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        if (this.listenerClosed.get()) {
            return;
        }
        if (stageCompleted != null && stageCompleted.stageInfo() != null && this.operationStageStatus.containsKey(stageCompleted.stageInfo().stageId())) {
            StageInfo stageInfo = stageCompleted.stageInfo();
            this.logger.debug(BaseMessages.getString(PKG, (String)OPERATION_STAGE_COMPLETED, (String[])new String[]{this.operationName, stageInfo.name()}));
            this.operationStageStatus.put(stageInfo.stageId(), Boolean.TRUE);
            if (this.stageStatus != Status.FAILED) {
                this.stageStatus = SUCCEEDED_STATUS.equals(stageInfo.getStatusString()) ? Status.FINISHED : Status.FAILED;
                String string = this.msgError = stageInfo.failureReason().isEmpty() ? null : (String)stageInfo.failureReason().get();
                if (this.stageStatus == Status.FAILED && this.msgError != null && this.msgError.contains(SPARK_CANCELLED_MSG_PART)) {
                    this.cancelledByUser.set(true);
                    this.operationErrorPrinted.getAndSet(true);
                    this.subscriber.getLogger().debug(BaseMessages.getString(PKG, (String)OPERATION_CANCELLED, (String[])new String[]{this.operationName, this.msgError}));
                }
            }
            this.ifReadyFinalize();
        }
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        if (this.listenerClosed.get()) {
            return;
        }
        if (taskEnd != null && this.operationStageStatus.containsKey(taskEnd.stageId())) {
            this.updateMetrics();
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        if (this.listenerClosed.get()) {
            return;
        }
        if (event instanceof FinalOperationEvent) {
            this.finalOperationEvent((FinalOperationEvent)event);
        } else if (event instanceof OperationErrorEvent) {
            this.operationErrorEvent((OperationErrorEvent)event);
        } else if (event instanceof OperationEndedEvent) {
            this.operationEndedEvent((OperationEndedEvent)event);
        }
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        if (this.listenerClosed.get()) {
            return;
        }
        this.finalizeOperation();
    }

    private void finalOperationEvent(FinalOperationEvent event) {
        if (this.operationUUID.equals(event.getOperation())) {
            this.readyToFinalize.set(true);
            if (this.allStagesCompleted()) {
                this.updateMetrics();
                if (this.operationStageStatus.size() == 0) {
                    this.stageStatus = Status.FINISHED;
                    this.updateStatus();
                }
                this.finalizeOperation();
            }
            OperationEndedEvent.sendEvent(this.javaSparkContext, this.operationUUID);
        }
    }

    private void operationEndedEvent(OperationEndedEvent event) {
        if (!this.endOperation && this.outputOps.contains(event.getOperation()) && !this.finalized.get() && this.nextStepEndedInc() >= this.outputOps.size()) {
            this.readyToFinalize.set(true);
            this.logSummary();
            if (this.allStagesCompleted()) {
                if (this.operationStageStatus.size() == 0) {
                    this.stageStatus = Status.FINISHED;
                    this.updateMetrics();
                    this.updateStatus();
                }
                this.finalizeOperation();
            }
            OperationEndedEvent.sendEvent(this.javaSparkContext, this.operationUUID);
        }
    }

    private void operationErrorEvent(OperationErrorEvent event) {
        if (this.operationUUID.equals(event.getOperation())) {
            this.throwable = event.getThrowable();
            if (!this.operationErrorPrinted.getAndSet(true)) {
                if (!this.cancelledByUser.get()) {
                    this.subscriber.getLogger().error(this.throwable != null ? this.throwable.getMessage() : BaseMessages.getString(PKG, (String)OPERATION_ERROR, (String[])new String[]{this.operationName}), this.throwable);
                } else {
                    this.subscriber.getLogger().debug(BaseMessages.getString(PKG, (String)OPERATION_CANCELLED, (String[])new String[]{this.operationName, this.throwable != null ? this.throwable.getMessage() : ""}));
                }
            }
        }
        this.finalizeOperation();
    }

    private void updateMetrics() {
        this.subscriber.updateMetrics(metrics -> new Metrics(this.metricsAccumulator.getRowIn(), this.metricsAccumulator.getRowOut(), this.metricsAccumulator.getRowError(), this.metricsAccumulator.getRowInFlight()));
    }

    private void logSummary() {
        long lr = this.metricsAccumulator.getRowIn();
        long lw = this.metricsAccumulator.getRowOut();
        long le = this.metricsAccumulator.getRowError();
        OperationLogger opLogger = this.subscriber.getLogger();
        opLogger.detailed(BaseMessages.getString(PKG, (String)FINISHED_PROCESSING, (String[])new String[]{String.valueOf(lr), String.valueOf(lw), String.valueOf(le)}));
    }

    private void updateStatus() {
        this.subscriber.updateStatus(this.stageStatus, this.msgError);
    }

    private void updateLogs() {
        LogEntryAccumulator.updateLogs(this.operationName, this.loggingToAccumAdapter.getAccumulator(this.operationName), this.loggingSubject);
    }

    private void finalizeOperation() {
        this.finalized.set(true);
        this.updateLogs();
        if (this.throwable != null) {
            this.subscriber.finalize(this.throwable);
        } else {
            this.subscriber.finalize(this.msgError != null && !this.msgError.isEmpty() ? new Throwable(this.msgError) : null);
        }
        this.listenerClosed.set(true);
    }

    private void ifReadyFinalize() {
        if (this.allStagesCompleted()) {
            this.logger.debug(BaseMessages.getString(PKG, (String)OPERATION_ALL_STAGES_COMPLETED, (String[])new String[]{this.operationName}));
            if (!this.operationErrorPrinted.getAndSet(true)) {
                this.subscriber.getLogger().error(this.msgError);
            }
            this.updateLogs();
            this.updateMetrics();
            this.updateStatus();
            if (this.readyToFinalize.get() && !this.finalized.get()) {
                this.finalizeOperation();
            }
        }
    }

    private int nextStepEndedInc() {
        return this.nextStepsEnded.incrementAndGet();
    }

    private boolean allStagesCompleted() {
        return this.operationStageStatus.values().stream().allMatch(Boolean::booleanValue);
    }

    @VisibleForTesting
    public Throwable getThrowable() {
        return this.throwable;
    }
}

