/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.listeners;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.spark.util.Util;

public class LoggingToAccumAdapter
implements KettleLoggingEventListener {
    private Map<String, CollectionAccumulator<LogEntry>> accumulators = new HashMap<String, CollectionAccumulator<LogEntry>>();

    public void eventAdded(KettleLoggingEvent kle) {
        if (this.accumulators.isEmpty()) {
            return;
        }
        org.pentaho.di.core.logging.LogLevel logLevel = kle.getLevel();
        LogMessageInterface message = (LogMessageInterface)kle.getMessage();
        long timeStamp = kle.getTimeStamp();
        String subject = message.getSubject();
        CollectionAccumulator<LogEntry> accumulator = null;
        accumulator = subject == null || subject.isEmpty() ? this.accumulators.get("trans_logging") : this.accumulators.get(subject);
        if (accumulator != null) {
            accumulator.add((Object)new LogEntry.LogEntryBuilder().withMessage(message.getMessage()).withLogLevel((LogLevel)Util.LEVEL_MAP.inverse().get((Object)logLevel)).withTimestamp(new Date(timeStamp)).build());
        }
    }

    public void addTransLoggingAccumulator(CollectionAccumulator<LogEntry> accumulator) {
        this.accumulators.put("trans_logging", accumulator);
    }

    public void addAccumulator(String operationID, CollectionAccumulator<LogEntry> accumulator) {
        this.accumulators.put(operationID, accumulator);
    }

    public CollectionAccumulator<LogEntry> getTransLoggingAccumulator() {
        return this.accumulators.get("trans_logging");
    }

    public CollectionAccumulator<LogEntry> getAccumulator(String operationID) {
        return this.accumulators.get(operationID);
    }

    public Map<String, CollectionAccumulator<LogEntry>> getAccumulators() {
        return this.accumulators;
    }

    @VisibleForTesting
    public void cleanAccumulators() {
        this.accumulators.clear();
    }
}

