/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.observers.DisposableCompletableObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.AccumulatorV2;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.api.reporting.SubTransCreation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.LogEntryAccumulator;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;
import org.pentaho.di.engine.spark.impl.execution.OperationDependency;
import org.pentaho.di.engine.spark.impl.listeners.LoggingAccumSparkListener;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.listeners.OperationEventListener;
import org.pentaho.di.engine.spark.impl.logger.OperationLogger;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.i18n.BaseMessages;

public class TaskObservable
implements ObservableSource<DriverTask> {
    private static final Class<?> PKG = TaskObservable.class;
    private static final String TASK_OBSERVABLE_ID = "TaskObservable.TaskObservable";
    private static final String FUTURE_RDD_NEVER_COMPLETED = "TaskObservable.FutureRDDNeverCompleted";
    private static final String UNEXPECTED_RDD = "TaskObservable.UnexpectedRDD";
    private static final String RDD_NOT_SET = "TaskObservable.RDDNotSet";
    private static final String ERROR_RDD_NOT_SET = "TaskObservable.ErrorRDDNotSet";
    private static final String OPERATION_INITIALIZED = "TaskObservable.OperationInitialized";
    private final JavaSparkContext sparkContext;
    private final SparkOperation sparkOperation;
    private final ImmutableMap<SparkOperation, OperationDependency> sources;
    private final ImmutableMap<SparkOperation, OperationDependency> targets;
    private final Subject<DriverTask> driverTasks = ReplaySubject.create();
    private final BehaviorSubject<Status> statusSubject = BehaviorSubject.create();
    private final BehaviorSubject<Metrics> metricsSubject = BehaviorSubject.createDefault((Object)Metrics.empty());
    private ReplaySubject<LogEntry> loggingSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
    private ReplaySubject<SubTransCreation> subTransSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<DriverTask> activeTasks = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
    private Map<String, AccumulatorV2> accumulators = new HashMap<String, AccumulatorV2>();
    MetricsAccumulator metricsAccumulator;
    LoggingToAccumAdapter loggingToAccumAdapter;
    private final Supplier<OperationLogger> opLogger = Suppliers.memoize(() -> new OperationLogger(this.loggingSubject));

    public static TaskObservable create(JavaSparkContext sparkContext, SparkOperation sparkOperation, Table<SparkOperation, SparkOperation, OperationDependency> dependencyTable, LoggingToAccumAdapter loggingToAccumAdapter, Map<String, AccumulatorV2<?, ?>> accumulators, MetricsAccumulator metricsAccumulator) {
        Map sources = dependencyTable.column((Object)sparkOperation);
        Map targets = dependencyTable.row((Object)sparkOperation);
        return new TaskObservable(sparkContext, sparkOperation, sources, targets, loggingToAccumAdapter, accumulators, metricsAccumulator);
    }

    private TaskObservable(JavaSparkContext sparkContext, SparkOperation sparkOperation, Map<SparkOperation, OperationDependency> sources, Map<SparkOperation, OperationDependency> targets, LoggingToAccumAdapter loggingToAccumAdapter, Map<String, AccumulatorV2<?, ?>> accumulators, MetricsAccumulator metricsAccumulator) {
        this.sparkContext = sparkContext;
        this.sparkOperation = sparkOperation;
        this.sources = ImmutableMap.copyOf(sources);
        this.targets = ImmutableMap.copyOf(targets);
        this.loggingToAccumAdapter = loggingToAccumAdapter;
        this.accumulators.putAll(accumulators);
        this.metricsAccumulator = metricsAccumulator;
    }

    public SparkOperation getSparkOperation() {
        return this.sparkOperation;
    }

    ImmutableSet<SparkOperation> getSources() {
        return this.sources.keySet();
    }

    ImmutableSet<SparkOperation> getTargets() {
        return this.targets.keySet();
    }

    public Observable<Status> getStatus() {
        return this.statusSubject.takeUntil(Status::isFinal);
    }

    public Observable<Metrics> getMetrics() {
        return this.metricsSubject.takeUntil((ObservableSource)this.driverTasks.ignoreElements().toObservable()).switchIfEmpty((ObservableSource)Observable.fromCallable(() -> this.metricsSubject.getValue()));
    }

    public Observable<LogEntry> getLogging() {
        this.accumulators.computeIfAbsent("op_logging", s -> {
            LogEntryAccumulator logEntryAccumulator = LogEntryAccumulator.getOperationLogging(this.sparkContext, this.loggingSubject, this.loggingToAccumAdapter, this.sparkOperation.getId());
            this.sparkContext.sc().addSparkListener((SparkListenerInterface)new LoggingAccumSparkListener(logEntryAccumulator));
            return logEntryAccumulator.getAccumulator();
        });
        return this.loggingSubject;
    }

    public Observable<SubTransCreation> getSubTransCreation() {
        return this.subTransSubject;
    }

    public String toString() {
        return BaseMessages.getString(PKG, (String)TASK_OBSERVABLE_ID, (String[])new String[]{this.sparkOperation.getId()});
    }

    public void subscribe(Observer<? super DriverTask> observer) {
        if (this.started.compareAndSet(false, true)) {
            this.statusSubject.onNext((Object)Status.RUNNING);
            ((CompletableFuture)Util.invertMap(this.sources).thenApply(x$0 -> new OperationSubscriber((Map)x$0))).thenAccept(this::applyOperation);
        }
        this.driverTasks.subscribe(observer);
    }

    private synchronized void runOnDriver(Runnable action) {
        final DriverTask task = DriverTask.create(action, this.sparkOperation);
        this.activeTasks.add(task);
        task.subscribe((CompletableObserver)new DisposableCompletableObserver(){

            public void onComplete() {
                TaskObservable.this.activeTasks.remove(task);
            }

            public void onError(Throwable e) {
                this.onComplete();
            }
        });
        this.driverTasks.onNext((Object)task);
    }

    private CompletableFuture<Void> applyOperation(OperationSubscriber subscriber) {
        OperationEventListener rddEventListener = new OperationEventListener(this.sparkContext, subscriber, this.sparkOperation, this.metricsAccumulator, this.loggingToAccumAdapter);
        this.sparkContext.sc().addSparkListener((SparkListenerInterface)rddEventListener);
        if (subscriber.getInputs() != null && !subscriber.getInputs().isEmpty()) {
            subscriber.getInputs().forEach((k, v) -> v.setName(this.sparkOperation.getUUID()));
        }
        try {
            this.sparkOperation.apply(subscriber);
            Util.getOperationLogger(subscriber).basic(BaseMessages.getString(PKG, (String)OPERATION_INITIALIZED, (String[])new String[]{this.sparkOperation.getId()}));
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent(this.sparkContext, this.sparkOperation.getUUID(), e);
        }
        return (CompletableFuture)Completable.fromRunnable(() -> subscriber.verifyTargetsSet()).andThen((CompletableSource)this.tasksDone()).andThen((CompletableSource)Completable.fromRunnable(this::verifyTargetsResolved)).to(Util::completableFuture);
    }

    private Completable tasksDone() {
        if (this.activeTasks.isEmpty()) {
            return Completable.complete();
        }
        return Completable.merge(this.activeTasks).andThen((CompletableSource)Completable.defer(this::tasksDone));
    }

    private void verifyTargetsResolved() {
        List unresolved = this.targets.entrySet().stream().filter(entry -> !((OperationDependency)entry.getValue()).isDone()).map(entry -> ((SparkOperation)entry.getKey()).getId()).collect(Collectors.toList());
        Preconditions.checkState((boolean)unresolved.isEmpty(), (Object)BaseMessages.getString(PKG, (String)FUTURE_RDD_NEVER_COMPLETED, (Object[])new Object[]{this.sparkOperation.getId(), unresolved}));
    }

    private class OperationSubscriber
    implements SparkOperation.Subscriber {
        final ImmutableMap<SparkOperation, JavaRDD<Row>> inputs;
        final ImmutableSet<SparkOperation> expectedOutputs;
        final ImmutableSet<SparkOperation> expectedErrorOutputs;
        final Set<SparkOperation> remainingOutput = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
        final Set<SparkOperation> remainingErrorOutput = Sets.newSetFromMap((Map)Maps.newConcurrentMap());

        private OperationSubscriber(Map<SparkOperation, JavaRDD<Row>> inputs) {
            this.inputs = ImmutableMap.copyOf(inputs);
            this.expectedOutputs = this.populateExpectedOutputs("NORMAL", this.remainingOutput);
            this.expectedErrorOutputs = this.populateExpectedOutputs("ERROR", this.remainingErrorOutput);
        }

        private ImmutableSet<SparkOperation> populateExpectedOutputs(String hopType, Set<SparkOperation> remainingOutputSet) {
            Map<Boolean, List<OperationDependency>> targetDependencies = TaskObservable.this.targets.values().stream().collect(Collectors.partitioningBy(dependency -> hopType.equals(dependency.getType())));
            ImmutableSet expectedOutputs = targetDependencies.get(true).stream().map(OperationDependency::getTo).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
            remainingOutputSet.addAll((Collection<SparkOperation>)expectedOutputs);
            return expectedOutputs;
        }

        @Override
        public Set<SparkOperation> getExpectedOutputs() {
            return this.expectedOutputs;
        }

        @Override
        public Set<SparkOperation> getExpectedErrorOutputs() {
            return this.expectedErrorOutputs;
        }

        @Override
        public Map<SparkOperation, JavaRDD<Row>> getInputs() {
            return this.inputs;
        }

        @Override
        public void addOutput(SparkOperation output, CompletableFuture<JavaRDD<Row>> futureValue) {
            Preconditions.checkArgument((boolean)TaskObservable.this.targets.containsKey((Object)output), (Object)BaseMessages.getString((Class)PKG, (String)TaskObservable.UNEXPECTED_RDD, (Object[])new Object[]{output}));
            if (this.remainingOutput.remove(output)) {
                CompletableFuture futureRdd = (CompletableFuture)TaskObservable.this.targets.get((Object)output);
                futureValue.whenComplete((rowJavaRDD, throwable) -> {
                    Optional.ofNullable(rowJavaRDD).ifPresent(futureRdd::complete);
                    Optional.ofNullable(throwable).ifPresent(futureRdd::completeExceptionally);
                });
            }
        }

        @Override
        public void addErrorOutput(SparkOperation output, CompletableFuture<JavaRDD<Row>> futureValue) {
            Preconditions.checkArgument((boolean)TaskObservable.this.targets.containsKey((Object)output), (Object)BaseMessages.getString((Class)PKG, (String)TaskObservable.UNEXPECTED_RDD, (Object[])new Object[]{output}));
            if (this.remainingErrorOutput.remove(output)) {
                CompletableFuture futureRdd = (CompletableFuture)TaskObservable.this.targets.get((Object)output);
                futureValue.whenComplete((rowJavaRDD, throwable) -> {
                    Optional.ofNullable(rowJavaRDD).ifPresent(futureRdd::complete);
                    Optional.ofNullable(throwable).ifPresent(futureRdd::completeExceptionally);
                });
            }
        }

        @Override
        public void registerDriverAction(Runnable action) {
            TaskObservable.this.runOnDriver(action);
        }

        private void verifyTargetsSet() {
            Set missing = this.remainingOutput.stream().map(SparkOperation::getId).collect(Collectors.toSet());
            Preconditions.checkState((boolean)missing.isEmpty(), (Object)BaseMessages.getString((Class)PKG, (String)TaskObservable.RDD_NOT_SET, (Object[])new Object[]{TaskObservable.this.sparkOperation.getId(), missing}));
            Set missingError = this.remainingErrorOutput.stream().map(SparkOperation::getId).collect(Collectors.toSet());
            Preconditions.checkState((boolean)missingError.isEmpty(), (Object)BaseMessages.getString((Class)PKG, (String)TaskObservable.ERROR_RDD_NOT_SET, (Object[])new Object[]{TaskObservable.this.sparkOperation.getId(), missing}));
        }

        @Override
        public void setOutput(CompletableFuture<JavaRDD<Row>> output) {
            if (this.getExpectedOutputs().isEmpty()) {
                output.thenAcceptAsync(this::collectMetrics, this::registerDriverAction);
            } else {
                CompletableFuture<JavaRDD<Row>> result = this.getExpectedOutputs().size() > 1 ? output.thenApply(JavaRDD::cache) : output;
                this.getExpectedOutputs().forEach(expected -> this.addOutput((SparkOperation)expected, result));
            }
        }

        @Override
        public void setErrorOutput(CompletableFuture<JavaRDD<Row>> output) {
            CompletableFuture<JavaRDD<Row>> result = this.getExpectedErrorOutputs().size() > 1 ? output.thenApply(JavaRDD::cache) : output;
            this.getExpectedErrorOutputs().forEach(expected -> this.addErrorOutput((SparkOperation)expected, result));
        }

        private void collectMetrics(JavaRDD<Row> output) {
            try {
                output.count();
                FinalOperationEvent.sendEvent(TaskObservable.this.sparkContext, TaskObservable.this.sparkOperation.getUUID());
            }
            catch (Exception e) {
                OperationErrorEvent.sendEvent(TaskObservable.this.sparkContext, TaskObservable.this.sparkOperation.getUUID(), e);
            }
        }

        @Override
        public void updateMetrics(UnaryOperator<Metrics> update) {
            TaskObservable.this.metricsSubject.firstElement().map(update::apply).subscribe(arg_0 -> ((BehaviorSubject)TaskObservable.this.metricsSubject).onNext(arg_0));
        }

        @Override
        public Map<String, AccumulatorV2> getAccumulators() {
            return TaskObservable.this.accumulators;
        }

        @Override
        public OperationLogger getLogger() {
            return (OperationLogger)TaskObservable.this.opLogger.get();
        }

        @Override
        public void initializeContext(ExecutionContext context, Transformation transformation) {
            SubTransCreation subTransCreation = new SubTransCreation();
            subTransCreation.setContext(context);
            subTransCreation.setTransformation(transformation);
            TaskObservable.this.subTransSubject.onNext((Object)subTransCreation);
        }

        @Override
        public void updateStatus(Status status, String msgError) {
            switch (status) {
                case FAILED: {
                    TaskObservable.this.activeTasks.forEach(task -> task.cancel(false));
                    TaskObservable.this.driverTasks.onError(new Throwable(msgError));
                }
            }
            TaskObservable.this.statusSubject.onNext((Object)status);
        }

        @Override
        public synchronized void finalize(Throwable throwable) {
            if (throwable == null) {
                TaskObservable.this.statusSubject.onComplete();
                TaskObservable.this.metricsSubject.onComplete();
                TaskObservable.this.loggingSubject.onComplete();
                TaskObservable.this.driverTasks.onComplete();
            } else {
                TaskObservable.this.statusSubject.onNext((Object)Status.FAILED);
                TaskObservable.this.metricsSubject.onComplete();
                TaskObservable.this.loggingSubject.onComplete();
                TaskObservable.this.statusSubject.onComplete();
                TaskObservable.this.activeTasks.forEach(task -> task.cancel(false));
                TaskObservable.this.driverTasks.onError(throwable);
            }
        }

        @Override
        public MetricsAccumulator getMetricsAccumulator() {
            return TaskObservable.this.metricsAccumulator;
        }
    }
}

