/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.subjects.AsyncSubject;
import java.util.concurrent.FutureTask;
import org.pentaho.di.engine.spark.api.SparkOperation;

public class DriverTask
extends FutureTask<Void>
implements CompletableSource {
    private final SparkOperation sparkOperation;
    private final AsyncSubject<Void> subject = AsyncSubject.create();

    public static DriverTask create(Runnable runnable, SparkOperation sparkOperation) {
        return new DriverTask(runnable, sparkOperation);
    }

    private DriverTask(Runnable runnable, SparkOperation sparkOperation) {
        super(runnable, null);
        this.sparkOperation = sparkOperation;
    }

    public SparkOperation getSparkOperation() {
        return this.sparkOperation;
    }

    @Override
    protected void set(Void nothing) {
        super.set(nothing);
        this.subject.onComplete();
    }

    @Override
    protected void setException(Throwable t) {
        super.setException(t);
        this.subject.onError(t);
    }

    public void subscribe(CompletableObserver cs) {
        this.subject.ignoreElements().subscribe(cs);
    }

    public AsyncSubject<Void> getSubject() {
        return this.subject;
    }
}

