/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.api;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.pentaho.di.engine.spark.api.IObjectConverter;

public class Field
implements Serializable {
    private final String name;
    private final String path;
    private final int type;
    private final boolean nullable;
    private final Object ifNull;
    private int length;
    private int precision;
    private int columnOrdinal;
    private IObjectConverter objectConverter;
    private final SimpleDateFormat dateFormat;
    private static final boolean DEFAULT_NULLABLE = true;
    private static final Object DEFAULT_IFNULL = "";

    private Field(String name, String path, int type, boolean nullable, Object ifNull, int length, int precision, SimpleDateFormat dateFormat, int columnOrdinal, IObjectConverter objectConverter) {
        this.path = path;
        this.type = type;
        this.nullable = nullable;
        this.ifNull = ifNull;
        this.name = name;
        this.length = length;
        this.precision = precision;
        this.dateFormat = dateFormat;
        this.columnOrdinal = columnOrdinal;
        this.objectConverter = objectConverter;
    }

    public static FieldBuilder builder() {
        return new FieldBuilder();
    }

    public int getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Object getIfNull() {
        return this.ifNull;
    }

    public String getName() {
        return this.name;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getColumnOrdinal() {
        return this.columnOrdinal;
    }

    public IObjectConverter getObjectConverter() {
        return this.objectConverter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (this.type != field.type) {
            return false;
        }
        if (this.nullable != field.nullable) {
            return false;
        }
        if (this.length != field.length) {
            return false;
        }
        if (this.precision != field.precision) {
            return false;
        }
        if (this.name != null ? !this.name.equals(field.name) : field.name != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(field.path) : field.path != null) {
            return false;
        }
        if (this.ifNull != null ? !this.ifNull.equals(field.ifNull) : field.ifNull != null) {
            return false;
        }
        return this.dateFormat != null ? this.dateFormat.equals(field.dateFormat) : field.dateFormat == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + this.type;
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + (this.ifNull != null ? this.ifNull.hashCode() : 0);
        result = 31 * result + this.length;
        result = 31 * result + this.precision;
        result = 31 * result + (this.dateFormat != null ? this.dateFormat.hashCode() : 0);
        return result;
    }

    public String getPath() {
        if (this.path == null) {
            return this.name;
        }
        return this.path;
    }

    static /* synthetic */ Object access$100() {
        return DEFAULT_IFNULL;
    }

    public static final class FieldBuilder {
        private String name;
        private int type;
        private boolean nullable = true;
        private Object ifNull = Field.access$100();
        private SimpleDateFormat dateFormat = new SimpleDateFormat();
        private int length;
        private int precision;
        private String path;
        private int columnOrdinal;
        private IObjectConverter objectConverter;

        private FieldBuilder() {
        }

        public static FieldBuilder builder() {
            return new FieldBuilder();
        }

        public FieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FieldBuilder path(String path) {
            this.path = path;
            return this;
        }

        public FieldBuilder type(int type) {
            this.type = type;
            return this;
        }

        public FieldBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public FieldBuilder ifNull(Object ifNull) {
            this.ifNull = ifNull;
            return this;
        }

        public FieldBuilder dateFormat(SimpleDateFormat dateFormat) {
            if (dateFormat != null) {
                this.dateFormat = dateFormat;
            }
            return this;
        }

        public FieldBuilder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public FieldBuilder length(int length) {
            this.length = length;
            return this;
        }

        public FieldBuilder columnOrdinal(int columnOrdinal) {
            this.columnOrdinal = columnOrdinal;
            return this;
        }

        public FieldBuilder objectConverter(IObjectConverter objectConverter) {
            this.objectConverter = objectConverter;
            return this;
        }

        public FieldBuilder field(Field field) {
            this.name = field.name;
            this.path = field.path;
            this.type = field.type;
            this.nullable = field.nullable;
            this.ifNull = field.ifNull;
            this.length = field.length;
            this.precision = field.precision;
            this.dateFormat = field.dateFormat;
            this.columnOrdinal = field.columnOrdinal;
            this.objectConverter = field.objectConverter;
            return this;
        }

        public Field build() {
            return new Field(this.name, this.path, this.type, this.nullable, this.ifNull, this.length, this.precision, this.dateFormat, this.columnOrdinal, this.objectConverter);
        }
    }
}

