/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.api;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.BaseSparkOperation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.SparkEngineContext;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.functions.WaitForeverFunction;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.MetaHelper;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;

public abstract class BaseSparkStreamingOperation
extends BaseSparkOperation {
    private transient SparkEngineContext executionContext;
    private transient Map<String, Transformation> subTransformations;
    protected final transient JavaSparkContext sparkContext;
    protected final transient BaseStreamStepMeta consumerMeta;
    protected final transient TransMeta transMeta;
    protected transient Transformation transformation;
    protected transient SparkOperation.Subscriber subscriber;
    protected transient JavaStreamingContext javaStreamingContext;
    protected transient FunctionLogger operationLogger = FunctionLogger.empty();

    protected BaseSparkStreamingOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this(operation, stepMeta, sparkContext);
        this.executionContext = (SparkEngineContext)executionContext;
        this.transformation = transformation;
        this.subTransformations = (HashMap)transformation.getConfig("SubTransformations").get();
    }

    public BaseSparkStreamingOperation(Operation operation, StepMeta stepMeta, JavaSparkContext sparkContext) {
        super(operation);
        this.transMeta = stepMeta.getParentTransMeta();
        this.consumerMeta = MetaHelper.getTypedStepMeta(stepMeta, BaseStreamStepMeta.class);
        this.sparkContext = sparkContext;
    }

    protected abstract JavaInputDStream<JavaRDD> buildStream();

    protected abstract JavaRDD<Row> mapPartitions(JavaRDD var1);

    @VisibleForTesting
    protected void executeStreamingTransformation() {
        try {
            this.checkMeta();
            Duration duration = new Duration(Long.parseLong(this.transMeta.environmentSubstitute(this.consumerMeta.getBatchDuration())));
            if (null == this.javaStreamingContext) {
                this.javaStreamingContext = new JavaStreamingContext(this.sparkContext, duration);
                this.executionContext.registerStreamingContext(this.javaStreamingContext);
            }
            JavaInputDStream<JavaRDD> stream = this.buildStream();
            stream.foreachRDD(this::executeSubTransformation);
            this.javaStreamingContext.start();
            this.javaStreamingContext.awaitTermination();
        }
        catch (Throwable e) {
            OperationErrorEvent.sendEvent(this.sparkContext, this.getUUID(), e);
        }
    }

    private void checkMeta() {
        ArrayList remarks = new ArrayList();
        RowMetaInterface rowMeta = MetaHelper.getRowMeta(this.transMeta, this.operation.getId());
        StepMeta stepMeta = MetaHelper.getStepMeta(this.getId(), this.transMeta);
        this.consumerMeta.check(remarks, this.transMeta, stepMeta, rowMeta, new String[0], new String[0], rowMeta, (VariableSpace)this.transMeta, null, null);
        if (remarks.size() > 0) {
            String checkErrorMsg = remarks.stream().map(CheckResultInterface::getText).collect(Collectors.joining("\n"));
            OperationErrorEvent.sendEvent(this.sparkContext, this.getUUID(), new RuntimeException(checkErrorMsg));
        }
    }

    protected void executeSubTransformation(JavaRDD javaRDD) {
        String transformationPath = this.transMeta.environmentSubstitute(this.consumerMeta.getTransformationPath());
        SparkEngineContext subTransContext = this.executionContext.createSubTransContext(transformationPath);
        subTransContext.setInitialRdd((JavaRDD<Row>)this.mapPartitions(javaRDD).cache());
        this.subscriber.initializeContext(subTransContext, subTransContext.getTransformation());
        try {
            ExecutionResult executionResult = subTransContext.execute().get();
            executionResult.getDataEventReport().entrySet().stream().map(e -> ((Metrics)e.getValue()).getDropped()).filter(dropped -> dropped > 0L).findFirst().ifPresent(dropped -> this.javaStreamingContext.stop());
        }
        catch (Exception e2) {
            this.subscriber.updateStatus(Status.FAILED, e2.getMessage());
            this.javaStreamingContext.stop();
        }
    }

    @Override
    public void apply(SparkOperation.Subscriber subscriber) {
        this.subscriber = subscriber;
        this.operationLogger = Util.getOperationLogger(subscriber);
        CompletableFuture.runAsync(this::executeStreamingTransformation, subscriber::registerDriverAction);
        KettleRow row = new KettleRow(Collections.singletonList("name"), new Object[]{"value"});
        JavaRDD rdd = this.sparkContext.parallelize(Collections.singletonList(row)).filter(new WaitForeverFunction().asRegisteredFunction(this.consumerMeta.getParentStepMeta().getStepID()));
        subscriber.setOutput((JavaRDD<Row>)rdd);
    }

    @Override
    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    @VisibleForTesting
    public void setJavaStreamingContext(JavaStreamingContext javaStreamingContext) {
        this.javaStreamingContext = javaStreamingContext;
    }

    @VisibleForTesting
    public void setSubscriber(SparkOperation.Subscriber subscriber) {
        this.subscriber = subscriber;
    }
}

