/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.MultivalueLog;
import org.netbeans.mdr.persistence.memoryimpl.StorageImpl;
import org.netbeans.mdr.persistence.memoryimpl.Utils;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.MapEntryImpl;

public abstract class MultivaluedIndexImpl
implements MultivaluedIndex,
Streamable {
    protected String name;
    protected Storage.EntryType keyType;
    protected Storage.EntryType valueType;
    protected boolean unique;
    protected Map entries;
    protected StorageImpl storage;
    protected MultivalueLog transLog = new MultivalueLog(this);

    public MultivaluedIndexImpl(String name, StorageImpl storage, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) {
        this.name = name;
        this.keyType = keyType;
        this.valueType = valueType;
        this.unique = unique;
        this.storage = storage;
        this.entries = new HashMap();
    }

    public MultivaluedIndexImpl() {
    }

    public String getName() throws StorageException {
        return this.name;
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this.valueType;
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return this.keyType;
    }

    public synchronized boolean remove(Object key) throws StorageException {
        Object value = this.entries.remove(key);
        if (value != null) {
            this.transLog.logRemoveKey(key, value);
            return true;
        }
        return false;
    }

    public synchronized Set keySet() throws StorageException {
        return this.entries.keySet();
    }

    public synchronized void add(Object key, Object value) throws StorageException {
        ArrayList<Object> vals = (ArrayList<Object>)this.entries.get(key);
        if (vals == null) {
            vals = new ArrayList<Object>();
            this.entries.put(key, vals);
        } else if (this.unique && vals.contains(value)) {
            throw this.createValueAlreadyContainedExc(key, value);
        }
        vals.add(value);
        this.transLog.logAdd(key, value);
    }

    public boolean isUnique() throws StorageException {
        return this.unique;
    }

    public synchronized Collection getItems(Object key) throws StorageException {
        ArrayList vals = (ArrayList)this.entries.get(key);
        if (vals == null) {
            vals = new ArrayList();
            this.entries.put(key, vals);
        }
        return new MIWrapper(vals, key);
    }

    public synchronized Collection getObjects(Object key, SinglevaluedIndex s) throws StorageException {
        if (this.keyType == Storage.EntryType.MOFID) {
            return new MOWrapper((List)this.getItems(key), s, key);
        }
        return this.getItems(key);
    }

    public synchronized boolean remove(Object key, Object value) throws StorageException {
        Collection vals = (Collection)this.entries.get(key);
        if (vals != null && vals.remove(value)) {
            this.transLog.logRemove(key, value);
            return true;
        }
        return false;
    }

    public void write(OutputStream out) throws StorageException {
        try {
            IOUtils.writeString(out, this.name);
            out.write(this.keyType.encode());
            out.write(this.valueType.encode());
            Utils.write(out, this.entries, this.storage);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public void read(InputStream is) throws StorageException {
        try {
            this.name = IOUtils.readString(is);
            this.keyType = Storage.EntryType.decodeEntryType((byte)is.read());
            this.valueType = Storage.EntryType.decodeEntryType((byte)is.read());
            this.entries = (Map)Utils.read(is, this.storage);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    public synchronized Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex primaryIndex) throws StorageException {
        if (this.keyType != Storage.EntryType.STRING) {
            throw new UnsupportedOperationException("Key type must be EntryType.STRING");
        }
        if (!(prefix instanceof String)) {
            throw new StorageBadRequestException("String object parameter expected.");
        }
        LinkedList<MapEntryImpl> result = new LinkedList<MapEntryImpl>();
        Iterator iter = this.entries.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith((String)prefix)) continue;
            result.add(new MapEntryImpl(key, this.getObjects(key, primaryIndex)));
        }
        return result;
    }

    protected synchronized void rollBackChanges() throws StorageException {
        this.transLog.rollBack();
        this.transLog.clear();
    }

    protected synchronized void commitChanges() throws StorageException {
        this.transLog.clear();
    }

    protected static boolean isUniqueValue(List list, Object value, int index) {
        Iterator iter = list.iterator();
        int x = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (x != index && value.equals(obj)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    protected StorageBadRequestException createValueAlreadyContainedExc(Object key, Object value) {
        return new StorageBadRequestException("Unique index already contains value " + value + " for key " + key);
    }

    public void changed(Object key) {
    }

    void setKey(Object key, Object vals) {
        this.entries.put(key, vals);
    }

    private class MIWrapper
    extends AbstractList {
        private final List inner;
        private final Object key;

        public MIWrapper(List inner, Object key) {
            this.inner = inner;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int param) {
            MultivaluedIndexImpl multivaluedIndexImpl = MultivaluedIndexImpl.this;
            synchronized (multivaluedIndexImpl) {
                return this.inner.get(param);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            MultivaluedIndexImpl multivaluedIndexImpl = MultivaluedIndexImpl.this;
            synchronized (multivaluedIndexImpl) {
                return this.inner.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            MultivaluedIndexImpl multivaluedIndexImpl = MultivaluedIndexImpl.this;
            synchronized (multivaluedIndexImpl) {
                if (MultivaluedIndexImpl.this.unique && !MultivaluedIndexImpl.isUniqueValue(this.inner, element, index)) {
                    throw new RuntimeStorageException(MultivaluedIndexImpl.this.createValueAlreadyContainedExc(this.key, element));
                }
                Object orig = this.inner.set(index, element);
                if (orig != null) {
                    MultivaluedIndexImpl.this.transLog.logReplace(this.key, orig, index);
                }
                return orig;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            MultivaluedIndexImpl multivaluedIndexImpl = MultivaluedIndexImpl.this;
            synchronized (multivaluedIndexImpl) {
                if (MultivaluedIndexImpl.this.unique && this.inner.contains(element)) {
                    throw new RuntimeStorageException(MultivaluedIndexImpl.this.createValueAlreadyContainedExc(this.key, element));
                }
                this.inner.add(index, element);
                MultivaluedIndexImpl.this.transLog.logAdd(this.key, element, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            MultivaluedIndexImpl multivaluedIndexImpl = MultivaluedIndexImpl.this;
            synchronized (multivaluedIndexImpl) {
                Object orig = this.inner.remove(index);
                if (orig != null) {
                    MultivaluedIndexImpl.this.transLog.logRemove(this.key, orig, index);
                    return orig;
                }
                return null;
            }
        }
    }

    private class MOWrapper
    extends AbstractList {
        private final List inner;
        private final SinglevaluedIndex pi;
        private final Object key;

        public MOWrapper(List inner, SinglevaluedIndex pi, Object key) {
            this.inner = inner;
            this.pi = pi;
            this.key = key;
        }

        public Object get(int param) {
            try {
                return this.pi.get(this.inner.get(param));
            }
            catch (StorageException e) {
                throw (RuntimeException)Logger.getDefault().annotate((Throwable)new RuntimeException(), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            MultivaluedIndexImpl multivaluedIndexImpl = MultivaluedIndexImpl.this;
            synchronized (multivaluedIndexImpl) {
                return this.inner.size();
            }
        }

        public Object set(int index, Object element) {
            if (element instanceof MOFID) {
                if (MultivaluedIndexImpl.this.unique && !MultivaluedIndexImpl.isUniqueValue(this.inner, element, index)) {
                    throw new RuntimeStorageException(MultivaluedIndexImpl.this.createValueAlreadyContainedExc(this.key, element));
                }
                return this.inner.set(index, element);
            }
            throw new IllegalArgumentException();
        }

        public void add(int index, Object element) {
            if (element instanceof MOFID) {
                if (MultivaluedIndexImpl.this.unique && this.inner.contains(element)) {
                    throw new RuntimeStorageException(MultivaluedIndexImpl.this.createValueAlreadyContainedExc(this.key, element));
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.inner.add(index, element);
        }

        public Object remove(int index) {
            return this.inner.remove(index);
        }
    }
}

